/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSFile;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.MongoJSStringUtil;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSBinaryExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpressionStatement;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSLiteralExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSStringTemplateExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoJSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!this.isSupportedFile(file) || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        Pair<@NotNull MongoJSLiteralExpression, Boolean> pair = MongoJSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        return pair == null ? null : ((Boolean)pair.second != false ? MongoJSStringUtil.unescapeSimpleStringChars((String)text) : text);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!this.isSupportedFile(file)) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        Pair<@NotNull MongoJSLiteralExpression, Boolean> pair = MongoJSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (pair == null) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        MongoJSLiteralExpression literalExpression = (MongoJSLiteralExpression)pair.first;
        if (literalExpression.getTextOffset() == selectionStart) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        return MongoJSStringLiteralCopyPasteProcessor.getPastedText(text, literalExpression, rawText);
    }

    public boolean isSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return file instanceof MongoJSFile && file.isPhysical();
    }

    @NotNull
    private static String getPastedText(String text, @NotNull MongoJSLiteralExpression literalExpression, RawText rawText) {
        if (literalExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        String literalText = literalExpression.getText();
        boolean isStringTemplate = literalExpression instanceof MongoJSStringTemplateExpression;
        boolean isSlashQuotedDestination = !isStringTemplate && literalText.contains("\\\n");
        boolean destinationAcceptsNewLines = MongoJSStringLiteralCopyPasteProcessor.isDestinationAcceptsNewLines(rawText, isStringTemplate, isSlashQuotedDestination);
        char quote = literalText.charAt(0);
        if (StringUtil.containsChar((String)text, (char)quote) && !isStringTemplate && MongoJSStringLiteralCopyPasteProcessor.isValidStringConcatenation((PsiElement)literalExpression, quote + (isSlashQuotedDestination ? StringUtil.trimEnd((String)text, (String)"\\") : text) + quote)) {
            String string = text;
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (rawText != null && rawText.rawText != null) {
            if (isStringTemplate) {
                String string = MongoJSStringUtil.escapeTemplateStringChars((String)rawText.rawText, (boolean)false, (boolean)false, (PsiElement)literalExpression);
                if (string == null) {
                    MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = MongoJSStringLiteralCopyPasteProcessor.escapeQuote(rawText.rawText, quote, !destinationAcceptsNewLines);
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (isStringTemplate) {
            String string = MongoJSStringUtil.escapeTemplateStringChars((String)text, (boolean)true, (boolean)true, (PsiElement)literalExpression);
            if (string == null) {
                MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        return MongoJSStringLiteralCopyPasteProcessor.escapeSimpleText(text, literalExpression, isSlashQuotedDestination, destinationAcceptsNewLines, quote);
    }

    private static boolean isDestinationAcceptsNewLines(RawText rawText, boolean isStringTemplate, boolean isSlashQuotedDestination) {
        return isStringTemplate || isSlashQuotedDestination || rawText != null && StringUtil.contains((CharSequence)rawText.rawText, (CharSequence)"\\\n");
    }

    @NotNull
    private static String escapeSimpleText(String text, @NotNull MongoJSLiteralExpression literalExpression, boolean isSlashQuotedDestination, boolean destinationAcceptsNewlines, char quote) {
        if (literalExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = isSlashQuotedDestination ? "\\\n" : MongoJSStringLiteralCopyPasteProcessor.getTail(quote, (PsiElement)literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            MongoJSStringUtil.escapeSimpleStringChars((String)line, (char)quote, (!destinationAcceptsNewlines ? 1 : 0) != 0, (boolean)true, (boolean)false, (StringBuilder)buffer);
            if (i == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static @Nullable Pair<@NotNull MongoJSLiteralExpression, Boolean> getSingleElementFromSelectionOrNull(@NotNull PsiFile file, int start, int end) {
        if (file == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        MongoJSLiteralExpression atStart = (MongoJSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), MongoJSLiteralExpression.class);
        MongoJSLiteralExpression atEnd = (MongoJSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(end), MongoJSLiteralExpression.class);
        if (atStart == null || atStart != atEnd || !atStart.isQuotedLiteral() || !atStart.getTextRange().containsRange(start, end)) {
            return null;
        }
        boolean canEscape = !(atStart instanceof MongoJSStringTemplateExpression) || MongoJSStringLiteralCopyPasteProcessor.isInStringRange((MongoJSStringTemplateExpression)atStart, new TextRange(start, end));
        return Pair.create((Object)atStart, (Object)canEscape);
    }

    private static boolean isValidStringConcatenation(@NotNull PsiElement context, @NotNull String text) {
        TextRange range;
        MongoJSExpression expression;
        PsiFile file;
        if (context == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        if (text == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        try {
            file = MongoJSPsiUtilKt.createJSFileFromText((Project)context.getProject(), (String)text);
        }
        catch (Exception e) {
            return false;
        }
        PsiElement firstStatement = (PsiElement)ArrayUtil.getFirstElement((Object[])file.getChildren());
        return firstStatement instanceof MongoJSExpressionStatement && (expression = ((MongoJSExpressionStatement)firstStatement).getExpression()) instanceof MongoJSBinaryExpression && JSElementTypes.PLUS == ((MongoJSBinaryExpression)expression).getOperationSign() && (range = expression.getTextRange()).getStartOffset() == 0 && range.getEndOffset() == file.getTextLength() && PsiTreeUtil.getDeepestFirst((PsiElement)expression).getParent() instanceof MongoJSLiteralExpression && PsiTreeUtil.getDeepestLast((PsiElement)expression).getParent() instanceof MongoJSLiteralExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context) {
        if (context == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)context.getContainingFile(), (Language)context.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static boolean isInStringRange(@NotNull MongoJSStringTemplateExpression templateExpression, int offset) {
        if (templateExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        return MongoJSStringLiteralCopyPasteProcessor.isInStringRange(templateExpression, TextRange.from((int)offset, (int)0));
    }

    public static boolean isInStringRange(@NotNull MongoJSStringTemplateExpression templateExpression, @NotNull TextRange range) {
        if (templateExpression == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        if (range == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        TextRange relativeRange = range.shiftLeft(templateExpression.getTextRange().getStartOffset());
        for (TextRange textRange : templateExpression.getStringRangesWithEmpty()) {
            if (!textRange.contains(relativeRange)) continue;
            return true;
        }
        return false;
    }

    private static String escapeQuote(String text, char quote, boolean escapeNewlines) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escapeNewlines && c == '\n') {
                result.append('\\').append('n');
                continue;
            }
            if (c == quote && (i == 0 || text.charAt(i - 1) != '\\')) {
                result.append('\\').append(quote);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        if (project == null) {
            MongoJSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 9, 11, 12, 13, 14, 16, 17, 18, 19, 20 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/js/editing/MongoJSStringLiteralCopyPasteProcessor";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/js/editing/MongoJSStringLiteralCopyPasteProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastedText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSimpleText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPastedText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElementFromSelectionOrNull";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidStringConcatenation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTail";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInStringRange";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 9, 11, 12, 13, 14, 16, 17, 18, 19, 20 -> new IllegalArgumentException(string);
        };
    }
}

