/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SshConfigManagerBase
implements PersistentStateComponent<State> {
    @NotNull
    private SshConfigManager.ConfigsData myData;
    @Nullable
    protected final com.intellij.openapi.project.Project myProject;
    private final List<Listener> myListeners = new CopyOnWriteArrayList<Listener>();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull String> myInitialMappingNameToIdConfig = new ConcurrentHashMap<String, String>();

    private SshConfigManagerBase(@Nullable com.intellij.openapi.project.Project project) {
        this.myProject = project;
        this.myData = new SshConfigManager.ConfigsData();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        MessageBusConnection messageBusConnection = this.myProject == null ? messageBus.connect() : messageBus.connect((Disposable)this.myProject);
        messageBusConnection.subscribe(SshConfigManager.SSH_CONFIG_AUTH, (Object)new SshConfigManager.SshConfigAuthListener(){

            @Override
            public void sshConfigAuthDataChanged(@NotNull SshConfig sshConfig) {
                if (sshConfig == null) {
                    1.y(0);
                }
                1.y(sshConfig, SshConfigManagerBase.this.myData.getLastSavedData());
                1.y(sshConfig, SshConfigManagerBase.this.myData.getCurrentData());
            }

            private static void y(@NotNull SshConfig sshConfig, List<SshUiData> list) {
                SshUiData sshUiData;
                if (sshConfig == null) {
                    1.y(1);
                }
                if ((sshUiData = SshUiData.findById(list, sshConfig.getId())) != null) {
                    sshUiData.reloadAuthDataFromPasswordSafe();
                }
            }

            private static /* synthetic */ void y(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "sshConfig";
                objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sshConfigAuthDataChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reloadAuthForConfig";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public State getState() {
        if (this.myData.getLastSavedData().isEmpty()) {
            return null;
        }
        State state = new State();
        for (SshUiData sshUiData : this.myData.getLastSavedData()) {
            SshConfig sshConfig = sshUiData.getConfig().clone();
            sshConfig.setProjectLevel(false);
            state.configs.add(sshConfig);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SshConfigManagerBase.y(0);
        }
        List<SshUiData> list = this.myData.getCurrentData();
        ArrayList<SshUiData> arrayList = new ArrayList<SshUiData>();
        for (SshConfig sshConfig : state.configs) {
            sshConfig.setProjectLevel(this.myProject != null);
            arrayList.add(new SshUiData(sshConfig));
            this.myInitialMappingNameToIdConfig.putIfAbsent(sshConfig.getName(), sshConfig.getId());
        }
        this.myData = new SshConfigManager.ConfigsData(arrayList, arrayList);
        this.y(new SshConfigManager.ConfigsData(list, arrayList));
    }

    public SshConfigManager.ConfigsData getLastSavedAndCurrentData() {
        return this.myData;
    }

    public void setCurrentData(@NotNull List<SshUiData> newData) {
        if (newData == null) {
            SshConfigManagerBase.y(1);
        }
        List<SshUiData> list = this.myData.getCurrentData();
        this.myData = this.myData.createWithCurrentData(newData);
        this.y(new SshConfigManager.ConfigsData(list, newData));
    }

    public void applyData(@NotNull List<SshUiData> data) {
        if (data == null) {
            SshConfigManagerBase.y(2);
        }
        List<SshUiData> list = this.myData.getCurrentData();
        for (SshUiData sshUiData : this.myData.getLastSavedData()) {
            String string = sshUiData.getConfig().getId();
            SshUiData sshUiData2 = SshUiData.findById(data, string);
            if (sshUiData2 != null) continue;
            sshUiData.getConfig().eraseAuthDataFromPasswordSafe();
        }
        for (SshUiData sshUiData : data) {
            sshUiData.saveAuthDataToPasswordSafe();
        }
        this.myData = new SshConfigManager.ConfigsData(data, data);
        this.y(new SshConfigManager.ConfigsData(list, data));
    }

    public void applyLastSavedData() {
        List<SshUiData> list = this.myData.getCurrentData();
        @NotNull List<SshUiData> list2 = this.myData.getLastSavedData();
        for (SshUiData sshUiData : list2) {
            sshUiData.saveAuthDataToPasswordSafe();
        }
        this.myData = new SshConfigManager.ConfigsData(list2, list2);
        this.y(new SshConfigManager.ConfigsData(list, list2));
    }

    public void addToSavedAndCurrent(SshUiData data) {
        List<SshUiData> list = this.myData.getCurrentData();
        this.myData = this.myData.createMerged(new SshConfigManager.ConfigsData(data));
        this.y(new SshConfigManager.ConfigsData(list, this.myData.getCurrentData()));
    }

    @Nullable
    public SshUiData findExistingData(String host, String port, String username, AuthType type) {
        if (StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)port) || SshConfig.parseSshPort(port) < 0) {
            return null;
        }
        for (SshUiData sshUiData : this.myData.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (type != sshConfig.getAuthType() || !Objects.equals(host, sshConfig.getHost()) || !Objects.equals(port, sshConfig.getLiteralPort()) || !Objects.equals(StringUtil.nullize((String)username, (boolean)true), StringUtil.nullize((String)sshConfig.getUsername(), (boolean)true))) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataName(@NotNull String name) {
        if (name == null) {
            SshConfigManagerBase.y(3);
        }
        for (SshUiData sshUiData : this.myData.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(name, sshConfig.getName())) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByData(@NotNull PresentableId presentableId) {
        String string;
        if (presentableId == null) {
            SshConfigManagerBase.y(4);
        }
        if ((string = presentableId.getId()) == null) {
            return null;
        }
        for (SshUiData sshUiData : this.myData.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(string, sshConfig.getId())) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    public SshUiData findCurrentByDataId(@NotNull String id) {
        if (id == null) {
            SshConfigManagerBase.y(5);
        }
        for (SshUiData sshUiData : this.myData.getCurrentData()) {
            SshConfig sshConfig = sshUiData.getConfig();
            if (!Objects.equals(id, sshConfig.getId())) continue;
            return sshUiData;
        }
        return null;
    }

    public void removeFromSavedAndCurrent(SshUiData data) {
        List<SshUiData> list = this.myData.getCurrentData();
        Condition condition = sshUiData2 -> !sshUiData2.getConfig().getId().equals(data.getConfig().getId());
        List list2 = ContainerUtil.findAll(this.myData.getLastSavedData(), (Condition)condition);
        List list3 = ContainerUtil.findAll(this.myData.getCurrentData(), (Condition)condition);
        this.myData = new SshConfigManager.ConfigsData(list2, list3);
        this.y(new SshConfigManager.ConfigsData(list, list3));
    }

    public void addChangeListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeChangeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private void y(@NotNull SshConfigManager.ConfigsData configsData) {
        if (configsData == null) {
            SshConfigManagerBase.y(6);
        }
        for (Listener listener : this.myListeners) {
            listener.changed(configsData);
        }
    }

    public String getIdFromInitialName(@NotNull String initialName) {
        if (initialName == null) {
            SshConfigManagerBase.y(7);
        }
        return this.myInitialMappingNameToIdConfig.get(initialName);
    }

    private static /* synthetic */ void y(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshConfigManagerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCurrentData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findCurrentByDataId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyListeners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdFromInitialName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class State {
        @XCollection(style=XCollection.Style.v2, propertyElementName="configs")
        public List<SshConfig> configs = new ArrayList<SshConfig>();
    }

    static interface Listener {
        public void changed(@NotNull SshConfigManager.ConfigsData var1);
    }

    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")}, category=SettingsCategory.TOOLS)
    @ApiStatus.Internal
    public static final class App
    extends SshConfigManagerBase {
        App() {
            super(null);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @com.intellij.openapi.components.State(name="SshConfigs", storages={@Storage(value="sshConfigs.xml")}, category=SettingsCategory.TOOLS)
    static final class Project
    extends SshConfigManagerBase {
        Project(@NotNull com.intellij.openapi.project.Project project) {
            if (project == null) {
                Project.z(0);
            }
            super(project);
        }

        public com.intellij.openapi.project.Project getProject() {
            return this.myProject;
        }

        private static /* synthetic */ void z(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ssh/config/unified/SshConfigManagerBase$Project", "<init>"));
        }
    }
}

