/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.lux.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.ide.model.LxInputMethodEvent;
import com.jetbrains.rd.ide.model.LxInputMethodEventType;
import com.jetbrains.rd.ide.model.LxKeyEvent;
import com.jetbrains.rd.ide.model.LxKeyEventType;
import com.jetbrains.rd.ide.model.LxMouseEvent;
import com.jetbrains.rd.ide.model.LxMouseEventBase;
import com.jetbrains.rd.ide.model.LxMouseEventType;
import com.jetbrains.rd.ide.model.LxMouseWheelEvent;
import com.jetbrains.rd.ide.model.LxWindowEvent;
import com.jetbrains.rd.ide.model.LxWindowEventType;
import com.jetbrains.rd.ide.model.LxWindowRef;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ClientIdAwareInputMethodEvent;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ClientIdAwareKeyEvent;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ClientIdAwareMouseEvent;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ClientIdAwareMouseWheelEvent;
import com.jetbrains.rd.platform.codeWithMe.lux.util.ClientIdAwareWindowEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000x\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u0003*\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a\n\u0010\u0000\u001a\u00020\b*\u00020\t\u001a\u001a\u0010\u0000\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u0000\u001a\u00020\u000f*\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u001a4\u0010\u0015\u001a\u00020\u0010*\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0016\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u001a\u001c\u0010\u0015\u001a\u00020\t*\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u001a\u001a4\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u000e2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u001f\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020 \u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0006\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\f\u001a\u001c\u0010\u0015\u001a\u00020\u000b*\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u001a\"\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"toLx", "Lcom/jetbrains/rd/ide/model/LxMouseWheelEvent;", "Ljava/awt/event/MouseWheelEvent;", "Lcom/jetbrains/rd/ide/model/LxMouseEvent;", "Ljava/awt/event/MouseEvent;", "type", "Lcom/jetbrains/rd/ide/model/LxMouseEventType;", "refEvent", "Lcom/jetbrains/rd/ide/model/LxKeyEvent;", "Ljava/awt/event/KeyEvent;", "Lcom/jetbrains/rd/ide/model/LxInputMethodEvent;", "Ljava/awt/event/InputMethodEvent;", "Lcom/jetbrains/rd/ide/model/LxInputMethodEventType;", "selectPreviousCharacter", "", "Lcom/jetbrains/rd/ide/model/LxWindowEvent;", "Ljava/awt/event/WindowEvent;", "windowToRef", "Lkotlin/Function1;", "Ljava/awt/Window;", "Lcom/jetbrains/rd/ide/model/LxWindowRef;", "fromLx", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "source", "refToWindow", "Ljava/awt/Component;", "Lcom/jetbrains/rd/ide/model/LxMouseEventBase;", "useAbsoluteMouseCoordinates", "toInt", "", "Lcom/jetbrains/rd/ide/model/LxWindowEventType;", "Lcom/jetbrains/rd/ide/model/LxKeyEventType;", "COMPOSED_TEXT_HIGHLIGHT", "Ljava/awt/im/InputMethodHighlight;", "getCOMPOSED_TEXT_HIGHLIGHT", "()Ljava/awt/im/InputMethodHighlight;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nevents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 events.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/util/EventsKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n23#2:213\n1#3:214\n*S KotlinDebug\n*F\n+ 1 events.kt\ncom/jetbrains/rd/platform/codeWithMe/lux/util/EventsKt\n*L\n130#1:213\n*E\n"})
public final class EventsKt {
    @NotNull
    private static final InputMethodHighlight COMPOSED_TEXT_HIGHLIGHT = new InputMethodHighlight(false, 0, 0, MapsKt.mapOf((Pair)TuplesKt.to((Object)TextAttribute.INPUT_METHOD_UNDERLINE, (Object)TextAttribute.UNDERLINE_LOW_ONE_PIXEL)));

    @NotNull
    public static final LxMouseWheelEvent toLx(@NotNull MouseWheelEvent $this$toLx) {
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        return new LxMouseWheelEvent($this$toLx.getScrollType(), $this$toLx.getScrollAmount(), $this$toLx.getWheelRotation(), $this$toLx.getPreciseWheelRotation(), LxMouseEventType.Wheel, $this$toLx.getX(), $this$toLx.getY(), $this$toLx.getXOnScreen(), $this$toLx.getYOnScreen(), $this$toLx.getClickCount(), AWTAccessor.getMouseEventAccessor().isCausedByTouchEvent($this$toLx), $this$toLx.getButton(), $this$toLx.isPopupTrigger(), $this$toLx.getModifiersEx());
    }

    @NotNull
    public static final LxMouseEvent toLx(@NotNull MouseEvent $this$toLx, @NotNull LxMouseEventType type, @Nullable MouseEvent refEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new LxMouseEvent(type, refEvent == null ? $this$toLx.getX() : $this$toLx.getXOnScreen() - refEvent.getXOnScreen(), refEvent == null ? $this$toLx.getY() : $this$toLx.getYOnScreen() - refEvent.getYOnScreen(), $this$toLx.getXOnScreen(), $this$toLx.getYOnScreen(), $this$toLx.getClickCount(), AWTAccessor.getMouseEventAccessor().isCausedByTouchEvent($this$toLx), $this$toLx.getButton(), $this$toLx.isPopupTrigger(), $this$toLx.getModifiersEx());
    }

    public static /* synthetic */ LxMouseEvent toLx$default(MouseEvent mouseEvent, LxMouseEventType lxMouseEventType, MouseEvent mouseEvent2, int n, Object object) {
        if ((n & 2) != 0) {
            mouseEvent2 = null;
        }
        return EventsKt.toLx(mouseEvent, lxMouseEventType, mouseEvent2);
    }

    @NotNull
    public static final LxMouseEvent toLx(@NotNull MouseEvent $this$toLx, @Nullable MouseEvent refEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        LxMouseEventType type = switch ($this$toLx.getID()) {
            case 500 -> LxMouseEventType.Clicked;
            case 501 -> LxMouseEventType.Pressed;
            case 502 -> LxMouseEventType.Released;
            case 503 -> LxMouseEventType.Moved;
            case 504 -> LxMouseEventType.Entered;
            case 505 -> LxMouseEventType.Exited;
            case 506 -> LxMouseEventType.Dragged;
            default -> throw new IllegalStateException(("Wrong Mouse event type: " + $this$toLx.getID()).toString());
        };
        return EventsKt.toLx($this$toLx, type, refEvent);
    }

    public static /* synthetic */ LxMouseEvent toLx$default(MouseEvent mouseEvent, MouseEvent mouseEvent2, int n, Object object) {
        if ((n & 1) != 0) {
            mouseEvent2 = null;
        }
        return EventsKt.toLx(mouseEvent, mouseEvent2);
    }

    @NotNull
    public static final LxKeyEvent toLx(@NotNull KeyEvent $this$toLx) {
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        LxKeyEventType type = switch ($this$toLx.getID()) {
            case 401 -> LxKeyEventType.Pressed;
            case 402 -> LxKeyEventType.Released;
            case 400 -> LxKeyEventType.Typed;
            default -> throw new IllegalArgumentException("Unknown KeyEvent ID: " + $this$toLx.getID());
        };
        int m = SystemInfo.isMac && type == LxKeyEventType.Typed ? $this$toLx.getModifiersEx() & 0xFFFFFDFF & 0xFFFFFFF7 : $this$toLx.getModifiersEx();
        return new LxKeyEvent(type, $this$toLx.getKeyCode(), $this$toLx.getKeyChar(), $this$toLx.getKeyLocation(), m);
    }

    @NotNull
    public static final LxInputMethodEvent toLx(@NotNull InputMethodEvent $this$toLx, @NotNull LxInputMethodEventType type, boolean selectPreviousCharacter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        AttributedCharacterIterator attributedCharacterIterator = $this$toLx.getText();
        if (attributedCharacterIterator != null) {
            AttributedCharacterIterator it = attributedCharacterIterator;
            boolean bl = false;
            StringBuilder b = new StringBuilder();
            char c = it.first();
            while (c != '\uffff') {
                b.append(c);
                c = it.next();
            }
            string = b.toString();
        } else {
            string = null;
        }
        String text = string;
        TextHitInfo textHitInfo = $this$toLx.getCaret();
        return new LxInputMethodEvent(type, text, $this$toLx.getCommittedCharacterCount(), textHitInfo != null ? Integer.valueOf(textHitInfo.getInsertionIndex()) : null, selectPreviousCharacter);
    }

    @NotNull
    public static final LxWindowEvent toLx(@NotNull WindowEvent $this$toLx, @NotNull Function1<? super Window, ? extends LxWindowRef> windowToRef) {
        LxWindowRef lxWindowRef;
        Intrinsics.checkNotNullParameter((Object)$this$toLx, (String)"<this>");
        Intrinsics.checkNotNullParameter(windowToRef, (String)"windowToRef");
        LxWindowEventType type = switch ($this$toLx.getID()) {
            case 202 -> LxWindowEventType.Closing;
            case 205 -> LxWindowEventType.Activated;
            case 206 -> LxWindowEventType.Deactivated;
            case 207 -> LxWindowEventType.GainedFocus;
            case 208 -> LxWindowEventType.LostFocus;
            default -> throw new IllegalStateException(("Unknown window event type: " + $this$toLx.getID()).toString());
        };
        Window window = $this$toLx.getOppositeWindow();
        if (window != null) {
            Window it = window;
            boolean bl = false;
            Window window2 = $this$toLx.getOppositeWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window2, (String)"getOppositeWindow(...)");
            lxWindowRef = (LxWindowRef)windowToRef.invoke((Object)window2);
        } else {
            lxWindowRef = null;
        }
        LxWindowRef ref = lxWindowRef;
        return new LxWindowEvent(type, ref);
    }

    @NotNull
    public static final WindowEvent fromLx(@NotNull LxWindowEvent $this$fromLx, @Nullable ClientId clientId, @NotNull Window source, @NotNull Function1<? super LxWindowRef, ? extends Window> refToWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$fromLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(refToWindow, (String)"refToWindow");
        Window opposite = (Window)refToWindow.invoke((Object)$this$fromLx.getOppositeWindow());
        return $this$fromLx.getType() == LxWindowEventType.LostFocus && opposite != null ? (WindowEvent)new ClientIdAwareWindowEvent(clientId, opposite, 207, source) : (WindowEvent)new ClientIdAwareWindowEvent(clientId, source, EventsKt.toInt($this$fromLx.getType()), opposite);
    }

    @NotNull
    public static final KeyEvent fromLx(@NotNull LxKeyEvent $this$fromLx, @Nullable ClientId clientId, @NotNull Component source) {
        ClientIdAwareKeyEvent clientIdAwareKeyEvent;
        Intrinsics.checkNotNullParameter((Object)$this$fromLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ClientIdAwareKeyEvent it = clientIdAwareKeyEvent = new ClientIdAwareKeyEvent(clientId, source, EventsKt.toInt($this$fromLx.getType()), System.currentTimeMillis(), $this$fromLx.getModifiers(), $this$fromLx.getKeyCode(), $this$fromLx.getKeyChar(), $this$fromLx.getKeyLocation());
        boolean bl = false;
        AWTAccessor.getAWTEventAccessor().setPosted(it);
        return clientIdAwareKeyEvent;
    }

    @Nullable
    public static final MouseEvent fromLx(@NotNull LxMouseEventBase $this$fromLx, @Nullable ClientId clientId, @NotNull Component source, boolean useAbsoluteMouseCoordinates, @Nullable MouseEvent refEvent) {
        MouseEvent mouseEvent;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$fromLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.isShowing()) {
            LxMouseEventBase $this$thisLogger$iv = $this$fromLx;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LxMouseEventBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Got mouse event for hidden component: " + source + ", " + $this$fromLx + ". Ignoring.");
            return null;
        }
        if (useAbsoluteMouseCoordinates) {
            Object object = source instanceof RootPaneContainer ? (RootPaneContainer)((Object)source) : null;
            Component contentPane = object != null && (object = object.getContentPane()) != null ? (Component)object : source;
            Point p = SwingUtilities.convertPoint(contentPane, $this$fromLx.getXAbs() - source.getLocationOnScreen().x, $this$fromLx.getYAbs() - source.getLocationOnScreen().y, source);
            pair = TuplesKt.to((Object)p.x, (Object)p.y);
        } else if (refEvent == null) {
            pair = TuplesKt.to((Object)$this$fromLx.getX(), (Object)$this$fromLx.getY());
        } else {
            Point p = new Point($this$fromLx.getX() + refEvent.getXOnScreen(), $this$fromLx.getY() + refEvent.getYOnScreen());
            SwingUtilities.convertPointFromScreen(p, source);
            pair = TuplesKt.to((Object)p.x, (Object)p.y);
        }
        Pair pair2 = pair;
        int relativeX = ((Number)pair2.component1()).intValue();
        int relativeY = ((Number)pair2.component2()).intValue();
        LxMouseEventBase lxMouseEventBase = $this$fromLx;
        if (lxMouseEventBase instanceof LxMouseEvent) {
            mouseEvent = new ClientIdAwareMouseEvent(clientId, source, EventsKt.toInt($this$fromLx.getType()), System.currentTimeMillis(), $this$fromLx.getModifiers(), relativeX, relativeY, $this$fromLx.getClickCount(), $this$fromLx.getPopupTrigger(), $this$fromLx.getButton());
        } else if (lxMouseEventBase instanceof LxMouseWheelEvent) {
            mouseEvent = new ClientIdAwareMouseWheelEvent(clientId, source, EventsKt.toInt($this$fromLx.getType()), System.currentTimeMillis(), $this$fromLx.getModifiers(), relativeX, relativeY, 0, 0, $this$fromLx.getClickCount(), $this$fromLx.getPopupTrigger(), ((LxMouseWheelEvent)$this$fromLx).getScrollType(), ((LxMouseWheelEvent)$this$fromLx).getScrollAmount(), ((LxMouseWheelEvent)$this$fromLx).getWheelRotation(), ((LxMouseWheelEvent)$this$fromLx).getPreciseWheelRotation());
        } else {
            throw new IllegalStateException(("Unknown mouse event type. " + $this$fromLx).toString());
        }
        return mouseEvent;
    }

    public static /* synthetic */ MouseEvent fromLx$default(LxMouseEventBase lxMouseEventBase, ClientId clientId, Component component, boolean bl, MouseEvent mouseEvent, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            mouseEvent = null;
        }
        return EventsKt.fromLx(lxMouseEventBase, clientId, component, bl, mouseEvent);
    }

    public static final int toInt(@NotNull LxWindowEventType $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toInt.ordinal()]) {
            case 1 -> 205;
            case 2 -> 206;
            case 3 -> 201;
            case 4 -> 207;
            case 5 -> 208;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int toInt(@NotNull LxKeyEventType $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toInt.ordinal()]) {
            case 1 -> 400;
            case 2 -> 401;
            case 3 -> 402;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int toInt(@NotNull LxMouseEventType $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$2[$this$toInt.ordinal()]) {
            case 1 -> 500;
            case 2 -> 501;
            case 3 -> 502;
            case 4 -> 503;
            case 5 -> 504;
            case 6 -> 505;
            case 7 -> 506;
            case 8 -> 507;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final int toInt(@NotNull LxInputMethodEventType $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$toInt.ordinal()]) {
            case 1 -> 1100;
            case 2 -> 1101;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InputMethodEvent fromLx(@NotNull LxInputMethodEvent $this$fromLx, @Nullable ClientId clientId, @NotNull Component source) {
        TextHitInfo textHitInfo;
        AttributedCharacterIterator attributedCharacterIterator;
        AttributedCharacterIterator attributedCharacterIterator2;
        ClientId clientId2;
        Component component;
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$fromLx, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component target = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, source) ? focusOwner : source;
        ClientId clientId3 = clientId;
        Component component2 = target;
        int n2 = EventsKt.toInt($this$fromLx.getType());
        String string = $this$fromLx.getText();
        if (string != null) {
            void it;
            AttributedString attributedString;
            String string2 = string;
            n = n2;
            component = component2;
            clientId2 = clientId3;
            boolean bl = false;
            AttributedString $this$fromLx_u24lambda_u241_u240 = attributedString = new AttributedString((String)it);
            boolean bl2 = false;
            if ($this$fromLx.getCommittedCount() < it.length()) {
                $this$fromLx_u24lambda_u241_u240.addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, COMPOSED_TEXT_HIGHLIGHT, $this$fromLx.getCommittedCount(), it.length());
            }
            attributedCharacterIterator2 = attributedString.getIterator();
            clientId3 = clientId2;
            component2 = component;
            n2 = n;
            attributedCharacterIterator = attributedCharacterIterator2;
        } else {
            attributedCharacterIterator = null;
        }
        int n3 = $this$fromLx.getCommittedCount();
        Integer n4 = $this$fromLx.getCaretPos();
        if (n4 != null) {
            int it = ((Number)n4).intValue();
            int n5 = n3;
            attributedCharacterIterator2 = attributedCharacterIterator;
            n = n2;
            component = component2;
            clientId2 = clientId3;
            boolean bl = false;
            TextHitInfo textHitInfo2 = TextHitInfo.beforeOffset(it);
            clientId3 = clientId2;
            component2 = component;
            n2 = n;
            attributedCharacterIterator = attributedCharacterIterator2;
            n3 = n5;
            textHitInfo = textHitInfo2;
        } else {
            textHitInfo = null;
        }
        TextHitInfo textHitInfo3 = null;
        TextHitInfo textHitInfo4 = textHitInfo;
        int n6 = n3;
        AttributedCharacterIterator attributedCharacterIterator3 = attributedCharacterIterator;
        int n7 = n2;
        Component component3 = component2;
        ClientId clientId4 = clientId3;
        return new ClientIdAwareInputMethodEvent(clientId4, component3, n7, attributedCharacterIterator3, n6, textHitInfo4, textHitInfo3);
    }

    @NotNull
    public static final InputMethodHighlight getCOMPOSED_TEXT_HIGHLIGHT() {
        return COMPOSED_TEXT_HIGHLIGHT;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[LxWindowEventType.values().length];
            try {
                nArray[LxWindowEventType.Activated.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxWindowEventType.Deactivated.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxWindowEventType.Closing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxWindowEventType.GainedFocus.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxWindowEventType.LostFocus.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LxKeyEventType.values().length];
            try {
                nArray[LxKeyEventType.Typed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxKeyEventType.Pressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxKeyEventType.Released.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[LxMouseEventType.values().length];
            try {
                nArray[LxMouseEventType.Clicked.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Pressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Released.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Moved.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Entered.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Exited.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Dragged.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxMouseEventType.Wheel.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[LxInputMethodEventType.values().length];
            try {
                nArray[LxInputMethodEventType.Text.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LxInputMethodEventType.Caret.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

