/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.backend.BackendTerminalSession;
import com.intellij.terminal.backend.ObservableTtyConnector;
import com.intellij.terminal.backend.StateAwareTerminalSession;
import com.intellij.terminal.backend.TerminalSessionStartKt;
import com.intellij.terminal.backend.TerminalSessionStartResult;
import com.intellij.util.CoroutinesKt;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TtyConnector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.block.reworked.session.rpc.TerminalSessionId;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0006J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/terminal/backend/TerminalSessionsManager;", "", "<init>", "()V", "sessionsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/terminal/block/reworked/session/rpc/TerminalSessionId;", "Lcom/intellij/terminal/backend/BackendTerminalSession;", "startSession", "Lcom/intellij/terminal/backend/TerminalSessionStartResult;", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getSession", "id", "storeSession", "session", "Companion", "intellij.terminal.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSessionsManager.kt\ncom/intellij/terminal/backend/TerminalSessionsManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n13#2:92\n*S KotlinDebug\n*F\n+ 1 TerminalSessionsManager.kt\ncom/intellij/terminal/backend/TerminalSessionsManager\n*L\n79#1:92\n*E\n"})
public final class TerminalSessionsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<TerminalSessionId, BackendTerminalSession> sessionsMap = new ConcurrentHashMap();
    @NotNull
    private static final AtomicInteger sessionIdCounter = new AtomicInteger(0);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final TerminalSessionStartResult startSession(@NotNull ShellStartupOptions options, @NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        TermSize termSize = options.getInitialTermSize();
        if (termSize == null) {
            TerminalSessionsManager $this$startSession_u24lambda_u240 = this;
            boolean bl = false;
            LOG.warn("No initial terminal size provided, using default 80x24. " + options);
            termSize = new TermSize(80, 24);
        }
        TermSize termSize2 = termSize;
        ShellStartupOptions optionsWithSize = options.builder().initialTermSize(termSize2).build();
        Pair<TtyConnector, ShellStartupOptions> pair = TerminalSessionStartKt.startTerminalProcess(project, optionsWithSize);
        TtyConnector ttyConnector = (TtyConnector)pair.component1();
        ShellStartupOptions configuredOptions = (ShellStartupOptions)pair.component2();
        ObservableTtyConnector observableTtyConnector = new ObservableTtyConnector(ttyConnector);
        CoroutineScope jediTermScope = CoroutineScopeKt.childScope$default((CoroutineScope)scope, (String)"JediTerm session", null, (boolean)false, (int)6, null);
        BackendTerminalSession jediTermSession = TerminalSessionStartKt.createTerminalSession(project, observableTtyConnector, configuredOptions, new JBTerminalSystemSettingsProvider(), jediTermScope);
        StateAwareTerminalSession stateAwareSession = new StateAwareTerminalSession(project, jediTermSession, scope);
        TerminalSessionId sessionId = this.storeSession(stateAwareSession, scope);
        return new TerminalSessionStartResult(configuredOptions, sessionId, observableTtyConnector);
    }

    @Nullable
    public final BackendTerminalSession getSession(@NotNull TerminalSessionId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.sessionsMap.get(id);
    }

    private final TerminalSessionId storeSession(BackendTerminalSession session2, CoroutineScope scope) {
        TerminalSessionId sessionId = new TerminalSessionId(sessionIdCounter.getAndIncrement());
        this.sessionsMap.put(sessionId, session2);
        CoroutinesKt.awaitCancellationAndInvoke$default((CoroutineScope)scope, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionId, null){
            int label;
            final /* synthetic */ TerminalSessionsManager this$0;
            final /* synthetic */ TerminalSessionId $sessionId;
            {
                this.this$0 = $receiver;
                this.$sessionId = $sessionId;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TerminalSessionsManager.access$getSessionsMap$p(this.this$0).remove(this.$sessionId);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return sessionId;
    }

    @JvmStatic
    @NotNull
    public static final TerminalSessionsManager getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessionsMap$p(TerminalSessionsManager $this) {
        return $this.sessionsMap;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalSessionsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/terminal/backend/TerminalSessionsManager$Companion;", "", "<init>", "()V", "sessionIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/terminal/backend/TerminalSessionsManager;", "intellij.terminal.backend"})
    @SourceDebugExtension(value={"SMAP\nTerminalSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalSessionsManager.kt\ncom/intellij/terminal/backend/TerminalSessionsManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,91:1\n42#2,3:92\n*S KotlinDebug\n*F\n+ 1 TerminalSessionsManager.kt\ncom/intellij/terminal/backend/TerminalSessionsManager$Companion\n*L\n82#1:92,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalSessionsManager getInstance() {
            boolean $i$f$service = false;
            Class<TerminalSessionsManager> serviceClass$iv = TerminalSessionsManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (TerminalSessionsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

