/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImplKt;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.session.scraper.DropTrailingNewLinesStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.SimpleStringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.StylesCollectingTerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.TerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.session.util.Debouncer;
import org.jetbrains.plugins.terminal.session.StyleRange;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraper;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "debounceTimeout", "", "<init>", "(Lcom/jediterm/terminal/model/TerminalTextBuffer;Lcom/intellij/openapi/Disposable;I)V", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputListener;", "debouncer", "Lorg/jetbrains/plugins/terminal/block/session/util/Debouncer;", "addListener", "", "listener", "useExtendedDelayOnce", "", "onContentChanged", "doOnContentChanged", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShellCommandOutputScraperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandOutputScraperImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl\n+ 2 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtilsKt\n*L\n1#1,117:1\n647#2,7:118\n*S KotlinDebug\n*F\n+ 1 ShellCommandOutputScraperImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl\n*L\n61#1:118,7\n*E\n"})
public final class ShellCommandOutputScraperImpl
implements ShellCommandOutputScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final List<ShellCommandOutputListener> listeners;
    @NotNull
    private final Debouncer debouncer;

    public ShellCommandOutputScraperImpl(@NotNull TerminalTextBuffer textBuffer, @NotNull Disposable parentDisposable, int debounceTimeout) {
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.textBuffer = textBuffer;
        this.listeners = new CopyOnWriteArrayList();
        this.debouncer = new Debouncer(debounceTimeout, parentDisposable);
        TerminalUtilKt.addModelListener(this.textBuffer, parentDisposable, () -> ShellCommandOutputScraperImpl._init_$lambda$0(this));
    }

    public /* synthetic */ ShellCommandOutputScraperImpl(TerminalTextBuffer terminalTextBuffer, Disposable disposable, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 50;
        }
        this(terminalTextBuffer, disposable, n);
    }

    public ShellCommandOutputScraperImpl(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2.getModel().getTextBuffer$intellij_terminal(), session2, 0, 4, null);
    }

    @Override
    public void addListener(@NotNull ShellCommandOutputListener listener2, @NotNull Disposable parentDisposable, boolean useExtendedDelayOnce) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.listeners, listener2, parentDisposable);
        this.debouncer.setExtendedDelayOnce();
    }

    private final void onContentChanged() {
        if (!((Collection)this.listeners).isEmpty()) {
            this.debouncer.execute((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ShellCommandOutputScraperImpl.access$doOnContentChanged((ShellCommandOutputScraperImpl)this.receiver);
                }
            }));
        }
    }

    private final void doOnContentChanged() {
        if (!((Collection)this.listeners).isEmpty()) {
            StyledCommandOutput output = this.scrapeOutput();
            for (ShellCommandOutputListener listener2 : this.listeners) {
                listener2.commandOutputChanged(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StyledCommandOutput scrapeOutput() {
        StyledCommandOutput styledCommandOutput;
        TerminalTextBuffer $this$withLock$iv = this.textBuffer;
        boolean $i$f$withLock = false;
        $this$withLock$iv.lock();
        try {
            TerminalTextBuffer it = $this$withLock$iv;
            boolean bl = false;
            styledCommandOutput = org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl$Companion.scrapeOutput$default(Companion, this.textBuffer, 0, 2, null);
        }
        finally {
            $this$withLock$iv.unlock();
        }
        return styledCommandOutput;
    }

    private static final void _init_$lambda$0(ShellCommandOutputScraperImpl this$0) {
        this$0.onContentChanged();
    }

    public static final /* synthetic */ void access$doOnContentChanged(ShellCommandOutputScraperImpl $this) {
        $this.doOnContentChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandOutputScraperImpl$Companion;", "", "<init>", "()V", "scrapeOutput", "Lorg/jetbrains/plugins/terminal/block/session/StyledCommandOutput;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "startLine", "", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull BlockTerminalSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            return org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl$Companion.scrapeOutput$default(this, session2.getModel().getTextBuffer$intellij_terminal(), 0, 2, null);
        }

        @NotNull
        public final StyledCommandOutput scrapeOutput(@NotNull TerminalTextBuffer textBuffer, int startLine) {
            TerminalLinesCollector styleCollectingOutputBuilder2;
            Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
            StringCollector stringCollector = new DropTrailingNewLinesStringCollector(new SimpleStringCollector());
            List styles = new ArrayList();
            TerminalLinesCollector terminalLinesCollector2 = styleCollectingOutputBuilder2 = (TerminalLinesCollector)new StylesCollectingTerminalLinesCollector(stringCollector, (Function1<? super StyleRange, Unit>)((Function1)new Function1<StyleRange, Unit>((Object)styles){

                public final void invoke(StyleRange p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)this.receiver).add(p0);
                }
            }));
            ShellCommandOutputScraperImplKt.collectLines(textBuffer, terminalLinesCollector2, startLine);
            return new StyledCommandOutput(stringCollector.buildText(), styles);
        }

        public static /* synthetic */ StyledCommandOutput scrapeOutput$default(Companion companion, TerminalTextBuffer terminalTextBuffer, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = -terminalTextBuffer.getHistoryLinesCount();
            }
            return companion.scrapeOutput(terminalTextBuffer, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

