/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.intellij.commandInterface.command.Argument;
import com.intellij.commandInterface.command.ArgumentsInfo;
import com.intellij.commandInterface.command.CommandExecutor;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.KnownArgumentsInfo;
import com.intellij.commandInterface.command.NoArgumentsInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.django.manage.DjangoManageCommandType;
import com.intellij.python.django.manage.DjangoStartAppExecutor;
import com.intellij.python.django.manage.FailedToProvideCommandsException;
import com.intellij.python.django.manage.ShellExecutor;
import com.intellij.python.django.manage.SpecialCaseInfo;
import com.intellij.python.django.manage.TestsExecutor;
import com.intellij.python.django.manage.externalUrl.DjangoExternalUrlsCommand;
import com.intellij.python.django.manage.externalUrl.DjangoExternalUrlsRoot;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.python.extensions.RegistryValueExtKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialCaseCommandsProvider {
    @NotNull
    private final Map<String, Pair<ArgumentsInfo, CommandExecutor>> myArgumentsAndExecutors;
    @NotNull
    private final Map<String, DjangoExternalUrlsCommand> myExternalUrls;
    private final Set<String> myCommandsToUseNativeRunner;

    public SpecialCaseCommandsProvider(@NotNull Module module) throws FailedToProvideCommandsException {
        if (module == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(0);
        }
        this.myArgumentsAndExecutors = new HashMap<String, Pair<ArgumentsInfo, CommandExecutor>>();
        this.myExternalUrls = new HashMap<String, DjangoExternalUrlsCommand>();
        this.myCommandsToUseNativeRunner = new HashSet<String>();
        this.fillArgumentsAndExecutors(module);
        this.myExternalUrls.putAll(DjangoExternalUrlsRoot.getCommands(module));
        this.myCommandsToUseNativeRunner.addAll(RegistryValueExtKt.asList((RegistryValue)Registry.get((String)"python.django.commandsToUseNativeRunner")));
    }

    private void fillArgumentsAndExecutors(@NotNull Module module) throws FailedToProvideCommandsException {
        DjangoModelApi api;
        if (module == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(1);
        }
        if ((api = (DjangoModelApi)DjangoModelApi.create((Module)module).getSuccessOrNull()) == null) {
            throw new FailedToProvideCommandsException("No django on module " + String.valueOf(module));
        }
        List applications = api.getApplications();
        ArrayList<String> appNames = new ArrayList<String>(applications.size());
        ArrayList<String> appLabels = new ArrayList<String>(applications.size());
        for (DjangoApplicationModel application : applications) {
            appNames.add(application.getName());
            appLabels.add(application.getLabel());
        }
        Argument applicationArgument = new Argument(new Help("appname"), Pair.create(appLabels, (Object)true));
        KnownArgumentsInfo infiniteAppArgs = new KnownArgumentsInfo(0, Integer.MAX_VALUE, new Argument[]{applicationArgument});
        KnownArgumentsInfo mandatoryAppArg = new KnownArgumentsInfo(1, Integer.MAX_VALUE, new Argument[]{applicationArgument});
        KnownArgumentsInfo appAndMigrateArgument = new KnownArgumentsInfo(0, 2, new Argument[]{applicationArgument, new Argument(new Help("migrationname"))});
        this.addCommand(DjangoManageCommandType.CHECK, (ArgumentsInfo)infiniteAppArgs);
        this.addCommand(DjangoManageCommandType.COMPILEMESSAGES, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.CREATECACHETABLE, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.DBSHELL, NoArgumentsInfo.INSTANCE, ShellExecutor.INSTANCE);
        this.addCommand(DjangoManageCommandType.DIFFSETTINGS, NoArgumentsInfo.INSTANCE);
        Argument dumpDataArg = new Argument(new Help("app_label app_label app_label.Model ..."), Pair.create(appLabels, (Object)false));
        this.addCommand(DjangoManageCommandType.DUMPDATA, (ArgumentsInfo)new KnownArgumentsInfo(0, Integer.MAX_VALUE, new Argument[]{dumpDataArg}));
        this.addCommand(DjangoManageCommandType.FLUSH, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.MAKEMESSAGES, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.MAKEMIGRATIONS, (ArgumentsInfo)infiniteAppArgs);
        this.addCommand(DjangoManageCommandType.MIGRATE, (ArgumentsInfo)appAndMigrateArgument);
        this.addCommand(DjangoManageCommandType.RUNSERVER, (ArgumentsInfo)new KnownArgumentsInfo(0, 1, new Argument[]{new Argument(new Help("[port or address:port]"))}));
        this.addCommand(DjangoManageCommandType.SHELL, NoArgumentsInfo.INSTANCE, ShellExecutor.INSTANCE);
        this.addCommand(DjangoManageCommandType.SQL, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLALL, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLCLEAR, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLCUSTOM, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLDROPINDEXES, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLFLUSH, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLINDEXES, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQLMIGRATE, (ArgumentsInfo)appAndMigrateArgument);
        this.addCommand(DjangoManageCommandType.SQLSEQUENCERESET, (ArgumentsInfo)mandatoryAppArg);
        this.addCommand(DjangoManageCommandType.SQUASHMIGRATIONS, (ArgumentsInfo)appAndMigrateArgument);
        this.addCommand(DjangoManageCommandType.STARTAPP, (ArgumentsInfo)new KnownArgumentsInfo(1, 2, new Argument[]{new Argument(new Help("<app_label>")), new Argument(new Help("[destination]"))}), DjangoStartAppExecutor.Companion.getINSTANCE());
        this.addCommand(DjangoManageCommandType.STARTPROJECT, (ArgumentsInfo)new KnownArgumentsInfo(1, 2, new Argument[]{new Argument(new Help("<projectname>")), new Argument(new Help("[destination]"))}));
        this.addCommand(DjangoManageCommandType.SYNCDB, NoArgumentsInfo.INSTANCE);
        Argument testArg = new Argument(new Help("<app or test identifier>"), Pair.create(appNames, (Object)false));
        this.addCommand(DjangoManageCommandType.TEST, (ArgumentsInfo)new KnownArgumentsInfo(0, Integer.MAX_VALUE, new Argument[]{testArg}), TestsExecutor.INSTANCE);
        this.addCommand(DjangoManageCommandType.TESTSERVER, (ArgumentsInfo)new KnownArgumentsInfo(1, Integer.MAX_VALUE, new Argument[]{new Argument(new Help("<fixture>"))}));
        this.addCommand(DjangoManageCommandType.VALIDATE, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.CHANGEPASSWORD, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.CREATESUPERUSER, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.OGRINSPECT, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.CLEARSESSIONS, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.PING_GOOGLE, NoArgumentsInfo.INSTANCE);
        this.addCommand(DjangoManageCommandType.COLLECTSTATIC, NoArgumentsInfo.INSTANCE);
    }

    private void addCommand(@NotNull DjangoManageCommandType commandType, @NotNull ArgumentsInfo argumentsInfo, @Nullable CommandExecutor executor) {
        if (commandType == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(2);
        }
        if (argumentsInfo == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(3);
        }
        this.myArgumentsAndExecutors.put(StringUtil.trim((String)commandType.getCommandName()), (Pair<ArgumentsInfo, CommandExecutor>)Pair.create((Object)argumentsInfo, (Object)executor));
    }

    private void addCommand(@NotNull DjangoManageCommandType commandType, @NotNull ArgumentsInfo argumentsInfo) {
        if (commandType == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(4);
        }
        if (argumentsInfo == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(5);
        }
        this.addCommand(commandType, argumentsInfo, null);
    }

    @Nullable
    public SpecialCaseInfo getSpecialCaseInfo(@NotNull String commandName) {
        if (commandName == null) {
            SpecialCaseCommandsProvider.$$$reportNull$$$0(6);
        }
        if (this.myCommandsToUseNativeRunner.contains(commandName)) {
            return null;
        }
        String href = null;
        Map<String, String> optionHrefs = null;
        DjangoExternalUrlsCommand urlInfo = this.myExternalUrls.get(commandName);
        if (urlInfo != null) {
            href = urlInfo.getHref();
            optionHrefs = urlInfo.getOptionHrefs();
        }
        Pair<ArgumentsInfo, CommandExecutor> info = this.myArgumentsAndExecutors.get(commandName);
        ArgumentsInfo argumentsInfo = null;
        CommandExecutor executor = null;
        if (info != null) {
            argumentsInfo = (ArgumentsInfo)info.first;
            executor = (CommandExecutor)info.second;
        }
        if (executor == null && href == null && argumentsInfo == null) {
            return null;
        }
        return new SpecialCaseInfo(executor, href, argumentsInfo, optionHrefs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/manage/SpecialCaseCommandsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fillArgumentsAndExecutors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpecialCaseInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

