/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ui;

import com.google.common.collect.Ordering;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.python.django.ui.DjangoTemplateFileFactory;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.ui.IdeaDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateTemplateDialog
extends IdeaDialog {
    private JCheckBox myCreateTemplateCheckBox;
    private JTextField myTemplateNameField;
    private final DjangoTemplateFileFactory myTemplateFileFactory;
    private final PsiElement myElement;
    private List<VirtualFile> myTemplateFolders;
    private final Project myProject;
    private boolean myTemplateNameEditable;
    private JPanel myPanel;
    private JComboBox myTemplateRootComboBox;
    private TextFieldWithBrowseButton myTemplateFolder;
    private JLabel myChooserLabel;
    private JLabel myComboLabel;

    public static DjangoTemplateFileFactory createTemplateFileFactory() {
        return DjangoTemplateFileFactory.acceptsRelativePath();
    }

    public CreateTemplateDialog(Project project, PsiElement element) {
        super(project);
        this.$$$setupUI$$$();
        this.myTemplateFileFactory = CreateTemplateDialog.createTemplateFileFactory();
        this.myProject = project;
        this.myElement = element;
        this.setTitle(DjangoBundle.message((String)"django.templates.create.capitalized", (Object[])new Object[0]));
        this.initTemplateFolders();
        if (this.myTemplateFolders.isEmpty()) {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false).withTitle(DjangoBundle.message((String)"select-template-folder", (Object[])new Object[0])).withDescription(DjangoBundle.message((String)"select-template-folder-text", (Object[])new Object[0]));
            this.myTemplateFolder.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener((ComponentWithBrowseButton)this.myTemplateFolder, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
            this.myTemplateFolder.setTextFieldPreferredWidth(50);
            this.myComboLabel.setVisible(false);
            this.myTemplateRootComboBox.setVisible(false);
        } else {
            this.myChooserLabel.setVisible(false);
            this.myTemplateFolder.setVisible(false);
        }
        this.myCreateTemplateCheckBox.setSelected(true);
        this.myCreateTemplateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTemplateDialog.this.enableCreateControls(CreateTemplateDialog.this.myCreateTemplateCheckBox.isSelected());
            }
        });
        this.addUpdater(this.myTemplateNameField);
        this.addUpdater(this.myCreateTemplateCheckBox);
        this.addUpdater(this.myTemplateFolder.getTextField());
        this.init();
        this.initValidation();
    }

    public void setTemplateNameEditable(boolean isEditable) {
        this.myTemplateNameEditable = isEditable;
        this.myTemplateNameField.setEditable(isEditable);
    }

    private void initTemplateFolders() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        this.myTemplateFolders = module != null ? DjangoTemplateManager.getInstance((Module)module).getTemplatesFolderList(true, this.myElement, true) : new ArrayList<VirtualFile>();
        if (!this.myTemplateFolders.isEmpty()) {
            int longestTemplatePath = ((VirtualFile)new Ordering<VirtualFile>(this){

                public int compare(@Nullable VirtualFile left, @Nullable VirtualFile right) {
                    Integer leftLength = (left != null ? left.getPath() : "").length();
                    int rightLength = (right != null ? right.getPath() : "").length();
                    return leftLength.compareTo(rightLength);
                }
            }.max(this.myTemplateFolders)).getPath().length();
            Dimension dimension = GuiUtils.getSizeByChars((int)longestTemplatePath, (JComponent)this.myTemplateRootComboBox);
            this.myTemplateRootComboBox.setPreferredSize(new Dimension(dimension.width + 10, dimension.height));
        }
    }

    public void setShowCreateTemplateCheckBox(boolean showCreateTemplateCheckBox) {
        this.myCreateTemplateCheckBox.setVisible(showCreateTemplateCheckBox);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public List<VirtualFile> getTemplateFolderList() {
        return this.myTemplateFolders;
    }

    private void enableCreateControls(boolean enable) {
        if (!this.myTemplateNameEditable) {
            this.myTemplateNameField.setEnabled(enable);
        }
        this.myTemplateFolder.setEnabled(enable);
        this.myTemplateRootComboBox.setEnabled(enable);
    }

    public void setTemplateName(String name) {
        this.myTemplateNameField.setText(FileUtil.toSystemDependentName((String)name));
    }

    @Nullable
    public String getTemplateName() {
        return this.myCreateTemplateCheckBox.isSelected() ? this.myTemplateNameField.getText() : null;
    }

    public boolean isCreateTemplate() {
        return this.myCreateTemplateCheckBox.isSelected();
    }

    public VirtualFile getSelectedTemplateRoot() {
        if (this.myTemplateFolders.isEmpty()) {
            return VirtualFileUtil.findFile((String)this.myTemplateFolder.getText());
        }
        return this.myTemplateFolders.get(this.myTemplateRootComboBox.getSelectedIndex());
    }

    public void show() {
        ArrayList<String> templateFolders = new ArrayList<String>();
        for (VirtualFile vf : this.myTemplateFolders) {
            templateFolders.add(FileUtil.toSystemDependentName((String)vf.getPath()));
        }
        for (String s : templateFolders) {
            this.myTemplateRootComboBox.addItem(s);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Shouldn't be shown under write action as it uses file chooser");
        }
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTemplateNameField;
    }

    protected ValidationInfo doValidate() {
        if (this.myCreateTemplateCheckBox.isSelected()) {
            if (!this.myTemplateFileFactory.isValid(this.myTemplateNameField.getText())) {
                return new ValidationInfo(DjangoBundle.message((String)"django.templates.name.not.valid", (Object[])new Object[0]), (JComponent)this.myTemplateNameField);
            }
            if (this.myTemplateFolders.isEmpty()) {
                if (StringUtil.isEmpty((String)this.myTemplateFolder.getText())) {
                    return new ValidationInfo(DjangoBundle.message((String)"django.templates.root.not.specified", (Object[])new Object[0]), (JComponent)this.myTemplateFolder);
                }
                if (!new File(this.myTemplateFolder.getText()).exists()) {
                    return new ValidationInfo(DjangoBundle.message((String)"django.templates.root.folder.missing", (Object[])new Object[0]), (JComponent)this.myTemplateFolder);
                }
            } else if (this.myTemplateRootComboBox.getSelectedIndex() < 0 || this.myTemplateRootComboBox.getSelectedIndex() >= this.myTemplateFolders.size()) {
                return new ValidationInfo(DjangoBundle.message((String)"django.templates.root.selection.invalid", (Object[])new Object[0]));
            }
            String templateName = this.getTemplateName();
            if (this.isTemplateExists(this.getTemplatesFolder(), templateName)) {
                return new ValidationInfo(DjangoBundle.message((String)"django.templates.with.name.exists", (Object[])new Object[]{templateName}), (JComponent)this.myTemplateNameField);
            }
        }
        return super.doValidate();
    }

    private boolean isTemplateExists(PsiDirectory templatesFolder2, String templateName) {
        if (templatesFolder2 != null && templateName != null) {
            return this.myTemplateFileFactory.exists(templatesFolder2, templateName);
        }
        return false;
    }

    public DjangoTemplateFileFactory getTemplateFileFactory() {
        return this.myTemplateFileFactory;
    }

    public PsiDirectory getTemplatesFolder() {
        @Nullable VirtualFile templatesRoot = this.getSelectedTemplateRoot();
        if (templatesRoot != null) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(templatesRoot);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DjangoBundle", CreateTemplateDialog.class).getString("template.path"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myTemplateNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myComboLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DjangoBundle", CreateTemplateDialog.class).getString("templates.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myCreateTemplateCheckBox = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DjangoBundle", CreateTemplateDialog.class).getString("django.templates.checkbox.create"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox comboBox = new ComboBox();
        this.myTemplateRootComboBox = comboBox;
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        this.myChooserLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DjangoBundle", CreateTemplateDialog.class).getString("templates.root"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myTemplateFolder = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

