/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.feedback.ide;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.feedback.dialog.BaseFeedbackSystemInfoDialogKt;
import com.intellij.platform.feedback.dialog.BlockBasedFeedbackDialog;
import com.intellij.platform.feedback.dialog.CommonFeedbackSystemData;
import com.intellij.platform.feedback.dialog.uiBlocks.DescriptionBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.FeedbackBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TextAreaBlock;
import com.intellij.platform.feedback.dialog.uiBlocks.TopLabelBlock;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.impl.feedback.ide.FullLineFeedbackSystemData;
import org.jetbrains.completion.full.line.impl.settings.FullLineBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0012\u001a\u00020\u0002H\u0094@\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH&\u00a2\u0006\u0002\u0010\u001cR\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineInIdeFeedbackSurveyDialog;", "Lcom/intellij/platform/feedback/dialog/BlockBasedFeedbackDialog;", "Lorg/jetbrains/completion/full/line/impl/feedback/ide/FullLineFeedbackSystemData;", "project", "Lcom/intellij/openapi/project/Project;", "forTest", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "ideName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getIdeName", "()Ljava/lang/String;", "myFeedbackJsonVersion", "", "getMyFeedbackJsonVersion", "()I", "computeSystemInfoData", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showFeedbackSystemInfoDialog", "", "systemInfoData", "myTitle", "getMyTitle", "myQuestionsContent", "", "Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "()[Lcom/intellij/platform/feedback/dialog/uiBlocks/FeedbackBlock;", "myBlocks", "", "getMyBlocks", "()Ljava/util/List;", "intellij.fullLine.core.impl"})
public abstract class FullLineInIdeFeedbackSurveyDialog
extends BlockBasedFeedbackDialog<FullLineFeedbackSystemData> {
    @NotNull
    private final String ideName;
    private final int myFeedbackJsonVersion;
    @NotNull
    private final String myTitle;

    public FullLineInIdeFeedbackSurveyDialog(@NotNull Project project, boolean forTest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, forTest);
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        this.ideName = string;
        this.myFeedbackJsonVersion = super.getMyFeedbackJsonVersion() + 1;
        Object[] objectArray = new Object[]{this.ideName};
        this.myTitle = FullLineBundle.message("full.line.survey.title", objectArray);
        this.init();
    }

    @NotNull
    protected final String getIdeName() {
        return this.ideName;
    }

    protected int getMyFeedbackJsonVersion() {
        return this.myFeedbackJsonVersion;
    }

    @Nullable
    protected Object computeSystemInfoData(@NotNull Continuation<? super FullLineFeedbackSystemData> $completion) {
        return FullLineInIdeFeedbackSurveyDialog.computeSystemInfoData$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object computeSystemInfoData$suspendImpl(FullLineInIdeFeedbackSurveyDialog $this, Continuation<? super FullLineFeedbackSystemData> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super FullLineFeedbackSystemData>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return FullLineFeedbackSystemData.Companion.getCurrentData();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super FullLineFeedbackSystemData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    protected void showFeedbackSystemInfoDialog(@NotNull FullLineFeedbackSystemData systemInfoData) {
        Intrinsics.checkNotNullParameter((Object)systemInfoData, (String)"systemInfoData");
        BaseFeedbackSystemInfoDialogKt.showFeedbackSystemInfoDialog((Project)this.getMyProject(), (CommonFeedbackSystemData)systemInfoData.getSystemInfo(), arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0(systemInfoData, arg_0));
    }

    @NotNull
    protected String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    public abstract FeedbackBlock[] myQuestionsContent();

    @NotNull
    protected List<FeedbackBlock> getMyBlocks() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        Object[] objectArray = new Object[]{this.ideName};
        spreadBuilder.add((Object)new TopLabelBlock(FullLineBundle.message("full.line.survey.title", objectArray)));
        objectArray = new Object[]{this.ideName};
        spreadBuilder.add((Object)new DescriptionBlock(FullLineBundle.message("full.line.survey.description", objectArray)));
        spreadBuilder.addSpread((Object)this.myQuestionsContent());
        spreadBuilder.add((Object)new TextAreaBlock(FullLineBundle.message("full.line.survey.question.last.text", new Object[0]), "textarea"));
        return CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new FeedbackBlock[spreadBuilder.size()]));
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0(FullLineFeedbackSystemData $systemInfoData, Panel $this$showFeedbackSystemInfoDialog) {
        Intrinsics.checkNotNullParameter((Object)$this$showFeedbackSystemInfoDialog, (String)"$this$showFeedbackSystemInfoDialog");
        $this$showFeedbackSystemInfoDialog.row("FLCC Plugin version:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$0($systemInfoData, arg_0));
        $this$showFeedbackSystemInfoDialog.row("Accepted count:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$1($systemInfoData, arg_0));
        $this$showFeedbackSystemInfoDialog.row("Language:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$2($systemInfoData, arg_0));
        $this$showFeedbackSystemInfoDialog.row("Group:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$3($systemInfoData, arg_0));
        $this$showFeedbackSystemInfoDialog.row("Sessions to notify:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$4($systemInfoData, arg_0));
        $this$showFeedbackSystemInfoDialog.row("Coefficient threshold:", arg_0 -> FullLineInIdeFeedbackSurveyDialog.showFeedbackSystemInfoDialog$lambda$0$5($systemInfoData, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$0(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getFlccPluginVersion()));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$1(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getAcceptedCount()));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$2(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getLanguage()));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$3(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getGroup()));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$4(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getSessionsToNotify()));
        return Unit.INSTANCE;
    }

    private static final Unit showFeedbackSystemInfoDialog$lambda$0$5(FullLineFeedbackSystemData $systemInfoData, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label(String.valueOf($systemInfoData.getCoefficientThreshold()));
        return Unit.INSTANCE;
    }
}

