/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.naming;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "dbms", "Lcom/intellij/database/Dbms;", "casing", "Lcom/intellij/database/util/Casing;", "<init>", "(Lcom/intellij/database/Dbms;Lcom/intellij/database/util/Casing;)V", "isPure", "", "name", "", "Provider", "intellij.database.dialects.generic"})
public final class GenericNamingService
extends AbstractNamingService {
    public GenericNamingService(@NotNull Dbms dbms, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        Pattern pattern = Pattern.compile("\\p{IsAlphabetic}[\\p{IsAlphabetic}\\d_]*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        super(dbms, pattern, casing);
    }

    public boolean isPure(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.getCasing().plain == this.getCasing().quoted ? this.isPlain(name2) : super.isPure(name2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007RV\u0010\b\u001aJ\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b*#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\u000e\u00a2\u0006\u0002\b\r0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "generics", "", "Lcom/intellij/database/util/Casing;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/script/generator/NamingService;", "Lorg/jetbrains/annotations/NotNull;", "", "getNamingService", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.generic"})
    public static final class Provider
    implements NamingService.Provider {
        @NotNull
        private final Dbms dbms;
        @NotNull
        private final Map<Casing, NamingService> generics;

        public Provider(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.dbms = dbms;
            Map map = FactoryMap.create(arg_0 -> Provider.generics$lambda$1(arg_0 -> Provider.generics$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
            this.generics = map;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            BasicModel basicModel = model;
            if (basicModel == null || (basicModel = basicModel.getRoot()) == null || (basicModel = basicModel.getDefaultCasing()) == null) {
                basicModel = CasingProvider.MIXED_CASING;
            }
            NamingService namingService = this.generics.get(basicModel);
            Intrinsics.checkNotNull((Object)namingService);
            return namingService;
        }

        private static final NamingService generics$lambda$0(Provider this$0, Casing it) {
            Dbms dbms = this$0.dbms;
            Intrinsics.checkNotNull((Object)it);
            return (NamingService)new GenericNamingService(dbms, it);
        }

        private static final NamingService generics$lambda$1(Function1 $tmp0, Object p0) {
            return (NamingService)$tmp0.invoke(p0);
        }
    }
}

