/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.protocol.startup.parameters;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelArgumentsBuilder;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelOwnParams;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\u0012\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelArgs;", "T", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelOwnParams;", "", "cfgFile", "Ljava/io/File;", "ownParams", "<init>", "(Ljava/io/File;Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelOwnParams;)V", "getCfgFile", "()Ljava/io/File;", "getOwnParams", "()Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelOwnParams;", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelOwnParams;", "argsList", "", "", "component1", "component2", "copy", "(Ljava/io/File;Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelOwnParams;)Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelArgs;", "equals", "", "other", "hashCode", "", "toString", "protocol"})
public final class KernelArgs<T extends KernelOwnParams> {
    @NotNull
    private final File cfgFile;
    @NotNull
    private final T ownParams;

    public KernelArgs(@NotNull File cfgFile, @NotNull T ownParams) {
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        Intrinsics.checkNotNullParameter(ownParams, (String)"ownParams");
        this.cfgFile = cfgFile;
        this.ownParams = ownParams;
    }

    @NotNull
    public final File getCfgFile() {
        return this.cfgFile;
    }

    @NotNull
    public final T getOwnParams() {
        return this.ownParams;
    }

    @NotNull
    public final List<String> argsList() {
        return new KernelArgumentsBuilder(this.ownParams.createBuilder(), this.cfgFile).argsList();
    }

    @NotNull
    public final File component1() {
        return this.cfgFile;
    }

    @NotNull
    public final T component2() {
        return this.ownParams;
    }

    @NotNull
    public final KernelArgs<T> copy(@NotNull File cfgFile, @NotNull T ownParams) {
        Intrinsics.checkNotNullParameter((Object)cfgFile, (String)"cfgFile");
        Intrinsics.checkNotNullParameter(ownParams, (String)"ownParams");
        return new KernelArgs<T>(cfgFile, ownParams);
    }

    public static /* synthetic */ KernelArgs copy$default(KernelArgs kernelArgs, File file, KernelOwnParams kernelOwnParams, int n, Object object) {
        if ((n & 1) != 0) {
            file = kernelArgs.cfgFile;
        }
        if ((n & 2) != 0) {
            kernelOwnParams = kernelArgs.ownParams;
        }
        return kernelArgs.copy(file, kernelOwnParams);
    }

    @NotNull
    public String toString() {
        return "KernelArgs(cfgFile=" + this.cfgFile + ", ownParams=" + this.ownParams + ")";
    }

    public int hashCode() {
        int result = this.cfgFile.hashCode();
        result = result * 31 + this.ownParams.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KernelArgs)) {
            return false;
        }
        KernelArgs kernelArgs = (KernelArgs)other;
        if (!Intrinsics.areEqual((Object)this.cfgFile, (Object)kernelArgs.cfgFile)) {
            return false;
        }
        return Intrinsics.areEqual(this.ownParams, kernelArgs.ownParams);
    }
}

