/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSArrayIteratorObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSArrayIterator
extends JSNonProxy
implements JSConstructorFactory,
PrototypeSupplier {
    public static final TruffleString TO_STRING_TAG;
    public static final TruffleString CLASS_NAME;
    public static final TruffleString PROTOTYPE_NAME;
    public static final JSArrayIterator INSTANCE;

    private JSArrayIterator() {
    }

    public static JSArrayIteratorObject create(JSContext context, JSRealm realm, Object iteratedObject, long nextIndex, int iterationKind) {
        JSObjectFactory factory = context.getArrayIteratorFactory();
        JSDynamicObject proto = factory.getPrototype(realm);
        Shape shape = factory.getShape(realm, proto);
        JSArrayIteratorObject newObj = factory.initProto(new JSArrayIteratorObject(shape, proto, iteratedObject, nextIndex, iterationKind), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, ArrayIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, TO_STRING_TAG);
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public TruffleString getClassName(JSDynamicObject object) {
        return this.getClassName();
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getArrayIteratorPrototype();
    }

    static {
        CLASS_NAME = TO_STRING_TAG = Strings.constant("Array Iterator");
        PROTOTYPE_NAME = Strings.constant("Array Iterator.prototype");
        INSTANCE = new JSArrayIterator();
    }
}

