/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.CharPercentEscaper;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Location;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0014\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\f2\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"PATTERN_PARAMETERS_POSTFIX", "", "DIRECT_SLASH_OR_DISK_LETTER", "SLASH", "ESCAPED_SLASH", "createUrlRegExp", "location", "Lorg/jetbrains/debugger/Location;", "useCaseSensitiveUrl", "", "REGEX_CHARS", "", "", "escapePath", "", "backslashAware", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUrl", "start", "end", "matches", "regExp", "url", "Lcom/intellij/util/Url;", "match", "input", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJavaScriptLineBreakpointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptLineBreakpointManager.kt\ncom/intellij/javascript/debugger/JavaScriptLineBreakpointManagerKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,455:1\n975#2:456\n1046#2,3:457\n*S KotlinDebug\n*F\n+ 1 JavaScriptLineBreakpointManager.kt\ncom/intellij/javascript/debugger/JavaScriptLineBreakpointManagerKt\n*L\n385#1:456\n385#1:457,3\n*E\n"})
public final class JavaScriptLineBreakpointManagerKt {
    @NotNull
    public static final String PATTERN_PARAMETERS_POSTFIX = "([;?#!].*)?$";
    @NotNull
    public static final String DIRECT_SLASH_OR_DISK_LETTER = "(?:(?:file:\\/\\/)?\\/|(?:[\\w]:))";
    @NotNull
    public static final String SLASH = "[\\/|\\\\]";
    @NotNull
    public static final String ESCAPED_SLASH = "[/\\\\]";
    @NotNull
    private static final Set<Integer> REGEX_CHARS;

    private static final String createUrlRegExp(Location location, boolean useCaseSensitiveUrl) {
        StringBuilder builder = new StringBuilder();
        Url url = location.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"getUrl(...)");
        Url url2 = url;
        String scheme = url2.getScheme();
        if (scheme == null) {
            builder.append('^');
            String string = url2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string, 0, 0, useCaseSensitiveUrl, 16, null);
        } else {
            String string = PathUtilRt.getFileName((String)url2.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String filename = string;
            if (StringsKt.startsWith$default((String)filename, (String)"index.", (boolean)false, (int)2, null) && !url2.isInLocalFileSystem()) {
                builder.append('^');
                builder.append(scheme).append("://");
                String string2 = url2.getAuthority();
                Intrinsics.checkNotNull((Object)string2);
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string2, 0, 0, useCaseSensitiveUrl, 24, null);
                builder.append('/');
                int dirLength = url2.getPath().length() - filename.length();
                if (dirLength > 0) {
                    builder.append('(');
                    String string3 = url2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    JavaScriptLineBreakpointManagerKt.escapePath(false, builder, string3, 1, dirLength, useCaseSensitiveUrl);
                    builder.append('|').append("[^.;?#]+");
                    builder.append(')').append('?');
                }
                builder.append('(');
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, filename, 0, 0, useCaseSensitiveUrl, 16, null);
                builder.append(')').append('?');
            } else {
                boolean useDetailed;
                boolean bl = useDetailed = location.getScript() != null;
                if (!useDetailed) {
                    builder.append(ESCAPED_SLASH);
                }
                String string4 = useDetailed ? url2.getPath() : filename;
                Intrinsics.checkNotNull((Object)string4);
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string4, 0, 0, useDetailed || useCaseSensitiveUrl, 16, null);
            }
        }
        builder.append(PATTERN_PARAMETERS_POSTFIX);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result = string;
        String string5 = location.getUrl().toDecodedForm();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toDecodedForm(...)");
        if (!JavaScriptLineBreakpointManagerKt.match(result, string5)) {
            JavaScriptDebugProcessKt.getLOG().error("Breakpoint regexp doesn't match url: url = " + url2 + ", regexp = " + result);
        }
        return result;
    }

    public static final void escapePath(boolean backslashAware, @NotNull StringBuilder builder, @NotNull String encodedUrl, int start2, int end, boolean useCaseSensitiveUrl) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)encodedUrl, (String)"encodedUrl");
        PrimitiveIterator.OfInt ofInt = encodedUrl.codePoints().skip(start2).limit((long)end - (long)start2).iterator();
        while (ofInt.hasNext()) {
            StringBuilder stringBuilder;
            int n;
            Integer c = ofInt.next();
            if (backslashAware) {
                Integer n2 = c;
                n = 92;
                if (n2 != null && n2 == n) {
                    stringBuilder = builder.append(ESCAPED_SLASH);
                    continue;
                }
            }
            Integer n3 = c;
            n = 47;
            if (n3 != null && n3 == n) {
                if (backslashAware) {
                    stringBuilder = builder.append(ESCAPED_SLASH);
                    continue;
                }
                Intrinsics.checkNotNull((Object)c);
                stringBuilder = builder.appendCodePoint(c);
                continue;
            }
            if (!useCaseSensitiveUrl) {
                int lowerCasedChar;
                int upperCasedChar;
                Intrinsics.checkNotNull((Object)c);
                if (Character.isLetter(c) && (upperCasedChar = Character.toUpperCase(c)) != (lowerCasedChar = Character.toLowerCase(c))) {
                    StringBuilder stringBuilder2;
                    if (CharPercentEscaper.isSafe(c)) {
                        stringBuilder2 = builder.append('[').appendCodePoint(lowerCasedChar).appendCodePoint(upperCasedChar).append(']');
                        continue;
                    }
                    builder.append("(?:").appendCodePoint(lowerCasedChar).append('|').appendCodePoint(upperCasedChar).append('|');
                    CharPercentEscaper.escape(c, builder);
                    stringBuilder2 = builder.append(')');
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)c);
            if (!CharPercentEscaper.isSafe(c)) {
                builder.append("(?:");
                if (REGEX_CHARS.contains(c)) {
                    builder.append('\\');
                }
                builder.appendCodePoint(c).append('|');
                CharPercentEscaper.escape(c, builder);
                builder.append(')');
                continue;
            }
            if (REGEX_CHARS.contains(c)) {
                builder.append('\\');
            }
            stringBuilder = builder.appendCodePoint(c);
        }
    }

    public static /* synthetic */ void escapePath$default(boolean bl, StringBuilder stringBuilder, String string, int n, int n2, boolean bl2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = string.length();
        }
        if ((n3 & 0x20) != 0) {
            bl2 = true;
        }
        JavaScriptLineBreakpointManagerKt.escapePath(bl, stringBuilder, string, n, n2, bl2);
    }

    public static final boolean matches(@NotNull String regExp, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        return JavaScriptLineBreakpointManagerKt.match(regExp, string);
    }

    public static final boolean match(@NotNull String regExp, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            return Pattern.compile(regExp).matcher(input).find();
        }
        catch (PatternSyntaxException e) {
            JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            return false;
        }
    }

    public static final /* synthetic */ String access$createUrlRegExp(Location location, boolean useCaseSensitiveUrl) {
        return JavaScriptLineBreakpointManagerKt.createUrlRegExp(location, useCaseSensitiveUrl);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        CharSequence $this$map$iv = ".?*+^$[](){}|-\\";
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void it;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)it);
        }
        REGEX_CHARS = CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

