/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.execution.JSLocalFilesMappingPanelKt;
import com.intellij.javascript.debugger.execution.JSRemoteUrlMappingModel;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingTableFactory;", "", "model", "Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;", "table", "Lcom/intellij/ui/table/JBTable;", "project", "Lcom/intellij/openapi/project/Project;", "baseUrlGetter", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/javascript/debugger/execution/JSRemoteUrlMappingModel;Lcom/intellij/ui/table/JBTable;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "createPanel", "Ljavax/swing/JPanel;", "doAddAction", "", "chooseFile", "toSelect", "Lcom/intellij/openapi/vfs/VirtualFile;", "handler", "Lkotlin/Function1;", "doRemoveAction", "doEditAction", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJSLocalFilesMappingPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLocalFilesMappingPanel.kt\ncom/intellij/javascript/debugger/execution/JSRemoteUrlMappingTableFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
final class JSRemoteUrlMappingTableFactory {
    @NotNull
    private final JSRemoteUrlMappingModel model;
    @NotNull
    private final JBTable table;
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<String> baseUrlGetter;

    public JSRemoteUrlMappingTableFactory(@NotNull JSRemoteUrlMappingModel model, @NotNull JBTable table, @NotNull Project project, @NotNull Function0<String> baseUrlGetter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(baseUrlGetter, (String)"baseUrlGetter");
        this.model = model;
        this.table = table;
        this.project = project;
        this.baseUrlGetter = baseUrlGetter;
    }

    @NotNull
    public final JPanel createPanel() {
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(this){
            final /* synthetic */ JSRemoteUrlMappingTableFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                Path path = Paths.get((String)value, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path path2 = path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                this.setIcon(Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type);
                Path parentPath = path2.getParent();
                if (parentPath != null) {
                    Comparable comparable;
                    String projectPath = JSRemoteUrlMappingTableFactory.access$getProject$p(this.this$0).getBasePath();
                    if (projectPath != null && parentPath.startsWith(projectPath)) {
                        String string = ((Object)parentPath).toString().substring(projectPath.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        comparable = (Comparable)((Object)("..." + string));
                    } else {
                        comparable = parentPath;
                    }
                    Comparable relativePath = comparable;
                    String string = FileUtil.toSystemDependentName((String)(relativePath + "/"));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
                    String presentablePath = string;
                    this.append(presentablePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                this.append(PathsKt.getName((Path)path2), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).disableUpAction().disableDownAction().setToolbarBorder((Border)JBUI.Borders.empty()).setPanelBorder((Border)JBUI.Borders.empty()).setScrollPaneBorder((Border)JBUI.Borders.empty()).setAddAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$0(this, arg_0)).setRemoveAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$1(this, arg_0)).setEditAction(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$2(this, arg_0)).setEditActionUpdater(arg_0 -> JSRemoteUrlMappingTableFactory.createPanel$lambda$3(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void doAddAction() {
        VirtualFile virtualFile;
        String selectedTarget;
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int row = this.table.getSelectedRow();
        String string = selectedTarget = row >= 0 ? this.model.getData().get((int)this.table.convertRowIndexToModel((int)row)).localFilePath : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        VirtualFile toSelect = virtualFile;
        this.chooseFile(toSelect, (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> JSRemoteUrlMappingTableFactory.doAddAction$lambda$1(this, arg_0)));
    }

    private final void chooseFile(VirtualFile toSelect, Function1<? super VirtualFile, Unit> handler2) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, true, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.project, (Component)((Component)this.table), (VirtualFile)toSelect, arg_0 -> JSRemoteUrlMappingTableFactory.chooseFile$lambda$0(handler2, arg_0));
    }

    private final void doRemoveAction() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int[] nArray = this.table.getSelectedRows();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
        Iterator iterator = ArraysKt.sortedDescending((int[])nArray).iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            this.model.getData().remove(i);
        }
        this.model.fireTableDataChanged();
    }

    private final void doEditAction() {
        TableCellEditor tableCellEditor = this.table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        int selectedRow = this.table.getSelectedRow();
        VirtualFile selectedFile = LocalFileSystem.getInstance().findFileByPath(this.model.getData().get((int)selectedRow).localFilePath);
        this.chooseFile(selectedFile, (Function1<? super VirtualFile, Unit>)((Function1)arg_0 -> JSRemoteUrlMappingTableFactory.doEditAction$lambda$0(this, selectedRow, arg_0)));
    }

    private static final void createPanel$lambda$0(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        this$0.doAddAction();
    }

    private static final void createPanel$lambda$1(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        this$0.doRemoveAction();
    }

    private static final void createPanel$lambda$2(JSRemoteUrlMappingTableFactory this$0, AnActionButton it) {
        this$0.doEditAction();
    }

    private static final boolean createPanel$lambda$3(JSRemoteUrlMappingTableFactory this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getSelectedRowCount() > 0;
    }

    private static final Unit doAddAction$lambda$1(JSRemoteUrlMappingTableFactory this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String baseUrl = (String)this$0.baseUrlGetter.invoke();
        MatchResult matchResult = JSLocalFilesMappingPanelKt.access$getURL_WITH_FILE_PATTERN$p().matchEntire((CharSequence)baseUrl);
        if (matchResult != null) {
            baseUrl = (String)matchResult.getGroupValues().get(1);
        }
        this$0.model.getData().add(new RemoteUrlMappingBean(it.getPath(), baseUrl));
        this$0.model.fireTableDataChanged();
        ApplicationManager.getApplication().invokeLater(() -> JSRemoteUrlMappingTableFactory.doAddAction$lambda$1$0(this$0));
        return Unit.INSTANCE;
    }

    private static final void doAddAction$lambda$1$0(JSRemoteUrlMappingTableFactory this$0) {
        this$0.table.editCellAt(this$0.model.getData().size() - 1, 1);
    }

    private static final void chooseFile$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit doEditAction$lambda$0(JSRemoteUrlMappingTableFactory this$0, int $selectedRow, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.model.getData().set($selectedRow, new RemoteUrlMappingBean(it.getPath(), this$0.model.getData().get($selectedRow).getRemoteUrl()));
        this$0.model.fireTableDataChanged();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(JSRemoteUrlMappingTableFactory $this) {
        return $this.project;
    }
}

