/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/scripts/OpenActualScriptSourceAction;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "<init>", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "isApplicable", "", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.javascript.debugger.backend"})
final class OpenActualScriptSourceAction
extends ScriptTreeActionBase {
    public OpenActualScriptSourceAction(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, JSDebuggerBundle.message("js.scripts.action.open.actual", new Object[0]));
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return info.getScripts$intellij_javascript_debugger_backend().size() == 1 && this.getTreeComponent().getDebugProcess().getConnection().getState().getStatus() == ConnectionStatus.CONNECTED;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JavaScriptDebugProcess<?> debugProcess = this.getTreeComponent().getDebugProcess();
        JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
        Project project = this.getProject();
        viewSupport.getFileByUrlOrVmSource(node.getFileInfo().getFirstScript(), false).onSuccess((Consumer)new ConsumerOnEdt<VirtualFile>(project){

            public void consume(Project project, VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
    }
}

