/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCustomMember;
import com.jetbrains.python.codeInsight.completion.PyCompletionUtilsKt;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.mlcompletion.PyCompletionMlElementInfo;
import com.jetbrains.python.codeInsight.mlcompletion.PyCompletionMlElementKind;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PointInImport;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleMembersProvider;
import com.jetbrains.python.psi.types.PyOverridingModuleMembersProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyModuleType
implements PyType {
    @NotNull
    private final PyFile myModule;
    private static final ImmutableSet<String> MODULE_MEMBERS = ImmutableSet.of((Object)"__name__", (Object)"__file__", (Object)"__path__", (Object)"__doc__", (Object)"__dict__", (Object)"__package__", (Object[])new String[0]);

    public PyModuleType(@NotNull PyFile source) {
        if (source == null) {
            PyModuleType.$$$reportNull$$$0(0);
        }
        this.myModule = source;
    }

    @NotNull
    public PyFile getModule() {
        PyFile pyFile = this.myModule;
        if (pyFile == null) {
            PyModuleType.$$$reportNull$$$0(1);
        }
        return pyFile;
    }

    @Nullable
    public PyClassType getModuleClassType() {
        return PyClassTypeImpl.createTypeByQName((PsiElement)this.myModule, "types.ModuleType", false);
    }

    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(2);
        }
        if (direction == null) {
            PyModuleType.$$$reportNull$$$0(3);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(4);
        }
        return this.resolveModuleMember(name, (PsiElement)location, direction, resolveContext);
    }

    @ApiStatus.Internal
    @Nullable
    public List<? extends RatedResolveResult> resolveModuleMember(@NotNull String name, @Nullable PsiElement scopeOwner, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PyClassType type;
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(5);
        }
        if (direction == null) {
            PyModuleType.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(7);
        }
        if (MODULE_MEMBERS.contains((Object)name) && (type = this.getModuleClassType()) != null) {
            PyExpression expression;
            PyExpression pyExpression = scopeOwner instanceof PyExpression ? (expression = (PyExpression)scopeOwner) : null;
            return type.resolveMember(name, pyExpression, direction, resolveContext);
        }
        return PyModuleType.resolveMemberInPackageOrModule(null, (PsiFileSystemItem)this.myModule, name, scopeOwner, resolveContext);
    }

    @Nullable
    public static List<? extends RatedResolveResult> resolveMemberInPackageOrModule(@Nullable PyImportedModule importedModule, @NotNull PsiFileSystemItem anchor, @NotNull String name, @Nullable PsiElement location, @NotNull PyResolveContext resolveContext) {
        PsiElement member;
        PyFile module;
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(8);
        }
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(9);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(10);
        }
        if ((module = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class)) != null) {
            PsiElement overridingMember = PyModuleType.resolveByOverridingMembersProviders(module, name, resolveContext);
            if (overridingMember != null) {
                return ResolveResultList.to(overridingMember);
            }
            List attributes = module.multiResolveName(name);
            if (!attributes.isEmpty()) {
                return attributes;
            }
        }
        if (PyUtil.isPackage(anchor, location)) {
            ResolveResultList implicitMembers = new ResolveResultList();
            PyModuleType.processImplicitPackageMembers(anchor, location, importedModule, n -> name.endsWith((String)n), (Processor<List<? extends RatedResolveResult>>)((Processor)results -> {
                implicitMembers.addAll(PyModuleType.convertDirsToInit(results));
                return implicitMembers.isEmpty();
            }), resolveContext);
            if (!implicitMembers.isEmpty()) {
                return implicitMembers;
            }
        }
        if (module != null && (member = PyModuleType.resolveByMembersProviders(module, name, resolveContext)) != null) {
            return ResolveResultList.to(member);
        }
        return null;
    }

    private static void processImplicitPackageMembers(@NotNull PsiFileSystemItem anchor, @Nullable PsiElement location, @Nullable PyImportedModule importedModule, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor, @Nullable PyResolveContext resolveContext) {
        PyImportElement origImportElement;
        PsiFile footHold;
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(12);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(13);
        }
        PsiElement realLocation = location == null ? null : PyPsiUtils.getRealContext((PsiElement)location);
        ArrayList<PyImportElement> importElements = new ArrayList<PyImportElement>();
        PyFile module = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        if (anchor.getVirtualFile() == null) {
            return;
        }
        Object object = realLocation != null ? realLocation.getContainingFile() : (footHold = module != null ? module : anchor);
        if (footHold == null) {
            return;
        }
        PyImportElement pyImportElement = origImportElement = importedModule != null ? importedModule.getImportElement() : null;
        if (!(importedModule == null || realLocation != null && PyUtil.inSameFile(realLocation, (PsiElement)importedModule))) {
            if (origImportElement != null) {
                importElements.add(origImportElement);
            }
        } else if (realLocation != null) {
            boolean crawlScope;
            ScopeOwner owner = ScopeUtil.getScopeOwner(realLocation);
            boolean bl = crawlScope = owner != null && (resolveContext == null || resolveContext.getTypeEvalContext().maySwitchToAST(realLocation));
            if (crawlScope) {
                importElements.addAll(PyModuleType.getVisibleImports(owner));
            } else if (realLocation instanceof PyFile) {
                PyFile pyFile = (PyFile)realLocation;
                importElements.addAll(PyModuleType.getTopImports(pyFile));
            }
            if (module != null) {
                if (!PyUtil.inSameFile(realLocation, (PsiElement)module)) {
                    importElements.addAll(module.getImportTargets());
                }
                List imports = module.getFromImports();
                for (PyFromImportStatement anImport : imports) {
                    Collections.addAll(importElements, anImport.getImportElements());
                }
            }
        }
        if (importElements.isEmpty()) {
            return;
        }
        HashSet seen = new HashSet();
        if (!PyModuleType.processImplicitlyImportedByImportElements(anchor, (PsiElement)footHold, importElements, name -> filter.test((String)name) && seen.add(name), resultProcessor)) {
            return;
        }
        if (location != null) {
            PyModuleType.processImplicitlyImportedByLocation(anchor, location, name -> filter.test((String)name) && seen.add(name), resultProcessor);
        }
    }

    private static boolean processImplicitlyImportedByImportElements(@NotNull PsiFileSystemItem anchor, @NotNull PsiElement footHold, @NotNull List<PyImportElement> importElements, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor) {
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(14);
        }
        if (footHold == null) {
            PyModuleType.$$$reportNull$$$0(15);
        }
        if (importElements == null) {
            PyModuleType.$$$reportNull$$$0(16);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(17);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(18);
        }
        PyFile module = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        List<QualifiedName> packageQNames = QualifiedNameFinder.findImportableQNames(footHold, anchor.getVirtualFile());
        for (PyImportElement importElement : importElements) {
            for (QualifiedName packageQName : packageQNames) {
                for (QualifiedName importedQName : PyModuleType.getImportedQNames(importElement)) {
                    List<RatedResolveResult> results;
                    String directChild = PyModuleType.findFirstComponentAfterPrefix(importedQName, packageQName);
                    if (directChild == null || !filter.test(directChild) || resultProcessor.process(ResolveResultList.asImportedResults(results = ResolveImportUtil.resolveChildren((PsiElement)anchor, directChild, (PsiFile)module, true, true, false, false), (PyImportedNameDefiner)importElement))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void processImplicitlyImportedByLocation(@NotNull PsiFileSystemItem anchor, @NotNull PsiElement location, @NotNull Predicate<String> filter, @NotNull Processor<List<? extends RatedResolveResult>> resultProcessor) {
        ScopeOwner owner;
        if (anchor == null) {
            PyModuleType.$$$reportNull$$$0(19);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(20);
        }
        if (filter == null) {
            PyModuleType.$$$reportNull$$$0(21);
        }
        if (resultProcessor == null) {
            PyModuleType.$$$reportNull$$$0(22);
        }
        if (location.getContainingFile().getVirtualFile() == null) {
            return;
        }
        ScopeOwner scopeOwner = owner = location instanceof ScopeOwner ? (ScopeOwner)location : ScopeUtil.getScopeOwner(location);
        if (owner == null) {
            return;
        }
        List<PyImportElement> visibleImports = PyModuleType.getVisibleImports(owner);
        PyFile module = PyUtil.as(PyUtil.turnDirIntoInit((PsiElement)anchor), PyFile.class);
        List<QualifiedName> packageQNames = QualifiedNameFinder.findImportableQNames((PsiElement)location.getContainingFile(), anchor.getVirtualFile());
        List<QualifiedName> locationQNames = QualifiedNameFinder.findImportableQNames(location, location.getContainingFile().getVirtualFile());
        for (QualifiedName locationQName : locationQNames) {
            for (QualifiedName packageQName : packageQNames) {
                List<RatedResolveResult> results;
                QualifiedName mainPackage;
                PyImportElement packageImportElement;
                String directChild = PyModuleType.findFirstComponentAfterPrefix(locationQName, packageQName);
                if (directChild == null || !filter.test(directChild) || (packageImportElement = (PyImportElement)ContainerUtil.find(visibleImports, arg_0 -> PyModuleType.lambda$processImplicitlyImportedByLocation$5(mainPackage = QualifiedName.fromComponents((String[])new String[]{locationQName.getFirstComponent()}), arg_0))) == null || resultProcessor.process(ResolveResultList.asImportedResults(results = ResolveImportUtil.resolveChildren((PsiElement)anchor, directChild, (PsiFile)module, true, true, false, false), (PyImportedNameDefiner)packageImportElement))) continue;
                return;
            }
        }
    }

    @Nullable
    private static String findFirstComponentAfterPrefix(@NotNull QualifiedName qualifiedName, @NotNull QualifiedName prefix) {
        if (qualifiedName == null) {
            PyModuleType.$$$reportNull$$$0(23);
        }
        if (prefix == null) {
            PyModuleType.$$$reportNull$$$0(24);
        }
        if (qualifiedName.matchesPrefix(prefix) && qualifiedName.getComponentCount() > prefix.getComponentCount()) {
            return qualifiedName.removeHead(prefix.getComponentCount()).getFirstComponent();
        }
        return null;
    }

    @NotNull
    private static List<? extends RatedResolveResult> convertDirsToInit(@NotNull List<? extends RatedResolveResult> ratedResolveList) {
        if (ratedResolveList == null) {
            PyModuleType.$$$reportNull$$$0(25);
        }
        List list = ContainerUtil.map(ratedResolveList, result -> {
            PsiElement element = result.getElement();
            if (element instanceof PsiDirectory) {
                PsiElement pkgInit = PyUtil.turnDirIntoInit(element);
                return pkgInit != null ? result.replace(pkgInit) : result;
            }
            return result;
        });
        if (list == null) {
            PyModuleType.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveByMembersProviders(PyFile module, String name, @NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(27);
        }
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement element;
            if (provider instanceof PyOverridingModuleMembersProvider || (element = provider.resolveMember(module, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveByOverridingMembersProviders(@NotNull PyFile module, @NotNull String name, @NotNull PyResolveContext resolveContext) {
        if (module == null) {
            PyModuleType.$$$reportNull$$$0(28);
        }
        if (name == null) {
            PyModuleType.$$$reportNull$$$0(29);
        }
        if (resolveContext == null) {
            PyModuleType.$$$reportNull$$$0(30);
        }
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            PsiElement element;
            if (!(provider instanceof PyOverridingModuleMembersProvider) || (element = provider.resolveMember(module, name, resolveContext)) == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<QualifiedName> getImportedQNames(@NotNull PyImportElement element) {
        QualifiedName importedQName;
        if (element == null) {
            PyModuleType.$$$reportNull$$$0(31);
        }
        ArrayList<QualifiedName> importedQNames = new ArrayList<QualifiedName>();
        PyStatement stmt = element.getContainingImportStatement();
        PyFromImportStatement fromImportStatement = (PyFromImportStatement)ObjectUtils.tryCast((Object)stmt, PyFromImportStatement.class);
        if (fromImportStatement != null) {
            importedQName = fromImportStatement.getImportSourceQName();
            String visibleName = element.getVisibleName();
            if (importedQName != null) {
                importedQNames.add(importedQName);
                if (visibleName != null) {
                    importedQNames.add(importedQName.append(visibleName));
                }
            } else {
                List<PsiElement> elements = ResolveImportUtil.resolveFromImportStatementSource(fromImportStatement, element.getImportedQName());
                for (PsiElement psiElement : elements) {
                    VirtualFile virtualFile;
                    QualifiedName qName;
                    if (!(psiElement instanceof PsiFile) || (qName = QualifiedNameFinder.findShortestImportableQName((PsiElement)element, virtualFile = ((PsiFile)psiElement).getVirtualFile())) == null) continue;
                    importedQNames.add(qName);
                }
            }
        } else if (stmt instanceof PyImportStatement && (importedQName = element.getImportedQName()) != null) {
            importedQNames.add(importedQName);
        }
        if (!ResolveImportUtil.isAbsoluteImportEnabledFor((PsiElement)element) || fromImportStatement != null && fromImportStatement.getRelativeLevel() == 1) {
            PsiFile file = element.getContainingFile();
            if (file != null) {
                file = file.getOriginalFile();
            }
            QualifiedName absoluteQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)file);
            if (file != null && absoluteQName != null) {
                QualifiedName prefixQName;
                QualifiedName qualifiedName = prefixQName = PyUtil.isPackage(file) ? absoluteQName : absoluteQName.removeLastComponent();
                if (prefixQName.getComponentCount() > 0) {
                    ArrayList<QualifiedName> results = new ArrayList<QualifiedName>(importedQNames);
                    for (QualifiedName qName : importedQNames) {
                        ArrayList components = new ArrayList();
                        components.addAll(prefixQName.getComponents());
                        components.addAll(qName.getComponents());
                        results.add(QualifiedName.fromComponents(components));
                    }
                    ArrayList<QualifiedName> arrayList = results;
                    if (arrayList == null) {
                        PyModuleType.$$$reportNull$$$0(32);
                    }
                    return arrayList;
                }
            }
        }
        ArrayList<QualifiedName> arrayList = importedQNames;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyImportElement> getTopImports(@NotNull PyFile file) {
        if (file == null) {
            PyModuleType.$$$reportNull$$$0(34);
        }
        ArrayList<PyImportElement> importElements = new ArrayList<PyImportElement>(file.getImportTargets());
        for (PyFromImportStatement fromImportStatement : file.getFromImports()) {
            importElements.addAll(Arrays.asList(fromImportStatement.getImportElements()));
        }
        ArrayList<PyImportElement> arrayList = importElements;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @NotNull
    private static List<PyImportElement> getVisibleImports(@NotNull ScopeOwner owner) {
        if (owner == null) {
            PyModuleType.$$$reportNull$$$0(36);
        }
        final ArrayList<PyImportElement> visibleImports = new ArrayList<PyImportElement>();
        PyResolveUtil.scopeCrawlUp(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof PyImportElement) {
                    visibleImports.add((PyImportElement)element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/types/PyModuleType$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, owner, null, null);
        ArrayList<PyImportElement> arrayList = visibleImports;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiFileSystemItem> getSubmodulesList(@Nullable PsiDirectory directory, @Nullable PsiElement anchor) {
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (directory != null) {
            for (PsiFile psiFile : directory.getFiles()) {
                String filename = psiFile.getName();
                if ((PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !(psiFile instanceof PyFile) || filename.equals("__init__.py")) && !PyModuleType.isBinaryModule(filename)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
            for (PsiFile psiFile : directory.getSubdirectories()) {
                if (PyModuleType.isExcluded((PsiFileSystemItem)psiFile) || !PyUtil.isPackage((PsiDirectory)psiFile, anchor)) continue;
                result.add((PsiFileSystemItem)psiFile);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    private static boolean isExcluded(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            PyModuleType.$$$reportNull$$$0(39);
        }
        return FileIndexFacade.getInstance((Project)file.getProject()).isExcludedFile(file.getVirtualFile());
    }

    private static boolean isBinaryModule(String filename) {
        String ext = FileUtilRt.getExtension((String)filename);
        if (SystemInfo.isWindows) {
            return "pyd".equalsIgnoreCase(ext);
        }
        return "so".equals(ext);
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)location.getProject(), (PsiFile)location.getContainingFile());
        List<LookupElement> result = this.getCompletionVariantsAsLookupElements(location, context, false, false, typeEvalContext);
        return result.toArray();
    }

    @NotNull
    public List<LookupElement> getCompletionVariantsAsLookupElements(@NotNull PsiElement location, @NotNull ProcessingContext context, boolean wantAllSubmodules, boolean suppressParentheses, @NotNull TypeEvalContext typeEvalContext) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(40);
        }
        if (context == null) {
            PyModuleType.$$$reportNull$$$0(41);
        }
        if (typeEvalContext == null) {
            PyModuleType.$$$reportNull$$$0(42);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        Set namesAlready = (Set)context.get(CTX_NAMES);
        PointInImport point = ResolveImportUtil.getPointInImport(location);
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeEvalContext);
        for (PyModuleMembersProvider provider : PyModuleMembersProvider.EP_NAME.getExtensionList()) {
            for (PyCustomMember member : provider.getMembers(this.myModule, point, typeEvalContext)) {
                String name = member.getName();
                if (namesAlready != null && !namesAlready.add(name) || PyUtil.isClassPrivateName(name)) continue;
                CompletionVariantsProcessor processor2 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
                PsiElement resolved = member.resolve(location, resolveContext);
                if (resolved != null) {
                    LookupElement element;
                    processor2.execute(resolved, ResolveState.initial());
                    List<LookupElement> lookupList = processor2.getResultList();
                    if (!lookupList.isEmpty() && name.equals((element = lookupList.get(0)).getLookupString())) {
                        result.add(element);
                        continue;
                    }
                }
                result.add((LookupElement)LookupElementBuilder.create((String)name).withIcon(member.getIcon()).withTypeText(member.getShortType()));
            }
        }
        if (point == PointInImport.NONE || point == PointInImport.AS_NAME) {
            CompletionVariantsProcessor processor3 = PyModuleType.createCompletionVariantsProcessor(location, suppressParentheses, point);
            this.myModule.processDeclarations((PsiScopeProcessor)processor3, ResolveState.initial(), null, location);
            if (namesAlready != null) {
                for (LookupElement le : processor3.getResultList()) {
                    String name = le.getLookupString();
                    if (namesAlready.contains(name)) continue;
                    result.add(le);
                    namesAlready.add(name);
                }
            } else {
                result.addAll(processor3.getResultList());
            }
        }
        if (PyUtil.isPackage((PsiFile)this.myModule)) {
            if (point == PointInImport.AS_MODULE || point == PointInImport.AS_NAME || wantAllSubmodules) {
                result.addAll(PyModuleType.getSubModuleVariants(this.myModule.getContainingDirectory(), location, namesAlready));
            } else {
                result.addAll(PyModuleType.collectImportedSubmodulesAsLookupElements((PsiFileSystemItem)this.myModule, location, namesAlready));
            }
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    private static CompletionVariantsProcessor createCompletionVariantsProcessor(PsiElement location, boolean suppressParentheses, PointInImport point) {
        Condition nodeFilter = psiElement -> !(psiElement instanceof PyImportElement) || PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyImportStatementBase.class) instanceof PyFromImportStatement;
        return new CompletionVariantsProcessor(location, (Condition<PsiElement>)nodeFilter, null, point == PointInImport.AS_NAME, suppressParentheses);
    }

    @NotNull
    public static List<LookupElement> collectImportedSubmodulesAsLookupElements(@NotNull PsiFileSystemItem pyPackage, @NotNull PsiElement location, @Nullable Set<? super String> existingNames) {
        if (pyPackage == null) {
            PyModuleType.$$$reportNull$$$0(44);
        }
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(45);
        }
        ArrayList elements = new ArrayList();
        PyModuleType.processImplicitPackageMembers(pyPackage, location, null, any -> true, (Processor<List<? extends RatedResolveResult>>)((Processor)results -> {
            elements.addAll(ResolveResultList.getElements(results));
            return true;
        }), null);
        List list = ContainerUtil.mapNotNull(elements, element -> {
            if (element instanceof PsiFileSystemItem) {
                return PyModuleType.buildFileLookupElement(location.getContainingFile(), (PsiFileSystemItem)element, existingNames);
            }
            if (element instanceof PsiNamedElement) {
                return LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)element));
            }
            return null;
        });
        if (list == null) {
            PyModuleType.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public static List<LookupElement> getSubModuleVariants(@Nullable PsiDirectory directory, @NotNull PsiElement location, @Nullable Set<? super String> namesAlready) {
        if (location == null) {
            PyModuleType.$$$reportNull$$$0(47);
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        for (PsiFileSystemItem item : PyModuleType.getSubmodulesList(directory, location)) {
            LookupElementBuilder lookupElement;
            if (item == location.getContainingFile().getOriginalFile() || (lookupElement = PyModuleType.buildFileLookupElement(location.getContainingFile(), item, namesAlready)) == null) continue;
            lookupElement.putUserData(PyCompletionMlElementInfo.Companion.getKey(), (Object)PyCompletionMlElementKind.PACKAGE_OR_MODULE.asInfo());
            result.add((LookupElement)lookupElement);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            PyModuleType.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @Nullable
    public static LookupElementBuilder buildFileLookupElement(PsiFile file, PsiFileSystemItem item, @Nullable Set<? super String> existingNames) {
        String s = FileUtilRt.getNameWithoutExtension((String)item.getName());
        if (!PyNames.isIdentifier((String)s)) {
            return null;
        }
        if (existingNames != null) {
            if (existingNames.contains(s)) {
                return null;
            }
            existingNames.add(s);
        }
        return PyCompletionUtilsKt.createLookupElementBuilder(file, item);
    }

    public String getName() {
        return this.myModule.getName();
    }

    public boolean isBuiltin() {
        return true;
    }

    public void assertValid(String message) {
        if (!this.myModule.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this.myModule, this.myModule.getClass().toString() + ": " + message);
        }
    }

    @NotNull
    public static Set<String> getPossibleInstanceMembers() {
        ImmutableSet<String> immutableSet = MODULE_MEMBERS;
        if (immutableSet == null) {
            PyModuleType.$$$reportNull$$$0(49);
        }
        return immutableSet;
    }

    @Nullable
    public PyQualifiedNameOwner getDeclarationElement() {
        return (PyQualifiedNameOwner)ObjectUtils.doIfNotNull((Object)this.getModuleClassType(), PyClassType::getPyClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyModuleType)) {
            return false;
        }
        PyModuleType type = (PyModuleType)o;
        return this.myModule.equals((Object)type.myModule);
    }

    public int hashCode() {
        return Objects.hash(this.myModule);
    }

    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor) {
        if (visitor == null) {
            PyModuleType.$$$reportNull$$$0(50);
        }
        if (visitor instanceof PyTypeVisitorExt) {
            PyTypeVisitorExt visitorExt = (PyTypeVisitorExt)visitor;
            return visitorExt.visitPyModuleType(this);
        }
        return (T)visitor.visitPyType((PyType)this);
    }

    private static /* synthetic */ boolean lambda$processImplicitlyImportedByLocation$5(QualifiedName mainPackage, PyImportElement el) {
        return ContainerUtil.exists(PyModuleType.getImportedQNames(el), qName -> qName.matchesPrefix(mainPackage));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 26, 32, 33, 35, 37, 38, 43, 46, 48, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 46: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "footHold";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importElements";
                break;
            }
            case 20: 
            case 40: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ratedResolveList";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyPackage";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyModuleType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDirsToInit";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedQNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopImports";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleImports";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubmodulesList";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubModuleVariants";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleInstanceMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 26: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 46: 
            case 48: 
            case 49: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleMember";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberInPackageOrModule";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitPackageMembers";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitlyImportedByImportElements";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitlyImportedByLocation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findFirstComponentAfterPrefix";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertDirsToInit";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveByMembersProviders";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveByOverridingMembersProviders";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getImportedQNames";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTopImports";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleImports";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariantsAsLookupElements";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "collectImportedSubmodulesAsLookupElements";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSubModuleVariants";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "acceptTypeVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 26, 32, 33, 35, 37, 38, 43, 46, 48, 49 -> new IllegalStateException(string);
        };
    }
}

