/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.devmode;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyNoneTypeKt;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzeParameterTypesAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AnalyzeParameterTypesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeParameterTypesAction.$$$reportNull$$$0(1);
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        e.getPresentation().setEnabledAndVisible(psiFile != null && psiFile.getFileType() instanceof PythonFileType);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            AnalyzeParameterTypesAction.$$$reportNull$$$0(2);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file != null) {
            new ParametersAnalyzer(project, file).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/devmode/AnalyzeParameterTypesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeParameterTypesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ParametersAnalyzer
    extends PyRecursiveElementVisitor {
        private final Project myProject;
        private final VirtualFile myFile;
        private long myDuration;
        private int myTotal;
        private int mySelfOrCls;
        private int myArgs;
        private int myKwArgs;
        private int myInferred;
        private int myLocalUsages;
        private int myUnknown;
        private int myDefaultValue;

        ParametersAnalyzer(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                ParametersAnalyzer.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ParametersAnalyzer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFile = file;
        }

        public void run() {
            long startTime = System.nanoTime();
            this.analyze(this.myFile);
            long endTime = System.nanoTime();
            this.myDuration = (endTime - startTime) / 1000000L;
            this.reportResults();
        }

        private void analyze(@NotNull VirtualFile root) {
            if (root == null) {
                ParametersAnalyzer.$$$reportNull$$$0(2);
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    PsiFile psiFile;
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ("venv".equals(file.getName())) {
                        return false;
                    }
                    if (!file.isDirectory() && (psiFile = PsiManager.getInstance((Project)myProject).findFile(file)) instanceof PyFile) {
                        psiFile.accept((PsiElementVisitor)this);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/python/pro/devmode/AnalyzeParameterTypesAction$ParametersAnalyzer$1", "visitFile"));
                }
            });
        }

        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                ParametersAnalyzer.$$$reportNull$$$0(3);
            }
            ++this.myTotal;
            if (node.isSelf()) {
                ++this.mySelfOrCls;
                return;
            }
            if (node.isPositionalContainer()) {
                ++this.myArgs;
                return;
            }
            if (node.isKeywordContainer()) {
                ++this.myKwArgs;
                return;
            }
            TypeEvalContext userWithoutUsagesContext = TypeEvalContext.userInitiated((Project)node.getProject(), null);
            if (!ParametersAnalyzer.isUnknown(userWithoutUsagesContext.getType((PyTypedElement)node), userWithoutUsagesContext)) {
                PyType type;
                PyExpression defaultValue = node.getDefaultValue();
                if (defaultValue != null && !ParametersAnalyzer.isUnknown(type = userWithoutUsagesContext.getType((PyTypedElement)defaultValue), userWithoutUsagesContext) && !PyNoneTypeKt.isNoneType((PyType)type)) {
                    ++this.myDefaultValue;
                    return;
                }
                ++this.myInferred;
                return;
            }
            TypeEvalContext userContext = TypeEvalContext.userInitiated((Project)node.getProject(), (PsiFile)node.getContainingFile());
            if (!ParametersAnalyzer.isUnknown(userContext.getType((PyTypedElement)node), userContext)) {
                ++this.myLocalUsages;
                return;
            }
            ++this.myUnknown;
        }

        private static boolean isUnknown(@Nullable PyType type, @NotNull TypeEvalContext context) {
            if (context == null) {
                ParametersAnalyzer.$$$reportNull$$$0(4);
            }
            return PyTypeChecker.isUnknown((PyType)type, (boolean)false, (TypeEvalContext)context);
        }

        private void reportResults() {
            System.out.println(this.counter("Total", this.myTotal));
            System.out.println(this.counter("Self or cls", this.mySelfOrCls));
            System.out.println(this.counter("Args", this.myArgs));
            System.out.println(this.counter("KwArgs", this.myKwArgs));
            System.out.println(this.counter("Default value", this.myDefaultValue));
            System.out.println(this.counter("Inferred", this.myInferred));
            System.out.println(this.counter("Local usages", this.myLocalUsages));
            System.out.println(this.counter("Unknown", this.myUnknown));
            System.out.println("Duration: " + this.myDuration + " ms");
        }

        private String counter(@NotNull String title, int n) {
            if (title == null) {
                ParametersAnalyzer.$$$reportNull$$$0(5);
            }
            return String.format("%s: %d (%d%%)", title, n, this.myTotal != 0 ? n * 100 / this.myTotal : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/pro/devmode/AnalyzeParameterTypesAction$ParametersAnalyzer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "analyze";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyNamedParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUnknown";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "counter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

