/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections.tree;

import com.intellij.scientific.py.tables.inspections.api.InspectionTarget;
import com.intellij.scientific.py.tables.inspections.api.quickFix.InspectionQuickFixInput;
import com.intellij.scientific.py.tables.inspections.api.results.DetailsOneColumn;
import com.intellij.scientific.py.tables.inspections.api.results.InspectionExecutionResult;
import com.intellij.scientific.py.tables.inspections.api.results.InspectionResultDetails;
import com.intellij.scientific.py.tables.inspections.api.results.InspectionResultDetailsColumnSpecific;
import com.intellij.scientific.py.tables.inspections.api.results.InspectionResultDetailsTableWide;
import com.intellij.scientific.py.tables.inspections.tree.InspectionDisplayInfo;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionGroupNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionLeafNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionRootNode;
import com.intellij.scientific.py.tables.inspections.tree.nodes.InspectionTreeNodeBase;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/scientific/py/tables/inspections/tree/InspectionNodeFactory;", "", "<init>", "()V", "createRoot", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionRootNode;", "buildInspectionTreeNode", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionTreeNodeBase;", "inspectionExecutionResults", "Lcom/intellij/scientific/py/tables/inspections/api/results/InspectionExecutionResult;", "tableVariableName", "", "tableRowsNumber", "", "buildTableWideLeafNode", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionLeafNode;", "value", "buildGroupNodeWithColumnSpecificLeafNodes", "Lcom/intellij/scientific/py/tables/inspections/tree/nodes/InspectionGroupNode;", "details", "Lcom/intellij/scientific/py/tables/inspections/api/results/InspectionResultDetailsColumnSpecific;", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nInspectionNodeFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionNodeFactory.kt\ncom/intellij/scientific/py/tables/inspections/tree/InspectionNodeFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1869#2,2:60\n*S KotlinDebug\n*F\n+ 1 InspectionNodeFactory.kt\ncom/intellij/scientific/py/tables/inspections/tree/InspectionNodeFactory\n*L\n50#1:60,2\n*E\n"})
public final class InspectionNodeFactory {
    @NotNull
    public static final InspectionNodeFactory INSTANCE = new InspectionNodeFactory();

    private InspectionNodeFactory() {
    }

    @NotNull
    public final InspectionRootNode createRoot() {
        return new InspectionRootNode();
    }

    @Nullable
    public final InspectionTreeNodeBase buildInspectionTreeNode(@NotNull InspectionExecutionResult inspectionExecutionResults, @NotNull String tableVariableName, int tableRowsNumber) {
        InspectionTreeNodeBase inspectionTreeNodeBase;
        Intrinsics.checkNotNullParameter((Object)inspectionExecutionResults, (String)"inspectionExecutionResults");
        Intrinsics.checkNotNullParameter((Object)tableVariableName, (String)"tableVariableName");
        InspectionResultDetails details = inspectionExecutionResults.getInspectionResultDetails();
        if (details instanceof InspectionResultDetailsTableWide) {
            inspectionTreeNodeBase = this.buildTableWideLeafNode(inspectionExecutionResults, ((InspectionResultDetailsTableWide)details).getValue(), tableVariableName, tableRowsNumber);
        } else if (details instanceof InspectionResultDetailsColumnSpecific) {
            inspectionTreeNodeBase = this.buildGroupNodeWithColumnSpecificLeafNodes(inspectionExecutionResults, (InspectionResultDetailsColumnSpecific)details, tableVariableName, tableRowsNumber);
        } else if (details == null) {
            inspectionTreeNodeBase = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return inspectionTreeNodeBase;
    }

    private final InspectionLeafNode buildTableWideLeafNode(InspectionExecutionResult inspectionExecutionResults, String value2, String tableVariableName, int tableRowsNumber) {
        InspectionDisplayInfo.LeafNodeInfo displayInfo = InspectionDisplayInfo.Companion.createLeafInfo(inspectionExecutionResults.getInspection().getInspectionName(), value2, tableRowsNumber, InspectionTarget.ROWS);
        InspectionQuickFixInput quickFixInput = new InspectionQuickFixInput(tableVariableName, inspectionExecutionResults.getInspection(), null, value2);
        return new InspectionLeafNode(displayInfo, quickFixInput);
    }

    private final InspectionGroupNode buildGroupNodeWithColumnSpecificLeafNodes(InspectionExecutionResult inspectionExecutionResults, InspectionResultDetailsColumnSpecific details, String tableVariableName, int tableRowsNumber) {
        List<DetailsOneColumn> columnsValues = details.getValue();
        InspectionDisplayInfo.GroupNodeInfo groupInfo = InspectionDisplayInfo.Companion.createGroupInfo(inspectionExecutionResults.getInspection().getInspectionName(), columnsValues.size());
        InspectionGroupNode groupNode = new InspectionGroupNode(groupInfo);
        Iterable $this$forEach$iv = columnsValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DetailsOneColumn detailsOneColumn = (DetailsOneColumn)element$iv;
            boolean bl = false;
            String columnName = detailsOneColumn.component1();
            String columnValue = detailsOneColumn.component2();
            InspectionDisplayInfo.LeafNodeInfo childInfo = InspectionDisplayInfo.Companion.createLeafInfo(columnName, columnValue, tableRowsNumber, inspectionExecutionResults.getInspection().getAppliesTo());
            InspectionQuickFixInput childQuickFixInput = new InspectionQuickFixInput(tableVariableName, inspectionExecutionResults.getInspection(), columnName, columnValue);
            InspectionLeafNode leafNode = new InspectionLeafNode(childInfo, childQuickFixInput);
            groupNode.add((MutableTreeNode)((Object)leafNode));
        }
        return groupNode;
    }
}

