/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.DnsResolveResult;
import com.intellij.util.ThrowableConvertor;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u001e\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0004j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0004j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/CustomizedDnsResolverNettyGroup;", "Lio/netty/resolver/AddressResolverGroup;", "Ljava/net/InetSocketAddress;", "dnsResolver", "Lcom/intellij/util/ThrowableConvertor;", "", "Lcom/intellij/httpClient/execution/DnsResolveResult;", "Ljava/net/UnknownHostException;", "Lcom/intellij/httpClient/execution/DnsResolveFunction;", "<init>", "(Lcom/intellij/util/ThrowableConvertor;)V", "newResolver", "Lio/netty/resolver/AddressResolver;", "executor", "Lio/netty/util/concurrent/EventExecutor;", "intellij.httpClient.executor"})
public final class CustomizedDnsResolverNettyGroup
extends AddressResolverGroup<InetSocketAddress> {
    @NotNull
    private final ThrowableConvertor<String, DnsResolveResult, UnknownHostException> dnsResolver;

    public CustomizedDnsResolverNettyGroup(@NotNull ThrowableConvertor<String, DnsResolveResult, UnknownHostException> dnsResolver) {
        Intrinsics.checkNotNullParameter(dnsResolver, (String)"dnsResolver");
        this.dnsResolver = dnsResolver;
    }

    @NotNull
    protected AddressResolver<InetSocketAddress> newResolver(@NotNull EventExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        AddressResolver addressResolver = new DefaultNameResolver(executor, this){
            final /* synthetic */ CustomizedDnsResolverNettyGroup this$0;
            {
                this.this$0 = $receiver;
                super($executor);
            }

            protected void doResolve(String inetHost, Promise<InetAddress> promise) {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)inetHost, (String)"inetHost");
                    Intrinsics.checkNotNullParameter(promise, (String)"promise");
                    try {
                        DnsResolveResult dnsResolveResult = (DnsResolveResult)CustomizedDnsResolverNettyGroup.access$getDnsResolver$p(this.this$0).convert((Object)inetHost);
                        if (dnsResolveResult == null) {
                            throw new UnknownHostException();
                        }
                        DnsResolveResult resolved = dnsResolveResult;
                        if (resolved instanceof DnsResolveResult.Alias) {
                            super.doResolve(((DnsResolveResult.Alias)resolved).getHost(), promise);
                            break block6;
                        }
                        if (resolved instanceof DnsResolveResult.Exact) {
                            InetAddress inetAddress = (InetAddress)ArraysKt.firstOrNull((Object[])((DnsResolveResult.Exact)resolved).getAddresses());
                            if (inetAddress == null) {
                                throw new UnknownHostException();
                            }
                            InetAddress address = inetAddress;
                            promise.setSuccess((Object)address);
                            break block6;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    catch (UnknownHostException e) {
                        promise.setFailure((Throwable)e);
                    }
                }
            }

            protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)inetHost, (String)"inetHost");
                    Intrinsics.checkNotNullParameter(promise, (String)"promise");
                    try {
                        DnsResolveResult dnsResolveResult = (DnsResolveResult)CustomizedDnsResolverNettyGroup.access$getDnsResolver$p(this.this$0).convert((Object)inetHost);
                        if (dnsResolveResult == null) {
                            throw new UnknownHostException();
                        }
                        DnsResolveResult resolved = dnsResolveResult;
                        if (resolved instanceof DnsResolveResult.Alias) {
                            super.doResolveAll(((DnsResolveResult.Alias)resolved).getHost(), promise);
                            break block5;
                        }
                        if (resolved instanceof DnsResolveResult.Exact) {
                            promise.setSuccess((Object)ArraysKt.toList((Object[])((DnsResolveResult.Exact)resolved).getAddresses()));
                            break block5;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    catch (UnknownHostException e) {
                        promise.setFailure((Throwable)e);
                    }
                }
            }
        }.asAddressResolver();
        Intrinsics.checkNotNullExpressionValue((Object)addressResolver, (String)"asAddressResolver(...)");
        return addressResolver;
    }

    public static final /* synthetic */ ThrowableConvertor access$getDnsResolver$p(CustomizedDnsResolverNettyGroup $this) {
        return $this.dnsResolver;
    }
}

