/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.managed;

import com.intellij.jupyter.core.executor.kernel.client.JupyterKernelClient;
import com.intellij.jupyter.core.executor.kernel.session.restore.JupyterExecutionProjectClosingListener;
import com.intellij.jupyter.core.jupyter.connections.client.JupyterClientManager;
import com.intellij.jupyter.core.jupyter.connections.client.status.JupyterConnectionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterKernelCommunicationClient;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.server.JupyterServer;
import com.intellij.jupyter.core.jupyter.connections.session.JupyterSessionData;
import com.intellij.jupyter.py.connections.server.JupyterlabServer;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJm\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152M\u0010\u0018\u001aI\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0015\u0012\u0013\u0018\u00010\u001e\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001f\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00170\u0019H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/py/connections/managed/JupyterlabKernelClient;", "Lcom/intellij/jupyter/core/executor/kernel/client/JupyterKernelClient;", "project", "Lcom/intellij/openapi/project/Project;", "server", "Lcom/intellij/jupyter/core/jupyter/connections/server/JupyterServer;", "sessionData", "Lcom/intellij/jupyter/core/jupyter/connections/session/JupyterSessionData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/connections/server/JupyterServer;Lcom/intellij/jupyter/core/jupyter/connections/session/JupyterSessionData;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getServer", "()Lcom/intellij/jupyter/core/jupyter/connections/server/JupyterServer;", "getSessionData", "()Lcom/intellij/jupyter/core/jupyter/connections/session/JupyterSessionData;", "serverClient", "Lcom/intellij/jupyter/core/jupyter/connections/client/JupyterClientManager;", "createWebSocketClientForKernel", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterKernelCommunicationClient;", "onMessage", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "onClose", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "code", "", "reason", "", "remote", "dispose", "intellij.jupyter.py"})
public final class JupyterlabKernelClient
implements JupyterKernelClient {
    @NotNull
    private final Project project;
    @NotNull
    private final JupyterServer server;
    @NotNull
    private final JupyterSessionData sessionData;
    @NotNull
    private final JupyterClientManager serverClient;

    public JupyterlabKernelClient(@NotNull Project project, @NotNull JupyterServer server, @NotNull JupyterSessionData sessionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)sessionData, (String)"sessionData");
        this.project = project;
        this.server = server;
        this.sessionData = sessionData;
        this.serverClient = this.server.getClient();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JupyterServer getServer() {
        return this.server;
    }

    @NotNull
    public final JupyterSessionData getSessionData() {
        return this.sessionData;
    }

    @Nullable
    public JupyterKernelCommunicationClient createWebSocketClientForKernel(@NotNull Function1<? super JupyterMessage, Unit> onMessage, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> onClose) {
        Intrinsics.checkNotNullParameter(onMessage, (String)"onMessage");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        return this.serverClient.createWebSocketClientForKernel-6A3UCyE(this.sessionData.getKernelId-qftoVCA(), this.sessionData.getSessionId-PaPw8_s(), onMessage, onClose);
    }

    public void dispose() {
        if (JupyterExecutionProjectClosingListener.Companion.isProjectClosing(this.project)) {
            return;
        }
        JupyterServer jupyterServer = this.server;
        JupyterlabServer jupyterlabServer = jupyterServer instanceof JupyterlabServer ? (JupyterlabServer)jupyterServer : null;
        if (jupyterlabServer == null) {
            return;
        }
        JupyterlabServer jupyterlabServer2 = jupyterlabServer;
        JupyterConnectionStatus status = jupyterlabServer2.getClient().getCachedConnectionStatus();
        jupyterServer = status;
        if (Intrinsics.areEqual((Object)jupyterServer, (Object)JupyterConnectionStatus.Disposed.INSTANCE)) {
            return;
        }
        if (jupyterServer instanceof JupyterConnectionStatus.Failed) {
            return;
        }
        if (Intrinsics.areEqual((Object)jupyterServer, (Object)JupyterConnectionStatus.NotStarted.INSTANCE)) {
            return;
        }
        if (!(jupyterServer instanceof JupyterConnectionStatus.Success)) {
            throw new NoWhenBranchMatchedException();
        }
    }
}

