/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.managed.log;

import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterIgnoreNotificationException;
import com.intellij.jupyter.core.jupyter.connections.fus.JupyterManagedStartResult;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStartError;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerController;
import com.intellij.jupyter.py.connections.managed.server.JupyterLabManagedServerController;
import com.intellij.jupyter.py.connections.managed.server.JupyterServerProcessListener;
import com.intellij.jupyter.py.connections.managed.server.exceptions.JupyterPackageInstallException;
import com.intellij.jupyter.py.connections.managed.server.exceptions.JupyterPySdkIsReadOnly;
import com.intellij.jupyter.py.stat.JupyterPyFeaturesCollector;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/py/connections/managed/log/JupyterServerFusListener;", "Lcom/intellij/jupyter/py/connections/managed/server/JupyterServerProcessListener;", "<init>", "()V", "serverStateChanged", "", "jupyterServerController", "Lcom/intellij/jupyter/core/jupyter/server/common/JupyterServerController;", "newState", "Lcom/intellij/jupyter/core/jupyter/connections/managed/state/JupyterServerState;", "logStart", "logStartError", "errorException", "", "intellij.jupyter.py"})
public final class JupyterServerFusListener
implements JupyterServerProcessListener {
    @Override
    public void serverStateChanged(@NotNull JupyterServerController jupyterServerController, @NotNull JupyterServerState newState) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerController, (String)"jupyterServerController");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        JupyterServerState jupyterServerState = newState;
        if (jupyterServerState instanceof JupyterServerStarted) {
            this.logStart(jupyterServerController);
        } else if (jupyterServerState instanceof JupyterServerStartError) {
            this.logStartError(jupyterServerController, ((JupyterServerStartError)newState).getErrorException());
        }
    }

    private final void logStart(JupyterServerController jupyterServerController) {
        long timeInMills = System.currentTimeMillis() - jupyterServerController.getStartTime();
        Intrinsics.checkNotNull((Object)jupyterServerController, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.connections.managed.server.JupyterLabManagedServerController");
        Sdk sdk = ((JupyterLabManagedServerController)jupyterServerController).getSdk();
        JupyterPyFeaturesCollector.INSTANCE.logServerStart(sdk, timeInMills, JupyterManagedStartResult.SUCCESS, JupyterPyFeaturesCollector.ManagedServerType.JUPYTERLAB);
    }

    private final void logStartError(JupyterServerController jupyterServerController, Throwable errorException) {
        JupyterManagedStartResult jupyterManagedStartResult;
        long timeInMills = System.currentTimeMillis() - jupyterServerController.getStartTime();
        Intrinsics.checkNotNull((Object)jupyterServerController, (String)"null cannot be cast to non-null type com.intellij.jupyter.py.connections.managed.server.JupyterLabManagedServerController");
        Sdk sdk = ((JupyterLabManagedServerController)jupyterServerController).getSdk();
        Throwable throwable = errorException;
        if (throwable instanceof JupyterPySdkIsReadOnly) {
            jupyterManagedStartResult = JupyterManagedStartResult.SDK_READ_ONLY;
        } else if (throwable instanceof JupyterPackageInstallException) {
            jupyterManagedStartResult = JupyterManagedStartResult.PACKAGE_INSTALL_FAILED;
        } else {
            if (throwable instanceof CancellationException || throwable instanceof JupyterIgnoreNotificationException) {
                return;
            }
            jupyterManagedStartResult = JupyterManagedStartResult.SERVER_ERROR;
        }
        JupyterManagedStartResult eventType = jupyterManagedStartResult;
        JupyterPyFeaturesCollector.INSTANCE.logServerStart(sdk, timeInMills, eventType, JupyterPyFeaturesCollector.ManagedServerType.JUPYTERLAB);
    }
}

