/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.telephony;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.CommonNotifications;
import com.intellij.cwm.plugin.common.telephony.JitsiEvent;
import com.intellij.cwm.plugin.common.telephony.JitsiEventParameters;
import com.intellij.cwm.plugin.common.telephony.OpenCallWindowAction;
import com.intellij.cwm.plugin.common.telephony.TelephonyLogger;
import com.intellij.cwm.plugin.common.telephony.TelephonyRequestsHandler;
import com.intellij.cwm.plugin.common.toolbar.CWMCallSplitButtonAction;
import com.intellij.cwm.plugin.common.toolbar.CWMShowPopupAction;
import com.intellij.cwm.plugin.common.users.UserNotifications;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GotItComponentBuilder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.util.UriUtilKt;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import java.io.BufferedReader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefMediaAccessCallback;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefPermissionHandler;
import org.cef.network.CefRequest;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 _2\u00020\u0001:\u0001_B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000207J\u0006\u00109\u001a\u000207J\u0006\u0010:\u001a\u000207J\b\u0010;\u001a\u000207H\u0002J\u0006\u0010<\u001a\u000207J\b\u0010=\u001a\u00020\u0014H\u0002J\u000e\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020\u0014J\u000e\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020\u0007J\u0006\u0010B\u001a\u000207J\u0006\u0010C\u001a\u000207J\u000e\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020FJ\b\u0010G\u001a\u000207H\u0002J\u000e\u0010H\u001a\u0002072\u0006\u0010I\u001a\u00020JJ\u000e\u0010K\u001a\u0002072\u0006\u0010L\u001a\u00020FJ&\u0010M\u001a\u0002072\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0001\u0010N\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010O\u001a\u00020\u0007H\u0002J\u0006\u0010P\u001a\u00020QJ\u0017\u0010R\u001a\u00020\u00072\b\u0010S\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010TJ\b\u0010U\u001a\u00020\u001bH\u0002J\b\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u00020YH\u0002J\b\u0010Z\u001a\u00020[H\u0002J\b\u0010\\\u001a\u00020]H\u0002J\u0006\u0010^\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R#\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020*0)0(\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R#\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020*0)0(\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\"R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\"R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\"R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u00140 \u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\"\u00a8\u0006`"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "jitsiRoomUrlString", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProject", "()Lcom/intellij/openapi/project/Project;", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "conferenceJoinedQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "onOfflinePageOpened", "value", "", "askForBrowserScreenSharing", "getAskForBrowserScreenSharing", "()Z", "setAskForBrowserScreenSharing", "(Z)V", "jitsiRoomUrl", "Ljava/net/URI;", "getJitsiRoomUrl", "()Ljava/net/URI;", "localUserName", "cameraEnabled", "Lcom/jetbrains/rd/util/reactive/Property;", "getCameraEnabled", "()Lcom/jetbrains/rd/util/reactive/Property;", "microphoneEnabled", "getMicrophoneEnabled", "screenSharingEnabled", "getScreenSharingEnabled", "userEnabledCamera", "Lcom/jetbrains/rd/util/reactive/Signal;", "Lkotlin/Pair;", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "getUserEnabledCamera", "()Lcom/jetbrains/rd/util/reactive/Signal;", "userEnabledSharing", "getUserEnabledSharing", "conferenceJoined", "getConferenceJoined", "connectionFailed", "getConnectionFailed", "joiningCall", "getJoiningCall", "isCallInBrowser", "toggleMicrophone", "", "toggleCamera", "toggleScreenSharing", "openDevTools", "hangup", "startScreenSharingViaBrowser", "openScreenSharingInBrowser", "joinConference", "join", "onMessageReceivedNotificationHandler", "receivedMessage", "onConferenceLeaveHandler", "onConferenceUnloadedHandler", "onPermissionsPromptHandler", "parameters", "Lcom/intellij/cwm/plugin/common/telephony/JitsiEventParameters;", "openRejoinPage", "onConferenceJoinedHandler", "parsedJitsiEvent", "Lcom/intellij/cwm/plugin/common/telephony/JitsiEvent;", "trackTypeHandler", "jitsiEventParameters", "showTelephonyGotIt", "content", "title", "getComponent", "Ljavax/swing/JComponent;", "buildJitsiUrl", "overridePrejoin", "(Ljava/lang/Boolean;)Ljava/lang/String;", "buildJitsiUrlForScreenSharing", "createDisplayHandler", "Lorg/cef/handler/CefDisplayHandler;", "createLoadHandler", "Lorg/cef/handler/CefLoadHandlerAdapter;", "createLifeSpanHandler", "Lorg/cef/handler/CefLifeSpanHandlerAdapter;", "createPermissionHandler", "Lorg/cef/handler/CefPermissionHandler;", "isSafariDefaultBrowser", "Companion", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nTelephonySession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelephonySession.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonySession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,512:1\n1#2:513\n13#3:514\n*S KotlinDebug\n*F\n+ 1 TelephonySession.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonySession\n*L\n68#1:514\n*E\n"})
public final class TelephonySession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final JBCefBrowser browser;
    @NotNull
    private final JBCefJSQuery conferenceJoinedQuery;
    @NotNull
    private final JBCefJSQuery onOfflinePageOpened;
    @NotNull
    private final URI jitsiRoomUrl;
    @Nullable
    private final String localUserName;
    @NotNull
    private final Property<Boolean> cameraEnabled;
    @NotNull
    private final Property<Boolean> microphoneEnabled;
    @NotNull
    private final Property<Boolean> screenSharingEnabled;
    @NotNull
    private final Signal<Pair<Boolean, RdUserModel>> userEnabledCamera;
    @NotNull
    private final Signal<Pair<Boolean, RdUserModel>> userEnabledSharing;
    @NotNull
    private final Property<Boolean> conferenceJoined;
    @NotNull
    private final Property<Boolean> connectionFailed;
    @NotNull
    private final Property<Boolean> joiningCall;
    @NotNull
    private final Property<Boolean> isCallInBrowser;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final TelephonyLogger TELEPHONY_LOG;
    @Language(value="text")
    @NotNull
    private static final String OFFLINE_PAGE_TEXT = "Your device may be offline or our servers may be experiencing problems";

    /*
     * WARNING - void declaration
     */
    public TelephonySession(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull String jitsiRoomUrlString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jitsiRoomUrlString, (String)"jitsiRoomUrlString");
        this.lifetime = lifetime;
        this.project = project;
        TelephonySession telephonySession = this;
        TelephonySession telephonySession2 = this;
        boolean bl = false;
        URI uRI = new URL(jitsiRoomUrlString).toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"run(...)");
        telephonySession2.jitsiRoomUrl = uRI;
        TelephonySession telephonySession3 = this;
        String string2 = (String)UriUtilKt.getFragmentParameters((URI)this.jitsiRoomUrl).get("userInfo.displayName");
        if (string2 != null) {
            void it;
            String $this$jitsiRoomUrl_u24lambda_u240 = string2;
            telephonySession2 = telephonySession3;
            boolean bl2 = false;
            char[] cArray = new char[]{'\"'};
            String trimmed = StringsKt.trim((String)it, (char[])cArray);
            string = URLDecoder.decode(trimmed, Charsets.UTF_8);
            telephonySession3 = telephonySession2;
        } else {
            string = null;
        }
        telephonySession3.localUserName = string;
        this.cameraEnabled = new Property((Object)false);
        this.microphoneEnabled = new Property((Object)false);
        this.screenSharingEnabled = new Property((Object)false);
        this.userEnabledCamera = new Signal();
        this.userEnabledSharing = new Signal();
        this.conferenceJoined = new Property((Object)false);
        this.connectionFailed = new Property((Object)false);
        this.joiningCall = new Property((Object)true);
        this.isCallInBrowser = new Property((Object)false);
        String resultUrl = this.buildJitsiUrl(null);
        RLifetimeKt.throwIfNotAlive((Lifetime)this.lifetime);
        boolean isOsrEnabled = Registry.Companion.is("ide.browser.jcef.codeWithMe.osr.enabled") || SystemInfo.isUnix && !SystemInfo.isMac;
        JBCefBrowser jBCefBrowser = new JBCefBrowserBuilder().setUrl(resultUrl).setOffScreenRendering(isOsrEnabled).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        this.browser = jBCefBrowser;
        LifetimeExKt.onTerminationOrNow((Lifetime)this.lifetime, () -> TelephonySession._init_$lambda$0(this));
        JBCefBrowser jBCefBrowser2 = this.browser;
        Intrinsics.checkNotNull((Object)jBCefBrowser2, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefBrowserBase browserAsBrowserBase = (JBCefBrowserBase)jBCefBrowser2;
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)browserAsBrowserBase);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.conferenceJoinedQuery = jBCefJSQuery;
        JBCefJSQuery jBCefJSQuery2 = JBCefJSQuery.create((JBCefBrowserBase)browserAsBrowserBase);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery2, (String)"create(...)");
        this.onOfflinePageOpened = jBCefJSQuery2;
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.cameraEnabled), (Lifetime)this.lifetime, arg_0 -> TelephonySession._init_$lambda$1(this, arg_0));
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.screenSharingEnabled), (Lifetime)this.lifetime, arg_0 -> TelephonySession._init_$lambda$2(this, arg_0));
        this.conferenceJoinedQuery.addHandler(arg_0 -> TelephonySession._init_$lambda$4(arg_0 -> TelephonySession._init_$lambda$3(this, arg_0), arg_0));
        SequentialLifetimes lifetimes = new SequentialLifetimes(this.lifetime);
        this.userEnabledCamera.advise(this.lifetime, arg_0 -> TelephonySession._init_$lambda$5(lifetimes, this, arg_0));
        this.userEnabledSharing.advise(this.lifetime, arg_0 -> TelephonySession._init_$lambda$6(lifetimes, this, arg_0));
        this.onOfflinePageOpened.addHandler(arg_0 -> TelephonySession._init_$lambda$8(arg_0 -> TelephonySession._init_$lambda$7(this, arg_0), arg_0));
        JBCefClient jBCefClient = this.browser.getJBCefClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
        JBCefClient client = jBCefClient;
        client.addDisplayHandler(this.createDisplayHandler(), this.browser.getCefBrowser());
        client.addLoadHandler((CefLoadHandler)this.createLoadHandler(), this.browser.getCefBrowser());
        client.addLifeSpanHandler((CefLifeSpanHandler)this.createLifeSpanHandler(), this.browser.getCefBrowser());
        client.addPermissionHandler(this.createPermissionHandler(), this.browser.getCefBrowser());
        CefBrowser cefBrowser = this.browser.getCefBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)cefBrowser, (String)"getCefBrowser(...)");
        CefBrowser cefBrowser2 = cefBrowser;
        RdCoroutinesUtilKt.launchIOBackground$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cefBrowser2, null){
            Object L$0;
            int label;
            final /* synthetic */ TelephonySession this$0;
            final /* synthetic */ CefBrowser $cefBrowser;
            {
                this.this$0 = $receiver;
                this.$cefBrowser = $cefBrowser;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        jsConnectionStatePoll = StringsKt.trimIndent((String)("\n          var isOffline = document.body.innerText.indexOf(\"Your device may be offline or our servers may be experiencing problems\") >= 0;\n          " + TelephonySession.access$getOnOfflinePageOpened$p(this.this$0).inject("isOffline") + ";\n        "));
lbl6:
                        // 2 sources

                        while (RLifetimeKt.isAlive((Lifetime)this.this$0.getLifetime())) {
                            this.L$0 = jsConnectionStatePoll;
                            this.label = 1;
                            v0 = DelayKt.delay((long)300L, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl18
                        }
                        break;
                    }
                    case 1: {
                        jsConnectionStatePoll = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.$cefBrowser.executeJavaScript(jsConnectionStatePoll, "", 11);
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        cefBrowser2.createImmediately();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final boolean getAskForBrowserScreenSharing() {
        return PropertiesComponent.getInstance().getBoolean("show.screen.sharing.in.browser.dialog", true);
    }

    private final void setAskForBrowserScreenSharing(boolean value2) {
        PropertiesComponent.getInstance().setValue("show.screen.sharing.in.browser.dialog", value2, true);
    }

    @NotNull
    public final URI getJitsiRoomUrl() {
        return this.jitsiRoomUrl;
    }

    @NotNull
    public final Property<Boolean> getCameraEnabled() {
        return this.cameraEnabled;
    }

    @NotNull
    public final Property<Boolean> getMicrophoneEnabled() {
        return this.microphoneEnabled;
    }

    @NotNull
    public final Property<Boolean> getScreenSharingEnabled() {
        return this.screenSharingEnabled;
    }

    @NotNull
    public final Signal<Pair<Boolean, RdUserModel>> getUserEnabledCamera() {
        return this.userEnabledCamera;
    }

    @NotNull
    public final Signal<Pair<Boolean, RdUserModel>> getUserEnabledSharing() {
        return this.userEnabledSharing;
    }

    @NotNull
    public final Property<Boolean> getConferenceJoined() {
        return this.conferenceJoined;
    }

    @NotNull
    public final Property<Boolean> getConnectionFailed() {
        return this.connectionFailed;
    }

    @NotNull
    public final Property<Boolean> getJoiningCall() {
        return this.joiningCall;
    }

    @NotNull
    public final Property<Boolean> isCallInBrowser() {
        return this.isCallInBrowser;
    }

    public final void toggleMicrophone() {
        TelephonyRequestsHandler.Companion.sendToggleMicrophoneEvent();
    }

    public final void toggleCamera() {
        TelephonyRequestsHandler.Companion.sendToggleCameraEvent();
    }

    public final void toggleScreenSharing() {
        TelephonyRequestsHandler.Companion.sendToggleScreenSharingEvent();
    }

    public final void openDevTools() {
        this.browser.openDevtools();
    }

    private final void hangup() {
        TelephonyRequestsHandler.Companion.sendHangupEvent();
    }

    public final void startScreenSharingViaBrowser() {
        if (!this.openScreenSharingInBrowser()) {
            return;
        }
        URI jitsiRoomUrlForScreenSharing = this.buildJitsiUrlForScreenSharing();
        this.hangup();
        OpenCallWindowAction.Companion.closeCallWindow(this.project);
        BrowserUtil.browse((URI)jitsiRoomUrlForScreenSharing);
    }

    private final boolean openScreenSharingInBrowser() {
        if (!this.getAskForBrowserScreenSharing()) {
            return true;
        }
        return ((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(CodeWithMeCommonBundle.INSTANCE.message("dialog.EnableScreenSharing.enable.in.browser.title", new Object[0]), CodeWithMeCommonBundle.INSTANCE.message("dialog.EnableScreenSharing.enable.in.browser.message", new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(this){
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                TelephonySession.access$setAskForBrowserScreenSharing(this.this$0, !isSelected);
            }
        })).icon(AllIcons.General.QuestionDialog)).ask(this.project);
    }

    public final void joinConference(boolean join) {
        if ((Boolean)this.conferenceJoined.getValue() == join) {
            return;
        }
        if (join) {
            this.joiningCall.set((Object)true);
            RdCoroutinesUtilKt.launchBackground$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ TelephonySession this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay((long)3000L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            TelephonySession.access$getBrowser$p(this.this$0).getCefBrowser().executeJavaScript("document.querySelectorAll('[data-testid=\"prejoin.joinMeeting\"]')[0].click()", "", 1);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.hangup();
        }
    }

    public final void onMessageReceivedNotificationHandler(@NotNull String receivedMessage) {
        Intrinsics.checkNotNullParameter((Object)receivedMessage, (String)"receivedMessage");
        Object message = null;
        Object username = null;
        try {
            Object object;
            block13: {
                block12: {
                    Object json;
                    Object object2;
                    JsonObject tree;
                    Object object3;
                    block11: {
                        block10: {
                            object3 = Json.Default.parseToJsonElement(receivedMessage);
                            JsonObject jsonObject = object3 instanceof JsonObject ? (JsonObject)object3 : null;
                            if (jsonObject == null) {
                                throw new IllegalStateException("Json Object is expected".toString());
                            }
                            tree = jsonObject;
                            object3 = tree.get((Object)"text");
                            object2 = object3 instanceof JsonPrimitive ? (JsonPrimitive)object3 : null;
                            if (object2 == null || (object2 = object2.getContent()) == null) break block10;
                            json = object2;
                            boolean bl = false;
                            String string = StringUtil.escapeXmlEntities((String)json);
                            object2 = string;
                            if (string != null) break block11;
                        }
                        throw new IllegalStateException("empty message text".toString());
                    }
                    message = object2;
                    object3 = tree.get((Object)"nick");
                    object = object3 instanceof JsonPrimitive ? (JsonPrimitive)object3 : null;
                    if (object == null || (object = object.getContent()) == null) break block12;
                    json = object;
                    boolean bl = false;
                    String string = StringUtil.escapeXmlEntities((String)json);
                    object = string;
                    if (string != null) break block13;
                }
                throw new IllegalStateException("empty message nickname".toString());
            }
            username = object;
        }
        catch (IllegalStateException e) {
            LOG.warn("Failed to deserialize chat message", (Throwable)e);
            return;
        }
        if (!Intrinsics.areEqual((Object)username, (Object)this.localUserName)) {
            Object[] objectArray = new Object[]{username};
            String title = CodeWithMeCommonBundle.INSTANCE.message("notification.telephonyChatMessage.title", objectArray);
            UserNotifications.INSTANCE.showInfoNotification(this.project, CommonNotifications.DisplayId.TEXT_MESSAGE.getValue(), title, (String)message);
        }
    }

    public final void onConferenceLeaveHandler() {
        BuildersKt.launch$default((CoroutineScope)this.lifetime.getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (((Boolean)this.this$0.isCallInBrowser().getValue()).booleanValue()) {
                            this.this$0.isCallInBrowser().set((Object)Boxing.boxBoolean((boolean)false));
                        }
                        this.this$0.getConferenceJoined().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getJoiningCall().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getMicrophoneEnabled().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getCameraEnabled().set((Object)Boxing.boxBoolean((boolean)false));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.openRejoinPage();
    }

    public final void onConferenceUnloadedHandler() {
        BuildersKt.launch$default((CoroutineScope)this.lifetime.getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!((Boolean)this.this$0.isCallInBrowser().getValue()).booleanValue()) {
                            return Unit.INSTANCE;
                        }
                        this.this$0.isCallInBrowser().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getConferenceJoined().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getJoiningCall().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getMicrophoneEnabled().set((Object)Boxing.boxBoolean((boolean)false));
                        this.this$0.getCameraEnabled().set((Object)Boxing.boxBoolean((boolean)false));
                        TelephonySession.access$openRejoinPage(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onPermissionsPromptHandler(@NotNull JitsiEventParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = parameters.getMessage();
        if (Intrinsics.areEqual((Object)string, (Object)"cameraNotGranted")) {
            TELEPHONY_LOG.info("camera permissions is not granted");
        } else if (Intrinsics.areEqual((Object)string, (Object)"microphoneNotGranted")) {
            TELEPHONY_LOG.info("microphone permissions is not granted");
        }
    }

    private final void openRejoinPage() {
        LOG.info("conference left, going to rejoin page");
        String resultUrl_ = this.buildJitsiUrl(true);
        this.browser.loadURL(resultUrl_);
    }

    public final void onConferenceJoinedHandler(@NotNull JitsiEvent parsedJitsiEvent) {
        Intrinsics.checkNotNullParameter((Object)parsedJitsiEvent, (String)"parsedJitsiEvent");
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(parsedJitsiEvent, this, null){
            int label;
            final /* synthetic */ JitsiEvent $parsedJitsiEvent;
            final /* synthetic */ TelephonySession this$0;
            {
                this.$parsedJitsiEvent = $parsedJitsiEvent;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (Boolean.parseBoolean(this.$parsedJitsiEvent.getParameters().getMessage())) {
                            this.this$0.isCallInBrowser().set((Object)Boxing.boxBoolean((boolean)true));
                        }
                        this.this$0.getConferenceJoined().set((Object)Boxing.boxBoolean((boolean)true));
                        this.this$0.getJoiningCall().set((Object)Boxing.boxBoolean((boolean)false));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void trackTypeHandler(@NotNull JitsiEventParameters jitsiEventParameters) {
        Intrinsics.checkNotNullParameter((Object)jitsiEventParameters, (String)"jitsiEventParameters");
        BuildersKt.launch$default((CoroutineScope)this.lifetime.getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jitsiEventParameters, this, null){
            int label;
            final /* synthetic */ JitsiEventParameters $jitsiEventParameters;
            final /* synthetic */ TelephonySession this$0;
            {
                this.$jitsiEventParameters = $jitsiEventParameters;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String string = this.$jitsiEventParameters.getTrackType();
                        if (string != null) {
                            int n = -1;
                            switch (string.hashCode()) {
                                case 1557106716: {
                                    if (!string.equals("desktop")) break;
                                    n = 1;
                                    break;
                                }
                                case 1370921258: {
                                    if (!string.equals("microphone")) break;
                                    n = 2;
                                    break;
                                }
                                case -1367751899: {
                                    if (!string.equals("camera")) break;
                                    n = 3;
                                    break;
                                }
                            }
                            switch (n) {
                                case 2: {
                                    Property<Boolean> property = this.this$0.getMicrophoneEnabled();
                                    Boolean bl = this.$jitsiEventParameters.getTrackState();
                                    Intrinsics.checkNotNull((Object)bl);
                                    property.set((Object)bl);
                                    return Unit.INSTANCE;
                                }
                                case 3: {
                                    Property<Boolean> property = this.this$0.getCameraEnabled();
                                    Boolean bl = this.$jitsiEventParameters.getTrackState();
                                    Intrinsics.checkNotNull((Object)bl);
                                    property.set((Object)bl);
                                    return Unit.INSTANCE;
                                }
                                case 1: {
                                    Property<Boolean> property = this.this$0.getScreenSharingEnabled();
                                    Boolean bl = this.$jitsiEventParameters.getTrackState();
                                    Intrinsics.checkNotNull((Object)bl);
                                    property.set((Object)bl);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        TelephonySession.access$getLOG$cp().warn("Unknown track type received: " + this.$jitsiEventParameters.getTrackType());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void showTelephonyGotIt(Lifetime lifetime, @Nls String content, @Nls String title) {
        ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> TelephonySession.showTelephonyGotIt$lambda$0(this, content, title, lifetime));
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final String buildJitsiUrl(Boolean overridePrejoin) {
        Map currentParameters = MapsKt.toMutableMap((Map)UriUtilKt.getFragmentParameters((URI)this.jitsiRoomUrl));
        if (overridePrejoin != null) {
            currentParameters.put("config.prejoinPageEnabled", overridePrejoin != false ? "true" : "false");
        }
        currentParameters.put("config.port", String.valueOf(BuiltInServerManager.Companion.getInstance().getPort()));
        String string = UriUtilKt.newURIWithFragmentParameters((URI)this.jitsiRoomUrl, (Map)currentParameters).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final URI buildJitsiUrlForScreenSharing() {
        Map currentParameters = MapsKt.toMutableMap((Map)UriUtilKt.getFragmentParameters((URI)this.jitsiRoomUrl));
        currentParameters.put("config.startScreenSharing", "true");
        currentParameters.put("config.ignoreStartMuted", "true");
        currentParameters.put("config.port", String.valueOf(BuiltInServerManager.Companion.getInstance().getPort()));
        return UriUtilKt.newURIWithFragmentParameters((URI)this.jitsiRoomUrl, (Map)currentParameters);
    }

    private final CefDisplayHandler createDisplayHandler() {
        return (CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                TelephonySession.access$getTELEPHONY_LOG$cp().autoDetermination(message, level);
                return true;
            }
        };
    }

    private final CefLoadHandlerAdapter createLoadHandler() {
        return new CefLoadHandlerAdapter(this){
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
            }

            public void onLoadStart(CefBrowser browser_, CefFrame frame, CefRequest.TransitionType transitionType) {
                if (browser_ == null) {
                    throw new IllegalStateException("onLoadStart: got no browser".toString());
                }
            }

            public void onLoadEnd(CefBrowser browser_, CefFrame frame, int httpStatusCode) {
                TelephonySession.access$getTELEPHONY_LOG$cp().info("onLoadEnd: page loading ended with " + httpStatusCode + " status code");
                if (browser_ == null) {
                    throw new IllegalStateException("onLoadEnd: Jitsi loaded, but onLoadEnd got no browser".toString());
                }
                String jsCode = StringsKt.trimIndent((String)("\n          if (!JitsiMeetJS) {          \n            JitsiMeetJS = {};\n          }\n          " + TelephonySession.access$getConferenceJoinedQuery$p(this.this$0).inject("JitsiMeetJS.version") + ";\n        "));
                browser_.executeJavaScript(jsCode, "", 0);
            }
        };
    }

    private final CefLifeSpanHandlerAdapter createLifeSpanHandler() {
        return new CefLifeSpanHandlerAdapter(){

            public boolean onBeforePopup(CefBrowser browser, CefFrame frame, String target_url, String target_frame_name) {
                if (target_url != null) {
                    BrowserUtil.browse((String)target_url);
                    return true;
                }
                return false;
            }
        };
    }

    private final CefPermissionHandler createPermissionHandler() {
        return new CefPermissionHandler(){

            public boolean onRequestMediaAccessPermission(CefBrowser browser, CefFrame frame, String requesting_url, int requested_permissions, CefMediaAccessCallback callback) {
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                int permissions = requested_permissions;
                boolean desktopAudioCapturePermission = (requested_permissions & 4) != 0;
                boolean desktopVideoCapturePermission = (requested_permissions & 8) != 0;
                boolean deviceAudioCapturePermission = (requested_permissions & 1) != 0;
                boolean deviceVideoCapturePermission = (requested_permissions & 2) != 0;
                TelephonySession.access$getTELEPHONY_LOG$cp().info("Requested permissions:\ndesktopAudioCapturePermission: " + desktopAudioCapturePermission + "\ndesktopVideoCapturePermission: " + desktopVideoCapturePermission + "\ndeviceAudioCapturePermission: " + deviceAudioCapturePermission + "\ndeviceVideoCapturePermission: " + deviceVideoCapturePermission);
                if (desktopAudioCapturePermission && desktopVideoCapturePermission) {
                    permissions &= 0xFFFFFFFB;
                }
                boolean desktopAudioCapturePermission2 = (permissions & 4) != 0;
                boolean desktopVideoCapturePermission2 = (permissions & 8) != 0;
                boolean deviceAudioCapturePermission2 = (permissions & 1) != 0;
                boolean deviceVideoCapturePermission2 = (permissions & 2) != 0;
                TelephonySession.access$getLOG$cp().info("Result permissions:\ndesktopAudioCapturePermission2: " + desktopAudioCapturePermission2 + "\ndesktopVideoCapturePermission2: " + desktopVideoCapturePermission2 + "\ndeviceAudioCapturePermission2: " + deviceAudioCapturePermission2 + "\ndeviceVideoCapturePermission2: " + deviceVideoCapturePermission2);
                callback.Continue(permissions);
                return true;
            }
        };
    }

    public final boolean isSafariDefaultBrowser() {
        boolean bl;
        if (!SystemInfo.isMac) {
            return false;
        }
        String[] stringArray = new String[]{"/usr/bin/defaults", "read", "com.apple.LaunchServices/com.apple.launchservices.secure.plist", "LSHandlers"};
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        Process process = processBuilder.start();
        BufferedReader reader = new BufferedReader(process.inputReader());
        try {
            bl = reader.lines().anyMatch(arg_0 -> TelephonySession.isSafariDefaultBrowser$lambda$1(TelephonySession::isSafariDefaultBrowser$lambda$0, arg_0));
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private static final Unit _init_$lambda$0(TelephonySession this$0) {
        Disposer.dispose((Disposable)((Disposable)this$0.browser));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TelephonySession this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!((Boolean)this$0.conferenceJoined.getValue()).booleanValue()) {
            return Unit.INSTANCE;
        }
        LOG.info("cameraEnabled - open CWM tool window...");
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!((Boolean)this.this$0.isCallInBrowser().getValue()).booleanValue()) {
                            OpenCallWindowAction.Companion.openCallWindow(this.this$0.getProject());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TelephonySession this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!((Boolean)this$0.conferenceJoined.getValue()).booleanValue() || ((Boolean)this$0.isCallInBrowser.getValue()).booleanValue()) {
            return Unit.INSTANCE;
        }
        if (Registry.Companion.is("ide.browser.jcef.codeWithMe.inBrowserScreenSharing.enabled") && !this$0.isSafariDefaultBrowser()) {
            this$0.toggleScreenSharing();
            this$0.startScreenSharingViaBrowser();
        } else {
            LOG.info("screenSharingEnabledQuery - open CWM tool window...");
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ TelephonySession this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            OpenCallWindowAction.Companion.openCallWindow(this.this$0.getProject());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response _init_$lambda$3(TelephonySession this$0, String it) {
        RdCoroutinesUtilKt.launchOnUi$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ TelephonySession this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (((Boolean)this.this$0.getJoiningCall().getValue()).booleanValue()) {
                            this.this$0.getConferenceJoined().set((Object)Boxing.boxBoolean((boolean)true));
                            this.this$0.getJoiningCall().set((Object)Boxing.boxBoolean((boolean)false));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$4(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$5(SequentialLifetimes $lifetimes, TelephonySession this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LifetimeDefinition lt = $lifetimes.next();
        if (!((Boolean)it.getFirst()).booleanValue()) {
            return Unit.INSTANCE;
        }
        String name = ((RdUserModel)it.getSecond()).getName();
        Object[] objectArray = new Object[]{name};
        this$0.showTelephonyGotIt((Lifetime)lt, CodeWithMeCommonBundle.INSTANCE.message("notification.video.is.shared.content", objectArray), CodeWithMeCommonBundle.INSTANCE.message("notification.video.is.shared.title", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(SequentialLifetimes $lifetimes, TelephonySession this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LifetimeDefinition lt = $lifetimes.next();
        if (!((Boolean)it.getFirst()).booleanValue()) {
            return Unit.INSTANCE;
        }
        String name = ((RdUserModel)it.getSecond()).getName();
        Object[] objectArray = new Object[]{name};
        this$0.showTelephonyGotIt((Lifetime)lt, null, CodeWithMeCommonBundle.INSTANCE.message("notification.screen.is.shared.title", objectArray));
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response _init_$lambda$7(TelephonySession this$0, String it) {
        boolean isConnectionFailed = Intrinsics.areEqual((Object)it, (Object)"true");
        if (isConnectionFailed && !((Boolean)this$0.connectionFailed.getValue()).booleanValue()) {
            TELEPHONY_LOG.warning("isConnectionFailed: schedule");
            RdCoroutinesUtilKt.launchBackground$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ TelephonySession this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 4 sources

                            while (((Boolean)this.this$0.getConnectionFailed().getValue()).booleanValue()) {
                                TelephonySession.access$getTELEPHONY_LOG$cp().warning("isConnectionFailed: reloading");
                                TelephonySession.access$getBrowser$p(this.this$0).getCefBrowser().reload();
                                this.label = 2;
                                v1 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                                if (v1 != var2_2) continue;
                                return var2_2;
                            }
                            break;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl13
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this$0.connectionFailed.set((Object)isConnectionFailed);
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$8(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final Unit showTelephonyGotIt$lambda$0(TelephonySession this$0, String $content, String $title, Lifetime $lifetime) {
        if (!((Boolean)this$0.conferenceJoined.getValue()).booleanValue()) {
            return Unit.INSTANCE;
        }
        boolean isCallWindowShown = OpenCallWindowAction.Companion.isCallWindowShown(this$0.project);
        JComponent jComponent = ExperimentalUI.Companion.isNewUI() ? CWMCallSplitButtonAction.Companion.findCWMCallSplitButton(this$0.project) : (JComponent)CWMShowPopupAction.Companion.findCurrentShowPopupButton(this$0.project);
        if (jComponent == null) {
            return Unit.INSTANCE;
        }
        JComponent button = jComponent;
        if (isCallWindowShown) {
            return Unit.INSTANCE;
        }
        String string = $content;
        if (string == null) {
            string = "";
        }
        new GotItComponentBuilder(string).showButton((Boolean)this$0.isCallInBrowser.getValue() != true).withHeader($title).withButtonLabel(CodeWithMeCommonBundle.INSTANCE.message("call.dialog.hidden.link.text", new Object[0])).onButtonClick(() -> TelephonySession.showTelephonyGotIt$lambda$0$0(this$0)).build(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)$lifetime, null, (int)1, null), TelephonySession::showTelephonyGotIt$lambda$0$1).show(RelativePoint.getSouthOf((JComponent)button), Balloon.Position.below);
        return Unit.INSTANCE;
    }

    private static final Unit showTelephonyGotIt$lambda$0$0(TelephonySession this$0) {
        OpenCallWindowAction.Companion.openCallWindow(this$0.project);
        return Unit.INSTANCE;
    }

    private static final BalloonBuilder showTelephonyGotIt$lambda$0$1(BalloonBuilder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.setCloseButtonEnabled(true);
        BalloonBuilder balloonBuilder = $this$build.setHideOnCloseClick(true);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnCloseClick(...)");
        return balloonBuilder;
    }

    private static final boolean isSafariDefaultBrowser$lambda$0(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return StringsKt.contains$default((CharSequence)line, (CharSequence)"com.apple.safari", (boolean)false, (int)2, null);
    }

    private static final boolean isSafariDefaultBrowser$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setAskForBrowserScreenSharing(TelephonySession $this, boolean value2) {
        $this.setAskForBrowserScreenSharing(value2);
    }

    public static final /* synthetic */ JBCefBrowser access$getBrowser$p(TelephonySession $this) {
        return $this.browser;
    }

    public static final /* synthetic */ void access$openRejoinPage(TelephonySession $this) {
        $this.openRejoinPage();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ TelephonyLogger access$getTELEPHONY_LOG$cp() {
        return TELEPHONY_LOG;
    }

    public static final /* synthetic */ JBCefJSQuery access$getConferenceJoinedQuery$p(TelephonySession $this) {
        return $this.conferenceJoinedQuery;
    }

    public static final /* synthetic */ JBCefJSQuery access$getOnOfflinePageOpened$p(TelephonySession $this) {
        return $this.onOfflinePageOpened;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TelephonySession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        String string = TelephonySession.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TELEPHONY_LOG = new TelephonyLogger(string);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonySession$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TELEPHONY_LOG", "Lcom/intellij/cwm/plugin/common/telephony/TelephonyLogger;", "OFFLINE_PAGE_TEXT", "", "intellij.cwm.plugin.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

