/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.restClient.execution;

import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestConverter;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequestConverter;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequestExecutionSupportKt;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequestHandler;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequestExecutionSupport;", "Lcom/intellij/httpClient/execution/common/RequestExecutionSupport;", "Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;", "<init>", "()V", "canProcess", "", "requestContext", "Lcom/intellij/httpClient/execution/common/RequestContext;", "getRequestHandler", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "getRequestConverter", "Lcom/intellij/httpClient/execution/common/RequestConverter;", "supportedMethods", "", "", "project", "Lcom/intellij/openapi/project/Project;", "supportedSchemes", "", "getSupportedSchemes", "()Ljava/util/List;", "needsScheme", "getNeedsScheme", "()Z", "intellij.httpClient.grpc"})
public final class GrpcRequestExecutionSupport
implements RequestExecutionSupport<GrpcRequest> {
    public boolean canProcess(@NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return !requestContext.getDebugMode() && (Intrinsics.areEqual((Object)requestContext.getMethod(), (Object)"GRPC") || CollectionsKt.contains((Iterable)GrpcRequestExecutionSupportKt.getGRPC_SCHEMES_TRIMMED(), (Object)requestContext.getScheme()));
    }

    @NotNull
    public RequestHandler<GrpcRequest> getRequestHandler() {
        return new GrpcRequestHandler();
    }

    @NotNull
    public RequestConverter<GrpcRequest> getRequestConverter() {
        return new GrpcRequestConverter();
    }

    @NotNull
    public Collection<String> supportedMethods(@Nullable Project project) {
        return CollectionsKt.listOf((Object)"GRPC");
    }

    @NotNull
    public Collection<String> supportedMethods() {
        return this.supportedMethods(null);
    }

    @NotNull
    public List<String> getSupportedSchemes() {
        return CollectionsKt.plus((Collection)GrpcRequestExecutionSupportKt.getGRPC_SCHEMES_TRIMMED(), (Iterable)GrpcRequestExecutionSupportKt.getHTTP_SCHEMES_TRIMMED());
    }

    public boolean getNeedsScheme() {
        return false;
    }
}

