/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.controllers.selfUpdate.common;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.controllers.selfUpdate.SelfManagedCellController;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\tH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020\u0013H\u0004J\b\u0010 \u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/intellij/notebooks/visualization/controllers/selfUpdate/common/NotebookCellSelfHighlighterController;", "Lcom/intellij/notebooks/visualization/controllers/selfUpdate/SelfManagedCellController;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getEditorCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getInterval", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "dispose", "", "getHighlighterLayer", "", "createLineMarkerRender", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "rangeHighlighter", "getTextAttribute", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "customizeHighlighter", "cellHighlighter", "checkAndRebuildInlays", "forceUpdate", "disposeHighlighter", "createNewHighlighter", "intellij.notebooks.visualization"})
public abstract class NotebookCellSelfHighlighterController
implements SelfManagedCellController {
    @NotNull
    private final EditorCell editorCell;
    @Nullable
    private RangeHighlighterEx highlighter;

    public NotebookCellSelfHighlighterController(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
        this.editorCell = editorCell;
    }

    @NotNull
    public final EditorCell getEditorCell() {
        return this.editorCell;
    }

    @NotNull
    protected final EditorImpl getEditor() {
        return this.editorCell.getEditor();
    }

    private final NotebookCellLines.Interval getInterval() {
        return this.editorCell.getInterval();
    }

    public void dispose() {
        this.disposeHighlighter();
    }

    public int getHighlighterLayer() {
        return NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellBackgroundHighlightLayer();
    }

    @Nullable
    public LineMarkerRenderer createLineMarkerRender(@NotNull RangeHighlighterEx rangeHighlighter) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        return null;
    }

    @Nullable
    public TextAttributes getTextAttribute() {
        return null;
    }

    public void customizeHighlighter(@NotNull RangeHighlighterEx cellHighlighter) {
        Intrinsics.checkNotNullParameter((Object)cellHighlighter, (String)"cellHighlighter");
    }

    @Override
    public void checkAndRebuildInlays() {
        NotebookCellLines.Interval interval = this.editorCell.getIntervalOrNull();
        if (interval == null) {
            this.disposeHighlighter();
            return;
        }
        RangeHighlighterEx rangeHighlighterEx = this.highlighter;
        boolean bl = rangeHighlighterEx != null ? rangeHighlighterEx.isValid() : false;
        if (bl) {
            RangeHighlighterEx rangeHighlighterEx2 = this.highlighter;
            boolean bl2 = rangeHighlighterEx2 != null ? rangeHighlighterEx2.getStartOffset() == interval.getCellStartOffset((Editor)this.getEditor()) : false;
            if (bl2) {
                RangeHighlighterEx rangeHighlighterEx3 = this.highlighter;
                boolean bl3 = rangeHighlighterEx3 != null ? rangeHighlighterEx3.getEndOffset() == this.editorCell.getInterval().getCellEndOffset((Editor)this.getEditor()) : false;
                if (bl3) {
                    return;
                }
            }
        }
        this.forceUpdate();
    }

    public final void forceUpdate() {
        this.disposeHighlighter();
        this.createNewHighlighter();
    }

    protected final void disposeHighlighter() {
        RangeHighlighterEx rangeHighlighterEx = this.highlighter;
        if (rangeHighlighterEx == null) {
            return;
        }
        RangeHighlighterEx highlighterEx = rangeHighlighterEx;
        this.getEditor().getMarkupModel().removeHighlighter((RangeHighlighter)highlighterEx);
        highlighterEx.dispose();
        this.highlighter = null;
    }

    private final void createNewHighlighter() {
        int startOffset = this.getInterval().getCellStartOffset((Editor)this.getEditor());
        int endOffset = this.getInterval().getCellEndOffset((Editor)this.getEditor());
        Consumer changeAction = arg_0 -> NotebookCellSelfHighlighterController.createNewHighlighter$lambda$0(this, arg_0);
        RangeHighlighterEx rangeHighlighterEx = this.getEditor().getMarkupModel().addRangeHighlighterAndChangeAttributes(startOffset, endOffset, this.getHighlighterLayer(), this.getTextAttribute(), HighlighterTargetArea.LINES_IN_RANGE, false, changeAction);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighterEx highlighter = rangeHighlighterEx;
        highlighter.setGreedyToRight(true);
        this.customizeHighlighter(highlighter);
        this.highlighter = highlighter;
    }

    private static final void createNewHighlighter$lambda$0(NotebookCellSelfHighlighterController this$0, RangeHighlighterEx rangeHighlighter) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        rangeHighlighter.setLineMarkerRenderer(this$0.createLineMarkerRender(rangeHighlighter));
    }
}

