/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.errorProcessing;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResult;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResultInfo;
import com.intellij.platform.eel.provider.utils.EelProcessUtilsKt;
import com.jetbrains.python.PyCommunityBundle;
import com.jetbrains.python.errorProcessing.ExecErrorReason;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001aA\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\n2\r\u0010\u000b\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f*\u0012\u0010\u0000\"\u0006\u0012\u0002\b\u00030\u00012\u0006\u0012\u0002\b\u00030\u0001\u00a8\u0006\u0010"}, d2={"ExecError", "Lcom/jetbrains/python/errorProcessing/ExecErrorImpl;", "asExecutionFailed", "Lcom/jetbrains/python/errorProcessing/ExecErrorReason$UnexpectedProcessTermination;", "Lcom/intellij/execution/process/ProcessOutput;", "getExecErrorMessage", "", "Lorg/jetbrains/annotations/Nls;", "exec", "args", "", "additionalMessage", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "execErrorReason", "Lcom/jetbrains/python/errorProcessing/ExecErrorReason;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Lcom/jetbrains/python/errorProcessing/ExecErrorReason;)Ljava/lang/String;", "intellij.python.community"})
public final class ExecErrorKt {
    @NotNull
    public static final ExecErrorReason.UnexpectedProcessTermination asExecutionFailed(@NotNull ProcessOutput $this$asExecutionFailed) {
        Intrinsics.checkNotNullParameter((Object)$this$asExecutionFailed, (String)"<this>");
        int n = $this$asExecutionFailed.getExitCode();
        String string = $this$asExecutionFailed.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        byte[] byArray = StringsKt.encodeToByteArray((String)string);
        String string2 = $this$asExecutionFailed.getStderr();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
        return new ExecErrorReason.UnexpectedProcessTermination(new EelProcessExecutionResult(n, byArray, StringsKt.encodeToByteArray((String)string2)));
    }

    private static final String getExecErrorMessage(String exec, String[] args, String additionalMessage, ExecErrorReason execErrorReason) {
        String string;
        String commandLine = exec + " " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        ExecErrorReason r = execErrorReason;
        if (r instanceof ExecErrorReason.CantStart) {
            Object[] objectArray = new Object[4];
            String string2 = additionalMessage;
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            objectArray[1] = commandLine;
            objectArray[2] = ((ExecErrorReason.CantStart)r).getCantExecProcessError();
            Object object = ((ExecErrorReason.CantStart)r).getErrNo();
            if (object == null) {
                object = "unknown";
            }
            objectArray[3] = object;
            string = PyCommunityBundle.INSTANCE.message("python.execution.cant.start.error", objectArray);
        } else if (r instanceof ExecErrorReason.UnexpectedProcessTermination) {
            Object[] objectArray = new Object[5];
            String string3 = additionalMessage;
            if (string3 == null) {
                string3 = "";
            }
            objectArray[0] = string3;
            objectArray[1] = commandLine;
            objectArray[2] = EelProcessUtilsKt.getStdoutString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)r));
            objectArray[3] = EelProcessUtilsKt.getStderrString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)r));
            objectArray[4] = ((ExecErrorReason.UnexpectedProcessTermination)r).getExitCode();
            string = PyCommunityBundle.INSTANCE.message("python.execution.error", objectArray);
        } else if (Intrinsics.areEqual((Object)r, (Object)ExecErrorReason.Timeout.INSTANCE)) {
            Object[] objectArray = new Object[2];
            String string4 = additionalMessage;
            if (string4 == null) {
                string4 = "";
            }
            objectArray[0] = string4;
            objectArray[1] = commandLine;
            string = PyCommunityBundle.INSTANCE.message("python.execution.timeout", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ String access$getExecErrorMessage(String exec, String[] args, String additionalMessage, ExecErrorReason execErrorReason) {
        return ExecErrorKt.getExecErrorMessage(exec, args, additionalMessage, execErrorReason);
    }
}

