/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorMapper;
import com.intellij.psi.css.impl.descriptor.visitor.CssParameterInfoValueDescriptorsVisitor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.css.inspections.CssInspectionFilter;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.css.parameterinfo.CssParameterInfoValueDescriptorComparator;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil;", "", "<init>", "()V", "Companion", "intellij.css.analysis"})
public final class CssValueInspectionUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey) {
        Companion.inspectCssValueAgainstDescriptors(descriptors, valueOwner, holder, errorMessageKey);
    }

    @JvmStatic
    public static final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey, @NotNull CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider) {
        Companion.inspectCssValueAgainstDescriptors(descriptors, valueOwner, holder, errorMessageKey, invalidValueRangeProvider);
    }

    @JvmStatic
    public static final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey, @NotNull CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider, boolean ignoreEmptyValue, boolean ignoreToggleValue) {
        Companion.inspectCssValueAgainstDescriptors(descriptors, valueOwner, holder, errorMessageKey, invalidValueRangeProvider, ignoreEmptyValue, ignoreToggleValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001EB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0015\u0010\r\u001a\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011H\u0007JE\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0015\u0010\r\u001a\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007JU\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0015\u0010\r\u001a\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007JS\u0010\u0017\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ5\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010 J6\u0010!\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J0\u0010(\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u001fH\u0002J/\u0010*\u001a\u00070\u000e\u00a2\u0006\u0002\b+2\u0006\u0010,\u001a\u00020&2\b\u0010-\u001a\u0004\u0018\u00010.2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u0015J$\u00100\u001a\u00020\u00052\n\u00101\u001a\u000602j\u0002`32\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205H\u0002J\u001e\u00107\u001a\u00020\u00152\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J+\u00108\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00109J+\u0010:\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00109J\u001b\u0010;\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0002\u0010<J\u0012\u0010=\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010>\u001a\u00020&2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010?\u001a\u00020.H\u0002J\u0018\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\u00152\u0006\u0010?\u001a\u00020.H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010#2\u0006\u0010,\u001a\u00020&H\u0002J\u001c\u0010C\u001a\u00020\u00152\b\u0010D\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002\u00a8\u0006F"}, d2={"Lcom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion;", "", "<init>", "()V", "inspectCssValueAgainstDescriptors", "", "descriptors", "", "Lcom/intellij/psi/css/descriptor/CssValueOwnerDescriptor;", "valueOwner", "Lcom/intellij/psi/css/CssValueOwner;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "errorMessageKey", "", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.CssBundle", "invalidValueRangeProvider", "Lcom/intellij/psi/css/inspections/CssInspectionsUtil$CssInvalidValueRangeProvider;", "ignoreEmptyValue", "", "ignoreToggleValue", "processValueValidation", "value", "Lcom/intellij/psi/css/CssTermList;", "terms", "", "Lcom/intellij/psi/css/CssTerm;", "(Ljava/util/Collection;Lcom/intellij/psi/css/CssValueOwner;Lcom/intellij/codeInspection/ProblemsHolder;Ljava/lang/String;Lcom/intellij/psi/css/inspections/CssInspectionsUtil$CssInvalidValueRangeProvider;Lcom/intellij/psi/css/CssTermList;[Lcom/intellij/psi/css/CssTerm;)V", "matchDescriptorsAgainstValue", "Lcom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion$MatchResult;", "(Ljava/util/Collection;Lcom/intellij/psi/css/CssTermList;[Lcom/intellij/psi/css/CssTerm;)Lcom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion$MatchResult;", "matchAllDescriptor", "stopElement", "Lcom/intellij/psi/PsiElement;", "matchedDataWithRedundantParameters", "Ljava/util/TreeSet;", "Lcom/intellij/psi/css/descriptor/value/CssValueMatchData;", "notMatchedData", "registerProblems", "matchResult", "buildInvalidValueErrorMessage", "Lcom/intellij/codeInspection/util/InspectionMessage;", "matchData", "highlightingDescriptor", "Lcom/intellij/psi/css/descriptor/value/CssValueDescriptor;", "onTheFly", "addHighlighting", "text", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "start", "", "end", "shouldSkipValidation", "shouldSkipBasedOnTerms", "([Lcom/intellij/psi/css/CssTerm;ZZ)Z", "shouldSkipBasedOnToggleFunction", "shouldSkipDueToVarWithoutFallback", "([Lcom/intellij/psi/css/CssTerm;)Z", "hasResolvedValueReference", "getMatchData", "valueDescriptor", "shouldReturnNullForEmptyValue", "emptyValue", "findEffectiveLastMatchedElement", "isStopElementReached", "lastMatchedElement", "MatchResult", "intellij.css.analysis"})
    @SourceDebugExtension(value={"SMAP\nCssValueInspectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssValueInspectionUtil.kt\ncom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1761#2,3:325\n12970#3,2:328\n1#4:330\n*S KotlinDebug\n*F\n+ 1 CssValueInspectionUtil.kt\ncom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion\n*L\n154#1:325,3\n259#1:328,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)valueOwner, (String)"valueOwner");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)errorMessageKey, (String)"errorMessageKey");
            CssInspectionsUtil.CssInvalidValueRangeProvider cssInvalidValueRangeProvider = CssInspectionsUtil.CssInvalidValueRangeProvider.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)cssInvalidValueRangeProvider, (String)"INSTANCE");
            this.inspectCssValueAgainstDescriptors(descriptors, valueOwner, holder, errorMessageKey, cssInvalidValueRangeProvider);
        }

        @JvmStatic
        public final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey, @NotNull CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)valueOwner, (String)"valueOwner");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)errorMessageKey, (String)"errorMessageKey");
            Intrinsics.checkNotNullParameter((Object)invalidValueRangeProvider, (String)"invalidValueRangeProvider");
            this.inspectCssValueAgainstDescriptors(descriptors, valueOwner, holder, errorMessageKey, invalidValueRangeProvider, true, false);
        }

        @JvmStatic
        public final void inspectCssValueAgainstDescriptors(@NotNull Collection<? extends CssValueOwnerDescriptor> descriptors, @NotNull CssValueOwner valueOwner, @NotNull ProblemsHolder holder, @NotNull String errorMessageKey, @NotNull CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider, boolean ignoreEmptyValue, boolean ignoreToggleValue) {
            CssTerm[] value;
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Intrinsics.checkNotNullParameter((Object)valueOwner, (String)"valueOwner");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)errorMessageKey, (String)"errorMessageKey");
            Intrinsics.checkNotNullParameter((Object)invalidValueRangeProvider, (String)"invalidValueRangeProvider");
            if (this.shouldSkipValidation(descriptors, valueOwner)) {
                return;
            }
            CssTerm[] cssTermArray = value = valueOwner.getValue();
            if (value == null || (cssTermArray = cssTermArray.getTerms()) == null) {
                cssTermArray = CssTerm.TERMS_EMPTY_ARRAY;
            }
            CssTerm[] terms = cssTermArray;
            Intrinsics.checkNotNull((Object)terms);
            if (this.shouldSkipBasedOnTerms(terms, ignoreEmptyValue, ignoreToggleValue)) {
                return;
            }
            if (this.hasResolvedValueReference((CssTermList)value)) {
                return;
            }
            this.processValueValidation(descriptors, valueOwner, holder, errorMessageKey, invalidValueRangeProvider, (CssTermList)value, terms);
        }

        private final void processValueValidation(Collection<? extends CssValueOwnerDescriptor> descriptors, CssValueOwner valueOwner, ProblemsHolder holder, String errorMessageKey, CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider, CssTermList value, CssTerm[] terms) {
            MatchResult matchResults = this.matchDescriptorsAgainstValue(descriptors, value, terms);
            if (matchResults == null) {
                return;
            }
            this.registerProblems(valueOwner, holder, errorMessageKey, invalidValueRangeProvider, matchResults);
        }

        private final MatchResult matchDescriptorsAgainstValue(Collection<? extends CssValueOwnerDescriptor> descriptors, CssTermList value, CssTerm[] terms) {
            PsiElement stopElement = CssPsiUtilCore.getLastDeepestTerm((PsiElement)((PsiElement)value));
            Comparator comparator = (Comparator)new CssParameterInfoValueDescriptorComparator();
            TreeSet notMatchedData = SetsKt.sortedSetOf((Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    CssValueMatchData cssValueMatchData = (CssValueMatchData)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    CssValueMatchData it = (CssValueMatchData)b;
                    CssValueDescriptor cssValueDescriptor = it.getDescriptor();
                    bl = false;
                    CssValueDescriptor cssValueDescriptor2 = it.getDescriptor();
                    return comparator.compare(cssValueDescriptor, cssValueDescriptor2);
                }
            }, (Object[])new CssValueMatchData[0]);
            Comparator comparator2 = (Comparator)new CssParameterInfoValueDescriptorComparator();
            TreeSet matchedDataWithRedundantParameters = SetsKt.sortedSetOf((Comparator)new Comparator(comparator2){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    CssValueMatchData cssValueMatchData = (CssValueMatchData)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    CssValueMatchData it = (CssValueMatchData)b;
                    CssValueDescriptor cssValueDescriptor = it.getDescriptor();
                    bl = false;
                    CssValueDescriptor cssValueDescriptor2 = it.getDescriptor();
                    return comparator.compare(cssValueDescriptor, cssValueDescriptor2);
                }
            }, (Object[])new CssValueMatchData[0]);
            boolean emptyValue = terms.length == 0;
            for (CssValueOwnerDescriptor descriptor : CssDescriptorsUtilCore.sortDescriptors(descriptors)) {
                CssValueDescriptor valueDescriptor;
                Intrinsics.checkNotNullExpressionValue((Object)descriptor.getValueDescriptor(), (String)"getValueDescriptor(...)");
                CssValueMatchData matchData = this.getMatchData(value, valueDescriptor);
                if (matchData.isMatched()) {
                    if (this.shouldReturnNullForEmptyValue(emptyValue, valueDescriptor)) {
                        return null;
                    }
                    PsiElement effectiveLastMatchedElement = this.findEffectiveLastMatchedElement(matchData);
                    if (this.isStopElementReached(effectiveLastMatchedElement, stopElement)) {
                        return null;
                    }
                    matchedDataWithRedundantParameters.add(matchData);
                    continue;
                }
                notMatchedData.add(matchData);
            }
            CssTermList cssTermList = value;
            if ((cssTermList != null ? cssTermList.getParent() : null) instanceof CssDeclaration && this.matchAllDescriptor(value, stopElement, matchedDataWithRedundantParameters, notMatchedData)) {
                return null;
            }
            return new MatchResult(notMatchedData, matchedDataWithRedundantParameters);
        }

        private final boolean matchAllDescriptor(CssTermList value, PsiElement stopElement, TreeSet<CssValueMatchData> matchedDataWithRedundantParameters, TreeSet<CssValueMatchData> notMatchedData) {
            CssPropertyDescriptor allDescriptor = CssDescriptorsUtil.getPropertyAllDescriptor((PsiElement)((PsiElement)value));
            if (allDescriptor != null) {
                CssValueDescriptor cssValueDescriptor = allDescriptor.getValueDescriptor();
                Intrinsics.checkNotNullExpressionValue((Object)cssValueDescriptor, (String)"getValueDescriptor(...)");
                CssValueMatchData matchData = this.getMatchData(value, cssValueDescriptor);
                if (matchData.isMatched()) {
                    PsiElement effectiveLastMatchedElement = this.findEffectiveLastMatchedElement(matchData);
                    if (this.isStopElementReached(effectiveLastMatchedElement, stopElement)) {
                        return true;
                    }
                    matchedDataWithRedundantParameters.add(matchData);
                } else if (matchedDataWithRedundantParameters.isEmpty()) {
                    boolean bl;
                    block9: {
                        Iterable $this$any$iv = notMatchedData;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                CssValueMatchData it = (CssValueMatchData)element$iv;
                                boolean bl2 = false;
                                if (!(it.getFirstMatchedElement() != null)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) {
                        notMatchedData.add(matchData);
                    }
                }
            }
            return false;
        }

        private final void registerProblems(CssValueOwner valueOwner, ProblemsHolder holder, String errorMessageKey, CssInspectionsUtil.CssInvalidValueRangeProvider invalidValueRangeProvider, MatchResult matchResult) {
            TextRange textRange = valueOwner.getTrimmedValueTextRange().shiftRight(-valueOwner.getTextRange().getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange valueTextRange = textRange;
            if (!matchResult.getNotMatchedData().isEmpty() && matchResult.getMatchedDataWithRedundantParameters().isEmpty()) {
                for (CssValueMatchData notMatched : matchResult.getNotMatchedData()) {
                    CssValueMatchData deepestNotMatchedData;
                    if (notMatched.findDeepestNotMatchedData() == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    CssValueMatchData cssValueMatchData = deepestNotMatchedData;
                    Intrinsics.checkNotNull((Object)cssValueMatchData);
                    String message = this.buildInvalidValueErrorMessage(notMatched, cssValueMatchData.getDescriptor(), errorMessageKey, holder.isOnTheFly());
                    holder.registerProblem((PsiElement)valueOwner, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, invalidValueRangeProvider.calculateInvalidRange(valueOwner, notMatched.getLastMatchedElement(), valueTextRange), new LocalQuickFix[0]);
                }
            } else {
                for (CssValueMatchData matchData : matchResult.getMatchedDataWithRedundantParameters()) {
                    String message = this.buildInvalidValueErrorMessage(matchData, null, errorMessageKey, holder.isOnTheFly());
                    PsiElement lastMatchedElement = matchData.getLastMatchedElement();
                    holder.registerProblem((PsiElement)valueOwner, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, invalidValueRangeProvider.calculateInvalidRange(valueOwner, lastMatchedElement, valueTextRange), new LocalQuickFix[0]);
                }
            }
        }

        @NotNull
        public final String buildInvalidValueErrorMessage(@NotNull CssValueMatchData matchData, @Nullable CssValueDescriptor highlightingDescriptor, @PropertyKey(resourceBundle="messages.CssBundle") @NotNull String errorMessageKey, boolean onTheFly) {
            String string;
            Intrinsics.checkNotNullParameter((Object)matchData, (String)"matchData");
            Intrinsics.checkNotNullParameter((Object)errorMessageKey, (String)"errorMessageKey");
            CssParameterInfoValueDescriptorsVisitor messageBuilder = new CssParameterInfoValueDescriptorsVisitor(highlightingDescriptor, true, false);
            CssValueDescriptor cssValueDescriptor = matchData.getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)cssValueDescriptor, (String)"getDescriptor(...)");
            CssValueDescriptor parentDescriptor = cssValueDescriptor;
            parentDescriptor.accept((CssValueDescriptorVisitor)messageBuilder);
            StringBuilder parameterInfo = new StringBuilder(messageBuilder.getParameterInfo());
            if (onTheFly) {
                this.addHighlighting(parameterInfo, messageBuilder.getHighlightingStart(), messageBuilder.getHighlightingEnd());
            }
            Object[] objectArray = new Object[]{parentDescriptor.getPresentableName(), parameterInfo};
            String string2 = CssBundle.message((String)errorMessageKey, (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            if (onTheFly) {
                String string3 = StringUtil.escapeXmlEntities((String)XmlStringUtil.wrapInHtml((CharSequence)message));
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            } else {
                string = message;
            }
            return string;
        }

        private final void addHighlighting(StringBuilder text, int start, int end) {
            if (start > -1 && end > -1) {
                JBColor errorColor = JBColor.RED;
                String string = "<span style='font-weight: bold; color: rgb(%d,%d,%d);'>";
                Object[] objectArray = new Object[]{errorColor.getRed(), errorColor.getGreen(), errorColor.getBlue()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String highlightStyle = string2;
                text.insert(end, "</span>").insert(start, highlightStyle);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldSkipValidation(Collection<? extends CssValueOwnerDescriptor> descriptors, CssValueOwner valueOwner) {
            Language language;
            if (descriptors.isEmpty()) {
                return true;
            }
            if (PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)valueOwner), OuterLanguageElement.class) != null) {
                return true;
            }
            Language language2 = language = CssPsiUtilCore.getStylesheetLanguage((PsiElement)((PsiElement)valueOwner));
            Language language3 = language2;
            if (language2 == null) return false;
            Language lang = language3;
            boolean bl = false;
            CssInspectionFilter cssInspectionFilter = (CssInspectionFilter)CssInspectionFilter.INSTANCE.forLanguage(lang);
            if (cssInspectionFilter == null) return false;
            CssInspectionFilter filter = cssInspectionFilter;
            boolean bl2 = false;
            Boolean bl3 = !filter.isValueShouldBeValidatedWithCssScheme(valueOwner.getValue());
            language3 = bl3;
            if (bl3 == null) return false;
            boolean bl4 = language3.booleanValue();
            return bl4;
        }

        private final boolean shouldSkipBasedOnTerms(CssTerm[] terms, boolean ignoreEmptyValue, boolean ignoreToggleValue) {
            return this.shouldSkipBasedOnToggleFunction(terms, ignoreEmptyValue, ignoreToggleValue) || this.shouldSkipDueToVarWithoutFallback(terms);
        }

        private final boolean shouldSkipBasedOnToggleFunction(CssTerm[] terms, boolean ignoreEmptyValue, boolean ignoreToggleValue) {
            boolean bl;
            if (ignoreEmptyValue && terms.length == 0) {
                bl = true;
            } else if (terms.length == 1 && ignoreToggleValue) {
                CssTerm cssTerm = (CssTerm)ArraysKt.firstOrNull((Object[])terms);
                bl = Intrinsics.areEqual((Object)(cssTerm != null ? cssTerm.getTermType() : null), (Object)CssTermTypes.TOGGLE);
            } else {
                bl = false;
            }
            return bl;
        }

        private final boolean shouldSkipDueToVarWithoutFallback(CssTerm[] terms) {
            boolean bl;
            block1: {
                CssTerm[] $this$any$iv = terms;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    CssTerm element$iv;
                    CssTerm term = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)term.getTermType(), (Object)CssTermTypes.VAR) && CssValueDescriptorMapper.Companion.getVarFallbackTerms((PsiElement)term) == null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasResolvedValueReference(CssTermList value) {
            if (value == null) {
                return false;
            }
            Ref.BooleanRef hasReference = new Ref.BooleanRef();
            value.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(hasReference){
                final /* synthetic */ Ref.BooleanRef $hasReference;
                {
                    this.$hasReference = $hasReference;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)CssElementTypes.CSS_IDENT)) {
                        boolean bl;
                        block3: {
                            PsiReference[] psiReferenceArray = element.getReferences();
                            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                            Object[] $this$any$iv = psiReferenceArray;
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                PsiReference it = (PsiReference)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof CssValueReference && ((CssValueReference)it).resolve() != null)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                        if (bl) {
                            this.$hasReference.element = true;
                            return;
                        }
                    }
                    super.visitElement(element);
                }
            });
            return hasReference.element;
        }

        private final CssValueMatchData getMatchData(CssTermList value, CssValueDescriptor valueDescriptor) {
            CssValueMatchData cssValueMatchData;
            if (value != null) {
                CssValueMatchData cssValueMatchData2 = value.matchWithValueDescriptor(valueDescriptor);
                Intrinsics.checkNotNull((Object)cssValueMatchData2);
                cssValueMatchData = cssValueMatchData2;
            } else {
                cssValueMatchData = new CssValueDescriptorMapper(null).mapValue(valueDescriptor);
            }
            return cssValueMatchData;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldReturnNullForEmptyValue(boolean emptyValue, CssValueDescriptor valueDescriptor) {
            if (!emptyValue) {
                return false;
            }
            if (valueDescriptor.getMinOccur() <= 0) return true;
            if (!(valueDescriptor instanceof CssGroupValue)) return false;
            Collection collection = ((CssGroupValue)valueDescriptor).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
            if (!CssValueDescriptorMapper.Companion.getAllRequired(collection).isEmpty()) return false;
            return true;
        }

        private final PsiElement findEffectiveLastMatchedElement(CssValueMatchData matchData) {
            PsiElement lastMatchedElement = matchData.getLastMatchedElement();
            PsiElement psiElement = CssValueDescriptorMapper.Companion.getVarFunctionTermElementIfIsLastFallbackTerm(lastMatchedElement);
            if (psiElement == null) {
                psiElement = lastMatchedElement;
            }
            return psiElement;
        }

        private final boolean isStopElementReached(PsiElement lastMatchedElement, PsiElement stopElement) {
            boolean bl;
            if (lastMatchedElement == null) {
                return false;
            }
            if (stopElement == lastMatchedElement) {
                return true;
            }
            Class[] classArray = new Class[]{CssTerm.class};
            CssTerm cssTerm = (CssTerm)PsiTreeUtil.getNonStrictParentOfType((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)lastMatchedElement), (Class[])classArray);
            if (cssTerm != null) {
                CssTerm it = cssTerm;
                boolean bl2 = false;
                bl = it == stopElement;
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/psi/css/inspections/invalid/CssValueInspectionUtil$Companion$MatchResult;", "", "notMatchedData", "", "Lcom/intellij/psi/css/descriptor/value/CssValueMatchData;", "matchedDataWithRedundantParameters", "<init>", "(Ljava/util/Set;Ljava/util/Set;)V", "getNotMatchedData", "()Ljava/util/Set;", "getMatchedDataWithRedundantParameters", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.css.analysis"})
        private static final class MatchResult {
            @NotNull
            private final Set<CssValueMatchData> notMatchedData;
            @NotNull
            private final Set<CssValueMatchData> matchedDataWithRedundantParameters;

            public MatchResult(@NotNull Set<CssValueMatchData> notMatchedData, @NotNull Set<CssValueMatchData> matchedDataWithRedundantParameters) {
                Intrinsics.checkNotNullParameter(notMatchedData, (String)"notMatchedData");
                Intrinsics.checkNotNullParameter(matchedDataWithRedundantParameters, (String)"matchedDataWithRedundantParameters");
                this.notMatchedData = notMatchedData;
                this.matchedDataWithRedundantParameters = matchedDataWithRedundantParameters;
            }

            @NotNull
            public final Set<CssValueMatchData> getNotMatchedData() {
                return this.notMatchedData;
            }

            @NotNull
            public final Set<CssValueMatchData> getMatchedDataWithRedundantParameters() {
                return this.matchedDataWithRedundantParameters;
            }

            @NotNull
            public final Set<CssValueMatchData> component1() {
                return this.notMatchedData;
            }

            @NotNull
            public final Set<CssValueMatchData> component2() {
                return this.matchedDataWithRedundantParameters;
            }

            @NotNull
            public final MatchResult copy(@NotNull Set<CssValueMatchData> notMatchedData, @NotNull Set<CssValueMatchData> matchedDataWithRedundantParameters) {
                Intrinsics.checkNotNullParameter(notMatchedData, (String)"notMatchedData");
                Intrinsics.checkNotNullParameter(matchedDataWithRedundantParameters, (String)"matchedDataWithRedundantParameters");
                return new MatchResult(notMatchedData, matchedDataWithRedundantParameters);
            }

            public static /* synthetic */ MatchResult copy$default(MatchResult matchResult, Set set, Set set2, int n, Object object) {
                if ((n & 1) != 0) {
                    set = matchResult.notMatchedData;
                }
                if ((n & 2) != 0) {
                    set2 = matchResult.matchedDataWithRedundantParameters;
                }
                return matchResult.copy(set, set2);
            }

            @NotNull
            public String toString() {
                return "MatchResult(notMatchedData=" + this.notMatchedData + ", matchedDataWithRedundantParameters=" + this.matchedDataWithRedundantParameters + ")";
            }

            public int hashCode() {
                int result = ((Object)this.notMatchedData).hashCode();
                result = result * 31 + ((Object)this.matchedDataWithRedundantParameters).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchResult)) {
                    return false;
                }
                MatchResult matchResult = (MatchResult)other;
                if (!Intrinsics.areEqual(this.notMatchedData, matchResult.notMatchedData)) {
                    return false;
                }
                return Intrinsics.areEqual(this.matchedDataWithRedundantParameters, matchResult.matchedDataWithRedundantParameters);
            }
        }
    }
}

