/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JBCefPsiNavigationUtils;
import com.intellij.util.messages.Topic;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterCefLoadHandler;", "Lorg/cef/handler/CefLoadHandlerAdapter;", "Lcom/intellij/openapi/Disposable;", "browserBase", "Lcom/intellij/ui/jcef/JBCefBrowserBase;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/ui/jcef/JBCefBrowserBase;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "queryOpenInBrowser", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "browser", "Lorg/cef/browser/CefBrowser;", "dispose", "", "onLoadEnd", "frame", "Lorg/cef/browser/CefFrame;", "httpStatusCode", "", "updateMarkdownFontSize", "Companion", "intellij.jupyter.core"})
public final class JupyterCefLoadHandler
extends CefLoadHandlerAdapter
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final JBCefJSQuery queryOpenInBrowser;
    @Nullable
    private CefBrowser browser;
    @NotNull
    private static final Lazy<String> processLinksJs$delegate = LazyKt.lazy(JupyterCefLoadHandler::processLinksJs_delegate$lambda$0);

    public JupyterCefLoadHandler(@NotNull JBCefBrowserBase browserBase, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)browserBase, (String)"browserBase");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)browserBase);
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.queryOpenInBrowser = jBCefJSQuery;
        Disposer.register((Disposable)((Disposable)browserBase), (Disposable)((Disposable)this.queryOpenInBrowser));
        Project project = this.editor.getProject();
        if (project != null && (project = project.getMessageBus()) != null && (project = project.connect((Disposable)this)) != null) {
            Topic topic = UISettingsListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            project.subscribe(topic, (Object)new UISettingsListener(){

                public void uiSettingsChanged(UISettings uiSettings) {
                    Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
                    this.updateMarkdownFontSize();
                }
            });
        }
        this.queryOpenInBrowser.addHandler(arg_0 -> JupyterCefLoadHandler._init_$lambda$1(JupyterCefLoadHandler::_init_$lambda$0, arg_0));
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    public void dispose() {
        this.browser = null;
    }

    public void onLoadEnd(@NotNull CefBrowser browser, @NotNull CefFrame frame, int httpStatusCode) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (httpStatusCode != 200) {
            return;
        }
        JBCefJSQuery it = this.queryOpenInBrowser;
        boolean bl = false;
        browser.executeJavaScript("\n         " + Companion.getProcessLinksJs() + "\n          window.__IntelliJTools.openInExternalBrowser = function(link) {\n                " + it.inject("link") + " \n          };", browser.getURL(), 0);
        this.browser = browser;
        this.updateMarkdownFontSize();
    }

    private final void updateMarkdownFontSize() {
        JupyterCoroutineKt.launchIO((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterCefLoadHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CefBrowser cefBrowser = JupyterCefLoadHandler.access$getBrowser$p(this.this$0);
                        if (cefBrowser == null) {
                            return Unit.INSTANCE;
                        }
                        CefBrowser browser = cefBrowser;
                        Editor editor = this.this$0.getEditor();
                        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                        int fontSize = ((EditorImpl)editor).getFontSize();
                        int scale = JupyterSettings.Companion.getInstance().getMarkdownScalePercentage();
                        int magicConst = 2;
                        int resultFontSize = fontSize * scale / 100 + magicConst;
                        String code = StringsKt.trimMargin$default((String)("\n        (function() {\n            const root = document.documentElement;\n            const fontSizeVars = ['--jp-content-font-size1'];\n            const resultFontSize = " + resultFontSize + "; \n        \n            fontSizeVars.forEach((varName) => {\n                // Get the current value of the CSS variable\n                const currentFontSize = getComputedStyle(root).getPropertyValue(varName).trim();\n        \n                // Parse the current value to extract the numerical value and unit\n                const fontSizeValue = parseFloat(currentFontSize);\n                const fontSizeUnit = currentFontSize.match(/[a-zA-Z%]+/)[0];\n        \n                // Calculate the new scaled value\n                const newFontSizeValue = resultFontSize;\n        \n                // Update the CSS variable with the new value\n                root.style.setProperty(varName, newFontSizeValue + fontSizeUnit);\n            });\n        })();\n"), null, (int)1, null);
                        browser.executeJavaScript(code, browser.getURL(), 0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final JBCefJSQuery.Response _init_$lambda$0(String link) {
        Intrinsics.checkNotNull((Object)link);
        if (JBCefPsiNavigationUtils.INSTANCE.navigateTo(link)) {
            return null;
        }
        BrowserUtil.browse((String)link);
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final String processLinksJs_delegate$lambda$0() {
        String string;
        InputStream inputStream = Companion.getClass().getResourceAsStream("processLinks.js");
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            string = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ CefBrowser access$getBrowser$p(JupyterCefLoadHandler $this) {
        return $this.browser;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterCefLoadHandler$Companion;", "", "<init>", "()V", "processLinksJs", "", "getProcessLinksJs", "()Ljava/lang/String;", "processLinksJs$delegate", "Lkotlin/Lazy;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getProcessLinksJs() {
            Lazy lazy = processLinksJs$delegate;
            return (String)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

