/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.notification;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterIgnoreNotificationException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterKernelDoesNotExistsException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterKernelSpecMissingException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterLoginException;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterManagedServerExited;
import com.intellij.jupyter.core.jupyter.connections.exceptions.JupyterResolvableException;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRestClientErrorResponseException;
import com.intellij.jupyter.core.jupyter.connections.ws.JupyterWebSocketClientClosedException;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.notification.JupyterNotification;
import com.intellij.jupyter.core.jupyter.ui.ExceptionUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.ListenerUtilKt;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.impl.CollapsibleTitledSeparatorImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import org.apache.http.conn.HttpHostConnectException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J4\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ \u0010\u001b\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010\u001fJ>\u0010 \u001a\u00020\u000f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\b\u0001\u0010#\u001a\u00020\u00132\b\b\u0001\u0010$\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010%\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010&J*\u0010'\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010(\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010)J$\u0010*\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010(\u001a\u00020\u0018H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0013J\u001e\u0010.\u001a\u0004\u0018\u00010\"2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0016\u00101\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u00103J\u0016\u00104\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u00103J\u0018\u00105\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u00106\u001a\u00020\u0013R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u00067"}, d2={"Lcom/intellij/jupyter/core/jupyter/notification/JupyterNotification;", "", "<init>", "()V", "JUPYTER_RFS_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getJUPYTER_RFS_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "JUPYTER_RFS_NOTIFICATION_GROUP$delegate", "Lkotlin/Lazy;", "JUPYTER_NOTIFICATION_GROUP", "getJUPYTER_NOTIFICATION_GROUP", "EVENT_LOG_NOTIFICATION_GROUP", "getEVENT_LOG_NOTIFICATION_GROUP", "notifyInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "message", "", "displayId", "notifyRfsInfo", "notifyRfsError", "suggestToOpenSettings", "", "throwable", "", "showErrorDialog", "e", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showErrorMessageDialog", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "displayServerMessage", "jupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "balloonMessage", "dialogMessage", "exception", "(Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showExceptionDialogAsync", "showSettingsAction", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Throwable;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showExceptionDialog", "createStackPanel", "Ljavax/swing/JScrollPane;", "stackTrace", "getJupyterFileEditor", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "showReconnectedKernelIdle", "filename", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showReconnectedKernelBusy", "notifyDisconnect", "connectionName", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterNotification.kt\ncom/intellij/jupyter/core/jupyter/notification/JupyterNotification\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,272:1\n23#2:273\n23#2:274\n4225#3,11:275\n*S KotlinDebug\n*F\n+ 1 JupyterNotification.kt\ncom/intellij/jupyter/core/jupyter/notification/JupyterNotification\n*L\n87#1:273\n180#1:274\n241#1:275,11\n*E\n"})
public final class JupyterNotification {
    @NotNull
    public static final JupyterNotification INSTANCE = new JupyterNotification();
    @NotNull
    private static final Lazy JUPYTER_RFS_NOTIFICATION_GROUP$delegate = LazyKt.lazy(JupyterNotification::JUPYTER_RFS_NOTIFICATION_GROUP_delegate$lambda$0);

    private JupyterNotification() {
    }

    private final NotificationGroup getJUPYTER_RFS_NOTIFICATION_GROUP() {
        Lazy lazy = JUPYTER_RFS_NOTIFICATION_GROUP$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (NotificationGroup)object;
    }

    @NotNull
    public final NotificationGroup getJUPYTER_NOTIFICATION_GROUP() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jupyter Server (Tool Window)");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @NotNull
    public final NotificationGroup getEVENT_LOG_NOTIFICATION_GROUP() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jupyter Server (Event Log)");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    public final void notifyInfo(@NotNull Project project, @Nls @NotNull String message, @NotNull String displayId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        this.getJUPYTER_NOTIFICATION_GROUP().createNotification(message, NotificationType.INFORMATION).setDisplayId(displayId).notify(project);
    }

    public final void notifyRfsInfo(@NotNull Project project, @Nls @NotNull String message, @NotNull String displayId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Notification notification = this.getJUPYTER_RFS_NOTIFICATION_GROUP().createNotification(message, NotificationType.INFORMATION).setDisplayId(displayId);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        notification2.notify(project);
    }

    public final void notifyRfsError(@NotNull Project project, @Nls @NotNull String message, @NotNull String displayId, boolean suggestToOpenSettings, @Nullable Throwable throwable) {
        AnAction openSettingsAction;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Notification notification = this.getJUPYTER_RFS_NOTIFICATION_GROUP().createNotification(message, NotificationType.ERROR).setDisplayId(displayId);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        if (suggestToOpenSettings && (openSettingsAction = ActionManager.getInstance().getAction("OpenJupyterSettingsAction")) != null) {
            notification2.addAction(openSettingsAction);
        }
        if (throwable != null) {
            notification2.addAction((AnAction)DumbAwareAction.create((String)JupyterBundle.message("notification.content.show.exception.action", new Object[0]), arg_0 -> JupyterNotification.notifyRfsError$lambda$1(arg_0 -> JupyterNotification.notifyRfsError$lambda$0(project, throwable, notification2, arg_0), arg_0)));
        }
        notification2.notify(project);
    }

    public static /* synthetic */ void notifyRfsError$default(JupyterNotification jupyterNotification, Project project, String string, String string2, boolean bl, Throwable throwable, int n, Object object) {
        if ((n & 0x10) != 0) {
            throwable = null;
        }
        jupyterNotification.notifyRfsError(project, string, string2, bl, throwable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Object showErrorDialog(@Nullable Project project, @NotNull Throwable e, @NotNull Continuation<? super Unit> $completion) {
        JupyterNotification $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterNotification.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Jupyter Connection Error", e);
        Throwable throwable = e;
        if (throwable instanceof TimeoutCancellationException) {
            Object object = this.showExceptionDialogAsync(project, e, false, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (throwable instanceof CancellationException) return Unit.INSTANCE;
        if (throwable instanceof JupyterIgnoreNotificationException) return Unit.INSTANCE;
        if (throwable instanceof JupyterKernelDoesNotExistsException) {
            BackedNotebookVirtualFile backedNotebookVirtualFile = ((JupyterKernelDoesNotExistsException)e).getNotebookVirtualFile();
            JupyterFileEditor jupyterFileEditor = this.getJupyterFileEditor(project, (VirtualFile)(backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getOriginFile() : null));
            String string = JupyterBundle.message("Jupyter.kernel.does.not.exist.balloon.message", new Object[0]);
            String string2 = ((JupyterKernelDoesNotExistsException)e).getMessage();
            JupyterKernelDoesNotExistsException jupyterKernelDoesNotExistsException = (JupyterKernelDoesNotExistsException)e;
            Object object = this.displayServerMessage(jupyterFileEditor, string, string2, project, jupyterKernelDoesNotExistsException, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (throwable instanceof JupyterKernelSpecMissingException) {
            JupyterFileEditor jupyterFileEditor = this.getJupyterFileEditor(project, ((JupyterKernelSpecMissingException)e).getNotebookVirtualFile().getOriginFile());
            Object object = this.displayServerMessage(jupyterFileEditor, JupyterBundle.message("Jupyter.kernel.spec.is.missing.in.notebook.balloon.message", new Object[0]), ((JupyterKernelSpecMissingException)e).getMessage(), project, e, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (throwable instanceof JupyterRestClientErrorResponseException) {
            Object object = this.showExceptionDialogAsync(project, e, false, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (throwable instanceof JupyterWebSocketClientClosedException || throwable instanceof JupyterManagedServerExited || throwable instanceof HttpHostConnectException) {
            JupyterResolvableException rootException;
            Throwable throwable2 = e.getCause();
            JupyterResolvableException jupyterResolvableException = rootException = throwable2 instanceof JupyterResolvableException ? (JupyterResolvableException)throwable2 : null;
            if (rootException != null) {
                rootException.resolve();
                return Unit.INSTANCE;
            }
            Object object = this.showExceptionDialogAsync(project, e, true, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        if (throwable instanceof JupyterLoginException) {
            Object object = this.showExceptionDialogAsync(project, e, true, $completion);
            if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
            return object;
        }
        Object object = this.showExceptionDialogAsync(project, e, false, $completion);
        if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
        return object;
    }

    @Nullable
    public final Object showErrorMessageDialog(@Nullable Project project, @NlsContexts.DialogMessage @NotNull String message, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, message, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $message;
            {
                this.$project = $project;
                this.$message = $message;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> showErrorMessageDialog.2.invokeSuspend$lambda$0(this.$project, this.$message), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Project $project, String $message) {
                Messages.showErrorDialog((Project)$project, (String)$message, (String)JupyterBundle.message("notification.title.jupyter", new Object[0]));
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object displayServerMessage(JupyterFileEditor jupyterFileEditor, @NlsContexts.DialogMessage String balloonMessage, @NlsContexts.DialogMessage String dialogMessage, Project project, Throwable exception, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(jupyterFileEditor, balloonMessage, project, exception, null){
            int label;
            final /* synthetic */ JupyterFileEditor $jupyterFileEditor;
            final /* synthetic */ String $balloonMessage;
            final /* synthetic */ Project $project;
            final /* synthetic */ Throwable $exception;
            {
                this.$jupyterFileEditor = $jupyterFileEditor;
                this.$balloonMessage = $balloonMessage;
                this.$project = $project;
                this.$exception = $exception;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> displayServerMessage.2.invokeSuspend$lambda$0(this.$jupyterFileEditor, this.$balloonMessage, this.$project, this.$exception), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(JupyterFileEditor $jupyterFileEditor, String $balloonMessage, Project $project, Throwable $exception) {
                if ($jupyterFileEditor != null && $jupyterFileEditor.isValid()) {
                    JupyterFileEditor.showServerBalloon$default($jupyterFileEditor, $balloonMessage, null, 2, null);
                } else {
                    JupyterNotification.showExceptionDialog$default(JupyterNotification.INSTANCE, $project, $exception, false, 4, null);
                }
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object showExceptionDialogAsync(Project project, Throwable throwable, boolean showSettingsAction, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, throwable, showSettingsAction, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ boolean $showSettingsAction;
            {
                this.$project = $project;
                this.$throwable = $throwable;
                this.$showSettingsAction = $showSettingsAction;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.writeIntentReadAction(() -> showExceptionDialogAsync.2.invokeSuspend$lambda$0(this.$project, this.$throwable, this.$showSettingsAction), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Project $project, Throwable $throwable, boolean $showSettingsAction) {
                JupyterNotification.access$showExceptionDialog(JupyterNotification.INSTANCE, $project, $throwable, $showSettingsAction);
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    static /* synthetic */ Object showExceptionDialogAsync$default(JupyterNotification jupyterNotification, Project project, Throwable throwable, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return jupyterNotification.showExceptionDialogAsync(project, throwable, bl, (Continuation<? super Unit>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    private final void showExceptionDialog(Project project, Throwable throwable, boolean showSettingsAction) {
        DialogBuilder dialogBuilder;
        void $this$showExceptionDialog_u24lambda_u240_u241;
        JPanel jPanel;
        JPanel jPanel2;
        JupyterNotification $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(JupyterNotification.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Jupyter error dialog", throwable);
        JScrollPane stack = this.createStackPanel(ExceptionsKt.stackTraceToString((Throwable)throwable));
        DialogBuilder dialogBuilder2 = new DialogBuilder(project);
        JPanel $this$showExceptionDialog_u24lambda_u240 = jPanel2 = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$showExceptionDialog_u24lambda_u240.add((Component)BuilderKt.panel(arg_0 -> JupyterNotification.showExceptionDialog$lambda$0$0(throwable, arg_0)), "North");
        JPanel jPanel3 = jPanel = new JPanel(new BorderLayout());
        JPanel jPanel4 = $this$showExceptionDialog_u24lambda_u240;
        boolean bl2 = false;
        CollapsibleTitledSeparatorImpl separator = new CollapsibleTitledSeparatorImpl(JupyterBundle.message("exception.dialog.stacktrace.title", new Object[0]));
        separator.setExpanded(false);
        $this$showExceptionDialog_u24lambda_u240_u241.add((Component)separator, "North");
        $this$showExceptionDialog_u24lambda_u240_u241.add((Component)stack, "Center");
        stack.setVisible(false);
        ListenerUtilKt.whenPropertyChanged((ObservableProperty)((ObservableProperty)separator.getExpandedProperty()), arg_0 -> JupyterNotification.showExceptionDialog$lambda$0$1$0(stack, separator, dialogBuilder2, arg_0));
        jPanel4.add(jPanel);
        JPanel panel = jPanel2;
        AnAction jupyterSettingsAction = ActionManager.getInstance().getAction("OpenJupyterSettingsAction");
        DialogBuilder $this$showExceptionDialog_u24lambda_u241 = dialogBuilder = dialogBuilder2;
        boolean bl3 = false;
        $this$showExceptionDialog_u24lambda_u241.addOkAction();
        if (showSettingsAction) {
            Object object = jupyterSettingsAction;
            if (object == null || (object = object.getTemplatePresentation()) == null || (object = object.getText()) == null) {
                object = Messages.getCancelButton();
            }
            Object object2 = object;
            AbstractAction settingsAction2 = new AbstractAction(project, jupyterSettingsAction, (String)object2){
                final /* synthetic */ Project $project;
                final /* synthetic */ AnAction $jupyterSettingsAction;
                {
                    this.$project = $project;
                    this.$jupyterSettingsAction = $jupyterSettingsAction;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)this.$project).build();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
                    DataContext dataContext2 = dataContext;
                    AnActionEvent anActionEvent = AnActionEvent.createEvent((AnAction)this.$jupyterSettingsAction, (DataContext)dataContext2, null, (String)"Notification", (ActionUiKind)ActionUiKind.NONE, null);
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
                    AnActionEvent actionEvent = anActionEvent;
                    this.$jupyterSettingsAction.actionPerformed(actionEvent);
                }
            };
            $this$showExceptionDialog_u24lambda_u241.addAction((Action)settingsAction2);
        }
        $this$showExceptionDialog_u24lambda_u241.setCenterPanel((JComponent)panel);
        $this$showExceptionDialog_u24lambda_u241.setTitle(JupyterBundle.message("notification.title.jupyter", new Object[0]));
        $this$showExceptionDialog_u24lambda_u241.show();
    }

    static /* synthetic */ void showExceptionDialog$default(JupyterNotification jupyterNotification, Project project, Throwable throwable, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        jupyterNotification.showExceptionDialog(project, throwable, bl);
    }

    @NotNull
    public final JScrollPane createStackPanel(@NotNull String stackTrace) {
        JTextArea jTextArea;
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        JTextArea $this$createStackPanel_u24lambda_u240 = jTextArea = new JTextArea();
        boolean bl = false;
        $this$createStackPanel_u24lambda_u240.setLineWrap(false);
        $this$createStackPanel_u24lambda_u240.setText(stackTrace);
        $this$createStackPanel_u24lambda_u240.setCaretPosition(0);
        $this$createStackPanel_u24lambda_u240.setRows(8);
        $this$createStackPanel_u24lambda_u240.setColumns(50);
        JTextArea stackEditor = jTextArea;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)stackEditor, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        return jScrollPane;
    }

    /*
     * WARNING - void declaration
     */
    private final JupyterFileEditor getJupyterFileEditor(Project project, VirtualFile originalFile) {
        JupyterFileEditor jupyterFileEditor;
        if (project != null && originalFile != null) {
            void $this$filterIsInstanceTo$iv$iv;
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors(originalFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] $this$filterIsInstance$iv = fileEditorArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof JupyterFileEditor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            jupyterFileEditor = (JupyterFileEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        } else {
            jupyterFileEditor = null;
        }
        return jupyterFileEditor;
    }

    @Nullable
    public final Object showReconnectedKernelIdle(@NotNull String filename, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(filename, null){
            int label;
            final /* synthetic */ String $filename;
            {
                this.$filename = $filename;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new Object[]{this.$filename};
                        new Notification("Jupyter", JupyterBundle.message("notification.reconnected.kernel.idle.title", new Object[0]), JupyterBundle.message("notification.reconnected.kernel.idle.content", objectArray), NotificationType.INFORMATION).setDisplayId("reconnected.kernel.idle").notify(null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object showReconnectedKernelBusy(@NotNull String filename, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(filename, null){
            int label;
            final /* synthetic */ String $filename;
            {
                this.$filename = $filename;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object[] objectArray = new Object[]{this.$filename};
                        new Notification("Jupyter", JupyterBundle.message("notification.reconnected.kernel.busy.title", new Object[0]), JupyterBundle.message("notification.reconnected.kernel.busy.content", objectArray), NotificationType.WARNING).setDisplayId("reconnected.kernel.busy").notify(null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void notifyDisconnect(@Nullable Project project, @NotNull String connectionName) {
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        Object[] objectArray = new Object[]{connectionName};
        Messages.showInfoMessage((Project)project, (String)JupyterBundle.message("notification.disconnected.message", objectArray), (String)JupyterBundle.message("notification.disconnected.title", new Object[0]));
    }

    private static final NotificationGroup JUPYTER_RFS_NOTIFICATION_GROUP_delegate$lambda$0() {
        return NotificationGroupManager.getInstance().getNotificationGroup("Jupyter Remote Notifications");
    }

    private static final Unit notifyRfsError$lambda$0(Project $project, Throwable $throwable, Notification $notification, AnActionEvent it) {
        INSTANCE.showExceptionDialog($project, $throwable, false);
        $notification.expire();
        return Unit.INSTANCE;
    }

    private static final void notifyRfsError$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit showExceptionDialog$lambda$0$0(Throwable $throwable, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterNotification.showExceptionDialog$lambda$0$0$0($throwable, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit showExceptionDialog$lambda$0$0$0(Throwable $throwable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)ExceptionUtilsKt.toPresentableText($throwable), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit showExceptionDialog$lambda$0$1$0(JScrollPane $stack, CollapsibleTitledSeparatorImpl $separator, DialogBuilder $dialogBuilder, boolean it) {
        $stack.setVisible($separator.getExpanded());
        $dialogBuilder.getDialogWrapper().pack();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$displayServerMessage(JupyterNotification $this, JupyterFileEditor jupyterFileEditor, String balloonMessage, String dialogMessage, Project project, Throwable exception, Continuation $completion) {
        return $this.displayServerMessage(jupyterFileEditor, balloonMessage, dialogMessage, project, exception, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$showExceptionDialogAsync(JupyterNotification $this, Project project, Throwable throwable, boolean showSettingsAction, Continuation $completion) {
        return $this.showExceptionDialogAsync(project, throwable, showSettingsAction, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$showExceptionDialog(JupyterNotification $this, Project project, Throwable throwable, boolean showSettingsAction) {
        $this.showExceptionDialog(project, throwable, showSettingsAction);
    }
}

