/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.methodslist;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.api.ValueMetricPrinter;
import com.intellij.profiler.api.ValueMetricPrinterWithOptionalUnits;
import com.intellij.profiler.model.CalleesListItem;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.callusage.CallUsageTableCellRenderer;
import com.intellij.profiler.ui.callusage.DiffFactor;
import com.intellij.profiler.ui.callusage.Percentage;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0002*\u0004\b\u0001\u0010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005:\u0007\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\u001b\b\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0007 !\"#$%&\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Item", "Lcom/intellij/profiler/model/CalleesListItem;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Aspect", "Lcom/intellij/util/ui/ColumnInfo;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "name", "", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;Ljava/lang/String;)V", "getMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "metricPrinter", "Lcom/intellij/profiler/api/ValueMetricPrinter;", "printValue", "", "Lcom/intellij/ui/ColoredTableCellRenderer;", "value", "", "MethodNameColumn", "ValueColumn", "OwnValueColumn", "DiffValueColumn", "OldValueColumn", "NewValueColumn", "DiffPercentColumn", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$DiffPercentColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$DiffValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$MethodNameColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$NewValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$OldValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$OwnValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$ValueColumn;", "intellij.profiler.common"})
public abstract sealed class CalleesListColumn<Item extends CalleesListItem<BaseCallStackElement>, Aspect>
extends ColumnInfo<Item, Aspect> {
    @NotNull
    private final ValueMetric metric;
    @NotNull
    private final ValueMetricPrinter metricPrinter;

    private CalleesListColumn(ValueMetric metric, @Nls String name) {
        super(name);
        this.metric = metric;
        this.metricPrinter = new ValueMetricPrinterWithOptionalUnits(ValueMetricPrinter.Default.INSTANCE);
    }

    @NotNull
    public final ValueMetric getMetric() {
        return this.metric;
    }

    @NotNull
    protected abstract TableCellRenderer getRenderer();

    protected final void printValue(@NotNull ColoredTableCellRenderer $this$printValue, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$printValue, (String)"<this>");
        $this$printValue.setBorder(null);
        $this$printValue.setTextAlign(4);
        $this$printValue.append(this.metricPrinter.print(this.metric, value));
    }

    public /* synthetic */ CalleesListColumn(ValueMetric metric, String name, DefaultConstructorMarker $constructor_marker) {
        this(metric, name);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u000b\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0010\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0011j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0012H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$DiffPercentColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Diff;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/DiffFactor;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "valueOf", "item", "valueOf-fFbcdcE", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nCalleesListColumnsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalleesListColumnsProvider.kt\ncom/intellij/profiler/ui/methodslist/CalleesListColumn$DiffPercentColumn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
    public static final class DiffPercentColumn
    extends CalleesListColumn<CalleesListItem.Diff<BaseCallStackElement>, DiffFactor> {
        @NotNull
        private final TableCellRenderer renderer;

        public DiffPercentColumn(@NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Object[] objectArray = new Object[]{metric.getColumnTitle()};
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.diff.method.percents", objectArray), null);
            this.renderer = new CallUsageTableCellRenderer(metric, null, 2, null);
        }

        @Override
        @NotNull
        protected TableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public DiffFactor valueOf-fFbcdcE(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            DiffFactor diffFactor;
            CalleesListItem.Diff<BaseCallStackElement> diff = item;
            if (diff != null) {
                CalleesListItem.Diff<BaseCallStackElement> it = diff;
                boolean bl = false;
                diffFactor = DiffFactor.box-impl(DiffFactor.constructor-impl(it.getFactor()));
            } else {
                diffFactor = null;
            }
            return diffFactor;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Diff<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Diff it = (CalleesListItem.Diff)a;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getFactor());
                    it = (CalleesListItem.Diff)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getFactor()));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u000b\u001a\u00020\u00102\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0013H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$DiffValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Diff;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "valueOf", "item", "(Lcom/intellij/profiler/model/CalleesListItem$Diff;)Ljava/lang/Long;", "Ljavax/swing/table/TableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class DiffValueColumn
    extends CalleesListColumn<CalleesListItem.Diff<BaseCallStackElement>, Long> {
        @NotNull
        private final ColoredTableCellRenderer renderer;

        public DiffValueColumn(@NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Object[] objectArray = new Object[]{metric.getColumnTitle()};
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.diff.method", objectArray), null);
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ DiffValueColumn this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value instanceof Long)) {
                        return;
                    }
                    if (((Number)value).longValue() > 0L) {
                        this.append("+");
                    }
                    this.this$0.printValue(this, ((Number)value).longValue());
                }
            };
        }

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Long valueOf(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            CalleesListItem.Diff<BaseCallStackElement> diff = item;
            return diff != null ? Long.valueOf(diff.getDiffValue()) : null;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            return (TableCellRenderer)this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Diff<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Diff p0 = (CalleesListItem.Diff)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getDiffValue());
                    p0 = (CalleesListItem.Diff)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getDiffValue()));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0012\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0013j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$MethodNameColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "delegate", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;Lcom/intellij/profiler/api/ValueMetric;)V", "getDelegate", "()Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "valueOf", "item", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class MethodNameColumn
    extends CalleesListColumn<CalleesListItem<BaseCallStackElement>, BaseCallStackElement> {
        @NotNull
        private final BaseCallStackElementRenderer delegate;
        @NotNull
        private final ColoredTableCellRenderer renderer;

        public MethodNameColumn(@NotNull BaseCallStackElementRenderer delegate, @NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.method", new Object[0]), null);
            this.delegate = delegate;
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ MethodNameColumn this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value instanceof BaseCallStackElement)) {
                        return;
                    }
                    this.setBorder(null);
                    this.this$0.getDelegate().appendStackElementInRenderer((BaseCallStackElement)value, (SimpleColoredComponent)this, table, selected);
                }
            };
        }

        @NotNull
        public final BaseCallStackElementRenderer getDelegate() {
            return this.delegate;
        }

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public BaseCallStackElement valueOf(@Nullable CalleesListItem<BaseCallStackElement> item) {
            CalleesListItem<BaseCallStackElement> calleesListItem = item;
            return calleesListItem != null ? calleesListItem.getCall() : null;
        }

        @NotNull
        public ColoredTableCellRenderer getRenderer(@Nullable CalleesListItem<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem<BaseCallStackElement>> getComparator() {
            return new Comparator(this){
                final /* synthetic */ MethodNameColumn this$0;
                {
                    this.this$0 = methodNameColumn;
                }

                public final int compare(T a, T b) {
                    CalleesListItem it = (CalleesListItem)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)this.this$0.getDelegate().getText((BaseCallStackElement)it.getCall()));
                    it = (CalleesListItem)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)this.this$0.getDelegate().getText((BaseCallStackElement)it.getCall()))));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u000b\u001a\u00020\u00102\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0013H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$NewValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Diff;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "valueOf", "item", "(Lcom/intellij/profiler/model/CalleesListItem$Diff;)Ljava/lang/Long;", "Ljavax/swing/table/TableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class NewValueColumn
    extends CalleesListColumn<CalleesListItem.Diff<BaseCallStackElement>, Long> {
        @NotNull
        private final ColoredTableCellRenderer renderer;

        public NewValueColumn(@NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Object[] objectArray = new Object[]{metric.getColumnTitle()};
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.new.method", objectArray), null);
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ NewValueColumn this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value instanceof Long)) {
                        return;
                    }
                    this.this$0.printValue(this, ((Number)value).longValue());
                }
            };
        }

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Long valueOf(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            CalleesListItem.Diff<BaseCallStackElement> diff = item;
            return diff != null ? Long.valueOf(diff.getNewValue()) : null;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            return (TableCellRenderer)this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Diff<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Diff p0 = (CalleesListItem.Diff)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getNewValue());
                    p0 = (CalleesListItem.Diff)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getNewValue()));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u000b\u001a\u00020\u00102\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0013H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$OldValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Diff;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;)V", "renderer", "Lcom/intellij/ui/ColoredTableCellRenderer;", "getRenderer", "()Lcom/intellij/ui/ColoredTableCellRenderer;", "valueOf", "item", "(Lcom/intellij/profiler/model/CalleesListItem$Diff;)Ljava/lang/Long;", "Ljavax/swing/table/TableCellRenderer;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class OldValueColumn
    extends CalleesListColumn<CalleesListItem.Diff<BaseCallStackElement>, Long> {
        @NotNull
        private final ColoredTableCellRenderer renderer;

        public OldValueColumn(@NotNull ValueMetric metric) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Object[] objectArray = new Object[]{metric.getColumnTitle()};
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.old.method", objectArray), null);
            this.renderer = new ColoredTableCellRenderer(this){
                final /* synthetic */ OldValueColumn this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    if (!(value instanceof Long)) {
                        return;
                    }
                    this.this$0.printValue(this, ((Number)value).longValue());
                }
            };
        }

        @NotNull
        protected ColoredTableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Long valueOf(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            CalleesListItem.Diff<BaseCallStackElement> diff = item;
            return diff != null ? Long.valueOf(diff.getOldValue()) : null;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Diff<BaseCallStackElement> item) {
            return (TableCellRenderer)this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Diff<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Diff p0 = (CalleesListItem.Diff)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getOldValue());
                    p0 = (CalleesListItem.Diff)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getOldValue()));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0018\u0010\r\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$OwnValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Regular;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/Percentage;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "maxValue", "", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;J)V", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "valueOf", "item", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class OwnValueColumn
    extends CalleesListColumn<CalleesListItem.Regular<BaseCallStackElement>, Percentage> {
        private final long maxValue;
        @NotNull
        private final TableCellRenderer renderer;

        public OwnValueColumn(@NotNull ValueMetric metric, long maxValue) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Object[] objectArray = new Object[]{metric.getColumnTitle()};
            super(metric, CommonProfilerBundleKt.profilerMessage("ui.column.own.method", objectArray), null);
            this.maxValue = maxValue;
            this.renderer = new CallUsageTableCellRenderer(metric, null, 2, null);
        }

        @Override
        @NotNull
        protected TableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Percentage valueOf(@Nullable CalleesListItem.Regular<BaseCallStackElement> item) {
            Percentage percentage;
            CalleesListItem.Regular<BaseCallStackElement> regular = item;
            if (regular != null) {
                CalleesListItem.Regular<BaseCallStackElement> it = regular;
                boolean bl = false;
                percentage = new Percentage((double)it.getOwnValue() / (double)this.maxValue, it.getOwnValue());
            } else {
                percentage = null;
            }
            return percentage;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Regular<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Regular<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Regular p0 = (CalleesListItem.Regular)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getOwnValue());
                    p0 = (CalleesListItem.Regular)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getOwnValue()));
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0018\u0010\r\u001a\u00020\f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J$\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002`\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ui/methodslist/CalleesListColumn$ValueColumn;", "Lcom/intellij/profiler/ui/methodslist/CalleesListColumn;", "Lcom/intellij/profiler/model/CalleesListItem$Regular;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "Lcom/intellij/profiler/ui/callusage/Percentage;", "metric", "Lcom/intellij/profiler/api/ValueMetric;", "maxValue", "", "<init>", "(Lcom/intellij/profiler/api/ValueMetric;J)V", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getRenderer", "()Ljavax/swing/table/TableCellRenderer;", "valueOf", "item", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.profiler.common"})
    public static final class ValueColumn
    extends CalleesListColumn<CalleesListItem.Regular<BaseCallStackElement>, Percentage> {
        private final long maxValue;
        @NotNull
        private final TableCellRenderer renderer;

        public ValueColumn(@NotNull ValueMetric metric, long maxValue) {
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            super(metric, metric.getColumnTitle(), null);
            this.maxValue = maxValue;
            this.renderer = new CallUsageTableCellRenderer(metric, null, 2, null);
        }

        @Override
        @NotNull
        protected TableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nullable
        public Percentage valueOf(@Nullable CalleesListItem.Regular<BaseCallStackElement> item) {
            Percentage percentage;
            CalleesListItem.Regular<BaseCallStackElement> regular = item;
            if (regular != null) {
                CalleesListItem.Regular<BaseCallStackElement> it = regular;
                boolean bl = false;
                percentage = new Percentage((double)it.getTotalValue() / (double)this.maxValue, it.getTotalValue());
            } else {
                percentage = null;
            }
            return percentage;
        }

        @NotNull
        public TableCellRenderer getRenderer(@Nullable CalleesListItem.Regular<BaseCallStackElement> item) {
            return this.getRenderer();
        }

        @NotNull
        public Comparator<CalleesListItem.Regular<BaseCallStackElement>> getComparator() {
            return new Comparator(){

                public final int compare(T a, T b) {
                    CalleesListItem.Regular p0 = (CalleesListItem.Regular)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(p0.getTotalValue());
                    p0 = (CalleesListItem.Regular)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getTotalValue()));
                }
            };
        }
    }
}

