/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class SpacesInspector
extends UrlEditorInspector {
    @Override
    protected boolean canInspectInstanceOf(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            SpacesInspector.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public void runInspection(@NotNull UrlEditorInspector.Context context, @NotNull UrlEditorInspector.InspectionConsumer consumer) {
        if (context == null) {
            SpacesInspector.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            SpacesInspector.$$$reportNull$$$0(2);
        }
        UrlEditorModel model = context.getModel();
        String url = model.getUrl();
        Couple<Boolean> spaces = SpacesInspector.getLeadingTailing(url);
        if (((Boolean)spaces.first).booleanValue() || ((Boolean)spaces.second).booleanValue()) {
            String fieldName = "Url";
            SpacesInspector.appendWarning(fieldName, spaces, consumer);
        }
        for (String param : model.getParameterNames()) {
            String value = model.getParameter(param);
            if (StringUtil.isEmpty((String)value)) continue;
            Couple<Boolean> spaces2 = SpacesInspector.getLeadingTailing(value);
            if (!((Boolean)spaces2.first).booleanValue() && !((Boolean)spaces2.second).booleanValue()) continue;
            String fieldName = context.getFieldName(param);
            SpacesInspector.appendWarning(fieldName, spaces2, consumer);
        }
    }

    private static void appendWarning(@NlsSafe String fieldName, Couple<Boolean> spaces, @NotNull UrlEditorInspector.InspectionConsumer consumer) {
        if (consumer == null) {
            SpacesInspector.$$$reportNull$$$0(3);
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = fieldName;
        objectArray[1] = ((Boolean)spaces.first).booleanValue() ? (((Boolean)spaces.second).booleanValue() ? 0 : 1) : 2;
        consumer.warning(DatabaseBundle.message((String)"field.has.spaces", (Object[])objectArray), null, new Pair[0]);
    }

    @NotNull
    private static Couple<Boolean> getLeadingTailing(String s) {
        if (s.isEmpty()) {
            Couple couple = Couple.of((Object)false, (Object)false);
            if (couple == null) {
                SpacesInspector.$$$reportNull$$$0(4);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)Character.isWhitespace(s.codePointAt(0)), (Object)Character.isWhitespace(s.codePointBefore(s.length())));
        if (couple == null) {
            SpacesInspector.$$$reportNull$$$0(5);
        }
        return couple;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/SpacesInspector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/SpacesInspector";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadingTailing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canInspectInstanceOf";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendWarning";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

