/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.twkb;

import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;

class BoundsExtractor
implements CoordinateSequenceFilter {
    private final int dimensions;
    double[] ordinates = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};

    BoundsExtractor(int dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public void filter(CoordinateSequence seq, int coordIndex) {
        for (int ordinateIndex = 0; ordinateIndex < this.dimensions; ++ordinateIndex) {
            double ordinate = seq.getOrdinate(coordIndex, ordinateIndex);
            int minIndex = 2 * ordinateIndex;
            int maxIndex = minIndex + 1;
            this.ordinates[minIndex] = Math.min(this.ordinates[minIndex], ordinate);
            this.ordinates[maxIndex] = Math.max(this.ordinates[maxIndex], ordinate);
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isGeometryChanged() {
        return false;
    }
}

