/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.base.view.table;

import com.intellij.ui.table.TableView;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksColors;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeComponent;
import com.intellij.xdebugger.impl.parallelStacks.base.view.ParallelStacksNodeRealizer;
import com.intellij.xdebugger.impl.parallelStacks.base.view.UpdatableGraph2DView;
import com.intellij.xdebugger.impl.parallelStacks.base.view.table.ParallelStacksColumnInfo;
import com.intellij.xdebugger.impl.parallelStacks.base.view.table.ParallelStacksTableModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B)\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\u0015\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010%R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/base/view/table/ParallelStacksFrameTable;", "T", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeComponent;", "tableModel", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/table/ParallelStacksTableModel;", "realizer", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeRealizer;", "graphView", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "ParallelStacksFrameTable", "(Lcom/intellij/xdebugger/impl/parallelStacks/base/view/table/ParallelStacksTableModel;Lcom/intellij/xdebugger/impl/parallelStacks/base/view/ParallelStacksNodeRealizer;Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;)V", "getTableModel", "()Lcom/intellij/xdebugger/impl/parallelStacks/base/view/table/ParallelStacksTableModel;", "getGraphView", "()Lcom/intellij/xdebugger/impl/parallelStacks/base/view/UpdatableGraph2DView;", "rowUnderMouseIndex", "", "getRowUnderMouseIndex", "()I", "setRowUnderMouseIndex", "(I)V", "initialize", "", "getMaxNonCroppedCharacters", "mouseLeft", "mousePressExpired", "mousePressed", "point", "Ljava/awt/Point;", "mouseMoved", "mouseClicked", "isDoubleClick", "", "updateColumnSizes", "selectItem", "item", "(Ljava/lang/Object;)V", "intellij.platform.debugger.parallelStacks"})
public abstract class ParallelStacksFrameTable<T>
extends TableView<T>
implements ParallelStacksNodeComponent {
    @NotNull
    private final ParallelStacksTableModel<T> tableModel;
    @NotNull
    private final ParallelStacksNodeRealizer<?> realizer;
    @NotNull
    private final UpdatableGraph2DView graphView;
    private int rowUnderMouseIndex;

    public ParallelStacksFrameTable(@NotNull ParallelStacksTableModel<T> tableModel, @NotNull ParallelStacksNodeRealizer<?> realizer, @NotNull UpdatableGraph2DView graphView) {
        Intrinsics.checkNotNullParameter(tableModel, (String)"tableModel");
        Intrinsics.checkNotNullParameter(realizer, (String)"realizer");
        Intrinsics.checkNotNullParameter((Object)graphView, (String)"graphView");
        this.tableModel = tableModel;
        this.realizer = realizer;
        this.graphView = graphView;
        this.rowUnderMouseIndex = -1;
    }

    @NotNull
    protected final ParallelStacksTableModel<T> getTableModel() {
        return this.tableModel;
    }

    @NotNull
    public final UpdatableGraph2DView getGraphView() {
        return this.graphView;
    }

    public final int getRowUnderMouseIndex() {
        return this.rowUnderMouseIndex;
    }

    public final void setRowUnderMouseIndex(int n2) {
        this.rowUnderMouseIndex = n2;
    }

    public final void initialize() {
        this.selectionModel.setSelectionMode(0);
        this.setBackground((Color)ParallelStacksColors.INSTANCE.getNODE_BACKGROUND_COLOR());
        this.selectionBackground = (Color)ParallelStacksColors.INSTANCE.getITEM_SELECTED_COLOR();
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        this.setModelAndUpdateColumns(this.tableModel);
    }

    public final int getMaxNonCroppedCharacters() {
        return 50;
    }

    @Override
    public void mouseLeft() {
        this.rowUnderMouseIndex = -1;
        this.realizer.repaint((JComponent)((Object)this));
    }

    @Override
    public void mousePressExpired() {
        if (this.selectionModel.isSelectionEmpty()) {
            return;
        }
        this.clearSelection();
        this.realizer.repaint((JComponent)((Object)this));
    }

    @Override
    public void mousePressed(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int n2 = this.rowAtPoint(point);
        this.selectionModel.setSelectionInterval(n2, n2);
        this.realizer.repaint((JComponent)((Object)this));
    }

    @Override
    public void mouseMoved(@NotNull Point point) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.rowUnderMouseIndex = n2 = this.rowAtPoint(point);
        this.realizer.repaint((JComponent)((Object)this));
    }

    @Override
    public void mouseClicked(@NotNull Point point, boolean isDoubleClick) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!isDoubleClick) {
            return;
        }
        int n2 = this.rowAtPoint(point);
        Object object = this.getListTableModel().getItem(n2);
        if (object == null) {
            return;
        }
        Object object2 = object;
        this.selectItem(object2);
    }

    public void updateColumnSizes() {
        ParallelStacksTableModel<T> parallelStacksTableModel = this.tableModel;
        ParallelStacksTableModel<T> parallelStacksTableModel2 = parallelStacksTableModel instanceof ParallelStacksTableModel ? parallelStacksTableModel : null;
        if (parallelStacksTableModel2 == null) {
            return;
        }
        ParallelStacksTableModel<T> parallelStacksTableModel3 = parallelStacksTableModel2;
        ParallelStacksColumnInfo<T>[] parallelStacksColumnInfoArray = parallelStacksTableModel3.getColumns();
        int n2 = parallelStacksColumnInfoArray.length;
        for (int i10 = 0; i10 < n2; ++i10) {
            int n3 = parallelStacksColumnInfoArray[i10].getPreferredWidth(this);
            int n4 = parallelStacksColumnInfoArray[i10].getWidth((JTable)((Object)this));
            TableColumn tableColumn = this.getColumnModel().getColumn(i10);
            boolean bl2 = false;
            tableColumn.setPreferredWidth(n3);
            if (n4 <= 0) continue;
            tableColumn.setMaxWidth(n4);
        }
    }

    protected abstract void selectItem(T var1);
}

