/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.text.TreeRuleChecker;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0003\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkTextLevel", "", "file", "Lcom/intellij/psi/PsiFile;", "reportProblem", "problem", "Lcom/intellij/grazie/text/TextProblem;", "hasTooLowSeverity", "Grammar", "Style", "Companion", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1869#2,2:190\n1869#2,2:192\n1740#2,3:194\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection\n*L\n79#1:190,2\n84#1:192,2\n88#1:194,3\n*E\n"})
public final class GrazieInspection
extends LocalInspectionTool
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<LocalInspectionTool> inspections;
    private static final int MAX_TEXT_LENGTH_IN_PSI_ELEMENT = 50000;
    private static final int MAX_TEXT_LENGTH_IN_FILE = 200000;
    @NotNull
    public static final String GRAMMAR_INSPECTION = "GrazieInspection";
    @NotNull
    public static final String STYLE_INSPECTION = "GrazieStyle";
    @NotNull
    private static final Lazy<Boolean> hasSpellChecking$delegate;

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.grammar.inspection.grammar.text", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (Companion.ignoreGrammarChecking(file) || this.hasTooLowSeverity(session)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker(file);
        return new PsiElementVisitor(areChecksDisabled, checkedDomains, session, file, this, holder){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ Set<TextContent.TextDomain> $checkedDomains;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ GrazieInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$checkedDomains = $checkedDomains;
                this.$session = $session;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitWhiteSpace(PsiWhiteSpace space) {
                Intrinsics.checkNotNullParameter((Object)space, (String)"space");
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void $this$forEach$iv;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object it;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$checkedDomains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                if (GrazieInspection.Companion.skipCheckingTooLargeTexts(texts)) {
                    return;
                }
                Iterable $this$filter$iv = texts;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TextContent)element$iv$iv;
                    boolean bl = false;
                    if (!ProblemFilter.allIgnoringFilters((TextContent)it).findAny().isEmpty()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List filteredTexts = (List)destination$iv$iv;
                TextRange textRange = this.$session.getPriorityRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
                $this$filter$iv = GrazieInspection.Companion.sortByPriority(filteredTexts, textRange);
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (TextContent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new CheckerRunner((TextContent)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (CheckerRunner)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it, ((CheckerRunner)it).run()));
                }
                $this$map$iv = (List)destination$iv$iv;
                ProblemsHolder problemsHolder = this.$holder;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    CheckerRunner runner = (CheckerRunner)pair.component1();
                    List problems = (List)pair.component2();
                    Iterable $this$forEach$iv2 = problems;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        TextProblem problem = (TextProblem)element$iv2;
                        boolean bl2 = false;
                        Iterable $this$forEach$iv3 = runner.toProblemDescriptors(problem, problemsHolder.isOnTheFly());
                        boolean $i$f$forEach3 = false;
                        for (T element$iv3 : $this$forEach$iv3) {
                            ProblemDescriptor p0 = (ProblemDescriptor)element$iv3;
                            boolean bl3 = false;
                            problemsHolder.registerProblem(p0);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)element, (Object)this.$file)) {
                    GrazieInspection.access$checkTextLevel(this.this$0, this.$file, this.$holder);
                }
            }
        };
    }

    private final void checkTextLevel(PsiFile file, ProblemsHolder holder) {
        List<TreeRuleChecker.TreeProblem> list = TreeRuleChecker.checkTextLevelProblems(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"checkTextLevelProblems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeRuleChecker.TreeProblem it = (TreeRuleChecker.TreeProblem)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.reportProblem(it, holder);
        }
    }

    private final void reportProblem(TextProblem problem, ProblemsHolder holder) {
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        Iterable $this$forEach$iv = new CheckerRunner(textContent).toProblemDescriptors(problem, holder.isOnTheFly());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProblemDescriptor it = (ProblemDescriptor)element$iv;
            boolean bl = false;
            holder.registerProblem(it);
        }
    }

    private final boolean hasTooLowSeverity(LocalInspectionToolSession session) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = inspections;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LocalInspectionTool it = (LocalInspectionTool)element$iv;
                    boolean bl2 = false;
                    if (InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean hasSpellChecking_delegate$lambda$0() {
        boolean bl;
        try {
            Class.forName("com.intellij.spellchecker.ui.SpellCheckingEditorCustomization");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
        return Companion.skipCheckingTooLargeTexts(texts);
    }

    @JvmStatic
    public static final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
        return Companion.ignoreGrammarChecking(file);
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent.TextDomain> checkedDomains() {
        return Companion.checkedDomains();
    }

    @JvmStatic
    @NotNull
    public static final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
        return Companion.getDisabledChecker(file);
    }

    @JvmStatic
    @NotNull
    public static final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
        return Companion.sortByPriority(texts, priorityRange);
    }

    public static final /* synthetic */ void access$checkTextLevel(GrazieInspection $this, PsiFile file, ProblemsHolder holder) {
        $this.checkTextLevel(file, holder);
    }

    static {
        Object[] objectArray = new LocalInspectionTool[]{new Grammar(), new Style()};
        inspections = CollectionsKt.listOf((Object[])objectArray);
        hasSpellChecking$delegate = LazyKt.lazy(GrazieInspection::hasSpellChecking_delegate$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0005H\u0007J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J$\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010!\u001a\u00020\"H\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "<init>", "()V", "inspections", "", "Lcom/intellij/codeInspection/LocalInspectionTool;", "MAX_TEXT_LENGTH_IN_PSI_ELEMENT", "", "MAX_TEXT_LENGTH_IN_FILE", "GRAMMAR_INSPECTION", "", "STYLE_INSPECTION", "hasSpellChecking", "", "getHasSpellChecking", "()Z", "hasSpellChecking$delegate", "Lkotlin/Lazy;", "skipCheckingTooLargeTexts", "texts", "Lcom/intellij/grazie/text/TextContent;", "ignoreGrammarChecking", "file", "Lcom/intellij/psi/PsiFile;", "isSpellCheckingDisabled", "checkedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "sortByPriority", "priorityRange", "Lcom/intellij/openapi/util/TextRange;", "TextContentRelatedData", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1#2:190\n1056#3:191\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n*L\n167#1:191\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getHasSpellChecking() {
            Lazy lazy = hasSpellChecking$delegate;
            return (Boolean)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
            int n;
            int n2;
            Object object2;
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            if (texts.isEmpty()) {
                return false;
            }
            Iterable iterable = texts;
            int n3 = 0;
            for (Object object2 : iterable) {
                void it;
                TextContent textContent = (TextContent)object2;
                n2 = n3;
                boolean bl = false;
                n = it.length();
                n3 = n2 + n;
            }
            if (n3 > 50000) {
                return true;
            }
            PsiFile psiFile = texts.get(0).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            if (file.getTextLength() <= 200000) {
                return false;
            }
            Set<TextContent> allInFile = ((TextContentRelatedData)CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$2(arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$1(file, arg_0), arg_0))).getContents();
            Set<TextContent.TextDomain> checkedDomains = this.checkedDomains();
            object2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allInFile), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$3(checkedDomains, arg_0));
            int n4 = 0;
            for (Object e : object2) {
                void it;
                TextContent textContent = (TextContent)e;
                n2 = n4;
                boolean bl = false;
                n = it.length();
                n4 = n2 + n;
            }
            return n4 > 200000;
        }

        @JvmStatic
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getHasSpellChecking() && this.isSpellCheckingDisabled(file);
        }

        private final boolean isSpellCheckingDisabled(PsiFile file) {
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file);
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            EnumSet<Enum> result = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result.add(TextContent.TextDomain.LITERALS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInCommentsEnabled()) {
                result.add(TextContent.TextDomain.COMMENTS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInDocumentationEnabled()) {
                result.add(TextContent.TextDomain.DOCUMENTATION);
            }
            Intrinsics.checkNotNull(result);
            return result;
        }

        @JvmStatic
        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return arg_0 -> Companion.getDisabledChecker$lambda$0(fileLanguage, supportedLanguages, disabledLanguages, arg_0);
        }

        @JvmStatic
        @NotNull
        public final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)priorityRange, (String)"priorityRange");
            Iterable $this$sortedBy$iv = texts;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(priorityRange){
                final /* synthetic */ TextRange $priorityRange$inlined;
                {
                    this.$priorityRange$inlined = textRange;
                }

                public final int compare(T a, T b) {
                    TextContent text = (TextContent)a;
                    boolean bl = false;
                    TextRange textRange = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                    TextRange textRangeInFile = textRange;
                    text = (TextContent)b;
                    Comparable comparable = Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2));
                    bl = false;
                    TextRange textRange2 = text.textRangeToFile(new TextRange(0, text.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRangeToFile(...)");
                    textRangeInFile = textRange2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2)));
                }
            });
        }

        private static final TextContentRelatedData skipCheckingTooLargeTexts$lambda$1(PsiFile $file, PsiFile it) {
            Set<TextContent> contents = TextExtractor.findAllTextContents(it.getViewProvider(), TextContent.TextDomain.ALL);
            Intrinsics.checkNotNull(contents);
            return new TextContentRelatedData($file, contents);
        }

        private static final TextContentRelatedData skipCheckingTooLargeTexts$lambda$2(Function1 $tmp0, Object p0) {
            return (TextContentRelatedData)$tmp0.invoke(p0);
        }

        private static final boolean skipCheckingTooLargeTexts$lambda$3(Set $checkedDomains, TextContent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $checkedDomains.contains((Object)it.getDomain());
        }

        private static final boolean getDisabledChecker$lambda$0(Language $fileLanguage, Set $supportedLanguages, Set $disabledLanguages, PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Language lang = element.getLanguage();
            if ($fileLanguage.isKindOf(lang)) {
                lang = $fileLanguage;
            }
            while (lang != null && !$supportedLanguages.contains(lang)) {
                lang = lang.getBaseLanguage();
            }
            return lang != null && $disabledLanguages.contains(lang.getID());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "contents", "", "Lcom/intellij/grazie/text/TextContent;", "<init>", "(Lcom/intellij/psi/PsiFile;Ljava/util/Set;)V", "getContents", "()Ljava/util/Set;", "toString", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "intellij.grazie.core"})
        @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1563#2:190\n1634#2,3:191\n1563#2:194\n1634#2,3:195\n1563#2:198\n1634#2,3:199\n1563#2:202\n1634#2,3:203\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion$TextContentRelatedData\n*L\n181#1:190\n181#1:191,3\n182#1:194\n182#1:195,3\n182#1:198\n182#1:199,3\n184#1:202\n184#1:203,3\n*E\n"})
        public static final class TextContentRelatedData {
            @NotNull
            private final PsiFile psiFile;
            @NotNull
            private final Set<TextContent> contents;

            public TextContentRelatedData(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                this.psiFile = psiFile;
                this.contents = contents;
            }

            @NotNull
            public final Set<TextContent> getContents() {
                return this.contents;
            }

            @NotNull
            public String toString() {
                Collection<Language> collection;
                TextContent it;
                Collection collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                FileType fileType = this.psiFile.getViewProvider().getVirtualFile().getFileType();
                Language language = this.psiFile.getLanguage();
                List list = this.psiFile.getViewProvider().getAllFiles();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllFiles(...)");
                Iterable iterable = list;
                Language language2 = language;
                FileType fileType2 = fileType;
                boolean $i$f$map = false;
                void var3_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PsiFile psiFile = (PsiFile)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getLanguage());
                }
                collection2 = (List)destination$iv$iv;
                $this$map$iv = this.contents;
                collection2 = CollectionsKt.toSet((Iterable)collection2);
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (TextContent)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((Language)it.getCommonParent());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (PsiElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getLanguage());
                }
                collection = (List)destination$iv$iv;
                return "[fileType = " + fileType2 + ", fileLanguage = " + language2 + ", viewProviderLanguages = " + (Set)collection2 + ", parentLanguages = " + CollectionsKt.toSet((Iterable)collection) + ",";
            }

            private final PsiFile component1() {
                return this.psiFile;
            }

            @NotNull
            public final Set<TextContent> component2() {
                return this.contents;
            }

            @NotNull
            public final TextContentRelatedData copy(@NotNull PsiFile psiFile, @NotNull Set<? extends TextContent> contents) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                Intrinsics.checkNotNullParameter(contents, (String)"contents");
                return new TextContentRelatedData(psiFile, contents);
            }

            public static /* synthetic */ TextContentRelatedData copy$default(TextContentRelatedData textContentRelatedData, PsiFile psiFile, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    psiFile = textContentRelatedData.psiFile;
                }
                if ((n & 2) != 0) {
                    set = textContentRelatedData.contents;
                }
                return textContentRelatedData.copy(psiFile, set);
            }

            public int hashCode() {
                int result = this.psiFile.hashCode();
                result = result * 31 + ((Object)this.contents).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof TextContentRelatedData)) {
                    return false;
                }
                TextContentRelatedData textContentRelatedData = (TextContentRelatedData)other;
                if (!Intrinsics.areEqual((Object)this.psiFile, (Object)textContentRelatedData.psiFile)) {
                    return false;
                }
                return Intrinsics.areEqual(this.contents, textContentRelatedData.contents);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Grammar;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getShortName", "", "Lorg/jetbrains/annotations/NonNls;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.grazie.core"})
    public static final class Grammar
    extends LocalInspectionTool
    implements DumbAware {
        @NotNull
        public String getShortName() {
            return GrazieInspection.GRAMMAR_INSPECTION;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Style;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getShortName", "", "Lorg/jetbrains/annotations/NonNls;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.grazie.core"})
    public static final class Style
    extends LocalInspectionTool
    implements DumbAware {
        @NotNull
        public String getShortName() {
            return GrazieInspection.STYLE_INSPECTION;
        }

        @NotNull
        public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
    }
}

