/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSshPanelUtil;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.HostPort;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final Disposable myParent;
    private JPanel myPanel;
    private JCheckBox myUseSshCheckBox;
    private SshConfigComboBox mySshConfigComboBox;
    private FixedSizeButton myCopyButton;
    private JBLabel myErrorLabel;
    private JBTextField myLocalPortField;
    private JPanel mySettingsPanel;
    private JLabel mySshConfigLabel;

    public DataSourceSshPanel(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Disposable parent2) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            DataSourceSshPanel.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            DataSourceSshPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource;
        this.myParent = parent2;
        this.$$$setupUI$$$();
        this.myCopyButton.setIcon(AllIcons.Actions.Copy);
        this.myCopyButton.addActionListener(e -> this.duplicateSshConfig());
        this.myCopyButton.setFocusable(true);
        this.reset(this.myDataSource);
        this.myUseSshCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshPanel.this.updateSshPanel();
            }
        });
        this.updateSshPanel();
        this.myErrorLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        this.mySshConfigLabel.setLabelFor(this.mySshConfigComboBox.getComboBox());
    }

    private void duplicateSshConfig() {
        this.mySshConfigComboBox.edit(true);
    }

    private void updateSshPanel() {
        UIUtil.setEnabled((Component)this.mySettingsPanel, (boolean)this.myUseSshCheckBox.isSelected(), (boolean)true);
    }

    @Nullable
    protected HostPort getActualHostPort() {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        String url = this.myDataSource.getUrl();
        return driver == null || url == null ? null : JdbcUrlParserUtil.extractFirstHostPort((Collection)driver.getJDBCUrlParsers(), (String)url, null);
    }

    public void updateInfoLabel() {
        HostPort hostPort = this.getActualHostPort();
        if (hostPort == null) {
            String message = DatabaseBundle.message((String)"DataSourceSshPanel.unable.to.find.host.port", (Object[])new Object[0]);
            this.myUseSshCheckBox.setToolTipText(message);
            this.myErrorLabel.setText(message);
            this.myErrorLabel.setVisible(true);
        } else {
            this.myUseSshCheckBox.setToolTipText(DatabaseBundle.message((String)"DataSourceSshPanel.remote.host.is", (Object[])new Object[]{hostPort.toString(true)}));
            this.myErrorLabel.setVisible(false);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.updateLocalPortFromSshConfig(hostPort));
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataSourceSshPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration createSshConfig() {
        @Nullable SshConfig sshConfig = this.mySshConfigComboBox.getSelectedSshConfig();
        if (sshConfig == null && !this.myUseSshCheckBox.isSelected()) {
            return null;
        }
        return new DataSourceSshTunnelConfiguration(this.myUseSshCheckBox.isSelected(), sshConfig == null ? "" : sshConfig.getId(), StringUtil.parseInt((String)this.myLocalPortField.getText(), (int)-1));
    }

    @Nullable
    public SshUiData getUiData() {
        if (!this.myUseSshCheckBox.isSelected()) {
            return null;
        }
        Pair uiDataAndName = this.mySshConfigComboBox.getSelectedUiDataAndName();
        return uiDataAndName == null ? null : (SshUiData)uiDataAndName.first;
    }

    private void setupFromSshCfg(@Nullable DataSourceSshTunnelConfiguration c2) {
        this.myUseSshCheckBox.setSelected(c2 != null && c2.isEnabled());
        this.mySshConfigComboBox.reload(c2 == null || c2.getSshConfigId().isEmpty() ? null : PresentableId.createId((String)c2.getSshConfigId(), null), SshConfigVisibility.App);
        this.myLocalPortField.setText(c2 == null || c2.getLocalPort() == -1 ? "" : String.valueOf(c2.getLocalPort()));
    }

    private void createUIComponents() {
        this.mySshConfigComboBox = new SshConfigComboBox(this.myProject, this.myParent, SshConfigVisibility.App);
    }

    public void copyFrom(LocalDataSource actualDataSource) {
        this.myUseSshCheckBox.setSelected(true);
        this.setupFromSshCfg(actualDataSource.getSshConfiguration());
        this.updateSshPanel();
    }

    public JCheckBox getUseSshCheckBox() {
        return this.myUseSshCheckBox;
    }

    @NotNull
    static LinkLabel<?> createLabel(final @NotNull Project project, final @NotNull Condition<LocalDataSource> condition, final @NotNull Consumer<? super LocalDataSource> processor, final @Nls @NotNull String emptyText) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(4);
        }
        if (condition == null) {
            DataSourceSshPanel.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DataSourceSshPanel.$$$reportNull$$$0(6);
        }
        if (emptyText == null) {
            DataSourceSshPanel.$$$reportNull$$$0(7);
        }
        return new LinkLabel(DatabaseBundle.message((String)"ssl.copy.from", (Object[])new Object[0]), null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel<Void> src, Void data) {
                List<LocalDataSource> sources = DataSourceSshPanel.findAvailableDataSources(project, (Condition<LocalDataSource>)condition);
                if (sources.isEmpty()) {
                    JBPopupFactory.getInstance().createPopupChooserBuilder(Collections.singletonList(emptyText)).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(dom -> {
                        JBLabel label = new JBLabel(dom, null, 2);
                        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                        return label;
                    })).setRequestFocus(true).createPopup().showUnderneathOf(src);
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(sources).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(o -> {
                    JBLabel label = new JBLabel(o.getName(), o.getBaseIcon(), 2);
                    label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                    return label;
                })).setRequestFocus(true).setItemChosenCallback(source -> {
                    if (source == null) {
                        return;
                    }
                    processor.consume(source);
                }).createPopup().showUnderneathOf(src);
            }
        });
    }

    @NotNull
    private static List<LocalDataSource> findAvailableDataSources(Project project, Condition<LocalDataSource> condition) {
        List dataSources = DbPsiFacade.getInstance((Project)project).getDataSources();
        List list = JBIterable.from((Iterable)dataSources).map(DbElement::getDelegate).filter(LocalDataSource.class).filter(condition).sort(Comparator.comparing(AbstractDataSource::getName)).toList();
        if (list == null) {
            DataSourceSshPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void reset(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(9);
        }
        this.setupFromSshCfg(ds.getSshConfiguration());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean enforceCredentials) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(10);
        }
        DataSourceSshTunnelConfiguration newSsh = this.createSshConfig();
        if (enforceCredentials && newSsh != null) {
            newSsh.enforceCredentials(this.myProject);
        }
        ds.setSshConfiguration(newSsh);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void updateLocalPortFromSshConfig(@Nullable HostPort hostPort) {
        OpenSshConfigForwardInfo forwarding = this.getMatchingForwarding(hostPort);
        this.myLocalPortField.getEmptyText().setText(forwarding == null ? SshBundle.message((String)"ssh.editor.local.port.placeholder.dynamic", (Object[])new Object[0]) : String.valueOf(forwarding.getBindPort()));
    }

    @Nullable
    private OpenSshConfigForwardInfo getMatchingForwarding(@Nullable HostPort hostPort) {
        if (hostPort == null) {
            return null;
        }
        SshConfig sshConf = this.mySshConfigComboBox.getSelectedSshConfig();
        if (sshConf == null || sshConf.getAuthType() != AuthType.OPEN_SSH) {
            return null;
        }
        int port = StringUtil.parseInt((String)hostPort.getPort(), (int)-1);
        if (port == -1) {
            return null;
        }
        SshConnectionConfig openSsh = DataSourceSshPanelUtil.getSshConfigWithModalProgress(this.myProject, sshConf.getHost());
        if (openSsh != null) {
            for (OpenSshConfigForwardInfo info2 : openSsh.getInitialLocalTcpForwardings()) {
                if (!info2.getHost().equals(hostPort.getHost()) || info2.getPort() != port) continue;
                return info2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        FixedSizeButton fixedSizeButton;
        JBTextField jBTextField;
        JPanel jPanel;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseSshCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(10);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshPanel.class).getString("ssh.panel.use.ssh.tunnel"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, new Dimension(136, 22), null, 0, true));
        this.myErrorLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/SshBundle", DataSourceSshPanel.class).getString("ssh.editor.local.port.label"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalPortField = jBTextField = new JBTextField();
        jBTextField.setColumns(10);
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        SshConfigComboBox sshConfigComboBox = this.mySshConfigComboBox;
        jPanel.add((Component)sshConfigComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCopyButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshPanel.class).getString("button.copy.tooltip"));
        jPanel.add((Component)fixedSizeButton, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null));
        this.mySshConfigLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshPanel.class).getString("ssh.config"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

