/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.ColumnModelModification;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.documentation.DataGridDocumentationUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TriConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigateAction
extends DumbAwareAction
implements GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            NavigateAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @NotNull
    protected EnumSet<DataGridDocumentationUtil.KeyType> getKeyTypes() {
        EnumSet<DataGridDocumentationUtil.KeyType> enumSet = EnumSet.of(DataGridDocumentationUtil.KeyType.FOREIGN, DataGridDocumentationUtil.KeyType.EXPORTED);
        if (enumSet == null) {
            NavigateAction.$$$reportNull$$$0(1);
        }
        return enumSet;
    }

    private static List<DataGridDocumentationUtil.QueryInfo> getQueries(@NotNull DasDataSource dataSource, @NotNull DataGrid dataGrid, @NotNull ModelIndexSet<GridRow> selectedRows, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> types) {
        if (dataSource == null) {
            NavigateAction.$$$reportNull$$$0(2);
        }
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(3);
        }
        if (selectedRows == null) {
            NavigateAction.$$$reportNull$$$0(4);
        }
        if (types == null) {
            NavigateAction.$$$reportNull$$$0(5);
        }
        return DataGridDocumentationUtil.buildQueries(dataSource, dataGrid, selectedRows, types);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(6);
        }
        if (e.getInputEvent() instanceof MouseEvent && (e.getInputEvent().getModifiersEx() & (ClientSystemInfo.isMac() ? 256 : 128)) != 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)dataGrid);
        if (project == null || dataGrid == null || dataSource == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set navigatableColumns = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)dataGrid, NavigateAction.getCacheValueProvider(dataGrid, project));
        if (navigatableColumns == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ModelIndexSet selectedColumnsIdx = dataGrid.getSelectionModel().getSelectedColumns();
        List selectedColumns = dataGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(selectedColumnsIdx);
        boolean enabled = ContainerUtil.exists((Iterable)selectedColumns, column -> navigatableColumns.contains(column.getName()));
        boolean visible = enabled || !e.getPlace().equals("TableFloatingToolbar");
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    private static Set<String> computeNavigatableColumns(@NotNull Project project, @NotNull DasTable table) {
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(7);
        }
        if (table == null) {
            NavigateAction.$$$reportNull$$$0(8);
        }
        JBIterable exportedKeys = ModelRelationManager.getExportedKeys((Project)project, (DasTable)table);
        JBIterable foreignKeys = ModelRelationManager.getForeignKeys((Project)project, (DasTable)table);
        HashSet<String> columns = new HashSet<String>();
        exportedKeys.forEach(key -> {
            DasTable keyTable = key.getTable();
            if (keyTable == null) {
                return;
            }
            key.getRefColumns().names().forEach(columns::add);
        });
        foreignKeys.forEach(key -> {
            DasTable keyTable = key.getRefTable();
            if (keyTable == null) {
                return;
            }
            key.getColumnsRef().names().forEach(columns::add);
        });
        HashSet<String> hashSet = columns;
        if (hashSet == null) {
            NavigateAction.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            NavigateAction.$$$reportNull$$$0(10);
        }
        Project project = e.getProject();
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DbDataSource dataSource = DataGridUtilCore.getDatabaseSystem((CoreGrid)dataGrid);
        if (dataGrid == null || dataSource == null || project == null) {
            return;
        }
        ModelIndexSet selectedRows = dataGrid.getSelectionModel().getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        for (ModelIndex selectedRow : selectedRows.asList()) {
            if (selectedRow.isValid((CoreGrid)dataGrid)) continue;
            return;
        }
        List<OpenDataFileDescriptor> descriptors = NavigateAction.convertDescriptors(project, NavigateAction.createDescriptorData(dataGrid, (DasDataSource)dataSource, this.getKeyTypes()));
        if (descriptors.size() == 1) {
            descriptors.get(0).navigate(true);
            return;
        }
        BaseListPopupStep<OpenDataFileDescriptor> step2 = NavigateAction.createStep(descriptors, this.getKeyTypes());
        ColoredListCellRenderer<OpenDataFileDescriptor> wrapper = NavigateAction.createRenderer(descriptors);
        ListPopupImpl popup2 = new ListPopupImpl(this, project, (ListPopupStep)step2, (ColoredListCellRenderer)wrapper, descriptors){
            final /* synthetic */ ColoredListCellRenderer val$wrapper;
            final /* synthetic */ List val$descriptors;
            {
                this.val$wrapper = coloredListCellRenderer;
                this.val$descriptors = list;
                super(arg0, arg1);
            }

            protected ListCellRenderer getListElementRenderer() {
                return new PopupListElementRenderer<OpenDataFileDescriptor>((ListPopupImpl)this){

                    protected JComponent createItemComponent() {
                        this.myTextLabel = new ErrorLabel();
                        return val$wrapper;
                    }

                    protected void customizeComponent(JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value, boolean isSelected) {
                        val$wrapper.getListCellRendererComponent(list, (Object)value, val$descriptors.indexOf((Object)value), isSelected, true);
                    }
                };
            }
        };
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("QuickJavaDoc"));
        if (!descriptors.isEmpty() && StringUtil.isNotEmpty((String)shortcutText)) {
            popup2.setAdText(DatabaseBundle.message((String)"popup.advertisement.use.in.table", (Object[])new Object[]{shortcutText}));
        }
        popup2.showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public static List<OpenDataFileDescriptor> convertDescriptors(@NotNull Project project, @NotNull List<DescriptorData> descriptorData) {
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(11);
        }
        if (descriptorData == null) {
            NavigateAction.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.map(descriptorData, data -> new OpenDataFileDescriptor(project, data.file, data.columnNames, data.description, data.values, data.condition));
        if (list == null) {
            NavigateAction.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static ColoredListCellRenderer<OpenDataFileDescriptor> createRenderer(List<OpenDataFileDescriptor> descriptors) {
        HashSet<DbElement> elements = new HashSet<DbElement>(ContainerUtil.filter((Collection)ContainerUtil.map(descriptors, descriptor2 -> DbImplUtilCore.findElement((Project)descriptor2.getProject(), (VirtualFile)descriptor2.getFile())), el -> el != null));
        final Map<DbElement, @NlsSafe String> uniqueTableNames = NavigateAction.calcUniqueTableNames(elements);
        return new ColoredListCellRenderer<OpenDataFileDescriptor>(){

            protected void customizeCellRenderer(@NotNull JList<? extends OpenDataFileDescriptor> list, OpenDataFileDescriptor value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.clear();
                this.setIcon(DatabaseIcons.Table);
                DbElement element = DbImplUtilCore.findElement((Project)value.getProject(), (VirtualFile)value.getFile());
                String uniqueName = (String)ObjectUtils.notNull((Object)((String)uniqueTableNames.get(element)), (Object)value.getFile().getName());
                this.append(uniqueName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.append(value.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/run/actions/NavigateAction$2", "customizeCellRenderer"));
            }
        };
    }

    @NotNull
    public static BaseListPopupStep<OpenDataFileDescriptor> createStep(List<OpenDataFileDescriptor> descriptors, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> keyTypes) {
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(14);
        }
        String popupTitle = DatabaseBundle.message((String)"popup.title.choose.target", (Object[])new Object[0]);
        BaseListPopupStep<OpenDataFileDescriptor> step2 = new BaseListPopupStep<OpenDataFileDescriptor>(popupTitle, descriptors){

            public PopupStep<?> onChosen(OpenDataFileDescriptor selectedValue, boolean finalChoice) {
                selectedValue.navigate(true);
                return FINAL_CHOICE;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            @NotNull
            public String getTextFor(OpenDataFileDescriptor value) {
                String string = value.getFile().getName() + ": " + value.getDescription();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$3", "getTextFor"));
            }
        };
        step2.setDefaultOptionIndex(0);
        BaseListPopupStep<OpenDataFileDescriptor> baseListPopupStep = step2;
        if (baseListPopupStep == null) {
            NavigateAction.$$$reportNull$$$0(15);
        }
        return baseListPopupStep;
    }

    public static @NotNull Map<DbElement, @NlsSafe String> calcUniqueTableNames(@NotNull Set<DbElement> elements) {
        if (elements == null) {
            NavigateAction.$$$reportNull$$$0(16);
        }
        Map nameToTables = CollectionFactory.createCaseInsensitiveStringMap();
        for (DbElement element : elements) {
            nameToTables.computeIfAbsent(element.getName(), e -> new HashSet()).add(element);
        }
        HashMap<DbElement, String> map2 = new HashMap<DbElement, String>();
        for (DbElement element : elements) {
            Set elementsWithSameName = (Set)nameToTables.get(element.getName());
            if (elementsWithSameName == null || elementsWithSameName.size() == 1) {
                map2.put(element, element.getName());
                continue;
            }
            DbElement parent2 = element.getParent();
            map2.put(element, (String)(parent2 == null ? "" : parent2.getName() + ".") + element.getName());
        }
        HashMap<DbElement, String> hashMap = map2;
        if (hashMap == null) {
            NavigateAction.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @NotNull
    public static List<DescriptorData> createDescriptorData(@NotNull DataGrid dataGrid, @NotNull DasDataSource dataSource, @NotNull EnumSet<DataGridDocumentationUtil.KeyType> keyTypes) {
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(18);
        }
        if (dataSource == null) {
            NavigateAction.$$$reportNull$$$0(19);
        }
        if (keyTypes == null) {
            NavigateAction.$$$reportNull$$$0(20);
        }
        ModelIndexSet selectedRows = dataGrid.getSelectionModel().getSelectedRows();
        ArrayList<DescriptorData> descriptorData = new ArrayList<DescriptorData>();
        List<DataGridDocumentationUtil.QueryInfo> queries = NavigateAction.getQueries(dataSource, dataGrid, (ModelIndexSet<GridRow>)selectedRows, keyTypes);
        BehaviorType mode = BehaviorType.getSelectedType();
        for (DataGridDocumentationUtil.QueryInfo info2 : queries) {
            String path = DatabaseElementVirtualFileImpl.getPath((DasDataSource)dataSource, (DasObject)info2.table, (boolean)false);
            VirtualFile file = DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
            if (file == null) continue;
            List<String[]> formattedValuesLists = DataGridUtil.formatValues(dataGrid, info2.sourceColumns, info2.values);
            DescriptorData descriptor2 = switch (mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new DescriptorData(file, null, null, info2.keysAndColumns, (TriConsumer<DdlBuilder, List<DasColumn>, Dbms>)DbImplUtil.defaultWhereCondition((String[])info2.targetColumnNames, formattedValuesLists, (Version)dataSource.getVersion()));
                case 1 -> new DescriptorData(file, info2.targetColumnNames, info2.values, info2.keysAndColumns, null);
            };
            descriptorData.add(descriptor2);
        }
        ArrayList<DescriptorData> arrayList = descriptorData;
        if (arrayList == null) {
            NavigateAction.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static CachedValueProvider<Set<String>> getCacheValueProvider(@NotNull DataGrid dataGrid, @NotNull Project project) {
        if (dataGrid == null) {
            NavigateAction.$$$reportNull$$$0(22);
        }
        if (project == null) {
            NavigateAction.$$$reportNull$$$0(23);
        }
        DbPsiFacade psiFacade = DbPsiFacade.getInstance((Project)project);
        return () -> {
            ModificationTracker columnModificationTracker;
            DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)dataGrid);
            if (dataGrid instanceof ColumnModelModification) {
                ColumnModelModification cmm = (ColumnModelModification)dataGrid;
                v0 = cmm.getColumnModelModificationTracker();
            } else {
                v0 = columnModificationTracker = ModificationTracker.NEVER_CHANGED;
            }
            if (!(table instanceof DasTable)) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{psiFacade, columnModificationTracker});
            }
            DasTable dasTable = (DasTable)table;
            return CachedValueProvider.Result.create(NavigateAction.computeNavigatableColumns(project, dasTable), (Object[])new Object[]{psiFacade, columnModificationTracker});
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 16, 18, 19, 20, 22, 23 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRows";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorData";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/NavigateAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNavigatableColumns";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createStep";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUniqueTableNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptorData";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatableColumns";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convertDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createStep";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calcUniqueTableNames";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorData";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCacheValueProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 16, 18, 19, 20, 22, 23 -> new IllegalArgumentException(string);
        };
    }

    public static enum BehaviorType {
        NAVIGATE_AND_FILTER_ALL{

            public String toString() {
                return DataGridBundle.message((String)"advanced.setting.database.grid.navigate.to.related.rows.behavior.navigate.filter", (Object[])new Object[0]);
            }
        }
        ,
        NAVIGATE_AND_SELECT_FIRST{

            public String toString() {
                return DataGridBundle.message((String)"advanced.setting.database.grid.navigate.to.related.rows.behavior.navigate.select", (Object[])new Object[0]);
            }
        };

        private static final String ID = "database.grid.navigate.to.related.rows.behavior";

        public static void setSelectedType(BehaviorType type) {
            AdvancedSettings.setEnum((String)ID, (Enum)type);
        }

        @NotNull
        public static BehaviorType getSelectedType() {
            BehaviorType behaviorType = (BehaviorType)AdvancedSettings.getEnum((String)ID, BehaviorType.class);
            if (behaviorType == null) {
                BehaviorType.$$$reportNull$$$0(0);
            }
            return behaviorType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/NavigateAction$BehaviorType", "getSelectedType"));
        }
    }

    public static class DescriptorData {
        public final VirtualFile file;
        public final String[] columnNames;
        public final List<Object[]> values;
        public final @NlsActions.ActionDescription String description;
        public final TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition;

        public DescriptorData(@NotNull VirtualFile file, String @Nullable [] names, List<Object @Nullable []> values, @NlsActions.ActionDescription @Nullable String description, @Nullable TriConsumer<DdlBuilder, List<DasColumn>, Dbms> condition) {
            if (file == null) {
                DescriptorData.$$$reportNull$$$0(0);
            }
            this.file = file;
            this.columnNames = names;
            this.values = values;
            this.description = description;
            this.condition = condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/actions/NavigateAction$DescriptorData", "<init>"));
        }
    }
}

