/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.layout.NodeLabelModel;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.SmartNodeLabelModel;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.uml.undo.UmlUndoableAction;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DiagramMeasureCentralityUndoableAction
extends BasicUndoableAction {
    @NotNull
    public static final Key<Map<DiagramNode<?>, Double>> CURRENT_CENTRALITY_VALUES_KEY = Key.create((String)"com.intellij.uml.core.actions.analysis.DiagramMeasureCentralityUndoableAction.CURRENT_CENTRALITY_VALUES_KEY");
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final Map<DiagramNode<?>, Double> myCentralities;
    private final boolean myIsEnableFirst;

    DiagramMeasureCentralityUndoableAction(@NotNull DiagramBuilder builder, @NotNull Map<DiagramNode<?>, Double> centralities, boolean isEnableFirst) {
        if (builder == null) {
            DiagramMeasureCentralityUndoableAction.$$$reportNull$$$0(0);
        }
        if (centralities == null) {
            DiagramMeasureCentralityUndoableAction.$$$reportNull$$$0(1);
        }
        super(UmlUndoableAction.getAffectedDocuments(builder, new PsiFile[0]));
        this.myBuilder = builder;
        this.myCentralities = centralities;
        this.myIsEnableFirst = isEnableFirst;
    }

    public void undo() {
        if (this.myIsEnableFirst) {
            this.dropCentralityValues();
        } else {
            this.applyCentralityValues();
        }
    }

    public void redo() {
        if (this.myIsEnableFirst) {
            this.applyCentralityValues();
        } else {
            this.dropCentralityValues();
        }
    }

    public void applyCentralityValues() {
        DiagramColorManager colorManager = this.myBuilder.getProvider().getColorManager();
        for (DiagramNode<?> diagramNode : this.myBuilder.getNodeObjects()) {
            Double centrality = this.myCentralities.get(diagramNode);
            if (centrality == null) continue;
            NodeLabel label = this.createNodeLabel(colorManager, String.format("%.2f", centrality));
            label.setFontSize((int)Math.round((double)UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.MINI) * (1.0 + centrality)));
            diagramNode.getLabels().clear();
            diagramNode.getLabels().add(label);
            DiagramSelectionService.getInstance().setPermanentHighlighting(this.myBuilder, diagramNode, ColorUtil.tuneSaturationEspeciallyGrey((Color)colorManager.getHighlightedNodeBorderColor(this.myBuilder, diagramNode), (int)1, (float)centrality.floatValue()));
        }
        this.myBuilder.putUserData(CURRENT_CENTRALITY_VALUES_KEY, this.myCentralities);
        this.myBuilder.queryUpdate().withPresentationUpdate().run();
    }

    @NotNull
    private NodeLabel createNodeLabel(@NotNull DiagramColorManager colorManager, @NotNull String text) {
        if (colorManager == null) {
            DiagramMeasureCentralityUndoableAction.$$$reportNull$$$0(2);
        }
        if (text == null) {
            DiagramMeasureCentralityUndoableAction.$$$reportNull$$$0(3);
        }
        NodeLabel label = GraphManager.getGraphManager().createNodeLabel(text);
        SmartNodeLabelModel model = GraphManager.getGraphManager().createSmartNodeLabelModel();
        label.setLabelModel((NodeLabelModel)model, model.createDiscreteModelParameter(SmartNodeLabelModel.POSITION_NORTH_EAST));
        label.setFont(colorManager.getNodeLabelFont(this.myBuilder));
        label.setTextColor(this.myBuilder.getColorScheme().getDefaultForeground());
        NodeLabel nodeLabel = label;
        if (nodeLabel == null) {
            DiagramMeasureCentralityUndoableAction.$$$reportNull$$$0(4);
        }
        return nodeLabel;
    }

    public void dropCentralityValues() {
        for (DiagramNode<?> diagramNode : this.myBuilder.getNodeObjects()) {
            diagramNode.getLabels().clear();
            DiagramSelectionService.getInstance().setPermanentHighlighting(this.myBuilder, diagramNode, null);
        }
        this.myBuilder.putUserData(CURRENT_CENTRALITY_VALUES_KEY, null);
        this.myBuilder.queryUpdate().withPresentationUpdate().run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "centralities";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/actions/analysis/DiagramMeasureCentralityUndoableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/actions/analysis/DiagramMeasureCentralityUndoableAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNodeLabel";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

