create table Author 
(
	Id	int		not null	primary key,
	F_Name	varchar(40)	not null,
	L_Name	varchar(40)	not null,
	constraint Author_Name_is_Unique
		unique (F_Name, L_Name)
);


create table Book 
(
	Id	int		not null	primary key,
	Title	varchar(160)	not null,
	Yr	decimal(4)	check (Yr between -1000 and 2099)
);


create table Book_Author
(
	Book_Id	int		not null,
	Auth_Id	int		not null,
	constraint Book_Author_pk
		primary key (Book_Id, Auth_Id),
	constraint Book_Author_Book_fk
		foreign key (Book_Id)
			references Book (Id)
			on update cascade
			on delete cascade, 
	constraint Book_Author_Auth_fk
		foreign key (Auth_Id)
			references Author (Id)
			on update cascade
			on delete cascade 
);


create view Book_Info
as
select B.*,
       count (distinct C.Auth_Id) as Authors_Count
from Book B,
     Book_Author C
where B.Id = C.Book_Id;
