/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BaseGraphMouseWheelListener
implements MouseWheelListener {
    private static final int PROCESSING_DELAY = 100;
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    private boolean myIsExecutionScheduled;
    private double myCurrentZoomDelta;
    @NotNull
    private Point myLastZoomPoint;

    protected BaseGraphMouseWheelListener(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(0);
        }
        this.myCurrentZoomDelta = 1.0;
        this.myLastZoomPoint = new Point(0, 0);
        this.myBuilder = builder;
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        int sign;
        if (e == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(1);
        }
        if ((sign = e.getWheelRotation()) == 0) {
            return;
        }
        if (e.isControlDown()) {
            if (!this.myIsExecutionScheduled) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    this.doZoomChange();
                    this.myIsExecutionScheduled = false;
                    this.myCurrentZoomDelta = 1.0;
                }), 100L, TimeUnit.MILLISECONDS);
                this.myIsExecutionScheduled = true;
            }
            this.myCurrentZoomDelta = sign > 0 ? (this.myCurrentZoomDelta /= 1.25) : (this.myCurrentZoomDelta *= 1.25);
            this.myLastZoomPoint = e.getPoint();
        }
    }

    protected void doZoomChange() {
        Magnificator magnificator = (Magnificator)ComponentUtil.getParentOfType(Magnificator.class, (Component)this.myBuilder.getView().getCanvasComponent());
        if (magnificator != null) {
            magnificator.magnify(this.myCurrentZoomDelta, this.myLastZoomPoint);
        }
    }

    @NotNull
    protected GraphBuilder<?, ?> getBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(2);
        }
        return graphBuilder;
    }

    protected double getCurrentZoomDelta() {
        return this.myCurrentZoomDelta;
    }

    @NotNull
    protected Point getLastZoomPoint() {
        Point point = this.myLastZoomPoint;
        if (point == null) {
            BaseGraphMouseWheelListener.$$$reportNull$$$0(3);
        }
        return point;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/BaseGraphMouseWheelListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/BaseGraphMouseWheelListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastZoomPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseWheelMoved";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

