/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.NumpyDocString;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocStringParser {
    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull String stringText) {
        if (format == null) {
            DocStringParser.$$$reportNull$$$0(0);
        }
        if (stringText == null) {
            DocStringParser.$$$reportNull$$$0(1);
        }
        return DocStringParser.parseDocString(format, DocStringParser.stripPrefixAndQuotes(stringText));
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull Substring content) {
        if (format == null) {
            DocStringParser.$$$reportNull$$$0(2);
        }
        if (content == null) {
            DocStringParser.$$$reportNull$$$0(3);
        }
        return switch (format) {
            default -> throw new MatchException(null, null);
            case DocStringFormat.REST -> new SphinxDocString(content);
            case DocStringFormat.GOOGLE -> new GoogleCodeStyleDocString(content);
            case DocStringFormat.NUMPY -> new NumpyDocString(content);
            case DocStringFormat.PLAIN -> new PlainDocString(content);
        };
    }

    @NotNull
    private static Substring stripPrefixAndQuotes(@NotNull String text) {
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(4);
        }
        TextRange contentRange = PyStringLiteralUtil.getContentRange((String)text);
        return new Substring(text, contentRange.getStartOffset(), contentRange.getEndOffset());
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text) {
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(5);
        }
        if (DocStringParser.isLikeSphinxDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.REST;
            if (docStringFormat == null) {
                DocStringParser.$$$reportNull$$$0(6);
            }
            return docStringFormat;
        }
        if (DocStringParser.isLikeNumpyDocstring(text)) {
            DocStringFormat docStringFormat = DocStringFormat.NUMPY;
            if (docStringFormat == null) {
                DocStringParser.$$$reportNull$$$0(7);
            }
            return docStringFormat;
        }
        if (DocStringParser.isLikeGoogleDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.GOOGLE;
            if (docStringFormat == null) {
                DocStringParser.$$$reportNull$$$0(8);
            }
            return docStringFormat;
        }
        DocStringFormat docStringFormat = DocStringFormat.PLAIN;
        if (docStringFormat == null) {
            DocStringParser.$$$reportNull$$$0(9);
        }
        return docStringFormat;
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text, @Nullable PsiElement anchor) {
        DocStringFormat guessed;
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(10);
        }
        DocStringFormat docStringFormat = (guessed = DocStringParser.guessDocStringFormat(text)) == DocStringFormat.PLAIN && anchor != null ? DocStringParser.getConfiguredDocStringFormatOrPlain(anchor) : guessed;
        if (docStringFormat == null) {
            DocStringParser.$$$reportNull$$$0(11);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getConfiguredDocStringFormat(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            DocStringParser.$$$reportNull$$$0(12);
        }
        if ((module = DocStringParser.getModuleForElement(anchor)) == null) {
            return null;
        }
        PyDocumentationSettings settings = PyDocumentationSettings.getInstance(module);
        return settings.getFormatForFile(anchor.getContainingFile());
    }

    @NotNull
    public static DocStringFormat getConfiguredDocStringFormatOrPlain(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DocStringParser.$$$reportNull$$$0(13);
        }
        DocStringFormat docStringFormat = (DocStringFormat)((Object)ObjectUtils.chooseNotNull((Object)((Object)DocStringParser.getConfiguredDocStringFormat(anchor)), (Object)((Object)DocStringFormat.PLAIN)));
        if (docStringFormat == null) {
            DocStringParser.$$$reportNull$$$0(14);
        }
        return docStringFormat;
    }

    public static boolean isLikeSphinxDocString(@NotNull String text) {
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(15);
        }
        return text.contains(":param ") || text.contains(":key ") || text.contains(":keyword ") || text.contains(":return:") || text.contains(":returns:") || text.contains(":raise ") || text.contains(":raises ") || text.contains(":except ") || text.contains(":exception ") || text.contains(":rtype") || text.contains(":type") || text.contains(":var") || text.contains(":ivar") || text.contains(":cvar");
    }

    public static boolean isLikeGoogleDocString(@NotNull String text) {
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(16);
        }
        for (String title : StringUtil.findMatches((String)text, (Pattern)GoogleCodeStyleDocString.SECTION_HEADER, (int)1)) {
            if (!SectionBasedDocString.isValidSectionTitle(title)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikeNumpyDocstring(@NotNull String text) {
        if (text == null) {
            DocStringParser.$$$reportNull$$$0(17);
        }
        String[] lines = StringUtil.splitByLines((String)text, (boolean)false);
        for (int i = 0; i < lines.length; ++i) {
            String lineBefore;
            String line = lines[i];
            if (!NumpyDocString.SECTION_HEADER.matcher(line).matches() || i <= 0 || !SectionBasedDocString.SECTION_NAMES.contains(StringUtil.toLowerCase((String)(lineBefore = lines[i - 1]).trim()))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Module getModuleForElement(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DocStringParser.$$$reportNull$$$0(18);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element.getContainingFile())) != null) {
            return module;
        }
        return (Module)ArrayUtil.getFirstElement((Object[])ModuleManager.getInstance((Project)element.getProject()).getModules());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringParser";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringParser";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDocStringFormat";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseDocString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixAndQuotes";
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessDocStringFormat";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormat";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLikeSphinxDocString";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isLikeGoogleDocString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLikeNumpyDocstring";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 11, 14 -> new IllegalStateException(string);
        };
    }
}

