/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.toolkit;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.desktop.DesktopActionsHandler;
import com.intellij.desktop.DesktopActionsUtils;
import com.intellij.openapi.util.Setter;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.jetbrains.annotations.NotNull;

class ToolkitHandler
implements Setter<RemoteDesktopActionsHandler> {
    ToolkitHandler() {
    }

    static ToolkitHandler create() {
        return ToolkitHandler.init() ? new ToolkitHandler() : null;
    }

    private static boolean init() {
        try {
            System.setProperty("awt.toolkit", DesktopActionsUtils.getActionsToolkitClass());
            if (DesktopActionsUtils.setDefaultToolkit()) {
                JdbcNativeUtil.logInfo("Toolkit is set to " + Toolkit.getDefaultToolkit().getClass().getName());
            }
            return true;
        }
        catch (RuntimeException e) {
            JdbcNativeUtil.logWarn(null, e);
            return false;
        }
    }

    public void set(@NotNull RemoteDesktopActionsHandler handler) {
        if (handler == null) {
            ToolkitHandler.$$$reportNull$$$0(0);
        }
        DesktopActionsUtils.setHandler(ToolkitHandler.adapt(handler));
    }

    private static DesktopActionsHandler adapt(final @NotNull RemoteDesktopActionsHandler handler) {
        if (handler == null) {
            ToolkitHandler.$$$reportNull$$$0(1);
        }
        return new DesktopActionsHandler(){

            @Override
            public boolean isSupported(Desktop.Action action) {
                try {
                    if (action == Desktop.Action.BROWSE) {
                        this.browse(null);
                    } else if (action == Desktop.Action.OPEN) {
                        this.open(null);
                    } else if (action == Desktop.Action.EDIT) {
                        this.edit(null);
                    } else if (action == Desktop.Action.MAIL) {
                        this.mail(null);
                    } else if (action == Desktop.Action.PRINT) {
                        this.print(null);
                    } else {
                        return false;
                    }
                    return true;
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
                catch (Exception e) {
                    JdbcNativeUtil.logWarn(null, e);
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void open(File file) throws IOException {
                handler.open(file);
            }

            @Override
            public void edit(File file) throws IOException {
                handler.edit(file);
            }

            @Override
            public void print(File file) throws IOException {
                handler.print(file);
            }

            @Override
            public void mail(URI mailtoURL) throws IOException {
                handler.mail(mailtoURL);
            }

            @Override
            public void browse(URI uri) throws IOException {
                handler.browse(uri);
            }
        };
    }

    public String toString() {
        return "awt.toolkit";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "handler";
        objectArray2[1] = "com/intellij/database/remote/toolkit/ToolkitHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "adapt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

