/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public final class SqlReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        DasObject dasObject;
        if (element == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(0);
        }
        return (dasObject = SqlImplUtil.unwrapPsiToObject((PsiElement)element)) instanceof DasTable || dasObject instanceof DasTypedObject || dasObject instanceof BuiltinFunction;
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(1);
        }
        if (element instanceof SqlVariableDefinition) {
            return ((SqlVariableDefinition)element).getInitializer() != null;
        }
        if (element instanceof SqlTableDefinition) {
            return ((SqlTableDefinition)element).getQueryExpression() != null;
        }
        if (element instanceof DasTypedObject) {
            return ((DasTypedObject)element).getDefault() != null;
        }
        return false;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        if (referencedElement == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(3);
        }
        if (referencedElement instanceof DasTypedObject || referencedElement instanceof SqlAsExpression) {
            ReadWriteAccessDetector.Access access = this.getExpressionAccess(reference.getElement());
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(4);
            }
            return access;
        }
        if (referencedElement instanceof SqlDefinition && reference.getElement() == ((SqlDefinition)referencedElement).getNameElement()) {
            ReadWriteAccessDetector.Access access = this.isDeclarationWriteAccess(referencedElement) ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(5);
            }
            return access;
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(6);
        }
        return access;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression) {
        SqlSetClause setClause;
        if (expression == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(7);
        }
        if (expression instanceof SqlDefinition) {
            ReadWriteAccessDetector.Access access = this.isDeclarationWriteAccess(expression) ? ReadWriteAccessDetector.Access.ReadWrite : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(8);
            }
            return access;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof SqlBinaryExpression) {
            SqlBinaryExpression binaryExpression = (SqlBinaryExpression)parent;
            ReadWriteAccessDetector.Access access = binaryExpression.getOpSign() == SqlCommonTokens.SQL_OP_ASSIGN && binaryExpression.getLOperand() == expression ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(9);
            }
            return access;
        }
        SqlTableColumnsList tableColumnList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlTableColumnsList.class);
        if (tableColumnList != null) {
            if (tableColumnList.getParent() instanceof SqlDmlInstruction && tableColumnList.getParent().getParent() instanceof SqlInsertStatement) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(10);
                }
                return access;
            }
            if (SqlImplUtil.getSqlDialectDbms((PsiElement)tableColumnList).isMicrosoft() && tableColumnList.getParent() instanceof SqlReturningClause) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(11);
                }
                return access;
            }
            ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
            if (access == null) {
                SqlReadWriteAccessDetector.$$$reportNull$$$0(12);
            }
            return access;
        }
        if (expression instanceof SqlReferenceExpression) {
            SqlAsExpression updateTargetExpression = parent instanceof SqlAsExpression ? (SqlAsExpression)parent : (SqlReferenceExpression)expression;
            SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlDmlInstruction.class);
            if (instruction != null && PsiTreeUtil.getChildOfType((PsiElement)instruction, SqlExpression.class) == updateTargetExpression) {
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(13);
                }
                return access;
            }
        }
        if ((setClause = (SqlSetClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSetClause.class)) != null) {
            PsiElement first = parent instanceof SqlReferenceList ? parent : expression;
            for (PsiElement child = first.getNextSibling(); child != null; child = child.getNextSibling()) {
                IElementType elementType = child.getNode().getElementType();
                if (elementType == SqlCommonTokens.SQL_COMMA) {
                    ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
                    if (access == null) {
                        SqlReadWriteAccessDetector.$$$reportNull$$$0(14);
                    }
                    return access;
                }
                if (elementType != SqlCommonTokens.SQL_OP_EQ) continue;
                ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Write;
                if (access == null) {
                    SqlReadWriteAccessDetector.$$$reportNull$$$0(15);
                }
                return access;
            }
        }
        ReadWriteAccessDetector.Access access = ReadWriteAccessDetector.Access.Read;
        if (access == null) {
            SqlReadWriteAccessDetector.$$$reportNull$$$0(16);
        }
        return access;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlReadWriteAccessDetector";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceAccess";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAccess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReadWriteAccessible";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDeclarationWriteAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAccess";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

