/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.data.input;

import com.intellij.database.actions.EditAsTableAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.dataspell.jupyter.customCells.data.input.JupyterCsvDropHandler;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonLanguage;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/data/input/JupyterDataInputCsvFormatAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getImportedCsvFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCsv", "", "vFile", "getDropHandler", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandler;", "getImportedFile", "intellij.dataspell.jupyter.customCells"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputCsvFormatAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputCsvFormatAction.kt\ncom/intellij/dataspell/jupyter/customCells/data/input/JupyterDataInputCsvFormatAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class JupyterDataInputCsvFormatAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.getImportedCsvFile(e) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = this.getImportedCsvFile(e);
        if (virtualFile == null) {
            return;
        }
        VirtualFile vFile = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(vFile, project2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        CsvFormat selectedFormat = EditAsTableAction.showDataFormatEditorDialog((Project)project2, (VirtualFile)vFile, (Document)document2, null);
        if (selectedFormat != null) {
            CsvFormatResolver.saveCsvFormatAndUpdateEditor((Project)project2, (CsvFormat)selectedFormat, (VirtualFile)vFile);
        }
    }

    private final VirtualFile getImportedCsvFile(AnActionEvent e) {
        Object object;
        VirtualFile virtualFile = this.getImportedFile(e);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = this.isCsv(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean isCsv(VirtualFile vFile) {
        return this.getDropHandler(vFile) instanceof JupyterCsvDropHandler;
    }

    private final TableDataFileDropHandler getDropHandler(VirtualFile vFile) {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"getInstance(...)");
        Language language = (Language)pythonLanguage;
        String string = vFile.getExtension();
        if (string == null) {
            string = "";
        }
        return TableDataFileDropHandler.Companion.findApplicable(language, string);
    }

    private final VirtualFile getImportedFile(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor2);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterNotebook jupyterNotebook = notebookFile.getNotebookOrNull();
        if (jupyterNotebook == null) {
            return null;
        }
        JupyterNotebook notebook = jupyterNotebook;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return null;
        }
        int cellIndex = interval.getOrdinal();
        JupyterCell jupyterCell = notebook.getCellOrNull(cellIndex);
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell cell = jupyterCell;
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata((JupyterCell)cell);
        if (jupyterDataInputCellMetadata == null) {
            return null;
        }
        JupyterDataInputCellMetadata metadata = jupyterDataInputCellMetadata;
        Path path = notebookFile.getOriginFile().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path path2 = metadata.getFilePath(path);
        if (path2 == null) {
            return null;
        }
        Path filePath = path2;
        return LocalFileSystem.getInstance().findFileByNioFile(filePath);
    }
}

