/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.variables.python;

import com.intellij.dataspell.jupyter.customCells.variables.api.JupyterVariableCellTypeProvider;
import com.intellij.dataspell.jupyter.customCells.variables.python.VariableCellLightElement;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.backend.documentation.DocumentationResult;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/variables/python/VariableCellDocumentationTarget;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "element", "Lcom/intellij/dataspell/jupyter/customCells/variables/python/VariableCellLightElement;", "<init>", "(Lcom/intellij/dataspell/jupyter/customCells/variables/python/VariableCellLightElement;)V", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "computeDocumentation", "Lcom/intellij/platform/backend/documentation/DocumentationResult;", "intellij.dataspell.jupyter.customCells.variables"})
public final class VariableCellDocumentationTarget
implements DocumentationTarget {
    @NotNull
    private final VariableCellLightElement element;

    public VariableCellDocumentationTarget(@NotNull VariableCellLightElement element) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        this.element = element;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        String name = this.element.getName();
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(name).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public DocumentationResult computeDocumentation() {
        String name = this.element.getName();
        PyType pyType = this.element.getType();
        JupyterCellTypeProvider provider = this.element.getCell().getCellTypeProvider();
        String rawValue = provider instanceof JupyterVariableCellTypeProvider ? ((JupyterVariableCellTypeProvider)provider).valueText(this.element.getCell()) : null;
        StringBuilder sb = new StringBuilder();
        sb.append("<div class='definition'><pre>");
        sb.append(name);
        if (pyType != null) {
            String typeLabel;
            PyType pyType2 = pyType;
            PyClassType pyClassType = pyType2 instanceof PyClassType ? (PyClassType)pyType2 : null;
            PyClass pyClass = pyClassType != null ? pyClassType.getPyClass() : null;
            String string = pyType.getName();
            if (string == null) {
                PyQualifiedNameOwner pyQualifiedNameOwner = pyClass instanceof PyQualifiedNameOwner ? (PyQualifiedNameOwner)pyClass : null;
                string = pyQualifiedNameOwner != null ? pyQualifiedNameOwner.getQualifiedName() : null;
            }
            if ((typeLabel = string) != null) {
                sb.append(": ");
                sb.append(StringUtil.escapeXmlEntities((String)typeLabel));
            }
        }
        if (rawValue != null && !StringsKt.isBlank((CharSequence)rawValue)) {
            String string = StringUtil.shortenTextWithEllipsis((String)((Object)StringsKt.trim((CharSequence)rawValue)).toString(), (int)200, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            String shownValue = string;
            sb.append(" = ");
            sb.append(StringUtil.escapeXmlEntities((String)shownValue));
        }
        sb.append("</pre></div>");
        sb.append("<div class='content'>");
        sb.append("<span class='grayed'>");
        sb.append("Defined in a Jupyter Variable cell");
        sb.append("</span>");
        sb.append("</div>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return (DocumentationResult)DocumentationResult.Companion.documentation(string);
    }
}

