/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.variables.ui;

import com.intellij.dataspell.jupyter.customCells.variables.VariablesJupyterCellsBundle;
import com.intellij.dataspell.jupyter.customCells.variables.api.JupyterVariableCellProvider;
import com.intellij.dataspell.jupyter.customCells.variables.ui.JupyterVariableCellComponent;
import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterChangeListener;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterEvent;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.NotebookChanged;
import com.intellij.notebooks.ui.SteadyUIPanel;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.InjectedDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.PanelUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u000f\u0010$\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010%J\u0015\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)J\u0015\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)J\u0015\u0010.\u001a\u00020\u001b2\u0006\u0010-\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/variables/ui/JupyterVariableCellPanel;", "T", "", "Lcom/intellij/notebooks/ui/SteadyUIPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "provider", "Lcom/intellij/dataspell/jupyter/customCells/variables/api/JupyterVariableCellProvider$Typed;", "component", "Lcom/intellij/dataspell/jupyter/customCells/variables/ui/JupyterVariableCellComponent;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCell;Lcom/intellij/dataspell/jupyter/customCells/variables/api/JupyterVariableCellProvider$Typed;Lcom/intellij/dataspell/jupyter/customCells/variables/ui/JupyterVariableCellComponent;)V", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "infoLabel", "Ljavax/swing/JLabel;", "lastExecutedMetadata", "Ljava/lang/Object;", "createInfoLabel", "createWrapperPanel", "Ljavax/swing/JPanel;", "detailsPanel", "Ljavax/swing/JComponent;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "setCellSource", "setupChangeListener", "getIntervalPointer", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getNotebookCell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "getMetadata", "()Ljava/lang/Object;", "getMetadataOrDefault", "setMetadata", "metadata", "(Ljava/lang/Object;)V", "settingState", "", "onMetadataChanged", "new", "setState", "intellij.dataspell.jupyter.customCells.variables"})
@SourceDebugExtension(value={"SMAP\nJupyterVariableCellPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterVariableCellPanel.kt\ncom/intellij/dataspell/jupyter/customCells/variables/ui/JupyterVariableCellPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public final class JupyterVariableCellPanel<T>
extends SteadyUIPanel
implements UiDataProvider {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCell cell;
    @NotNull
    private final JupyterVariableCellProvider.Typed<T> provider;
    @NotNull
    private final JupyterVariableCellComponent<T> component;
    @NotNull
    private final JupyterNotebook notebook;
    @NotNull
    private JLabel infoLabel;
    @Nullable
    private T lastExecutedMetadata;
    private boolean settingState;

    public JupyterVariableCellPanel(@NotNull EditorImpl editor, @NotNull EditorCell cell, @NotNull JupyterVariableCellProvider.Typed<T> provider, @NotNull JupyterVariableCellComponent<T> component) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(component, (String)"component");
        super(new PanelUI(){});
        this.editor = editor;
        this.cell = cell;
        this.provider = provider;
        this.component = component;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)((Editor)this.editor));
        Intrinsics.checkNotNull((Object)backedNotebookVirtualFile);
        this.notebook = backedNotebookVirtualFile.getNotebook();
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setCellSource();
        this.infoLabel = this.createInfoLabel();
        T t = this.getMetadata();
        if (t != null) {
            T it = t;
            boolean bl = false;
            this.setState(it);
            this.component.setState$intellij_dataspell_jupyter_customCells_variables(it);
        }
        JComponent detailsPanel = this.component.build$intellij_dataspell_jupyter_customCells_variables();
        detailsPanel.setOpaque(false);
        JPanel wrapperPanel = this.createWrapperPanel(detailsPanel);
        this.add(wrapperPanel, "Center");
        this.setupChangeListener();
    }

    private final JLabel createInfoLabel() {
        JBLabel jBLabel;
        JBLabel $this$createInfoLabel_u24lambda_u240 = jBLabel = new JBLabel(VariablesJupyterCellsBundle.message("variable.cell.cell.updated.info.label", new Object[0]), AllIcons.General.Information, 10);
        boolean bl = false;
        $this$createInfoLabel_u24lambda_u240.setOpaque(false);
        $this$createInfoLabel_u24lambda_u240.setForeground(UIUtil.getLabelForeground());
        $this$createInfoLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        return (JLabel)jBLabel;
    }

    private final JPanel createWrapperPanel(JComponent detailsPanel) {
        JPanel jPanel;
        JPanel $this$createWrapperPanel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        $this$createWrapperPanel_u24lambda_u240.setOpaque(false);
        $this$createWrapperPanel_u24lambda_u240.add((Component)detailsPanel, "Center");
        if (!(detailsPanel instanceof JupyterVariableCellPanel)) {
            JPanel jPanel2;
            JPanel $this$createWrapperPanel_u24lambda_u240_u240 = jPanel2 = new JPanel(new BorderLayout());
            boolean bl2 = false;
            $this$createWrapperPanel_u24lambda_u240_u240.setOpaque(false);
            $this$createWrapperPanel_u24lambda_u240_u240.add((Component)this.infoLabel, "North");
            JPanel infoLabelPanel = jPanel2;
            $this$createWrapperPanel_u24lambda_u240.add((Component)infoLabelPanel, "East");
        }
        return jPanel;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        sink.setNull(dataKey);
        DataKey dataKey2 = CommonDataKeys.HOST_EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"HOST_EDITOR");
        sink.setNull(dataKey2);
        DataKey dataKey3 = InjectedDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"EDITOR");
        sink.setNull(dataKey3);
    }

    private final void setCellSource() {
        JupyterCell notebookCell = this.notebook.getCell(this.cell.getInterval().getOrdinal());
        String string = this.provider.generateCode(notebookCell);
        if (string == null) {
            string = VariablesJupyterCellsBundle.message("jupyter.custom.cell.variable.cell.source", new Object[0]);
        }
        String code = string;
        notebookCell.setSource(code);
    }

    private final void setupChangeListener() {
        JupyterChangeListener listener = arg_0 -> JupyterVariableCellPanel.setupChangeListener$lambda$0(this, arg_0);
        this.notebook.getListeners().getChangeListeners().addListener((EventListener)listener, (Disposable)this.cell);
        this.component.setStateListener(arg_0 -> JupyterVariableCellPanel.setupChangeListener$lambda$1(this, arg_0));
    }

    private final NotebookCellLines.Interval getIntervalPointer() {
        return this.cell.getIntervalPointer().get();
    }

    private final JupyterCell getNotebookCell() {
        JupyterCell jupyterCell;
        NotebookCellLines.Interval interval = this.getIntervalPointer();
        if (interval != null) {
            int it = interval.getOrdinal();
            boolean bl = false;
            jupyterCell = this.notebook.getCell(it);
        } else {
            jupyterCell = null;
        }
        return jupyterCell;
    }

    private final T getMetadata() {
        JupyterCell jupyterCell = this.getNotebookCell();
        if (jupyterCell == null) {
            return this.provider.getDefaultMetadata();
        }
        JupyterCell cell = jupyterCell;
        return this.provider.getMetadata(cell);
    }

    private final T getMetadataOrDefault() {
        JupyterCell jupyterCell = this.getNotebookCell();
        if (jupyterCell == null) {
            return this.provider.getDefaultMetadata();
        }
        JupyterCell cell = jupyterCell;
        return this.provider.getMetadataOrDefault(cell);
    }

    private final void setMetadata(T metadata) {
        PsiFile psiFile;
        JupyterCell jupyterCell = this.getNotebookCell();
        if (jupyterCell == null) {
            return;
        }
        JupyterCell cell = jupyterCell;
        Project project = this.editor.getProject();
        String string = VariablesJupyterCellsBundle.message("command.name.change.variable.cell", new Object[0]);
        String string2 = cell.getId();
        Runnable runnable = () -> JupyterVariableCellPanel.setMetadata$lambda$0(this, cell, metadata);
        PsiFile[] psiFileArray = new PsiFile[1];
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)((Editor)this.editor));
        if (backedNotebookVirtualFile != null && (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) != null) {
            Project project2 = this.editor.getProject();
            if (project2 == null) {
                return;
            }
            psiFile = VirtualFileUtil.findPsiFile((VirtualFile)backedNotebookVirtualFile, (Project)project2);
        } else {
            psiFile = null;
        }
        psiFileArray[0] = psiFile;
        WriteCommandAction.runWriteCommandAction((Project)project, (String)string, (String)string2, (Runnable)runnable, (PsiFile[])psiFileArray);
    }

    private final void onMetadataChanged(T t) {
        if (this.settingState) {
            return;
        }
        T old = this.getMetadataOrDefault();
        if (Intrinsics.areEqual(old, t)) {
            return;
        }
        this.setMetadata(t);
    }

    private final void setState(T t) {
        this.settingState = true;
        this.component.setState$intellij_dataspell_jupyter_customCells_variables(t);
        this.settingState = false;
        JupyterCell jupyterCell = this.getNotebookCell();
        if (jupyterCell == null) {
            return;
        }
        JupyterCell cell = jupyterCell;
        if (this.component.requiresSettings$intellij_dataspell_jupyter_customCells_variables(t)) {
            this.provider.showSettingsPopup(cell, null, null);
        }
    }

    private static final void setupChangeListener$lambda$0(JupyterVariableCellPanel this$0, JupyterEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof NotebookChanged)) {
            return;
        }
        if (this$0.getIntervalPointer() == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> JupyterVariableCellPanel.setupChangeListener$lambda$0$0(this$0));
    }

    private static final void setupChangeListener$lambda$0$0(JupyterVariableCellPanel this$0) {
        if (this$0.getIntervalPointer() == null) {
            return;
        }
        Object old = this$0.component.getState$intellij_dataspell_jupyter_customCells_variables();
        Object t = this$0.getMetadataOrDefault();
        ProgressStatus progressStatus = ((EditorCell.ExecutionStatus)this$0.cell.getExecutionStatus().get()).getStatus();
        switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1: 
            case 2: {
                this$0.lastExecutedMetadata = t;
            }
        }
        this$0.infoLabel.setVisible(!Intrinsics.areEqual(this$0.lastExecutedMetadata, t));
        if (Intrinsics.areEqual(old, t)) {
            return;
        }
        this$0.setCellSource();
        this$0.setState(t);
    }

    private static final Unit setupChangeListener$lambda$1(JupyterVariableCellPanel this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.onMetadataChanged(it);
        return Unit.INSTANCE;
    }

    private static final void setMetadata$lambda$0(JupyterVariableCellPanel this$0, JupyterCell $cell, Object $metadata) {
        this$0.provider.setMetadata($cell, $metadata);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.QUEUED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

