/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterCallbackBasedSocketImpl;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterReceiveSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSendReceiveSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.exceptions.ExceptionMerger;
import org.jetbrains.kotlinx.jupyter.protocol.messaging.JupyterClientSockets;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqClientReceiveSockets;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocket;
import org.slf4j.Logger;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSockets;", "Lorg/jetbrains/kotlinx/jupyter/protocol/messaging/JupyterClientSockets;", "delegate", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientReceiveSockets;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientReceiveSockets;Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "context", "Lorg/zeromq/ZMQ$Context;", "getContext", "()Lorg/zeromq/ZMQ$Context;", "shell", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterCallbackBasedSocketImpl;", "getShell", "()Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterCallbackBasedSocketImpl;", "control", "getControl", "stdin", "getStdin", "ioPub", "getIoPub", "mainThread", "Ljava/lang/Thread;", "close", "", "noOpSend", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSockets$NoOpSendSocket;", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocket;", "NoOpSendSocket", "zmq-protocol"})
@SourceDebugExtension(value={"SMAP\nJupyterZmqClientSocketManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterZmqClientSocketManager.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSockets\n+ 2 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/UtilKt\n+ 3 Util.kt\norg/jetbrains/kotlinx/jupyter/protocol/exceptions/ExceptionMerger\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 JupyterZmqClientSocketManager.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSocketManagerKt\n*L\n1#1,129:1\n18#2:130\n10#2,4:131\n19#2,2:147\n14#2,3:149\n21#2:153\n30#3,6:135\n30#3,6:141\n1#4:152\n1563#5:154\n1634#5,3:155\n1869#5,2:158\n1869#5,2:160\n1869#5,2:162\n109#6,20:164\n*S KotlinDebug\n*F\n+ 1 JupyterZmqClientSocketManager.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSockets\n*L\n73#1:130\n73#1:131,4\n73#1:147,2\n73#1:149,3\n73#1:153\n78#1:135,6\n80#1:141,6\n73#1:152\n50#1:154\n50#1:155,3\n59#1:158,2\n61#1:160,2\n62#1:162,2\n53#1:164,20\n*E\n"})
public final class JupyterZmqClientSockets
implements JupyterClientSockets {
    @NotNull
    private final JupyterZmqClientReceiveSockets delegate;
    @NotNull
    private final Logger logger;
    @NotNull
    private final JupyterCallbackBasedSocketImpl shell;
    @NotNull
    private final JupyterCallbackBasedSocketImpl control;
    @NotNull
    private final JupyterCallbackBasedSocketImpl stdin;
    @NotNull
    private final JupyterCallbackBasedSocketImpl ioPub;
    @NotNull
    private final Thread mainThread;

    public JupyterZmqClientSockets(@NotNull JupyterZmqClientReceiveSockets delegate, @NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.delegate = delegate;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.shell = JupyterSocketKt.callbackBased((JupyterSendReceiveSocket)this.delegate.getShell(), this.logger);
        this.control = JupyterSocketKt.callbackBased((JupyterSendReceiveSocket)this.delegate.getControl(), this.logger);
        this.stdin = JupyterSocketKt.callbackBased((JupyterSendReceiveSocket)this.delegate.getStdin(), this.logger);
        this.ioPub = JupyterSocketKt.callbackBased((JupyterSendReceiveSocket)this.noOpSend(this.delegate.getIoPub()), this.logger);
        this.mainThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"JupyterZmqClientSockets.main", (int)0, () -> JupyterZmqClientSockets.mainThread$lambda$0(this), (int)23, null);
    }

    @NotNull
    public final ZMQ.Context getContext() {
        return this.delegate.getContext();
    }

    @Override
    @NotNull
    public JupyterCallbackBasedSocketImpl getShell() {
        return this.shell;
    }

    @Override
    @NotNull
    public JupyterCallbackBasedSocketImpl getControl() {
        return this.control;
    }

    @Override
    @NotNull
    public JupyterCallbackBasedSocketImpl getStdin() {
        return this.stdin;
    }

    @Override
    @NotNull
    public JupyterCallbackBasedSocketImpl getIoPub() {
        return this.ioPub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean $i$f$mergeExceptions = false;
        ExceptionMerger exceptionMerger$iv = new ExceptionMerger();
        Throwable throwable$iv = null;
        try {
            ExceptionMerger $this$close_u24lambda_u240 = exceptionMerger$iv;
            boolean bl = false;
            Object[] objectArray = new JupyterCallbackBasedSocketImpl[]{this.getShell(), this.getControl(), this.getIoPub(), this.getStdin()};
            for (JupyterCallbackBasedSocketImpl socket : CollectionsKt.listOf((Object[])objectArray)) {
                ExceptionMerger this_$iv = $this$close_u24lambda_u240;
                boolean $i$f$catchIndependently = false;
                try {
                    boolean bl2 = false;
                    socket.close();
                }
                catch (Throwable e$iv) {
                    this_$iv.addError(e$iv);
                }
            }
            ExceptionMerger this_$iv = $this$close_u24lambda_u240;
            boolean $i$f$catchIndependently = false;
            try {
                boolean bl3 = false;
                this.delegate.close();
            }
            catch (Throwable e$iv) {
                this_$iv.addError(e$iv);
            }
            exceptionMerger$iv.finalize();
        }
        catch (Throwable e$iv) {
            try {
                throwable$iv = e$iv;
                throw e$iv;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable$iv;
                if (throwable2 != null) {
                    Throwable it$iv = throwable2;
                    boolean bl = false;
                    exceptionMerger$iv.addError(it$iv);
                }
                exceptionMerger$iv.finalize();
                throw throwable;
            }
        }
        this.mainThread.interrupt();
        try {
            this.mainThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final NoOpSendSocket noOpSend(JupyterZmqSocket $this$noOpSend) {
        return new NoOpSendSocket($this$noOpSend);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit mainThread$lambda$0(JupyterZmqClientSockets this$0) {
        Iterator $this$mapTo$iv$iv;
        Thread mainThread2 = Thread.currentThread();
        Object[] objectArray = new KProperty0[]{new PropertyReference0Impl(this$0){

            public Object get() {
                return ((JupyterZmqClientSockets)this.receiver).getShell();
            }
        }, new PropertyReference0Impl(this$0){

            public Object get() {
                return ((JupyterZmqClientSockets)this.receiver).getControl();
            }
        }, new PropertyReference0Impl(this$0){

            public Object get() {
                return ((JupyterZmqClientSockets)this.receiver).getStdin();
            }
        }, new PropertyReference0Impl(this$0){

            public Object get() {
                return ((JupyterZmqClientSockets)this.receiver).getIoPub();
            }
        }};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void socketProp;
            Object item$iv$iv = iterator.next();
            KProperty0 kProperty0 = (KProperty0)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JupyterCallbackBasedSocketImpl socket = (JupyterCallbackBasedSocketImpl)socketProp.get();
            collection.add(ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("JupyterZmqClientSockets." + socketProp.getName()), (int)0, () -> JupyterZmqClientSockets.mainThread$lambda$0$0$0(mainThread2, (KProperty0)socketProp, this$0, socket), (int)23, null));
        }
        List socketThreads2 = (List)destination$iv$iv;
        try {
            Iterable $this$forEach$iv = socketThreads2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl = false;
                it.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread it;
            Iterable $this$forEach$iv = socketThreads2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Thread)element$iv;
                boolean bl = false;
                it.interrupt();
            }
            $this$forEach$iv = socketThreads2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Thread)element$iv;
                boolean bl = false;
                try {
                    it.join();
                }
                catch (InterruptedException interruptedException2) {
                }
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit mainThread$lambda$0$0$0(Thread $mainThread, KProperty0 $socketProp, JupyterZmqClientSockets this$0, JupyterCallbackBasedSocketImpl $socket) {
        Intrinsics.checkNotNull((Object)$mainThread);
        Thread thread = $mainThread;
        String string = $socketProp.getName();
        Logger logger$iv = this$0.logger;
        boolean $i$f$socketLoop = false;
        while (true) {
            try {
                boolean bl = false;
                $socket.receiveMessageAndRunCallbacks();
            }
            catch (Throwable e$iv) {
                void socketName$iv;
                void parentThread$iv;
                Throwable throwable = e$iv;
                if (throwable instanceof InterruptedException) {
                    parentThread$iv.interrupt();
                    break;
                }
                if (throwable instanceof ZMQException && ((ZMQException)e$iv).getErrorCode() == 125) {
                    parentThread$iv.interrupt();
                    break;
                }
                logger$iv.error("Exception in socket loop for '" + (String)socketName$iv + "' socket", e$iv);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\t\u0010\f\u001a\u00020\tH\u0096\u0001J\u000b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0096\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqClientSockets$NoOpSendSocket;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterReceiveSocket;", "Ljava/io/Closeable;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterSendReceiveSocket;", "receiveSocket", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocket;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocket;)V", "sendRawMessage", "", "msg", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "close", "receiveRawMessage", "zmq-protocol"})
    private static final class NoOpSendSocket
    implements JupyterReceiveSocket,
    Closeable,
    JupyterSendReceiveSocket {
        @NotNull
        private final JupyterZmqSocket receiveSocket;

        public NoOpSendSocket(@NotNull JupyterZmqSocket receiveSocket) {
            Intrinsics.checkNotNullParameter((Object)receiveSocket, (String)"receiveSocket");
            this.receiveSocket = receiveSocket;
        }

        @Override
        public void sendRawMessage(@NotNull RawMessage msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        }

        @Override
        @Nullable
        public RawMessage receiveRawMessage() {
            return this.receiveSocket.receiveRawMessage();
        }

        @Override
        public void close() {
            this.receiveSocket.close();
        }
    }
}

