/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformUtils;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.intention.CheckRegExpForm;
import org.jetbrains.annotations.NotNull;

final class CheckRegExpIntentionAction
extends QuickEditAction
implements Iconable {
    CheckRegExpIntentionAction() {
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            CheckRegExpIntentionAction.$$$reportNull$$$0(0);
        }
        if (PlatformUtils.isPyCharmEducational()) {
            return false;
        }
        if (editor.getUserData(CheckRegExpForm.Keys.CHECK_REG_EXP_EDITOR) != null) {
            return false;
        }
        Pair pair = this.getRangePair(psiFile, editor);
        if (pair != null && pair.first != null) {
            Language language = ((PsiElement)pair.first).getLanguage();
            return language.isKindOf((Language)RegExpLanguage.INSTANCE);
        }
        PsiFile baseFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile);
        return baseFile != null && baseFile.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        PsiFile baseFile;
        if (project == null) {
            CheckRegExpIntentionAction.$$$reportNull$$$0(1);
        }
        if ((baseFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)psiFile)) == null || !baseFile.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) {
            super.invoke(project, editor, psiFile);
            return;
        }
        JComponent component = this.createBalloonComponent(psiFile);
        if (component != null) {
            QuickEditHandler.showBalloon((Editor)editor, (PsiFile)psiFile, (JComponent)component);
        }
    }

    protected boolean isShowInBalloon() {
        return true;
    }

    protected JComponent createBalloonComponent(@NotNull PsiFile file) {
        Project project;
        Document document;
        if (file == null) {
            CheckRegExpIntentionAction.$$$reportNull$$$0(2);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) != null) {
            return new CheckRegExpForm(file).getRootPanel();
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = RegExpBundle.message("intention.name.check.regexp", new Object[0]);
        if (string == null) {
            CheckRegExpIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            CheckRegExpIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public Icon getIcon(int flags) {
        return RegExpLanguage.INSTANCE.getAssociatedFileType().getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonComponent";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

