/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.plantuml;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.util.registry.Registry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionWithDownloadableFiles;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLCodeFenceLanguageProvider;
import org.intellij.plugins.markdown.extensions.common.plantuml.PlantUMLJarManager;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001)B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002R$\u0010\u0006\u001a\u0018\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0019\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006*"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider;", "Lorg/intellij/plugins/markdown/extensions/CodeFenceGeneratingProvider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "externalFiles", "", "getExternalFiles", "()Ljava/lang/Iterable;", "filesToDownload", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles$FileEntry;", "getFilesToDownload", "isApplicable", "", "language", "generateHtml", "raw", "node", "Lorg/intellij/markdown/ast/ASTNode;", "obtainGeneratedContent", "displayName", "getDisplayName", "()Ljava/lang/String;", "description", "getDescription", "id", "getId", "beforeCleanup", "", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "generateDiagram", "text", "", "Companion", "intellij.markdown"})
@ApiStatus.Internal
public final class PlantUMLCodeGeneratingProvider
implements CodeFenceGeneratingProvider,
MarkdownExtensionWithDownloadableFiles,
MarkdownBrowserPreviewExtension.Provider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<String, String> cache;
    @NotNull
    private final String id;
    @NotNull
    public static final String jarFilename = "plantuml.jar";
    @NotNull
    private static final List<String> ownFiles = CollectionsKt.listOf((Object)"plantuml.jar");
    @NotNull
    private static final List<MarkdownExtensionWithDownloadableFiles.FileEntry> dowloadableFiles = CollectionsKt.listOf((Object)new MarkdownExtensionWithDownloadableFiles.FileEntry("plantuml.jar", PlantUMLCodeGeneratingProvider::dowloadableFiles$lambda$0));

    public PlantUMLCodeGeneratingProvider() {
        Cache cache = Caffeine.newBuilder().softValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        this.id = "PlantUMLLanguageExtension";
    }

    @Override
    @NotNull
    public Iterable<String> getExternalFiles() {
        return ownFiles;
    }

    @Override
    @NotNull
    public Iterable<MarkdownExtensionWithDownloadableFiles.FileEntry> getFilesToDownload() {
        return dowloadableFiles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!this.isEnabled()) return false;
        if (!this.isAvailable()) return false;
        String string = language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!PlantUMLCodeFenceLanguageProvider.Companion.isPlantUmlInfoString$intellij_markdown(string)) return false;
        return true;
    }

    @Override
    @NotNull
    public String generateHtml(@NotNull String language, @NotNull String raw, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String content2 = this.obtainGeneratedContent(raw);
        String header = "data:image/png;base64,";
        return "<img src=\"" + header + content2 + "\" from-extension=true/>";
    }

    private final String obtainGeneratedContent(String raw) {
        String key = MarkdownUtil.INSTANCE.md5(raw, "salt");
        String cached = (String)this.cache.getIfPresent((Object)key);
        if (cached != null) {
            return cached;
        }
        String generated = this.generateDiagram(raw);
        this.cache.put((Object)key, (Object)generated);
        return generated;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = MarkdownBundle.message("markdown.extensions.plantuml.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = MarkdownBundle.message("markdown.extensions.plantuml.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public void beforeCleanup() {
        PlantUMLJarManager.Companion.getInstance().dropCache();
    }

    @Override
    @Nullable
    public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        return null;
    }

    private final String generateDiagram(CharSequence text2) throws IOException {
        StringBuilder stringBuilder;
        StringBuilder $this$generateDiagram_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.startsWith$default((CharSequence)text2, (CharSequence)"@startuml", (boolean)false, (int)2, null)) {
            $this$generateDiagram_u24lambda_u240.append("@startuml\n");
        }
        $this$generateDiagram_u24lambda_u240.append(text2);
        if (!StringsKt.endsWith$default((CharSequence)text2, (CharSequence)"@enduml", (boolean)false, (int)2, null)) {
            $this$generateDiagram_u24lambda_u240.append("\n@enduml");
        }
        String content2 = stringBuilder.toString();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PlantUMLJarManager.Companion.getInstance().generateImage(content2, stream);
        byte[] encodedContent = Base64.getEncoder().encode(stream.toByteArray());
        Intrinsics.checkNotNull((Object)encodedContent);
        return new String(encodedContent, Charsets.UTF_8);
    }

    private static final String dowloadableFiles$lambda$0() {
        return Registry.Companion.stringValue("markdown.plantuml.download.link");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/plantuml/PlantUMLCodeGeneratingProvider$Companion;", "", "<init>", "()V", "jarFilename", "", "ownFiles", "", "dowloadableFiles", "Lorg/intellij/plugins/markdown/extensions/MarkdownExtensionWithDownloadableFiles$FileEntry;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

