/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaConfigurationType;
import com.jetbrains.nodejs.mocha.execution.MochaDetector;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunConfigurationProducer
extends JsTestRunConfigurationProducer<MochaRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        MochaConfigurationType mochaConfigurationType = MochaConfigurationType.getInstance();
        if (mochaConfigurationType == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return mochaConfigurationType;
    }

    @NotNull
    public MochaDetector getTestFrameworkDetector() {
        MochaDetector mochaDetector = MochaDetector.Companion.getInstance();
        if (mochaDetector == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        return mochaDetector;
    }

    private boolean isActiveFor(@NotNull PsiElement element, @NotNull ConfigurationContext context) {
        VirtualFile file;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return false;
        }
        if (this.isTestRunnerAvailableFor(element, context)) {
            return true;
        }
        List<VirtualFile> roots = MochaRunConfigurationProducer.collectMochaTestRoots(element.getProject());
        if (roots.isEmpty()) {
            return false;
        }
        HashSet<VirtualFile> dirs = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            if (root.isDirectory()) {
                dirs.add(root);
                continue;
            }
            if (!root.equals(file)) continue;
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)file, dirs);
    }

    @NotNull
    private static List<VirtualFile> collectMochaTestRoots(@NotNull Project project) {
        if (project == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        List list = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)MochaConfigurationType.getInstance());
        SmartList roots = new SmartList();
        for (RunConfiguration configuration : list) {
            VirtualFile dir;
            if (!(configuration instanceof MochaRunConfiguration)) continue;
            MochaRunSettings settings = ((MochaRunConfiguration)configuration).getRunSettings();
            String path = null;
            if (settings.getTestKind() == MochaTestKind.DIRECTORY) {
                path = settings.getTestDirPath();
            } else if (settings.getTestKind() == MochaTestKind.TEST_FILE || settings.getTestKind() == MochaTestKind.SUITE || settings.getTestKind() == MochaTestKind.TEST) {
                path = settings.getTestFilePath();
            }
            if (StringUtil.isEmptyOrSpaces((String)path) || (dir = LocalFileSystem.getInstance().findFileByPath(path)) == null) continue;
            roots.add(dir);
        }
        SmartList smartList = roots;
        if (smartList == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        String compilerMochaOption;
        PsiElement element;
        if (configuration == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (sourceElement == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        if (!this.isActiveFor(element, context)) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings runSettings = elementRunInfo.getRunSettings();
        if (runSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            return false;
        }
        if (StringUtil.isEmptyOrSpaces((String)runSettings.getExtraMochaOptions()) && (compilerMochaOption = MochaRunConfigurationProducer.getLanguageCompilerMochaOption(runSettings, MochaRunConfigurationProducer.getOriginalPsiFile(element))) != null) {
            runSettings = runSettings.builder().setExtraMochaOptions(compilerMochaOption).build();
        }
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    @Nullable
    private static PsiFile getOriginalPsiFile(@Nullable PsiElement element) {
        PsiFile file = element != null ? element.getContainingFile() : null;
        return file != null ? file.getOriginalFile() : null;
    }

    @Nullable
    private static String getLanguageCompilerMochaOption(@NotNull MochaRunSettings runSettings, @Nullable PsiFile psiFile) {
        String[] mochaConfigPaths;
        if (runSettings == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (!Registry.is((String)"mocha.add.option.require.ts-node/register")) {
            return null;
        }
        if (psiFile == null) {
            return null;
        }
        VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(runSettings.getWorkingDir());
        if (workingDir == null || !workingDir.isValid()) {
            return null;
        }
        VirtualFile packageJsonWithConfig = (VirtualFile)PackageJsonUtil.processUpPackageJsonFilesAndFindFirst((Project)psiFile.getProject(), (VirtualFile)workingDir, packageJson -> PackageJsonData.getOrCreate((VirtualFile)packageJson).getTopLevelProperties().contains("mocha") ? packageJson : null);
        if (packageJsonWithConfig != null) {
            return null;
        }
        for (String mochaOptsPath : mochaConfigPaths = new String[]{".mocharc.js", ".mocharc.cjs", ".mocharc.yaml", ".mocharc.yml", ".mocharc.json", ".mocharc.jsonc", "test/mocha.opts", "mocha.opts"}) {
            VirtualFile mochaConfigFile = workingDir.findFileByRelativePath(mochaOptsPath);
            if (mochaConfigFile == null || !mochaConfigFile.isValid() || mochaConfigFile.isDirectory()) continue;
            return null;
        }
        Project project = psiFile.getProject();
        NodePackage pkg = MochaUtil.getMochaPackage(project);
        if (pkg.getName().equals("mocha-webpack")) {
            return null;
        }
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(psiFile.getFileType()) && MochaRunConfigurationProducer.hasAnyDependencyOn(project, workingDir, "ts-node")) {
            return "--require ts-node/register";
        }
        return null;
    }

    private static boolean hasAnyDependencyOn(@NotNull Project project, @NotNull VirtualFile contextFileOrDir, @NotNull String dependencyName) {
        if (project == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (contextFileOrDir == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (dependencyName == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        Ref result = Ref.create((Object)false);
        PackageJsonUtil.processUpPackageJsonFiles((Project)project, (VirtualFile)contextFileOrDir, packageJson -> {
            PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            if (data.isDependencyOfAnyType(dependencyName)) {
                result.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.get();
    }

    @Nullable
    private static com.intellij.openapi.util.Pair<String, JsTestElementPath> createSuiteOrTestData(@NotNull PsiElement element) {
        JsTestElementPath path;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TextRange textRange = element.getTextRange();
        if (jsFile == null || textRange == null) {
            return null;
        }
        @Nullable Pair<AbstractTestFileStructure, String> testsStructureWithUi = MochaDetector.Companion.getInstance().findTestsStructureWithUi(jsFile);
        if (testsStructureWithUi != null && (path = ((AbstractTestFileStructure)testsStructureWithUi.component1()).findTestElementPath(textRange)) != null) {
            return com.intellij.openapi.util.Pair.create((Object)((String)testsStructureWithUi.component2()), (Object)path);
        }
        return null;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (context == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        TestElementInfo elementRunInfo = MochaRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        MochaRunSettings thisRunSettings = elementRunInfo.getRunSettings();
        MochaRunSettings thatRunSettings = configuration.getRunSettings();
        if (thisRunSettings.getTestKind() != thatRunSettings.getTestKind()) {
            return false;
        }
        MochaTestKind testKind = thisRunSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return thisRunSettings.getTestDirPath().equals(thatRunSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return thisRunSettings.getTestFilePattern().equals(thatRunSettings.getTestFilePattern());
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath());
        }
        if (testKind == MochaTestKind.SUITE) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getSuiteNames().equals(thatRunSettings.getSuiteNames());
        }
        if (testKind == MochaTestKind.TEST) {
            return thisRunSettings.getTestFilePath().equals(thatRunSettings.getTestFilePath()) && thisRunSettings.getTestNames().equals(thatRunSettings.getTestNames());
        }
        return false;
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull MochaRunSettings templateRunSettings) {
        JsTestElementPath testElementPath;
        String testName;
        VirtualFile virtualFile;
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (templateRunSettings == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(17);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        com.intellij.openapi.util.Pair<String, JsTestElementPath> pair = MochaRunConfigurationProducer.createSuiteOrTestData(element);
        if (StringUtil.isEmptyOrSpaces((String)templateRunSettings.getWorkingDir())) {
            String workingDir = MochaRunConfigurationProducer.guessWorkingDir(element.getProject(), virtualFile);
            templateRunSettings = templateRunSettings.builder().setWorkingDir(workingDir).build();
        }
        if (pair == null) {
            return MochaRunConfigurationProducer.createFileInfo(element, virtualFile, templateRunSettings);
        }
        MochaRunSettings.Builder builder = templateRunSettings.builder();
        builder.setTestFilePath(virtualFile.getPath());
        if (templateRunSettings.getUi().isEmpty()) {
            builder.setUi((String)pair.getFirst());
        }
        if ((testName = (testElementPath = (JsTestElementPath)pair.getSecond()).getTestName()) == null) {
            builder.setTestKind(MochaTestKind.SUITE);
            builder.setSuiteNames(testElementPath.getSuiteNames());
        } else {
            builder.setTestKind(MochaTestKind.TEST);
            ArrayList<String> names = new ArrayList<String>(testElementPath.getSuiteNames());
            names.add(testName);
            builder.setTestNames(names);
        }
        return new TestElementInfo(builder.build(), testElementPath.getTestElement());
    }

    @NotNull
    private static String guessWorkingDir(@NotNull Project project, @NotNull VirtualFile contextFile) {
        VirtualFile configFile;
        VirtualFile workingDir;
        if (project == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(18);
        }
        if (contextFile == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(19);
        }
        VirtualFile virtualFile = workingDir = (configFile = JSProjectUtil.findFileUpToContentRoot((Project)project, (VirtualFile)contextFile, (String[])new String[]{"package.json"})) != null ? configFile.getParent() : null;
        if (workingDir == null) {
            workingDir = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(contextFile);
        }
        if (workingDir == null) {
            workingDir = contextFile.getParent();
        }
        return workingDir != null ? FileUtil.toSystemDependentName((String)workingDir.getPath()) : "";
    }

    @Nullable
    private static TestElementInfo createFileInfo(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull MochaRunSettings templateRunSettings) {
        if (element == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(21);
        }
        if (templateRunSettings == null) {
            MochaRunConfigurationProducer.$$$reportNull$$$0(22);
        }
        if (virtualFile.isDirectory()) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.DIRECTORY);
            builder.setTestDirPath(virtualFile.getPath());
            return new TestElementInfo(builder.build(), element);
        }
        JSFile psiFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        if (psiFile != null && MochaDetector.Companion.getInstance().hasTestsInFile(psiFile)) {
            MochaRunSettings.Builder builder = templateRunSettings.builder();
            builder.setTestKind(MochaTestKind.TEST_FILE);
            builder.setTestFilePath(virtualFile.getPath());
            if (templateRunSettings.getUi().isEmpty()) {
                String ui = MochaDetector.Companion.getInstance().findTestStructureUi(psiFile);
                builder.setUi((String)ObjectUtils.notNull((Object)ui, (Object)"bdd"));
            }
            return new TestElementInfo(builder.build(), (PsiElement)psiFile);
        }
        return null;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        PreferableRunConfiguration otherRc;
        return other == null || (otherRc = (PreferableRunConfiguration)ObjectUtils.tryCast((Object)other.getConfiguration(), PreferableRunConfiguration.class)) == null || !otherRc.isPreferredOver(self.getConfiguration(), self.getSourceElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer";
                break;
            }
            case 2: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFileOrDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFrameworkDetector";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMochaTestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isActiveFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectMochaTestRoots";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageCompilerMochaOption";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyDependencyOn";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSuiteOrTestData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createTestElementRunInfo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDir";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }

    private static class TestElementInfo {
        private final MochaRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        TestElementInfo(@NotNull MochaRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                TestElementInfo.$$$reportNull$$$0(0);
            }
            if (enclosingTestElement == null) {
                TestElementInfo.$$$reportNull$$$0(1);
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public MochaRunSettings getRunSettings() {
            MochaRunSettings mochaRunSettings = this.myRunSettings;
            if (mochaRunSettings == null) {
                TestElementInfo.$$$reportNull$$$0(2);
            }
            return mochaRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                TestElementInfo.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingTestElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer$TestElementInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingTestElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

