/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.diagnostics.actions;

import com.intellij.ml.diagnostics.DiagnosticsBundle;
import com.intellij.ml.diagnostics.DiagnosticsToggles;
import com.intellij.ml.diagnostics.MLDiagnosticsIcons;
import com.intellij.ml.diagnostics.ui.DiagnosticsToolWindowFactory;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/diagnostics/actions/MLDiagnosticsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "registerToolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "intellij.ml.diagnostics"})
public final class MLDiagnosticsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && DiagnosticsToggles.INSTANCE.isEnabled());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project3);
        ToolWindow toolWindow = toolWindowManager.getToolWindow("ML Diagnostics");
        if (toolWindow == null) {
            this.registerToolwindow(toolWindowManager).activate(MLDiagnosticsAction::actionPerformed$lambda$0);
        } else {
            toolWindow.activate(MLDiagnosticsAction::actionPerformed$lambda$1);
        }
    }

    private final ToolWindow registerToolwindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.BOTTOM;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"BOTTOM");
        ToolWindowAnchor toolWindowAnchor2 = toolWindowAnchor;
        Icon icon = MLDiagnosticsIcons.FullLine;
        DiagnosticsToolWindowFactory diagnosticsToolWindowFactory = new DiagnosticsToolWindowFactory();
        Supplier<String> supplier = DiagnosticsBundle.messagePointer("action.MLCompletionDiagnostics.text", new Object[0]);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask("ML Diagnostics", toolWindowAnchor2, null, false, false, false, false, (ToolWindowFactory)diagnosticsToolWindowFactory, icon, supplier, 104, null));
        return toolWindow;
    }

    private static final void actionPerformed$lambda$0() {
    }

    private static final void actionPerformed$lambda$1() {
    }
}

