/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 107414277797655L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1440721440 - -30852, -1440721440 - -((char)-23629), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1440721440 - -30853, -1440721440 - -15757, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 5597531912481L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.h();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1189591320 - -((char)-1688), 1189591320 - (char)-13272, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1189591320 - -((char)-1687), -1189460250 + -((char)-1574), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1189591320 - -((char)-1682), 1189591320 - (char)-4230, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 96162536138252L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.h();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(1781634510 - 13908, 1781634510 - 31413, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1781634510 - 13909, -1781634510 - -9337, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1781634510 - 13910, 1781634510 - (char)-28180, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1781634510 - 13911, -1781634510 - -((char)-31592), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1781634510 - 13912, -1781634510 - -16107, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1781634510 - 13913, 1781634510 - 12440, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1781634510 - 13911, -1781634510 - -((char)-31592), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1781634510 - 13914, -1781634510 - -28841, (int)l2));
            if (ActionTimestamp.h() == null) {
                SshAgentIpcService.h("jPIpxc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 6924758105400L;
                    string = SshAgentIpcService.h();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 10990915786653L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = SshAgentIpcService.h();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-94501470 - -26944, -94501470 - -25512, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26945, 94501470 - 12069, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26942, -94501470 - -6690, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-94501470 - -26944, -94501470 - -25512, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26943, 94501470 - 3690, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-94501470 - -26944, -94501470 - -25512, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26972, -94501470 - -6884, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26973, 94501470 - 24080, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26942, -94501470 - -6690, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-94501470 - -26944, -94501470 - -25512, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-94501470 - -26948, 94501470 - 6915, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-94501470 - -26970, -94501470 - -11598, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 92342345286621L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(548396880 + 11501, 548396880 + 21167, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 136455866636798L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(460711050 - (char)-12693, -460711050 - -((char)-26626), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u001f\u0013eL\u00c0\u0083r\u00e2\u0005\u0080E\u0014\u00ef\u009a\u0000~Q\u00a4s\u0014\u00a4X\u0012#5\u00ac\u00b1\u0082\u00ff\u008a\u00df\u0081~\u00d1\u00f3\u009c\u00c2>\u0006\u001f";
                        var4_3 = "\u001f\u0013eL\u00c0\u0083r\u00e2\u0005\u0080E\u0014\u00ef\u009a\u0000~Q\u00a4s\u0014\u00a4X\u0012#5\u00ac\u00b1\u0082\u00ff\u008a\u00df\u0081~\u00d1\u00f3\u009c\u00c2>\u0006\u001f".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 59;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 72;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 31;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 7;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 17;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 39;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 100;
                                        break;
                                    }
                                    default: {
                                        v11 = 4;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x4FE0) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 5;
                            case 1 -> 38;
                            case 2 -> 133;
                            case 3 -> 116;
                            case 4 -> 255;
                            case 5 -> 219;
                            case 6 -> 118;
                            case 7 -> 55;
                            case 8 -> 251;
                            case 9 -> 79;
                            case 10 -> 40;
                            case 11 -> 30;
                            case 12 -> 6;
                            case 13 -> 113;
                            case 14 -> 218;
                            case 15 -> 70;
                            case 16 -> 128;
                            case 17 -> 154;
                            case 18 -> 34;
                            case 19 -> 185;
                            case 20 -> 87;
                            case 21 -> 217;
                            case 22 -> 3;
                            case 23 -> 181;
                            case 24 -> 183;
                            case 25 -> 215;
                            case 26 -> 96;
                            case 27 -> 149;
                            case 28 -> 148;
                            case 29 -> 26;
                            case 30 -> 222;
                            case 31 -> 7;
                            case 32 -> 44;
                            case 33 -> 43;
                            case 34 -> 223;
                            case 35 -> 254;
                            case 36 -> 98;
                            case 37 -> 193;
                            case 38 -> 151;
                            case 39 -> 196;
                            case 40 -> 36;
                            case 41 -> 110;
                            case 42 -> 111;
                            case 43 -> 13;
                            case 44 -> 140;
                            case 45 -> 237;
                            case 46 -> 91;
                            case 47 -> 173;
                            case 48 -> 125;
                            case 49 -> 245;
                            case 50 -> 250;
                            case 51 -> 85;
                            case 52 -> 56;
                            case 53 -> 27;
                            case 54 -> 137;
                            case 55 -> 135;
                            case 56 -> 60;
                            case 57 -> 58;
                            case 58 -> 207;
                            case 59 -> 153;
                            case 60 -> 182;
                            case 61 -> 208;
                            case 62 -> 129;
                            case 63 -> 169;
                            case 64 -> 12;
                            case 65 -> 122;
                            case 66 -> 57;
                            case 67 -> 1;
                            case 68 -> 94;
                            case 69 -> 119;
                            case 70 -> 184;
                            case 71 -> 252;
                            case 72 -> 100;
                            case 73 -> 232;
                            case 74 -> 64;
                            case 75 -> 195;
                            case 76 -> 82;
                            case 77 -> 213;
                            case 78 -> 248;
                            case 79 -> 211;
                            case 80 -> 77;
                            case 81 -> 123;
                            case 82 -> 240;
                            case 83 -> 20;
                            case 84 -> 117;
                            case 85 -> 178;
                            case 86 -> 174;
                            case 87 -> 130;
                            case 88 -> 236;
                            case 89 -> 16;
                            case 90 -> 47;
                            case 91 -> 253;
                            case 92 -> 212;
                            case 93 -> 172;
                            case 94 -> 227;
                            case 95 -> 92;
                            case 96 -> 59;
                            case 97 -> 83;
                            case 98 -> 84;
                            case 99 -> 72;
                            case 100 -> 230;
                            case 101 -> 242;
                            case 102 -> 179;
                            case 103 -> 15;
                            case 104 -> 216;
                            case 105 -> 71;
                            case 106 -> 152;
                            case 107 -> 17;
                            case 108 -> 32;
                            case 109 -> 69;
                            case 110 -> 18;
                            case 111 -> 90;
                            case 112 -> 25;
                            case 113 -> 78;
                            case 114 -> 204;
                            case 115 -> 202;
                            case 116 -> 4;
                            case 117 -> 191;
                            case 118 -> 89;
                            case 119 -> 106;
                            case 120 -> 163;
                            case 121 -> 141;
                            case 122 -> 62;
                            case 123 -> 171;
                            case 124 -> 226;
                            case 125 -> 21;
                            case 126 -> 186;
                            case 127 -> 147;
                            case 128 -> 247;
                            case 129 -> 158;
                            case 130 -> 39;
                            case 131 -> 102;
                            case 132 -> 155;
                            case 133 -> 188;
                            case 134 -> 239;
                            case 135 -> 249;
                            case 136 -> 187;
                            case 137 -> 139;
                            case 138 -> 9;
                            case 139 -> 120;
                            case 140 -> 159;
                            case 141 -> 144;
                            case 142 -> 61;
                            case 143 -> 103;
                            case 144 -> 8;
                            case 145 -> 86;
                            case 146 -> 112;
                            case 147 -> 241;
                            case 148 -> 76;
                            case 149 -> 175;
                            case 150 -> 234;
                            case 151 -> 68;
                            case 152 -> 10;
                            case 153 -> 214;
                            case 154 -> 165;
                            case 155 -> 14;
                            case 156 -> 177;
                            case 157 -> 167;
                            case 158 -> 22;
                            case 159 -> 189;
                            case 160 -> 190;
                            case 161 -> 246;
                            case 162 -> 233;
                            case 163 -> 131;
                            case 164 -> 157;
                            case 165 -> 156;
                            case 166 -> 97;
                            case 167 -> 28;
                            case 168 -> 42;
                            case 169 -> 81;
                            case 170 -> 164;
                            case 171 -> 206;
                            case 172 -> 243;
                            case 173 -> 46;
                            case 174 -> 41;
                            case 175 -> 231;
                            case 176 -> 99;
                            case 177 -> 221;
                            case 178 -> 205;
                            case 179 -> 31;
                            case 180 -> 161;
                            case 181 -> 19;
                            case 182 -> 74;
                            case 183 -> 63;
                            case 184 -> 54;
                            case 185 -> 29;
                            case 186 -> 121;
                            case 187 -> 115;
                            case 188 -> 238;
                            case 189 -> 104;
                            case 190 -> 176;
                            case 191 -> 0;
                            case 192 -> 107;
                            case 193 -> 11;
                            case 194 -> 24;
                            case 195 -> 126;
                            case 196 -> 114;
                            case 197 -> 166;
                            case 198 -> 146;
                            case 199 -> 93;
                            case 200 -> 228;
                            case 201 -> 142;
                            case 202 -> 75;
                            case 203 -> 220;
                            case 204 -> 2;
                            case 205 -> 33;
                            case 206 -> 194;
                            case 207 -> 138;
                            case 208 -> 199;
                            case 209 -> 180;
                            case 210 -> 235;
                            case 211 -> 65;
                            case 212 -> 198;
                            case 213 -> 52;
                            case 214 -> 23;
                            case 215 -> 209;
                            case 216 -> 150;
                            case 217 -> 200;
                            case 218 -> 67;
                            case 219 -> 136;
                            case 220 -> 224;
                            case 221 -> 109;
                            case 222 -> 160;
                            case 223 -> 201;
                            case 224 -> 225;
                            case 225 -> 170;
                            case 226 -> 132;
                            case 227 -> 192;
                            case 228 -> 101;
                            case 229 -> 45;
                            case 230 -> 210;
                            case 231 -> 35;
                            case 232 -> 48;
                            case 233 -> 197;
                            case 234 -> 134;
                            case 235 -> 244;
                            case 236 -> 50;
                            case 237 -> 49;
                            case 238 -> 108;
                            case 239 -> 168;
                            case 240 -> 95;
                            case 241 -> 51;
                            case 242 -> 229;
                            case 243 -> 203;
                            case 244 -> 105;
                            case 245 -> 73;
                            case 246 -> 162;
                            case 247 -> 37;
                            case 248 -> 127;
                            case 249 -> 124;
                            case 250 -> 143;
                            case 251 -> 53;
                            case 252 -> 88;
                            case 253 -> 66;
                            case 254 -> 80;
                            default -> 145;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.h("g4DAvc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 42784418555758L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.h();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26625, 2045609490 + (char)-27737, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26621, -2045609490 + -((char)-13754), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26628, -2045609490 + -((char)-12390), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26625, 2045609490 + (char)-27737, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26621, -2045609490 + -((char)-13754), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(2045609490 + (char)-26633, -2045609490 + -((char)-24917), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 27266590148161L;
                        String string3 = SshAgentIpcService.h();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-2137751700 + -69, 2137751700 + 28830, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-2137751700 + -72, 2137751700 + 24403, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 114387908613542L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.h();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10801), -44563800 + -((char)-10441), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10805), 44563800 + (char)-24568, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10778), -44563800 + -((char)-25200), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10805), 44563800 + (char)-24568, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10803), -44563800 + -((char)-23383), (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10801), -44563800 + -((char)-10441), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10805), 44563800 + (char)-24568, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10789), -44563800 + -((char)-6516), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10801), -44563800 + -((char)-10441), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10805), 44563800 + (char)-24568, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10788), -44563800 + -((char)-17727), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10801), -44563800 + -((char)-10441), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10805), 44563800 + (char)-24568, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-44563800 + -((char)-10791), -44563800 + -((char)-17183), (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 37279911919195L;
                    Object object = this.lock;
                    string = SshAgentIpcService.h();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8388, 404219880 - 10076, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(404219880 - 8392, -404219880 - -24197, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(404219880 - 8373, 404219880 + 4672, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(404219880 - 8372, -404219880 - -20333, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8388, 404219880 - 10076, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(404219880 - 8392, -404219880 - -24197, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(404219880 - 8371, 404219880 - 24041, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8388, 404219880 - 10076, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(404219880 - 8392, -404219880 - -24197, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(404219880 - 8370, -404219880 - -8274, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8388, 404219880 - 10076, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(404219880 - 8392, -404219880 - -24197, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(404219880 - 8369, 404219880 + 5372, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8388, 404219880 - 10076, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(404219880 - 8392, -404219880 - -24197, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(404219880 - 8416, -404219880 - -326, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(404219880 - 8415, 404219880 - 15584, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "2cJ\u009a\u0006m\b\u00e7\u0014\u00f4/\u00aa\u00f4\u00e4(\u00fbU\u00f0]\u00c6\u00e7\u0085\u0093E\u00c2__\u00b6\u00fd\u0006\u00af\f\u00f9w\u001a\u0091\u0018T\u00cc\u00de\u00b8\u00e8dx\u001cH\t\u00de\u001d\u00e03\u00bbT)\u00e4V\u0017\u0091\u00e7\u00a7\n\t<eM<\u00f1kC\u00b5\u0013\u0005#\u0094hd2\b\u00f7j\u00f2\u00caCA\u00a6\u0080\u0014e+\u00e0\u00ef\u00c0CJ\u00af\u00a8\u00dff\u0003\u00db\u00ac5\u00c8C\u00cd\u00cc\u00ed\u0005\u00d6G\u00d6\u001e\u00e5\u001eiw4|$8C\u00ed\u008a#\u00cd\u00df\u00ceK\u00dc?$\u0018%|S\u00a5\u00f3\u008f\u00f1\u00187\u00b6\u00c7b\u0010\u00ae3(1\u00f0\u00a3/gz\u00c0^^\u00ba.\u00fd\f\t}\u00cc\u00b3\u0018}\u00c8\u00f4^\u000b\u0010;f\u009a\u009b\u00a6\u00f6\u00e5\u00cd#\u0095u\u00f4\u00df{Q\u00a6?\u00f6\"\u00cf\u00d6Vd\u0088\n\u0082\u000e\u0089\u0081\u00f9v\u0007\u00a1\u009a\u00ae\u008fo\u0088\u0095\u00f3\u00ef\u00e1\u00fc8\u009e\u00111\u00a7\u00a77=H\u00a8\u0090\u00fc\u00b6\u00dd\u00cf\u00f6\\\u0090\u00e8\u00e6\u00b0\u009dRG\u0006\u00c4}\u0086\u0084f%_\u00f6@1\u00b6\u0007\b\u001c\u00f1\u008f\u00b9\u00ec/SM\f\u0081j,\u00d1\u0085@\u0090\u00a7\u00a4\u0090\u00d7PFO\u00b7\u00f5j\u00be7\u00f7IHA@\u00aeV\u009b\u00ed:;\u00ba\u00bbB\u001cbb#\u00e5NK\u00c3\u00c0\u00b3\u00a7\u00cb\u000b\u0006\r\u00ee\u00e2yS\u00a9\u00e0m2\u0018\u00fbr\u0086rsBD\u00ce\u00daQf\u0087\u00e6\u0017\u0018\u00f5\u00dfi\u0086\u00a8\u00f3\u00b30\u0096\u00ba\u0015\u001f\t\u00cd8+\u00a5\u00d2s\u00b0\u008c\u0088\r\u00aa\u00d6\u00f8\u00d4\u00f8^\b\u0017\u00b4\u00de<\u0095\u0017\\\u00db\u0095\u0002\u008e\u0005l\u000b\u00a3whr\r4\u0081)\u0086M\u0099\u0015-\u000e\u00b9^0\u00d9\u00ca\u00e9\u00d1\u00b5\u00bb\u00c6\u00be\u00d9\u00c4\u008a\u00a7\u00d2\u00f5\u0096\u00b4)\u000f\u00e4\u00f8\u000e\u00bdvp$\u00ec\u001a\u0001\u00f8S\u00b8\u00fa\u00f5\u00c4!\u009f6?\u0014o\nl1D'\u009bUL)\u0088\u00ff\u001b\\>2CiA\u0007\u00e2\u00e2O\u00d4op\u00b1\u0007Y*\\\u00a1\u00ea1\u0017(\u00fb\u00a2*\u00e7W!\u00db\u00e9\u00e9t\u008b\u0003!F\u00f6\u00a9B\u0007\u00e1\u00b1\u0091\u00da\u00d5\u0018\u00ab\u00cf\n\u0083e\u00a1H\u00ae\u00f3d\u00ea\u0082\u00ba\u0094@N\u000f\u000e\u00e3\u00da\u00e6\u00a1m\u00a0\u00a3\u00f3\u00b0i\u00ca\u00dd+\u00f7\"k\u0006tR,\u00fdBU\u00aa4\u00c9=I\f\u00dd\u00ad\u00cb\u0003\u00f40\u00b8\u00d4?B\u00f5l\u00baR`\u00c9\u0091\u00bd\u001d\u009e\u000e\u0093pi\u0094\u00d7#nj*\u0089R\u00ed\u00b6\u00c5\u001b\u00acO\u0089v0\u00ca\u0007\u000bP\"\u0090\u0099\u00be}\u0005\u0095x\u00ae?\u0019\u00fa\u00c5\u0004\u00c6\u00d9\u0091j\nz\u00f5\u0097&\u00e7$.\u00fc\u00de\u00be\u0018\u00c4\u00b5\u0084$\u0090<2\u008b\u00e8\u00fbE=\u00bd\u00ba\u0099L\u009c\u0094t'\u00ebI}\u0004)\u0016%\u00db6\u00d9q\u00fc\u00c4}\u00063{\u0011\u00c1-\u00a1@\u00de\u00d0\f\u00ecC\\\u00ec\u007f\u007f\u00bb\u00027\u00adb\u00a7h\u00f0\u00d2)\u00d9\u00b8\u00bf8\u00de\t\u00ce\u00df\u00c5d\u00b9\u0088:\ro";
                var4_3 = "2cJ\u009a\u0006m\b\u00e7\u0014\u00f4/\u00aa\u00f4\u00e4(\u00fbU\u00f0]\u00c6\u00e7\u0085\u0093E\u00c2__\u00b6\u00fd\u0006\u00af\f\u00f9w\u001a\u0091\u0018T\u00cc\u00de\u00b8\u00e8dx\u001cH\t\u00de\u001d\u00e03\u00bbT)\u00e4V\u0017\u0091\u00e7\u00a7\n\t<eM<\u00f1kC\u00b5\u0013\u0005#\u0094hd2\b\u00f7j\u00f2\u00caCA\u00a6\u0080\u0014e+\u00e0\u00ef\u00c0CJ\u00af\u00a8\u00dff\u0003\u00db\u00ac5\u00c8C\u00cd\u00cc\u00ed\u0005\u00d6G\u00d6\u001e\u00e5\u001eiw4|$8C\u00ed\u008a#\u00cd\u00df\u00ceK\u00dc?$\u0018%|S\u00a5\u00f3\u008f\u00f1\u00187\u00b6\u00c7b\u0010\u00ae3(1\u00f0\u00a3/gz\u00c0^^\u00ba.\u00fd\f\t}\u00cc\u00b3\u0018}\u00c8\u00f4^\u000b\u0010;f\u009a\u009b\u00a6\u00f6\u00e5\u00cd#\u0095u\u00f4\u00df{Q\u00a6?\u00f6\"\u00cf\u00d6Vd\u0088\n\u0082\u000e\u0089\u0081\u00f9v\u0007\u00a1\u009a\u00ae\u008fo\u0088\u0095\u00f3\u00ef\u00e1\u00fc8\u009e\u00111\u00a7\u00a77=H\u00a8\u0090\u00fc\u00b6\u00dd\u00cf\u00f6\\\u0090\u00e8\u00e6\u00b0\u009dRG\u0006\u00c4}\u0086\u0084f%_\u00f6@1\u00b6\u0007\b\u001c\u00f1\u008f\u00b9\u00ec/SM\f\u0081j,\u00d1\u0085@\u0090\u00a7\u00a4\u0090\u00d7PFO\u00b7\u00f5j\u00be7\u00f7IHA@\u00aeV\u009b\u00ed:;\u00ba\u00bbB\u001cbb#\u00e5NK\u00c3\u00c0\u00b3\u00a7\u00cb\u000b\u0006\r\u00ee\u00e2yS\u00a9\u00e0m2\u0018\u00fbr\u0086rsBD\u00ce\u00daQf\u0087\u00e6\u0017\u0018\u00f5\u00dfi\u0086\u00a8\u00f3\u00b30\u0096\u00ba\u0015\u001f\t\u00cd8+\u00a5\u00d2s\u00b0\u008c\u0088\r\u00aa\u00d6\u00f8\u00d4\u00f8^\b\u0017\u00b4\u00de<\u0095\u0017\\\u00db\u0095\u0002\u008e\u0005l\u000b\u00a3whr\r4\u0081)\u0086M\u0099\u0015-\u000e\u00b9^0\u00d9\u00ca\u00e9\u00d1\u00b5\u00bb\u00c6\u00be\u00d9\u00c4\u008a\u00a7\u00d2\u00f5\u0096\u00b4)\u000f\u00e4\u00f8\u000e\u00bdvp$\u00ec\u001a\u0001\u00f8S\u00b8\u00fa\u00f5\u00c4!\u009f6?\u0014o\nl1D'\u009bUL)\u0088\u00ff\u001b\\>2CiA\u0007\u00e2\u00e2O\u00d4op\u00b1\u0007Y*\\\u00a1\u00ea1\u0017(\u00fb\u00a2*\u00e7W!\u00db\u00e9\u00e9t\u008b\u0003!F\u00f6\u00a9B\u0007\u00e1\u00b1\u0091\u00da\u00d5\u0018\u00ab\u00cf\n\u0083e\u00a1H\u00ae\u00f3d\u00ea\u0082\u00ba\u0094@N\u000f\u000e\u00e3\u00da\u00e6\u00a1m\u00a0\u00a3\u00f3\u00b0i\u00ca\u00dd+\u00f7\"k\u0006tR,\u00fdBU\u00aa4\u00c9=I\f\u00dd\u00ad\u00cb\u0003\u00f40\u00b8\u00d4?B\u00f5l\u00baR`\u00c9\u0091\u00bd\u001d\u009e\u000e\u0093pi\u0094\u00d7#nj*\u0089R\u00ed\u00b6\u00c5\u001b\u00acO\u0089v0\u00ca\u0007\u000bP\"\u0090\u0099\u00be}\u0005\u0095x\u00ae?\u0019\u00fa\u00c5\u0004\u00c6\u00d9\u0091j\nz\u00f5\u0097&\u00e7$.\u00fc\u00de\u00be\u0018\u00c4\u00b5\u0084$\u0090<2\u008b\u00e8\u00fbE=\u00bd\u00ba\u0099L\u009c\u0094t'\u00ebI}\u0004)\u0016%\u00db6\u00d9q\u00fc\u00c4}\u00063{\u0011\u00c1-\u00a1@\u00de\u00d0\f\u00ecC\\\u00ec\u007f\u007f\u00bb\u00027\u00adb\u00a7h\u00f0\u00d2)\u00d9\u00b8\u00bf8\u00de\t\u00ce\u00df\u00c5d\u00b9\u0088:\ro".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 64;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f6\b=i\u00ff`\u00c2\u001c@\u00e7n\u00bd@\u00e3\u00fd\u001f\u00a0\u00fffV\u0095\u00cdz\u0019\u00ea'b\u00b6f\u0014\u00c5\u0086v;\u0085+-\u00cf\u00d0\u00f48(\u00a0\u0090\u001bXn\u00f6j2";
                    var4_3 = "\u00f6\b=i\u00ff`\u00c2\u001c@\u00e7n\u00bd@\u00e3\u00fd\u001f\u00a0\u00fffV\u0095\u00cdz\u0019\u00ea'b\u00b6f\u0014\u00c5\u0086v;\u0085+-\u00cf\u00d0\u00f48(\u00a0\u0090\u001bXn\u00f6j2".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 52;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 1;
                            break;
                        }
                        case 1: {
                            v15 = 7;
                            break;
                        }
                        case 2: {
                            v15 = 106;
                            break;
                        }
                        case 3: {
                            v15 = 127;
                            break;
                        }
                        case 4: {
                            v15 = 100;
                            break;
                        }
                        case 5: {
                            v15 = 49;
                            break;
                        }
                        default: {
                            v15 = 34;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFF973) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 85;
                case 1 -> 213;
                case 2 -> 239;
                case 3 -> 139;
                case 4 -> 45;
                case 5 -> 130;
                case 6 -> 17;
                case 7 -> 195;
                case 8 -> 18;
                case 9 -> 254;
                case 10 -> 64;
                case 11 -> 252;
                case 12 -> 56;
                case 13 -> 201;
                case 14 -> 231;
                case 15 -> 92;
                case 16 -> 165;
                case 17 -> 159;
                case 18 -> 88;
                case 19 -> 226;
                case 20 -> 220;
                case 21 -> 248;
                case 22 -> 243;
                case 23 -> 83;
                case 24 -> 59;
                case 25 -> 33;
                case 26 -> 52;
                case 27 -> 21;
                case 28 -> 214;
                case 29 -> 215;
                case 30 -> 73;
                case 31 -> 46;
                case 32 -> 31;
                case 33 -> 89;
                case 34 -> 190;
                case 35 -> 123;
                case 36 -> 135;
                case 37 -> 217;
                case 38 -> 230;
                case 39 -> 146;
                case 40 -> 255;
                case 41 -> 212;
                case 42 -> 49;
                case 43 -> 163;
                case 44 -> 28;
                case 45 -> 101;
                case 46 -> 142;
                case 47 -> 79;
                case 48 -> 131;
                case 49 -> 145;
                case 50 -> 132;
                case 51 -> 91;
                case 52 -> 100;
                case 53 -> 105;
                case 54 -> 53;
                case 55 -> 5;
                case 56 -> 191;
                case 57 -> 90;
                case 58 -> 120;
                case 59 -> 199;
                case 60 -> 209;
                case 61 -> 183;
                case 62 -> 119;
                case 63 -> 179;
                case 64 -> 96;
                case 65 -> 43;
                case 66 -> 34;
                case 67 -> 71;
                case 68 -> 147;
                case 69 -> 164;
                case 70 -> 118;
                case 71 -> 93;
                case 72 -> 97;
                case 73 -> 67;
                case 74 -> 208;
                case 75 -> 19;
                case 76 -> 82;
                case 77 -> 177;
                case 78 -> 185;
                case 79 -> 69;
                case 80 -> 234;
                case 81 -> 176;
                case 82 -> 60;
                case 83 -> 162;
                case 84 -> 184;
                case 85 -> 193;
                case 86 -> 133;
                case 87 -> 196;
                case 88 -> 16;
                case 89 -> 77;
                case 90 -> 143;
                case 91 -> 232;
                case 92 -> 20;
                case 93 -> 242;
                case 94 -> 148;
                case 95 -> 102;
                case 96 -> 50;
                case 97 -> 224;
                case 98 -> 3;
                case 99 -> 168;
                case 100 -> 172;
                case 101 -> 134;
                case 102 -> 109;
                case 103 -> 75;
                case 104 -> 66;
                case 105 -> 15;
                case 106 -> 4;
                case 107 -> 225;
                case 108 -> 228;
                case 109 -> 238;
                case 110 -> 244;
                case 111 -> 194;
                case 112 -> 187;
                case 113 -> 181;
                case 114 -> 245;
                case 115 -> 129;
                case 116 -> 152;
                case 117 -> 200;
                case 118 -> 171;
                case 119 -> 81;
                case 120 -> 206;
                case 121 -> 237;
                case 122 -> 186;
                case 123 -> 57;
                case 124 -> 106;
                case 125 -> 110;
                case 126 -> 158;
                case 127 -> 227;
                case 128 -> 250;
                case 129 -> 63;
                case 130 -> 233;
                case 131 -> 192;
                case 132 -> 84;
                case 133 -> 229;
                case 134 -> 150;
                case 135 -> 44;
                case 136 -> 144;
                case 137 -> 216;
                case 138 -> 8;
                case 139 -> 47;
                case 140 -> 221;
                case 141 -> 141;
                case 142 -> 153;
                case 143 -> 10;
                case 144 -> 22;
                case 145 -> 115;
                case 146 -> 207;
                case 147 -> 107;
                case 148 -> 125;
                case 149 -> 175;
                case 150 -> 136;
                case 151 -> 223;
                case 152 -> 58;
                case 153 -> 182;
                case 154 -> 9;
                case 155 -> 108;
                case 156 -> 197;
                case 157 -> 140;
                case 158 -> 116;
                case 159 -> 104;
                case 160 -> 246;
                case 161 -> 113;
                case 162 -> 180;
                case 163 -> 160;
                case 164 -> 40;
                case 165 -> 236;
                case 166 -> 14;
                case 167 -> 155;
                case 168 -> 13;
                case 169 -> 37;
                case 170 -> 114;
                case 171 -> 251;
                case 172 -> 241;
                case 173 -> 124;
                case 174 -> 26;
                case 175 -> 74;
                case 176 -> 78;
                case 177 -> 240;
                case 178 -> 0;
                case 179 -> 203;
                case 180 -> 219;
                case 181 -> 126;
                case 182 -> 27;
                case 183 -> 23;
                case 184 -> 6;
                case 185 -> 30;
                case 186 -> 36;
                case 187 -> 205;
                case 188 -> 68;
                case 189 -> 48;
                case 190 -> 161;
                case 191 -> 86;
                case 192 -> 111;
                case 193 -> 137;
                case 194 -> 103;
                case 195 -> 12;
                case 196 -> 41;
                case 197 -> 173;
                case 198 -> 249;
                case 199 -> 189;
                case 200 -> 2;
                case 201 -> 253;
                case 202 -> 112;
                case 203 -> 39;
                case 204 -> 76;
                case 205 -> 218;
                case 206 -> 11;
                case 207 -> 35;
                case 208 -> 210;
                case 209 -> 62;
                case 210 -> 121;
                case 211 -> 1;
                case 212 -> 54;
                case 213 -> 99;
                case 214 -> 211;
                case 215 -> 204;
                case 216 -> 169;
                case 217 -> 87;
                case 218 -> 98;
                case 219 -> 80;
                case 220 -> 128;
                case 221 -> 167;
                case 222 -> 70;
                case 223 -> 138;
                case 224 -> 65;
                case 225 -> 42;
                case 226 -> 149;
                case 227 -> 94;
                case 228 -> 55;
                case 229 -> 24;
                case 230 -> 202;
                case 231 -> 61;
                case 232 -> 235;
                case 233 -> 127;
                case 234 -> 174;
                case 235 -> 157;
                case 236 -> 247;
                case 237 -> 156;
                case 238 -> 51;
                case 239 -> 178;
                case 240 -> 154;
                case 241 -> 25;
                case 242 -> 198;
                case 243 -> 151;
                case 244 -> 95;
                case 245 -> 32;
                case 246 -> 166;
                case 247 -> 222;
                case 248 -> 72;
                case 249 -> 188;
                case 250 -> 29;
                case 251 -> 170;
                case 252 -> 117;
                case 253 -> 7;
                case 254 -> 38;
                default -> 122;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 52423349475831L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1021297440 + -((char)-31108), 1021297440 + 32690, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 33766335674532L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.h();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-697161330 + -((char)-11688), -697161330 + -((char)-1606), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-697161330 + -((char)-11687), 697292400 - (char)-431, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-697161330 + -((char)-11686), -697161330 + -((char)-13051), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "H!&%\u008f\u00d4\u001e\u00db\u0010AP\u00f6\u00aa/\u009e\u00f3\u00cb\u009av\u00b5\u008c\u0089S\u0090\u00d8";
                    var4_3 = "H!&%\u008f\u00d4\u001e\u00db\u0010AP\u00f6\u00aa/\u009e\u00f3\u00cb\u009av\u00b5\u008c\u0089S\u0090\u00d8".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 65;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = ">:\u0012\u00bc\u00835H\u0011\u00cb\u00b5j\u00be\u00b9\u009e^\u009dE\u00cb\u009a\u00ab\r\u00b7\u001c\u00a86\u008a~]\u0000{\u00f3?\u00d1\u0011Mq$\u00e5E}\u00df\u0010&\u0018)\u00d48%\u00c4\u0083wbO+\u00c4\u0096F\u0002=";
                        var4_3 = ">:\u0012\u00bc\u00835H\u0011\u00cb\u00b5j\u00be\u00b9\u009e^\u009dE\u00cb\u009a\u00ab\r\u00b7\u001c\u00a86\u008a~]\u0000{\u00f3?\u00d1\u0011Mq$\u00e5E}\u00df\u0010&\u0018)\u00d48%\u00c4\u0083wbO+\u00c4\u0096F\u0002=".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 53;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 2;
                                break;
                            }
                            case 1: {
                                v15 = 56;
                                break;
                            }
                            case 2: {
                                v15 = 8;
                                break;
                            }
                            case 3: {
                                v15 = 78;
                                break;
                            }
                            case 4: {
                                v15 = 13;
                                break;
                            }
                            case 5: {
                                v15 = 120;
                                break;
                            }
                            default: {
                                v15 = 9;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2F93) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 224;
                    case 1 -> 169;
                    case 2 -> 11;
                    case 3 -> 10;
                    case 4 -> 156;
                    case 5 -> 187;
                    case 6 -> 241;
                    case 7 -> 153;
                    case 8 -> 199;
                    case 9 -> 66;
                    case 10 -> 226;
                    case 11 -> 170;
                    case 12 -> 126;
                    case 13 -> 150;
                    case 14 -> 172;
                    case 15 -> 248;
                    case 16 -> 8;
                    case 17 -> 25;
                    case 18 -> 107;
                    case 19 -> 79;
                    case 20 -> 185;
                    case 21 -> 208;
                    case 22 -> 180;
                    case 23 -> 166;
                    case 24 -> 38;
                    case 25 -> 249;
                    case 26 -> 100;
                    case 27 -> 140;
                    case 28 -> 158;
                    case 29 -> 59;
                    case 30 -> 85;
                    case 31 -> 193;
                    case 32 -> 22;
                    case 33 -> 34;
                    case 34 -> 201;
                    case 35 -> 149;
                    case 36 -> 129;
                    case 37 -> 221;
                    case 38 -> 75;
                    case 39 -> 228;
                    case 40 -> 36;
                    case 41 -> 24;
                    case 42 -> 93;
                    case 43 -> 243;
                    case 44 -> 17;
                    case 45 -> 117;
                    case 46 -> 139;
                    case 47 -> 247;
                    case 48 -> 161;
                    case 49 -> 77;
                    case 50 -> 7;
                    case 51 -> 220;
                    case 52 -> 47;
                    case 53 -> 48;
                    case 54 -> 52;
                    case 55 -> 64;
                    case 56 -> 145;
                    case 57 -> 206;
                    case 58 -> 244;
                    case 59 -> 238;
                    case 60 -> 177;
                    case 61 -> 127;
                    case 62 -> 28;
                    case 63 -> 133;
                    case 64 -> 37;
                    case 65 -> 250;
                    case 66 -> 44;
                    case 67 -> 181;
                    case 68 -> 4;
                    case 69 -> 58;
                    case 70 -> 229;
                    case 71 -> 51;
                    case 72 -> 155;
                    case 73 -> 159;
                    case 74 -> 102;
                    case 75 -> 12;
                    case 76 -> 115;
                    case 77 -> 136;
                    case 78 -> 113;
                    case 79 -> 82;
                    case 80 -> 194;
                    case 81 -> 69;
                    case 82 -> 215;
                    case 83 -> 122;
                    case 84 -> 49;
                    case 85 -> 13;
                    case 86 -> 218;
                    case 87 -> 188;
                    case 88 -> 2;
                    case 89 -> 50;
                    case 90 -> 74;
                    case 91 -> 71;
                    case 92 -> 63;
                    case 93 -> 192;
                    case 94 -> 68;
                    case 95 -> 65;
                    case 96 -> 191;
                    case 97 -> 23;
                    case 98 -> 230;
                    case 99 -> 128;
                    case 100 -> 176;
                    case 101 -> 29;
                    case 102 -> 163;
                    case 103 -> 135;
                    case 104 -> 152;
                    case 105 -> 151;
                    case 106 -> 6;
                    case 107 -> 124;
                    case 108 -> 198;
                    case 109 -> 237;
                    case 110 -> 184;
                    case 111 -> 1;
                    case 112 -> 252;
                    case 113 -> 195;
                    case 114 -> 254;
                    case 115 -> 183;
                    case 116 -> 236;
                    case 117 -> 196;
                    case 118 -> 19;
                    case 119 -> 60;
                    case 120 -> 157;
                    case 121 -> 56;
                    case 122 -> 240;
                    case 123 -> 32;
                    case 124 -> 45;
                    case 125 -> 81;
                    case 126 -> 70;
                    case 127 -> 232;
                    case 128 -> 162;
                    case 129 -> 27;
                    case 130 -> 207;
                    case 131 -> 212;
                    case 132 -> 90;
                    case 133 -> 154;
                    case 134 -> 222;
                    case 135 -> 131;
                    case 136 -> 33;
                    case 137 -> 120;
                    case 138 -> 103;
                    case 139 -> 225;
                    case 140 -> 251;
                    case 141 -> 40;
                    case 142 -> 0;
                    case 143 -> 92;
                    case 144 -> 80;
                    case 145 -> 137;
                    case 146 -> 78;
                    case 147 -> 57;
                    case 148 -> 147;
                    case 149 -> 164;
                    case 150 -> 168;
                    case 151 -> 123;
                    case 152 -> 30;
                    case 153 -> 61;
                    case 154 -> 217;
                    case 155 -> 144;
                    case 156 -> 182;
                    case 157 -> 203;
                    case 158 -> 76;
                    case 159 -> 233;
                    case 160 -> 119;
                    case 161 -> 26;
                    case 162 -> 197;
                    case 163 -> 96;
                    case 164 -> 20;
                    case 165 -> 88;
                    case 166 -> 148;
                    case 167 -> 104;
                    case 168 -> 211;
                    case 169 -> 160;
                    case 170 -> 89;
                    case 171 -> 99;
                    case 172 -> 41;
                    case 173 -> 3;
                    case 174 -> 15;
                    case 175 -> 130;
                    case 176 -> 255;
                    case 177 -> 210;
                    case 178 -> 84;
                    case 179 -> 111;
                    case 180 -> 9;
                    case 181 -> 116;
                    case 182 -> 178;
                    case 183 -> 53;
                    case 184 -> 95;
                    case 185 -> 227;
                    case 186 -> 73;
                    case 187 -> 141;
                    case 188 -> 83;
                    case 189 -> 14;
                    case 190 -> 216;
                    case 191 -> 173;
                    case 192 -> 105;
                    case 193 -> 35;
                    case 194 -> 31;
                    case 195 -> 142;
                    case 196 -> 245;
                    case 197 -> 231;
                    case 198 -> 175;
                    case 199 -> 110;
                    case 200 -> 98;
                    case 201 -> 132;
                    case 202 -> 189;
                    case 203 -> 121;
                    case 204 -> 109;
                    case 205 -> 239;
                    case 206 -> 214;
                    case 207 -> 16;
                    case 208 -> 242;
                    case 209 -> 174;
                    case 210 -> 114;
                    case 211 -> 209;
                    case 212 -> 118;
                    case 213 -> 91;
                    case 214 -> 42;
                    case 215 -> 125;
                    case 216 -> 190;
                    case 217 -> 134;
                    case 218 -> 21;
                    case 219 -> 205;
                    case 220 -> 94;
                    case 221 -> 87;
                    case 222 -> 165;
                    case 223 -> 97;
                    case 224 -> 219;
                    case 225 -> 86;
                    case 226 -> 246;
                    case 227 -> 186;
                    case 228 -> 223;
                    case 229 -> 204;
                    case 230 -> 106;
                    case 231 -> 200;
                    case 232 -> 146;
                    case 233 -> 62;
                    case 234 -> 108;
                    case 235 -> 138;
                    case 236 -> 43;
                    case 237 -> 46;
                    case 238 -> 253;
                    case 239 -> 18;
                    case 240 -> 179;
                    case 241 -> 171;
                    case 242 -> 234;
                    case 243 -> 213;
                    case 244 -> 55;
                    case 245 -> 235;
                    case 246 -> 143;
                    case 247 -> 112;
                    case 248 -> 5;
                    case 249 -> 167;
                    case 250 -> 67;
                    case 251 -> 202;
                    case 252 -> 101;
                    case 253 -> 39;
                    case 254 -> 54;
                    default -> 72;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 94797910234180L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "d\u0002\u001d\u0010)\u0002R=\tc\b\u000e\u001ad@O!N";
                    var5_4 = "d\u0002\u001d\u0010)\u0002R=\tc\b\u000e\u001ad@O!N".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 71;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 72;
                                    break;
                                }
                                case 1: {
                                    v11 = 32;
                                    break;
                                }
                                case 2: {
                                    v11 = 40;
                                    break;
                                }
                                case 3: {
                                    v11 = 57;
                                    break;
                                }
                                case 4: {
                                    v11 = 11;
                                    break;
                                }
                                case 5: {
                                    v11 = 41;
                                    break;
                                }
                                default: {
                                    v11 = 38;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 70920784420187L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "M\u0011\u0005ZXe=\u0004K\u000f\t@\nG\u0010\u0002@Tg%m\u0011\u000b\tG\u0010\u0002@Tg%a\u001b\r@\u0016\u001fM^j?a\u001c\u0018G_c";
                    var5_4 = "M\u0011\u0005ZXe=\u0004K\u000f\t@\nG\u0010\u0002@Tg%m\u0011\u000b\tG\u0010\u0002@Tg%a\u001b\r@\u0016\u001fM^j?a\u001c\u0018G_c".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "8l|\"'\u0015I\u00068l|\"+\u001f";
                        var5_4 = "8l|\"'\u0015I\u00068l|\"+\u001f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 8;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 115;
                                break;
                            }
                            case 1: {
                                v15 = 8;
                                break;
                            }
                            case 2: {
                                v15 = 27;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 70;
                                break;
                            }
                            case 5: {
                                v15 = 115;
                                break;
                            }
                            default: {
                                v15 = 38;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 22994483612554L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-771346950 - -((char)-4222), 771346950 - (char)-1850, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 125215856069388L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00d0\u00e3\u00d7\u00c8\u00b3\u0003NC\u00b0\u0005CC\u0083\u0018\u00da\r\u001b\u008d\u00be\u008b\u0088\u0017\u00a5}\u0013\u00e0\u0016\u0082#\u0010\u00e4;\u0086\u00b6\u00b0%\u0089\u0006_\u000b|\u00b2\u0088\u001d\n\u009b\u0005;.\u008c\u00b5;3\u00a3,\u008e\u0082d\u00e7#Jw\u007f\u00f2\u0015\u009f\u00b8\u00c40+\u00c8\u00ccD\u00f5\u00c2g>_co\u00bfd`\u0000\u0011k\u0087\u0089df\u00ea\u001a\u00eb\u0001\u00eb\u00b2\u0018\u00f6\u00e8z\u0092\u0098\u00d1M";
                    var4_3 = "\u00d0\u00e3\u00d7\u00c8\u00b3\u0003NC\u00b0\u0005CC\u0083\u0018\u00da\r\u001b\u008d\u00be\u008b\u0088\u0017\u00a5}\u0013\u00e0\u0016\u0082#\u0010\u00e4;\u0086\u00b6\u00b0%\u0089\u0006_\u000b|\u00b2\u0088\u001d\n\u009b\u0005;.\u008c\u00b5;3\u00a3,\u008e\u0082d\u00e7#Jw\u007f\u00f2\u0015\u009f\u00b8\u00c40+\u00c8\u00ccD\u00f5\u00c2g>_co\u00bfd`\u0000\u0011k\u0087\u0089df\u00ea\u001a\u00eb\u0001\u00eb\u00b2\u0018\u00f6\u00e8z\u0092\u0098\u00d1M".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b7\u0089XT\u00df\u00cd\u00d0\u00af\u00c0\u008a;6\u00d495\u00abL\u00f48\u00c7\u00a8\u0006\u009a\u0085+\u00e3\u0089\u00f3\u00ef\u00c3\u008cDd\u008a'\u00b3\u00fb\u00c6\u00e5\u009f\u00cc\u00d7b\u00ef\u00ed:\u00d7\u0090<\u00ddx\u009a3\u0082j\b)\u00c1\u00fa\u00d1\u00f3;\u00ff\u00bc\u00fc\u0006\u009c\u00c2]\u00f8M\t\u00f7\u0095\u00fc|?u\u00e3=\u0089\u00b4\u00c4\u00108\u00d5\u008d\u00d0\u0094\u00f7\u0006\u0011H";
                        var4_3 = "\u00b7\u0089XT\u00df\u00cd\u00d0\u00af\u00c0\u008a;6\u00d495\u00abL\u00f48\u00c7\u00a8\u0006\u009a\u0085+\u00e3\u0089\u00f3\u00ef\u00c3\u008cDd\u008a'\u00b3\u00fb\u00c6\u00e5\u009f\u00cc\u00d7b\u00ef\u00ed:\u00d7\u0090<\u00ddx\u009a3\u0082j\b)\u00c1\u00fa\u00d1\u00f3;\u00ff\u00bc\u00fc\u0006\u009c\u00c2]\u00f8M\t\u00f7\u0095\u00fc|?u\u00e3=\u0089\u00b4\u00c4\u00108\u00d5\u008d\u00d0\u0094\u00f7\u0006\u0011H".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 12;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 77;
                                break;
                            }
                            case 1: {
                                v15 = 96;
                                break;
                            }
                            case 2: {
                                v15 = 117;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 99;
                                break;
                            }
                            case 5: {
                                v15 = 85;
                                break;
                            }
                            default: {
                                v15 = 29;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x16F6) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 179;
                    case 1 -> 169;
                    case 2 -> 112;
                    case 3 -> 176;
                    case 4 -> 116;
                    case 5 -> 115;
                    case 6 -> 205;
                    case 7 -> 198;
                    case 8 -> 244;
                    case 9 -> 19;
                    case 10 -> 65;
                    case 11 -> 240;
                    case 12 -> 55;
                    case 13 -> 56;
                    case 14 -> 48;
                    case 15 -> 232;
                    case 16 -> 177;
                    case 17 -> 201;
                    case 18 -> 222;
                    case 19 -> 90;
                    case 20 -> 231;
                    case 21 -> 114;
                    case 22 -> 194;
                    case 23 -> 113;
                    case 24 -> 146;
                    case 25 -> 180;
                    case 26 -> 172;
                    case 27 -> 233;
                    case 28 -> 124;
                    case 29 -> 237;
                    case 30 -> 137;
                    case 31 -> 236;
                    case 32 -> 68;
                    case 33 -> 159;
                    case 34 -> 84;
                    case 35 -> 243;
                    case 36 -> 106;
                    case 37 -> 190;
                    case 38 -> 152;
                    case 39 -> 246;
                    case 40 -> 142;
                    case 41 -> 67;
                    case 42 -> 30;
                    case 43 -> 83;
                    case 44 -> 89;
                    case 45 -> 125;
                    case 46 -> 91;
                    case 47 -> 46;
                    case 48 -> 228;
                    case 49 -> 139;
                    case 50 -> 207;
                    case 51 -> 216;
                    case 52 -> 212;
                    case 53 -> 104;
                    case 54 -> 4;
                    case 55 -> 38;
                    case 56 -> 64;
                    case 57 -> 171;
                    case 58 -> 191;
                    case 59 -> 2;
                    case 60 -> 13;
                    case 61 -> 69;
                    case 62 -> 202;
                    case 63 -> 161;
                    case 64 -> 70;
                    case 65 -> 239;
                    case 66 -> 187;
                    case 67 -> 138;
                    case 68 -> 132;
                    case 69 -> 29;
                    case 70 -> 210;
                    case 71 -> 150;
                    case 72 -> 42;
                    case 73 -> 227;
                    case 74 -> 77;
                    case 75 -> 24;
                    case 76 -> 223;
                    case 77 -> 10;
                    case 78 -> 225;
                    case 79 -> 79;
                    case 80 -> 135;
                    case 81 -> 185;
                    case 82 -> 36;
                    case 83 -> 34;
                    case 84 -> 141;
                    case 85 -> 51;
                    case 86 -> 7;
                    case 87 -> 93;
                    case 88 -> 143;
                    case 89 -> 80;
                    case 90 -> 215;
                    case 91 -> 249;
                    case 92 -> 247;
                    case 93 -> 151;
                    case 94 -> 61;
                    case 95 -> 195;
                    case 96 -> 166;
                    case 97 -> 117;
                    case 98 -> 71;
                    case 99 -> 253;
                    case 100 -> 128;
                    case 101 -> 148;
                    case 102 -> 109;
                    case 103 -> 74;
                    case 104 -> 200;
                    case 105 -> 9;
                    case 106 -> 252;
                    case 107 -> 157;
                    case 108 -> 203;
                    case 109 -> 127;
                    case 110 -> 45;
                    case 111 -> 255;
                    case 112 -> 234;
                    case 113 -> 73;
                    case 114 -> 217;
                    case 115 -> 58;
                    case 116 -> 213;
                    case 117 -> 102;
                    case 118 -> 168;
                    case 119 -> 178;
                    case 120 -> 72;
                    case 121 -> 156;
                    case 122 -> 108;
                    case 123 -> 17;
                    case 124 -> 182;
                    case 125 -> 20;
                    case 126 -> 144;
                    case 127 -> 21;
                    case 128 -> 160;
                    case 129 -> 32;
                    case 130 -> 153;
                    case 131 -> 94;
                    case 132 -> 53;
                    case 133 -> 35;
                    case 134 -> 25;
                    case 135 -> 147;
                    case 136 -> 18;
                    case 137 -> 162;
                    case 138 -> 47;
                    case 139 -> 75;
                    case 140 -> 26;
                    case 141 -> 37;
                    case 142 -> 154;
                    case 143 -> 63;
                    case 144 -> 164;
                    case 145 -> 76;
                    case 146 -> 44;
                    case 147 -> 31;
                    case 148 -> 103;
                    case 149 -> 1;
                    case 150 -> 107;
                    case 151 -> 110;
                    case 152 -> 199;
                    case 153 -> 230;
                    case 154 -> 211;
                    case 155 -> 85;
                    case 156 -> 189;
                    case 157 -> 0;
                    case 158 -> 100;
                    case 159 -> 5;
                    case 160 -> 130;
                    case 161 -> 28;
                    case 162 -> 122;
                    case 163 -> 96;
                    case 164 -> 219;
                    case 165 -> 11;
                    case 166 -> 33;
                    case 167 -> 59;
                    case 168 -> 245;
                    case 169 -> 131;
                    case 170 -> 52;
                    case 171 -> 167;
                    case 172 -> 136;
                    case 173 -> 105;
                    case 174 -> 235;
                    case 175 -> 118;
                    case 176 -> 173;
                    case 177 -> 140;
                    case 178 -> 49;
                    case 179 -> 174;
                    case 180 -> 66;
                    case 181 -> 224;
                    case 182 -> 8;
                    case 183 -> 184;
                    case 184 -> 175;
                    case 185 -> 183;
                    case 186 -> 12;
                    case 187 -> 145;
                    case 188 -> 181;
                    case 189 -> 126;
                    case 190 -> 99;
                    case 191 -> 250;
                    case 192 -> 111;
                    case 193 -> 81;
                    case 194 -> 54;
                    case 195 -> 170;
                    case 196 -> 241;
                    case 197 -> 60;
                    case 198 -> 248;
                    case 199 -> 57;
                    case 200 -> 220;
                    case 201 -> 204;
                    case 202 -> 163;
                    case 203 -> 82;
                    case 204 -> 87;
                    case 205 -> 218;
                    case 206 -> 27;
                    case 207 -> 6;
                    case 208 -> 39;
                    case 209 -> 196;
                    case 210 -> 242;
                    case 211 -> 226;
                    case 212 -> 208;
                    case 213 -> 120;
                    case 214 -> 197;
                    case 215 -> 41;
                    case 216 -> 165;
                    case 217 -> 97;
                    case 218 -> 129;
                    case 219 -> 78;
                    case 220 -> 121;
                    case 221 -> 134;
                    case 222 -> 101;
                    case 223 -> 133;
                    case 224 -> 254;
                    case 225 -> 50;
                    case 226 -> 98;
                    case 227 -> 251;
                    case 228 -> 95;
                    case 229 -> 23;
                    case 230 -> 186;
                    case 231 -> 238;
                    case 232 -> 62;
                    case 233 -> 229;
                    case 234 -> 14;
                    case 235 -> 192;
                    case 236 -> 119;
                    case 237 -> 40;
                    case 238 -> 86;
                    case 239 -> 221;
                    case 240 -> 155;
                    case 241 -> 92;
                    case 242 -> 123;
                    case 243 -> 43;
                    case 244 -> 158;
                    case 245 -> 209;
                    case 246 -> 214;
                    case 247 -> 88;
                    case 248 -> 188;
                    case 249 -> 149;
                    case 250 -> 193;
                    case 251 -> 15;
                    case 252 -> 16;
                    case 253 -> 3;
                    case 254 -> 206;
                    default -> 22;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 33307616821015L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-145487700 - -((char)-11494), -145487700 - -((char)-22642), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 88036082301112L;
                    String string = SshAgentIpcService.h();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2137620630 + -8962, 2137620630 + 19058, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 1587025909325L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0005\u00d4\u00ec\u00bf\u00e0\u0003)\u001a?";
                var4_3 = "\u0005\u00d4\u00ec\u00bf\u00e0\u0003)\u001a?".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 12;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 12;
                                break;
                            }
                            case 1: {
                                v11 = 121;
                                break;
                            }
                            case 2: {
                                v11 = 104;
                                break;
                            }
                            case 3: {
                                v11 = 98;
                                break;
                            }
                            case 4: {
                                v11 = 64;
                                break;
                            }
                            case 5: {
                                v11 = 106;
                                break;
                            }
                            default: {
                                v11 = 69;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE4D1) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 70;
                    case 1 -> 101;
                    case 2 -> 105;
                    case 3 -> 229;
                    case 4 -> 241;
                    case 5 -> 201;
                    case 6 -> 64;
                    case 7 -> 178;
                    case 8 -> 245;
                    case 9 -> 85;
                    case 10 -> 183;
                    case 11 -> 63;
                    case 12 -> 28;
                    case 13 -> 135;
                    case 14 -> 234;
                    case 15 -> 82;
                    case 16 -> 76;
                    case 17 -> 235;
                    case 18 -> 66;
                    case 19 -> 54;
                    case 20 -> 164;
                    case 21 -> 42;
                    case 22 -> 8;
                    case 23 -> 180;
                    case 24 -> 104;
                    case 25 -> 55;
                    case 26 -> 137;
                    case 27 -> 77;
                    case 28 -> 121;
                    case 29 -> 144;
                    case 30 -> 88;
                    case 31 -> 194;
                    case 32 -> 90;
                    case 33 -> 213;
                    case 34 -> 173;
                    case 35 -> 224;
                    case 36 -> 118;
                    case 37 -> 119;
                    case 38 -> 0;
                    case 39 -> 204;
                    case 40 -> 9;
                    case 41 -> 86;
                    case 42 -> 237;
                    case 43 -> 219;
                    case 44 -> 228;
                    case 45 -> 226;
                    case 46 -> 152;
                    case 47 -> 142;
                    case 48 -> 158;
                    case 49 -> 181;
                    case 50 -> 74;
                    case 51 -> 189;
                    case 52 -> 12;
                    case 53 -> 47;
                    case 54 -> 45;
                    case 55 -> 145;
                    case 56 -> 75;
                    case 57 -> 69;
                    case 58 -> 202;
                    case 59 -> 15;
                    case 60 -> 249;
                    case 61 -> 195;
                    case 62 -> 115;
                    case 63 -> 248;
                    case 64 -> 67;
                    case 65 -> 114;
                    case 66 -> 200;
                    case 67 -> 236;
                    case 68 -> 62;
                    case 69 -> 93;
                    case 70 -> 159;
                    case 71 -> 203;
                    case 72 -> 179;
                    case 73 -> 215;
                    case 74 -> 29;
                    case 75 -> 250;
                    case 76 -> 125;
                    case 77 -> 161;
                    case 78 -> 231;
                    case 79 -> 7;
                    case 80 -> 221;
                    case 81 -> 100;
                    case 82 -> 187;
                    case 83 -> 129;
                    case 84 -> 94;
                    case 85 -> 214;
                    case 86 -> 36;
                    case 87 -> 4;
                    case 88 -> 6;
                    case 89 -> 50;
                    case 90 -> 95;
                    case 91 -> 190;
                    case 92 -> 87;
                    case 93 -> 209;
                    case 94 -> 16;
                    case 95 -> 171;
                    case 96 -> 1;
                    case 97 -> 155;
                    case 98 -> 11;
                    case 99 -> 186;
                    case 100 -> 71;
                    case 101 -> 198;
                    case 102 -> 184;
                    case 103 -> 97;
                    case 104 -> 48;
                    case 105 -> 79;
                    case 106 -> 146;
                    case 107 -> 154;
                    case 108 -> 212;
                    case 109 -> 176;
                    case 110 -> 2;
                    case 111 -> 111;
                    case 112 -> 218;
                    case 113 -> 210;
                    case 114 -> 232;
                    case 115 -> 134;
                    case 116 -> 81;
                    case 117 -> 230;
                    case 118 -> 17;
                    case 119 -> 25;
                    case 120 -> 108;
                    case 121 -> 106;
                    case 122 -> 124;
                    case 123 -> 40;
                    case 124 -> 175;
                    case 125 -> 131;
                    case 126 -> 174;
                    case 127 -> 254;
                    case 128 -> 130;
                    case 129 -> 243;
                    case 130 -> 91;
                    case 131 -> 238;
                    case 132 -> 109;
                    case 133 -> 107;
                    case 134 -> 57;
                    case 135 -> 27;
                    case 136 -> 165;
                    case 137 -> 160;
                    case 138 -> 60;
                    case 139 -> 151;
                    case 140 -> 136;
                    case 141 -> 148;
                    case 142 -> 227;
                    case 143 -> 207;
                    case 144 -> 167;
                    case 145 -> 192;
                    case 146 -> 222;
                    case 147 -> 31;
                    case 148 -> 143;
                    case 149 -> 46;
                    case 150 -> 240;
                    case 151 -> 23;
                    case 152 -> 233;
                    case 153 -> 162;
                    case 154 -> 208;
                    case 155 -> 19;
                    case 156 -> 217;
                    case 157 -> 126;
                    case 158 -> 239;
                    case 159 -> 223;
                    case 160 -> 140;
                    case 161 -> 251;
                    case 162 -> 172;
                    case 163 -> 147;
                    case 164 -> 225;
                    case 165 -> 197;
                    case 166 -> 206;
                    case 167 -> 35;
                    case 168 -> 53;
                    case 169 -> 185;
                    case 170 -> 14;
                    case 171 -> 30;
                    case 172 -> 3;
                    case 173 -> 117;
                    case 174 -> 13;
                    case 175 -> 177;
                    case 176 -> 133;
                    case 177 -> 24;
                    case 178 -> 120;
                    case 179 -> 220;
                    case 180 -> 141;
                    case 181 -> 41;
                    case 182 -> 52;
                    case 183 -> 73;
                    case 184 -> 38;
                    case 185 -> 182;
                    case 186 -> 32;
                    case 187 -> 211;
                    case 188 -> 37;
                    case 189 -> 92;
                    case 190 -> 170;
                    case 191 -> 252;
                    case 192 -> 103;
                    case 193 -> 96;
                    case 194 -> 72;
                    case 195 -> 168;
                    case 196 -> 58;
                    case 197 -> 20;
                    case 198 -> 21;
                    case 199 -> 166;
                    case 200 -> 51;
                    case 201 -> 122;
                    case 202 -> 191;
                    case 203 -> 26;
                    case 204 -> 99;
                    case 205 -> 68;
                    case 206 -> 61;
                    case 207 -> 253;
                    case 208 -> 78;
                    case 209 -> 43;
                    case 210 -> 10;
                    case 211 -> 89;
                    case 212 -> 157;
                    case 213 -> 112;
                    case 214 -> 255;
                    case 215 -> 83;
                    case 216 -> 193;
                    case 217 -> 153;
                    case 218 -> 205;
                    case 219 -> 110;
                    case 220 -> 244;
                    case 221 -> 56;
                    case 222 -> 34;
                    case 223 -> 80;
                    case 224 -> 123;
                    case 225 -> 39;
                    case 226 -> 242;
                    case 227 -> 44;
                    case 228 -> 18;
                    case 229 -> 188;
                    case 230 -> 169;
                    case 231 -> 199;
                    case 232 -> 163;
                    case 233 -> 138;
                    case 234 -> 98;
                    case 235 -> 65;
                    case 236 -> 139;
                    case 237 -> 33;
                    case 238 -> 150;
                    case 239 -> 102;
                    case 240 -> 216;
                    case 241 -> 246;
                    case 242 -> 49;
                    case 243 -> 5;
                    case 244 -> 196;
                    case 245 -> 132;
                    case 246 -> 22;
                    case 247 -> 113;
                    case 248 -> 116;
                    case 249 -> 59;
                    case 250 -> 156;
                    case 251 -> 84;
                    case 252 -> 128;
                    case 253 -> 247;
                    case 254 -> 149;
                    default -> 127;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

