/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapSerializerUtil {
    private static final String STD_EX_SUFFIX = "Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n";
    protected static final String PARSING_ERROR_PREFIX = "Error while parsing TeamCity service message: ";
    @Deprecated
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        @Override
        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char unescape(char c) {
            switch (c) {
                case 'n': {
                    return '\n';
                }
                case 'r': {
                    return '\r';
                }
                case 'x': {
                    return '\u0085';
                }
                case 'l': {
                    return '\u2028';
                }
                case 'p': {
                    return '\u2029';
                }
                case '\'': {
                    return '\'';
                }
                case '|': {
                    return '|';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char escapeCharacter() {
            return '|';
        }
    };
    public static final EscapeInfoProvider2 STD_ESCAPER2 = new EscapeInfoProvider2(){

        @Override
        @Nullable
        public String escape(char c) {
            switch (c) {
                case '\n': {
                    return "n";
                }
                case '\r': {
                    return "r";
                }
                case '|': {
                    return "|";
                }
                case '\'': {
                    return "'";
                }
                case '[': {
                    return "[";
                }
                case ']': {
                    return "]";
                }
            }
            return c < '\u0080' ? null : String.format("0x%04x", c);
        }

        @Override
        @Nullable
        public UnescapeResult unescape(@NotNull String str, int startPos) {
            char c;
            if (str == null) {
                2.$$$reportNull$$$0(0);
            }
            if ((c = str.charAt(startPos)) == '0') {
                if (startPos + 5 < str.length() && str.charAt(startPos + 1) == 'x') {
                    try {
                        return new UnescapeResult((char)Integer.parseInt(str.substring(startPos + 2, startPos + 6), 16), 6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
            switch (c) {
                case 'n': {
                    return new UnescapeResult('\n', 1);
                }
                case 'r': {
                    return new UnescapeResult('\r', 1);
                }
                case 'x': {
                    return new UnescapeResult('\u0085', 1);
                }
                case 'l': {
                    return new UnescapeResult('\u2028', 1);
                }
                case 'p': {
                    return new UnescapeResult('\u2029', 1);
                }
                case '\'': {
                    return new UnescapeResult('\'', 1);
                }
                case '|': {
                    return new UnescapeResult('|', 1);
                }
                case '[': {
                    return new UnescapeResult('[', 1);
                }
                case ']': {
                    return new UnescapeResult(']', 1);
                }
            }
            return null;
        }

        @Override
        public char escapeCharacter() {
            return '|';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$2", "unescape"));
        }
    };

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(0);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(1);
        }
        return MapSerializerUtil.stringToProperties(string2, escaper, true);
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(2);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(3);
        }
        return MapSerializerUtil.stringToProperties(string2, escaper, true);
    }

    @Deprecated
    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        return MapSerializerUtil.propertiesToString(props, MapSerializerUtil.convertProvider(escaper));
    }

    @NotNull
    public static String propertiesToString(@NotNull Map<String, String> props, @NotNull EscapeInfoProvider2 escaper) {
        if (props == null) {
            MapSerializerUtil.$$$reportNull$$$0(4);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(5);
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(MapSerializerUtil.escapeStr(entry.getKey(), escaper));
            builder.append('=');
            builder.append('\'').append(MapSerializerUtil.escapeStr(entry.getValue(), escaper)).append('\'');
        }
        String string2 = builder.toString();
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(7);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(8);
        }
        return MapSerializerUtil.stringToProperties(string2, MapSerializerUtil.convertProvider(escaper), strictNameCheck);
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string2, @NotNull EscapeInfoProvider2 escaper, boolean strictNameCheck) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(9);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(10);
        }
        LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
        StringBuilder buf = new StringBuilder(Math.min(512, string2.length()));
        for (int curPos = 0; curPos < string2.length(); ++curPos) {
            curPos = MapSerializerUtil.parseName(string2, curPos, buf, strictNameCheck);
            String name = buf.toString();
            buf.setLength(0);
            curPos = MapSerializerUtil.skipSpacesFromStart(string2, curPos, string2.length());
            if (string2.charAt(curPos) != '\'') {
                throw new ParseException("Error while parsing TeamCity service message: Value should start with \"'\". Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
            }
            curPos = MapSerializerUtil.parseValue(string2, curPos + 1, buf, escaper);
            result2.put(name, buf.toString());
            buf.setLength(0);
        }
        LinkedHashMap<String, String> linkedHashMap = result2;
        if (linkedHashMap == null) {
            MapSerializerUtil.$$$reportNull$$$0(11);
        }
        return linkedHashMap;
    }

    private static int parseName(@NotNull String string2, int startPos, @NotNull StringBuilder buf, boolean strictNameCheck) throws ParseException {
        int nameEndPos;
        int nameSep;
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(12);
        }
        if (buf == null) {
            MapSerializerUtil.$$$reportNull$$$0(13);
        }
        if ((nameSep = string2.indexOf("=", startPos)) == -1) {
            throw new ParseException("Error while parsing TeamCity service message: Property value not found (no \"=\" character). Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
        }
        int nameStartPos = MapSerializerUtil.skipSpacesFromStart(string2, startPos, nameSep);
        if (nameStartPos > (nameEndPos = MapSerializerUtil.skipSpacesFromEnd(string2, nameSep - 1, startPos - 1))) {
            throw new ParseException("Error while parsing TeamCity service message: Incorrect property name \"" + string2.substring(startPos, nameSep).trim() + "\". " + STD_EX_SUFFIX, 0);
        }
        for (int idx = nameStartPos; idx <= nameEndPos; ++idx) {
            char c = string2.charAt(idx);
            if (strictNameCheck) {
                if (idx == nameStartPos && !Character.isJavaIdentifierStart(c) || idx > nameStartPos && !Character.isJavaIdentifierPart(c)) {
                    throw new ParseException("Error while parsing TeamCity service message: Incorrect property name \"" + string2.substring(startPos, nameSep).trim() + "\": should start with a character/underscore and contain only alpha-numeric symbols or underscore. " + STD_EX_SUFFIX, 0);
                }
            } else if (c == ' ') {
                throw new ParseException("Error while parsing TeamCity service message: Incorrect property name \"" + string2.substring(startPos, nameSep).trim() + "\": should not contain spaces. " + STD_EX_SUFFIX, 0);
            }
            buf.append(c);
        }
        return nameSep + 1;
    }

    private static int skipSpacesFromStart(@NotNull String string2, int startPos, int endPos) {
        int idx;
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(14);
        }
        for (idx = startPos; idx < endPos && string2.charAt(idx) <= ' '; ++idx) {
        }
        return idx;
    }

    private static int skipSpacesFromEnd(@NotNull String string2, int startPos, int endPos) {
        int idx;
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(15);
        }
        for (idx = startPos; idx > endPos && string2.charAt(idx) <= ' '; --idx) {
        }
        return idx;
    }

    private static int parseValue(@NotNull String string2, int startPos, @NotNull StringBuilder resultBuf, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string2 == null) {
            MapSerializerUtil.$$$reportNull$$$0(16);
        }
        if (resultBuf == null) {
            MapSerializerUtil.$$$reportNull$$$0(17);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(18);
        }
        char escapeCharacter = escaper.escapeCharacter();
        boolean endOfValueFound = false;
        while (startPos < string2.length()) {
            UnescapeResult unescaped;
            char c = string2.charAt(startPos);
            if (c == '\'') {
                endOfValueFound = true;
                break;
            }
            if (c == escapeCharacter && startPos + 1 < string2.length() && (unescaped = escaper.unescape(string2, startPos + 1)) != null) {
                resultBuf.append(unescaped.getChar());
                startPos += 1 + unescaped.getEscapedLength();
                continue;
            }
            resultBuf.append(c);
            ++startPos;
        }
        if (!endOfValueFound) {
            throw new ParseException("Error while parsing TeamCity service message: Value should end with \"'\". Valid service message has a form of \"##teamcity[messageName name1='escaped_value' name2='escaped_value']\" where escaped_value uses substitutions: '->|', [->|[, ]->|], |->||, newline->|n", 0);
        }
        return startPos;
    }

    @Deprecated
    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        return MapSerializerUtil.indexOf(currentString, findWhat, MapSerializerUtil.convertProvider(escaper));
    }

    public static int indexOf(@NotNull String currentString, char findWhat, @NotNull EscapeInfoProvider2 escaper) {
        if (currentString == null) {
            MapSerializerUtil.$$$reportNull$$$0(19);
        }
        if (escaper == null) {
            MapSerializerUtil.$$$reportNull$$$0(20);
        }
        int length = currentString.length();
        for (int i2 = 0; i2 < length; ++i2) {
            UnescapeResult unescaped;
            char currentChar = currentString.charAt(i2);
            if (currentChar == escaper.escapeCharacter() && i2 + 1 < length && (unescaped = escaper.unescape(currentString, i2 + 1)) != null) {
                i2 += unescaped.getEscapedLength();
                continue;
            }
            if (currentChar != findWhat) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isValidJavaIdentifier(@NotNull String name) {
        if (name == null) {
            MapSerializerUtil.$$$reportNull$$$0(21);
        }
        if (name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < name.length(); ++i2) {
            if (Character.isJavaIdentifierPart(name.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static String escapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.escapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @NotNull
    private static EscapeInfoProvider2 convertProvider(final @NotNull EscapeInfoProvider p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(22);
        }
        return new EscapeInfoProvider2(){

            @Override
            @Nullable
            public String escape(char c) {
                char result2 = p.escape(c);
                return result2 == '\u0000' ? null : String.valueOf(result2);
            }

            @Override
            @Nullable
            public UnescapeResult unescape(@NotNull String str, int startPos) {
                char result2;
                if (str == null) {
                    3.$$$reportNull$$$0(0);
                }
                return (result2 = p.unescape(str.charAt(startPos))) == '\u0000' ? null : new UnescapeResult(result2, 1);
            }

            @Override
            public char escapeCharacter() {
                return p.escapeCharacter();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil$3", "unescape"));
            }
        };
    }

    @Nullable
    @Contract(value="null,_->null; !null,_->!null")
    public static String escapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(23);
        }
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            String escaped = p.escape(c);
            if (escaped != null) {
                resultChars[resultPos++] = p.escapeCharacter();
                int escapedLength = escaped.length();
                System.arraycopy(escaped.toCharArray(), 0, resultChars, resultPos, escapedLength);
                resultPos += escapedLength;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(@NotNull String str, @NotNull EscapeInfoProvider2 p) {
        if (str == null) {
            MapSerializerUtil.$$$reportNull$$$0(24);
        }
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(25);
        }
        int result2 = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String escapePresentation = p.escape(str.charAt(i2));
            if (escapePresentation != null) {
                result2 += 1 + escapePresentation.length();
                continue;
            }
            ++result2;
        }
        return result2;
    }

    @Deprecated
    @Nullable
    public static String unescapeStr(@Nullable String str, @NotNull EscapeInfoProvider p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(26);
        }
        return MapSerializerUtil.unescapeStr(str, MapSerializerUtil.convertProvider(p));
    }

    @Nullable
    public static String unescapeStr(@Nullable String str, @NotNull EscapeInfoProvider2 p) {
        if (p == null) {
            MapSerializerUtil.$$$reportNull$$$0(27);
        }
        if (str == null) {
            return null;
        }
        char escapeCharacter = p.escapeCharacter();
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i2 = 0; i2 < len; ++i2) {
            UnescapeResult unescaped;
            char c = str.charAt(i2);
            if (c == escapeCharacter && i2 + 1 < len && (unescaped = p.unescape(str, i2 + 1)) != null) {
                c = unescaped.getChar();
                i2 += unescaped.getEscapedLength();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultBuf";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentString";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/messages/serviceMessages/MapSerializerUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "propertiesToString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stringToProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "propertiesToString";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "skipSpacesFromStart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "skipSpacesFromEnd";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseValue";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isValidJavaIdentifier";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertProvider";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "escapeStr";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calcFinalEscapedStringCount";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStr";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnescapeResult {
        private final char myChar;
        private final int myEscapedLength;

        public UnescapeResult(char ch, int escapedLength) {
            this.myChar = ch;
            this.myEscapedLength = escapedLength;
        }

        public char getChar() {
            return this.myChar;
        }

        public int getEscapedLength() {
            return this.myEscapedLength;
        }
    }

    public static interface EscapeInfoProvider2 {
        @Nullable
        public String escape(char var1);

        @Nullable
        public UnescapeResult unescape(@NotNull String var1, int var2);

        public char escapeCharacter();
    }

    @Deprecated
    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char unescape(char var1);

        public char escapeCharacter();
    }
}

